/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.meta.io;

import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.io.MetadataContext;
import com.ibm.pdp.mdl.meta.io.internal.LuceneRepository;
import com.ibm.pdp.mdl.meta.plugin.MetaPlugin;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;

public class MetadataAccess {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2024.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _METADATA_LOCATION_SUFFIX = "location";
    public static final int _SUB_REF = 0;
    public static final int _SUPER_REF = 1;
    private static final String _METADATA_LOCATION_EXTENSION = ".location";
    private static LuceneRepository _luceneRepository = null;
    private static MetadataAccess _instance = null;

    public static MetadataAccess getMetadataAccess() {
        if (_instance == null) {
            _instance = new MetadataAccess();
        }
        return _instance;
    }

    private static Query getContextQuery(MetadataContext context) {
        BooleanQuery.Builder builder;
        Set<String> projectNames;
        if (context == null || context.getCategories() == null && context.getProjectNames() == null) {
            return new MatchAllDocsQuery();
        }
        Query query = null;
        Query categoryQuery = null;
        BooleanQuery projectQuery = null;
        Set<String> categories = context.getCategories();
        if (categories != null) {
            if (categories.size() > 1) {
                BooleanQuery.Builder builder2 = new BooleanQuery.Builder();
                for (String category : context.getCategories()) {
                    Query singleQuery = MetadataAccess.getCategoryQuery(category);
                    builder2.add(singleQuery, context.getOperator());
                }
                categoryQuery = builder2.build();
            } else {
                categoryQuery = categories.size() == 1 ? MetadataAccess.getCategoryQuery(categories.iterator().next()) : MetadataAccess.getCategoryQuery("");
            }
        }
        if ((projectNames = context.getProjectNames()) != null) {
            if (projectNames.size() > 1) {
                builder = new BooleanQuery.Builder();
                for (String projectName : projectNames) {
                    Term projectTerm = new Term("_FIELD_PROJECT", projectName);
                    builder.add((Query)new TermQuery(projectTerm), BooleanClause.Occur.SHOULD);
                }
                projectQuery = builder.build();
            } else if (projectNames.size() == 1) {
                projectTerm = new Term("_FIELD_PROJECT", projectNames.iterator().next());
                projectQuery = new TermQuery(projectTerm);
            } else {
                projectTerm = new Term("_FIELD_PROJECT", "");
                projectQuery = new TermQuery(projectTerm);
            }
        }
        if (projectQuery != null && categoryQuery != null) {
            builder = new BooleanQuery.Builder();
            builder.add(categoryQuery, BooleanClause.Occur.MUST);
            builder.add(projectQuery, BooleanClause.Occur.MUST);
            query = builder.build();
        } else if (categoryQuery != null) {
            query = categoryQuery;
        } else if (projectQuery != null) {
            query = projectQuery;
        }
        return query;
    }

    private static Query getCategoryQuery(String category) {
        Object query = null;
        boolean wildCar = false;
        int i = 0;
        while (i < category.length() && !wildCar) {
            char c = category.charAt(i);
            wildCar = c == '*' || c == '?';
            ++i;
        }
        query = wildCar ? new WildcardQuery(new Term("_FIELD_CATEGORY", category)) : new TermQuery(new Term("_FIELD_CATEGORY", category));
        return query;
    }

    private MetadataAccess() {
    }

    private LuceneRepository getRepository() {
        if (_luceneRepository == null) {
            _luceneRepository = LuceneRepository.getInstance();
        }
        return _luceneRepository;
    }

    private boolean indexReaderExists(Directory directory) throws IOException {
        boolean exists = false;
        try {
            exists = DirectoryReader.indexExists((Directory)directory);
        }
        catch (Exception exception) {}
        return exists;
    }

    public synchronized void writeLocation(File directory, String locationName) {
        if (directory == null) {
            return;
        }
        if (locationName == null || locationName.length() == 0) {
            return;
        }
        File metadataFile = new File(directory, locationName + _METADATA_LOCATION_EXTENSION);
        if (!metadataFile.exists()) {
            try {
                metadataFile.createNewFile();
            }
            catch (IOException e) {
                MetaPlugin.logError((Throwable)e);
                throw Util.rethrow((Throwable)e);
            }
        }
    }

    public synchronized void deleteLocation(File directory, String locationName) {
        if (directory == null) {
            return;
        }
        if (locationName == null || locationName.length() == 0) {
            return;
        }
        File metadataFile = new File(directory, locationName + _METADATA_LOCATION_EXTENSION);
        metadataFile.delete();
    }

    public synchronized List<Document> readDocuments(MetadataContext context) {
        return this.readDocuments(context, false);
    }

    public synchronized List<Document> readDocuments(MetadataContext context, boolean shallowMode) {
        ArrayList<Document> documents = new ArrayList<Document>();
        Query query = MetadataAccess.getContextQuery(context);
        try {
            ScoreDoc[] hits;
            if (!this.indexReaderExists(this.getRepository().getDataDirectory())) {
                return documents;
            }
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getDataDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            ScoreDoc[] scoreDocArray = hits = LuceneRepository.getHits(searcher, query);
            int n = hits.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc hit = scoreDocArray[n2];
                StoredFields storedFields = searcher.storedFields();
                org.apache.lucene.document.Document luceneDoc = storedFields.document(hit.doc);
                Document document = null;
                document = shallowMode ? MetaFactory.eINSTANCE.createShallowDocument() : MetaFactory.eINSTANCE.createDocument();
                LuceneRepository.buildDocument(document, luceneDoc);
                MetaFactory.eINSTANCE.putDocument(document.getId(), document);
                documents.add(document);
                ++n2;
            }
            reader.close();
        }
        catch (IOException iOException) {}
        return documents;
    }

    public synchronized List<Document> queryDocuments(Query query) {
        if (query == null) {
            return Collections.emptyList();
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        try {
            ScoreDoc[] hits;
            if (!this.indexReaderExists(this.getRepository().getDataDirectory())) {
                return documents;
            }
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getDataDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            ScoreDoc[] scoreDocArray = hits = LuceneRepository.getHits(searcher, query);
            int n = hits.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc hit = scoreDocArray[n2];
                StoredFields storedFields = searcher.storedFields();
                org.apache.lucene.document.Document luceneDoc = storedFields.document(hit.doc);
                Document document = MetaFactory.eINSTANCE.createDocument();
                LuceneRepository.buildDocument(document, luceneDoc);
                MetaFactory.eINSTANCE.putDocument(document.getId(), document);
                documents.add(document);
                ++n2;
            }
            reader.close();
        }
        catch (IOException iOException) {}
        return documents;
    }

    public synchronized Document readDocument(String documentId) {
        Document document = null;
        if (documentId == null || documentId.length() == 0) {
            return document;
        }
        Query query = this.getDocumentQuery(documentId);
        try {
            if (!this.indexReaderExists(this.getRepository().getDataDirectory())) {
                return document;
            }
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getDataDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            ScoreDoc[] hits = LuceneRepository.getHits(searcher, query);
            if (hits.length == 1) {
                ScoreDoc hit = hits[0];
                StoredFields storedFields = searcher.storedFields();
                org.apache.lucene.document.Document luceneDoc = storedFields.document(hit.doc);
                document = MetaFactory.eINSTANCE.createDocument();
                LuceneRepository.buildDocument(document, luceneDoc);
                MetaFactory.eINSTANCE.putDocument(documentId, document);
            }
            reader.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
        return document;
    }

    public synchronized void writeDocuments(String category, List<Document> documents) {
        HashSet<String> categories = null;
        if (category != null && category.length() > 0) {
            categories = new HashSet<String>(1);
            categories.add(category);
        }
        this.writeDocuments(categories, documents);
    }

    public synchronized void writeDocuments(Set<String> categories, List<Document> documents) {
        if (documents == null) {
            return;
        }
        try {
            IndexWriter writer = this.getRepository().getDataWriter();
            for (Document document : documents) {
                org.apache.lucene.document.Document luceneDoc = new org.apache.lucene.document.Document();
                if (categories == null || categories.size() == 0) {
                    String category = "";
                    luceneDoc.add((IndexableField)new Field("_FIELD_CATEGORY", (CharSequence)category, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
                } else {
                    for (String category : categories) {
                        luceneDoc.add((IndexableField)new Field("_FIELD_CATEGORY", (CharSequence)category, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
                    }
                }
                LuceneRepository.buildLuceneDoc(luceneDoc, document);
                writer.addDocument((Iterable)luceneDoc);
            }
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
            throw Util.rethrow((Throwable)e);
        }
    }

    public synchronized void writeDocument(String category, Document document) {
        HashSet<String> categories = null;
        if (category != null && category.length() > 0) {
            categories = new HashSet<String>(1);
            categories.add(category);
        }
        this.writeDocument(categories, document);
    }

    public synchronized void writeDocument(Set<String> categories, Document document) {
        if (document == null) {
            return;
        }
        try {
            IndexWriter writer = this.getRepository().getDataWriter();
            org.apache.lucene.document.Document luceneDoc = new org.apache.lucene.document.Document();
            if (categories == null || categories.size() == 0) {
                String category = "";
                luceneDoc.add((IndexableField)new Field("_FIELD_CATEGORY", (CharSequence)category, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
            } else {
                for (String category : categories) {
                    luceneDoc.add((IndexableField)new Field("_FIELD_CATEGORY", (CharSequence)category, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
                }
            }
            LuceneRepository.buildLuceneDoc(luceneDoc, document);
            writer.addDocument((Iterable)luceneDoc);
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
            throw Util.rethrow((Throwable)e);
        }
    }

    public synchronized void deleteDocuments(MetadataContext context) {
        try {
            if (context != null && (context.getCategories() != null || context.getProjectNames() != null)) {
                IndexWriter writer = this.getRepository().getDataWriter();
                Query query = MetadataAccess.getContextQuery(context);
                writer.deleteDocuments(new Query[]{query});
                writer.close();
            } else {
                this.deleteAll(".dat");
            }
        }
        catch (IOException ioe) {
            this.deleteAll(".dat");
            MetaPlugin.logError((Throwable)ioe);
        }
    }

    public synchronized void deleteDocuments(Set<String> documentIds) {
        if (documentIds == null || documentIds.size() == 0) {
            return;
        }
        try {
            IndexWriter writer = this.getRepository().getDataWriter();
            for (String documentId : documentIds) {
                Query query = this.getDocumentQuery(documentId);
                writer.deleteDocuments(new Query[]{query});
            }
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
    }

    public synchronized void deleteDocument(String documentId) {
        if (documentId == null || documentId.length() == 0) {
            return;
        }
        Query query = this.getDocumentQuery(documentId);
        try {
            IndexWriter writer = this.getRepository().getDataWriter();
            writer.deleteDocuments(new Query[]{query});
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
    }

    public synchronized Map<String, Integer> countReferences(Set<String> documentIds, int direction) {
        MetadataContext context = new MetadataContext(null, null);
        return this.countReferences(context, documentIds, direction);
    }

    public synchronized Map<String, Integer> countReferences(String category, Set<String> documentIds, int direction) {
        MetadataContext context = new MetadataContext(category, null);
        return this.countReferences(context, documentIds, direction);
    }

    public synchronized Map<String, Integer> countReferences(MetadataContext context, Set<String> documentIds, int direction) {
        if (documentIds == null || documentIds.size() == 0) {
            return Collections.emptyMap();
        }
        if (direction != 0 && direction != 1) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> allRefCounts = new HashMap<String, Integer>();
        try {
            if (!this.indexReaderExists(this.getRepository().getXRefDirectory())) {
                return allRefCounts;
            }
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getXRefDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            for (String documentId : documentIds) {
                Query query = this.getReferenceQuery(context, documentId, direction);
                ScoreDoc[] hits = LuceneRepository.getHits(searcher, query);
                allRefCounts.put(documentId, hits.length);
            }
            reader.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
        return allRefCounts;
    }

    public synchronized int countReferences(String documentId, int direction) {
        MetadataContext context = new MetadataContext(null, null);
        return this.countReferences(context, documentId, direction);
    }

    public synchronized int countReferences(String category, String documentId, int direction) {
        MetadataContext context = new MetadataContext(category, null);
        return this.countReferences(context, documentId, direction);
    }

    public synchronized int countReferences(MetadataContext context, String documentId, int direction) {
        Query query;
        int refCount;
        block5: {
            if (documentId == null || documentId.length() == 0) {
                return 0;
            }
            if (direction != 0 && direction != 1) {
                return 0;
            }
            refCount = 0;
            query = this.getReferenceQuery(context, documentId, direction);
            if (this.indexReaderExists(this.getRepository().getXRefDirectory())) break block5;
            return 0;
        }
        try {
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getXRefDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            ScoreDoc[] hits = LuceneRepository.getHits(searcher, query);
            refCount = hits.length;
            reader.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
        return refCount;
    }

    public synchronized Map<String, List<Reference>> readReferences(MetadataContext context) {
        HashMap<String, List<Reference>> allReferences = new HashMap<String, List<Reference>>();
        Query query = MetadataAccess.getContextQuery(context);
        try {
            ScoreDoc[] hits;
            if (!this.indexReaderExists(this.getRepository().getXRefDirectory())) {
                return allReferences;
            }
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getXRefDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            ScoreDoc[] scoreDocArray = hits = LuceneRepository.getHits(searcher, query);
            int n = hits.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc hit = scoreDocArray[n2];
                StoredFields storedFields = searcher.storedFields();
                org.apache.lucene.document.Document luceneDoc = storedFields.document(hit.doc);
                Reference reference = MetaFactory.eINSTANCE.createReference();
                LuceneRepository.buildReference(reference, luceneDoc);
                ArrayList<Reference> references = (ArrayList<Reference>)allReferences.get(reference.getSourceId());
                if (references == null) {
                    references = new ArrayList<Reference>(1);
                    allReferences.put(reference.getSourceId(), references);
                }
                references.add(reference);
                ++n2;
            }
            reader.close();
        }
        catch (IOException iOException) {}
        return allReferences;
    }

    public synchronized Map<String, List<Reference>> readReferences(Set<String> documentIds, int direction) {
        MetadataContext context = new MetadataContext(null, null);
        return this.readReferences(context, documentIds, direction);
    }

    public synchronized Map<String, List<Reference>> readReferences(String category, Set<String> documentIds, int direction) {
        MetadataContext context = new MetadataContext(category, null);
        return this.readReferences(context, documentIds, direction);
    }

    public synchronized Map<String, List<Reference>> readReferences(MetadataContext context, Set<String> documentIds, int direction) {
        if (documentIds == null || documentIds.size() == 0) {
            return Collections.emptyMap();
        }
        if (direction != 0 && direction != 1) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Reference>> allReferences = new HashMap<String, List<Reference>>();
        try {
            if (!this.indexReaderExists(this.getRepository().getXRefDirectory())) {
                return allReferences;
            }
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getXRefDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            HashSet<String> pageIds = new HashSet<String>(IndexSearcher.getMaxClauseCount());
            Iterator<String> iterator = documentIds.iterator();
            while (iterator.hasNext()) {
                String documentId = iterator.next();
                boolean isLast = !iterator.hasNext();
                pageIds.add(documentId);
                if (!isLast && pageIds.size() != IndexSearcher.getMaxClauseCount()) continue;
                Query query = this.getReferenceQuery(context, pageIds, direction);
                ScoreDoc[] hits = LuceneRepository.getHits(searcher, query);
                pageIds = new HashSet(IndexSearcher.getMaxClauseCount());
                ScoreDoc[] scoreDocArray = hits;
                int n = hits.length;
                int n2 = 0;
                while (n2 < n) {
                    ScoreDoc hit = scoreDocArray[n2];
                    StoredFields storedFields = searcher.storedFields();
                    org.apache.lucene.document.Document luceneDoc = storedFields.document(hit.doc);
                    Reference reference = MetaFactory.eINSTANCE.createReference();
                    LuceneRepository.buildReference(reference, luceneDoc);
                    String keyId = null;
                    if (direction == 0) {
                        keyId = reference.getSourceId();
                    } else if (direction == 1) {
                        keyId = reference.getTargetId();
                    }
                    ArrayList<Reference> references = (ArrayList<Reference>)allReferences.get(keyId);
                    if (references == null) {
                        references = new ArrayList<Reference>(1);
                        allReferences.put(keyId, references);
                    }
                    references.add(reference);
                    ++n2;
                }
            }
            reader.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
        return allReferences;
    }

    public synchronized List<Reference> readReferences(String documentId, int direction) {
        MetadataContext context = new MetadataContext(null, null);
        return this.readReferences(context, documentId, direction);
    }

    public synchronized List<Reference> readReferences(String category, String documentId, int direction) {
        MetadataContext context = new MetadataContext(category, null);
        return this.readReferences(context, documentId, direction);
    }

    public synchronized List<Reference> readReferences(MetadataContext context, String documentId, int direction) {
        if (documentId == null || documentId.length() == 0) {
            return Collections.emptyList();
        }
        if (direction != 0 && direction != 1) {
            return Collections.emptyList();
        }
        ArrayList<Reference> references = new ArrayList<Reference>();
        Query query = this.getReferenceQuery(context, documentId, direction);
        try {
            ScoreDoc[] hits;
            if (!this.indexReaderExists(this.getRepository().getXRefDirectory())) {
                return references;
            }
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getXRefDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            ScoreDoc[] scoreDocArray = hits = LuceneRepository.getHits(searcher, query);
            int n = hits.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc hit = scoreDocArray[n2];
                StoredFields storedFields = searcher.storedFields();
                org.apache.lucene.document.Document luceneDoc = storedFields.document(hit.doc);
                Reference reference = MetaFactory.eINSTANCE.createReference();
                LuceneRepository.buildReference(reference, luceneDoc);
                references.add(reference);
                ++n2;
            }
            reader.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
        return references;
    }

    public synchronized List<Reference> queryReferences(Query query) {
        if (query == null) {
            return Collections.emptyList();
        }
        ArrayList<Reference> references = new ArrayList<Reference>();
        try {
            ScoreDoc[] hits;
            if (!this.indexReaderExists(this.getRepository().getXRefDirectory())) {
                return references;
            }
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getXRefDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            ScoreDoc[] scoreDocArray = hits = LuceneRepository.getHits(searcher, query);
            int n = hits.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc hit = scoreDocArray[n2];
                StoredFields storedFields = searcher.storedFields();
                org.apache.lucene.document.Document luceneDoc = storedFields.document(hit.doc);
                Reference reference = MetaFactory.eINSTANCE.createReference();
                LuceneRepository.buildReference(reference, luceneDoc);
                references.add(reference);
                ++n2;
            }
            reader.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
        return references;
    }

    public synchronized void writeReferences(String category, Map<String, List<Reference>> allReferences) {
        HashSet<String> categories = null;
        if (category != null && category.length() > 0) {
            categories = new HashSet<String>(1);
            categories.add(category);
        }
        this.writeReferences(categories, allReferences);
    }

    public synchronized void writeReferences(Set<String> categories, Map<String, List<Reference>> allReferences) {
        if (allReferences == null) {
            return;
        }
        try {
            IndexWriter writer = this.getRepository().getXRefWriter();
            for (Map.Entry<String, List<Reference>> entry : allReferences.entrySet()) {
                String documentId = entry.getKey();
                List<Reference> references = entry.getValue();
                String project = MetadataService.getProject((String)documentId);
                for (Reference reference : references) {
                    org.apache.lucene.document.Document luceneDoc = new org.apache.lucene.document.Document();
                    if (categories == null || categories.size() == 0) {
                        String category = "";
                        luceneDoc.add((IndexableField)new Field("_FIELD_CATEGORY", (CharSequence)category, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
                    } else {
                        for (String category : categories) {
                            luceneDoc.add((IndexableField)new Field("_FIELD_CATEGORY", (CharSequence)category, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
                        }
                    }
                    luceneDoc.add((IndexableField)new Field("_FIELD_PROJECT", (CharSequence)project, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
                    LuceneRepository.buildLuceneDoc(luceneDoc, reference);
                    Field field = (Field)luceneDoc.getField("_FIELD_SOURCE_ID");
                    field.setStringValue(documentId);
                    writer.addDocument((Iterable)luceneDoc);
                }
            }
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
            throw Util.rethrow((Throwable)e);
        }
    }

    public synchronized void writeReferences(String category, String documentId, List<Reference> references) {
        HashSet<String> categories = null;
        if (category != null && category.length() > 0) {
            categories = new HashSet<String>(1);
            categories.add(category);
        }
        this.writeReferences(categories, documentId, references);
    }

    public synchronized void writeReferences(Set<String> categories, String documentId, List<Reference> references) {
        if (documentId == null || documentId.length() == 0 || references == null) {
            return;
        }
        try {
            IndexWriter writer = this.getRepository().getXRefWriter();
            String project = MetadataService.getProject((String)documentId);
            for (Reference reference : references) {
                org.apache.lucene.document.Document luceneDoc = new org.apache.lucene.document.Document();
                if (categories == null || categories.size() == 0) {
                    String category = "";
                    luceneDoc.add((IndexableField)new Field("_FIELD_CATEGORY", (CharSequence)category, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
                } else {
                    for (String category : categories) {
                        luceneDoc.add((IndexableField)new Field("_FIELD_CATEGORY", (CharSequence)category, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
                    }
                }
                luceneDoc.add((IndexableField)new Field("_FIELD_PROJECT", (CharSequence)project, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
                LuceneRepository.buildLuceneDoc(luceneDoc, reference);
                Field field = (Field)luceneDoc.getField("_FIELD_SOURCE_ID");
                field.setStringValue(documentId);
                writer.addDocument((Iterable)luceneDoc);
            }
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
            throw Util.rethrow((Throwable)e);
        }
    }

    public synchronized void deleteReferences(MetadataContext context) {
        try {
            if (context != null && (context.getCategories() != null || context.getProjectNames() != null)) {
                IndexWriter writer = this.getRepository().getXRefWriter();
                Query query = MetadataAccess.getContextQuery(context);
                writer.deleteDocuments(new Query[]{query});
                writer.close();
            } else {
                this.deleteAll(".xref");
            }
        }
        catch (IOException e) {
            this.deleteAll(".xref");
            MetaPlugin.logError((Throwable)e);
        }
    }

    public synchronized void deleteReferences(Set<String> documentIds) {
        MetadataContext context = new MetadataContext(null, null);
        this.deleteReferences(context, documentIds);
    }

    public synchronized void deleteReferences(String category, Set<String> documentIds) {
        MetadataContext context = new MetadataContext(category, null);
        this.deleteReferences(context, documentIds);
    }

    public synchronized void deleteReferences(MetadataContext context, Set<String> documentIds) {
        if (documentIds == null || documentIds.size() == 0) {
            return;
        }
        try {
            HashSet<String> pageIds = new HashSet<String>(IndexSearcher.getMaxClauseCount());
            Iterator<String> iterator = documentIds.iterator();
            while (iterator.hasNext()) {
                String documentId = iterator.next();
                boolean isLast = !iterator.hasNext();
                pageIds.add(documentId);
                if (!isLast && pageIds.size() != IndexSearcher.getMaxClauseCount()) continue;
                Query query = this.getReferenceQuery(context, pageIds, 0);
                pageIds = new HashSet(IndexSearcher.getMaxClauseCount());
                IndexWriter writer = this.getRepository().getXRefWriter();
                writer.deleteDocuments(new Query[]{query});
                writer.close();
            }
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
    }

    public synchronized void deleteReferences(String documentId) {
        MetadataContext context = new MetadataContext(null, null);
        this.deleteReferences(context, documentId);
    }

    public synchronized void deleteReferences(String category, String documentId) {
        MetadataContext context = new MetadataContext(category, null);
        this.deleteReferences(context, documentId);
    }

    public synchronized void deleteReferences(MetadataContext context, String documentId) {
        if (documentId == null || documentId.length() == 0) {
            return;
        }
        Query query = this.getReferenceQuery(context, documentId, 0);
        try {
            IndexWriter writer = this.getRepository().getXRefWriter();
            writer.deleteDocuments(new Query[]{query});
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
    }

    public synchronized Set<String> readMergedReferences(Set<String> documentIds, int direction) {
        MetadataContext context = new MetadataContext(null, null);
        return this.readMergedReferences(context, documentIds, direction);
    }

    public synchronized Set<String> readMergedReferences(String category, Set<String> documentIds, int direction) {
        MetadataContext context = new MetadataContext(category, null);
        return this.readMergedReferences(context, documentIds, direction);
    }

    public synchronized Set<String> readMergedReferences(MetadataContext context, Set<String> documentIds, int direction) {
        if (documentIds == null || documentIds.size() == 0) {
            return Collections.emptySet();
        }
        if (direction != 0 && direction != 1) {
            return Collections.emptySet();
        }
        HashSet<String> allReferences = new HashSet<String>();
        try {
            if (!this.indexReaderExists(this.getRepository().getXRefDirectory())) {
                return allReferences;
            }
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getXRefDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            HashSet<String> pageIds = new HashSet<String>(IndexSearcher.getMaxClauseCount());
            Iterator<String> iterator = documentIds.iterator();
            while (iterator.hasNext()) {
                String documentId = iterator.next();
                boolean isLast = !iterator.hasNext();
                pageIds.add(documentId);
                if (!isLast && pageIds.size() != IndexSearcher.getMaxClauseCount()) continue;
                Query query = this.getReferenceQuery(context, pageIds, direction);
                ScoreDoc[] hits = LuceneRepository.getHits(searcher, query);
                pageIds = new HashSet(IndexSearcher.getMaxClauseCount());
                ScoreDoc[] scoreDocArray = hits;
                int n = hits.length;
                int n2 = 0;
                while (n2 < n) {
                    ScoreDoc hit = scoreDocArray[n2];
                    StoredFields storedFields = searcher.storedFields();
                    org.apache.lucene.document.Document luceneDoc = storedFields.document(hit.doc);
                    if (direction == 0) {
                        allReferences.add(luceneDoc.get("_FIELD_TARGET_ID"));
                    } else if (direction == 1) {
                        allReferences.add(luceneDoc.get("_FIELD_SOURCE_ID"));
                    }
                    ++n2;
                }
            }
            reader.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
        return allReferences;
    }

    public synchronized void writeReferences(String category, List<Reference> references) {
        HashSet<String> categories = null;
        if (category != null && category.length() > 0) {
            categories = new HashSet<String>(1);
            categories.add(category);
        }
        this.writeReferences(categories, references);
    }

    public synchronized void writeReferences(Set<String> categories, List<Reference> references) {
        if (references == null) {
            return;
        }
        try {
            IndexWriter writer = this.getRepository().getXRefWriter();
            for (Reference reference : references) {
                String project = MetadataService.getProject((String)reference.getSourceId());
                org.apache.lucene.document.Document luceneDoc = new org.apache.lucene.document.Document();
                if (categories == null || categories.size() == 0) {
                    String category = "";
                    luceneDoc.add((IndexableField)new Field("_FIELD_CATEGORY", (CharSequence)category, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
                } else {
                    for (String category : categories) {
                        luceneDoc.add((IndexableField)new Field("_FIELD_CATEGORY", (CharSequence)category, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
                    }
                }
                luceneDoc.add((IndexableField)new Field("_FIELD_PROJECT", (CharSequence)project, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
                LuceneRepository.buildLuceneDoc(luceneDoc, reference);
                writer.addDocument((Iterable)luceneDoc);
            }
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
            throw Util.rethrow((Throwable)e);
        }
    }

    public synchronized void writeReference(String category, Reference reference) {
        HashSet<String> categories = null;
        if (category != null && category.length() > 0) {
            categories = new HashSet<String>(1);
            categories.add(category);
        }
        this.writeReference(categories, reference);
    }

    public synchronized void writeReference(Set<String> categories, Reference reference) {
        if (reference == null) {
            return;
        }
        try {
            IndexWriter writer = this.getRepository().getXRefWriter();
            String project = MetadataService.getProject((String)reference.getSourceId());
            org.apache.lucene.document.Document luceneDoc = new org.apache.lucene.document.Document();
            if (categories == null || categories.size() == 0) {
                String category = "";
                luceneDoc.add((IndexableField)new Field("_FIELD_CATEGORY", (CharSequence)category, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
            } else {
                for (String category : categories) {
                    luceneDoc.add((IndexableField)new Field("_FIELD_CATEGORY", (CharSequence)category, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
                }
            }
            luceneDoc.add((IndexableField)new Field("_FIELD_PROJECT", (CharSequence)project, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
            LuceneRepository.buildLuceneDoc(luceneDoc, reference);
            writer.addDocument((Iterable)luceneDoc);
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
            throw Util.rethrow((Throwable)e);
        }
    }

    public synchronized void deleteReferences(List<Reference> references) {
        if (references == null) {
            return;
        }
        HashSet<String> referenceIds = new HashSet<String>();
        try {
            IndexWriter writer = this.getRepository().getXRefWriter();
            ArrayList<BooleanQuery> queries = new ArrayList<BooleanQuery>();
            int index = 0;
            Iterator<Reference> iterator = references.iterator();
            while (iterator.hasNext()) {
                ++index;
                Reference reference = iterator.next();
                boolean isLast = !iterator.hasNext();
                String referenceId = reference.getId();
                if (!referenceIds.contains(referenceId)) {
                    referenceIds.add(referenceId);
                    String sourceId = reference.getSourceId();
                    String targetId = reference.getTargetId();
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    builder.add((Query)new TermQuery(new Term("_FIELD_SOURCE_ID", sourceId)), BooleanClause.Occur.MUST);
                    builder.add((Query)new TermQuery(new Term("_FIELD_TARGET_ID", targetId)), BooleanClause.Occur.MUST);
                    queries.add(builder.build());
                }
                if (index <= 0 || !isLast && index != BooleanQuery.getMaxClauseCount()) continue;
                writer.deleteDocuments(queries.toArray(new Query[queries.size()]));
                queries = new ArrayList();
                index = 0;
            }
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
    }

    public synchronized void deleteReference(Reference reference) {
        if (reference == null) {
            return;
        }
        try {
            IndexWriter writer = this.getRepository().getXRefWriter();
            Term sourceTerm = new Term("_FIELD_SOURCE_ID", reference.getSourceId());
            Term targetTerm = new Term("_FIELD_TARGET_ID", reference.getTargetId());
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add((Query)new TermQuery(sourceTerm), BooleanClause.Occur.MUST);
            builder.add((Query)new TermQuery(targetTerm), BooleanClause.Occur.MUST);
            writer.deleteDocuments(new Query[]{builder.build()});
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
    }

    private void deleteAll(String directory) {
        File metaDirectory = MetaPlugin.getDefault().getStateLocation().toFile();
        if (".dat".equals(directory) || ".xref".equals(directory)) {
            File dataDirectory = new File(metaDirectory, directory);
            File[] fileArray = dataDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File dataFile = fileArray[n2];
                dataFile.delete();
                ++n2;
            }
        }
    }

    private Query getDocumentQuery(String documentId) {
        String[] tokens = MetadataService.getTokens((String)documentId);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        Term projectTerm = new Term("_FIELD_PROJECT", tokens[0]);
        builder.add((Query)new TermQuery(projectTerm), BooleanClause.Occur.MUST);
        if (tokens[1].length() > 0) {
            Term packageTerm = new Term("_FIELD_PACKAGE", tokens[1]);
            builder.add((Query)new TermQuery(packageTerm), BooleanClause.Occur.MUST);
        }
        Term nameTerm = new Term("_FIELD_NAME", tokens[2]);
        builder.add((Query)new TermQuery(nameTerm), BooleanClause.Occur.MUST);
        if (tokens[3].length() > 0) {
            Term metaTypeTerm = new Term("_FIELD_META_TYPE", tokens[3]);
            builder.add((Query)new TermQuery(metaTypeTerm), BooleanClause.Occur.MUST);
        }
        Term typeTerm = new Term("_FIELD_TYPE", tokens[4]);
        builder.add((Query)new TermQuery(typeTerm), BooleanClause.Occur.MUST);
        BooleanQuery query = builder.build();
        return query;
    }

    private Query getReferenceQuery(MetadataContext context, String documentId, int direction) {
        TermQuery query = null;
        Query contextQuery = MetadataAccess.getContextQuery(context);
        Term term = null;
        if (direction == 0) {
            term = new Term("_FIELD_SOURCE_ID", documentId);
        } else if (direction == 1) {
            term = new Term("_FIELD_TARGET_ID", documentId);
        }
        if (!(contextQuery instanceof MatchAllDocsQuery)) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(contextQuery, BooleanClause.Occur.MUST);
            builder.add((Query)new TermQuery(term), BooleanClause.Occur.MUST);
            query = builder.build();
        } else {
            query = new TermQuery(term);
        }
        return query;
    }

    private Query getReferenceQuery(MetadataContext context, Set<String> documentIds, int direction) {
        if (documentIds.size() > IndexSearcher.getMaxClauseCount()) {
            return null;
        }
        Query contextQuery = MetadataAccess.getContextQuery(context);
        BooleanQuery.Builder documentsBuilder = new BooleanQuery.Builder();
        for (String documentId : documentIds) {
            Term term = null;
            if (direction == 0) {
                term = new Term("_FIELD_SOURCE_ID", documentId);
            } else if (direction == 1) {
                term = new Term("_FIELD_TARGET_ID", documentId);
            }
            documentsBuilder.add((Query)new TermQuery(term), BooleanClause.Occur.SHOULD);
        }
        BooleanQuery documentsQuery = documentsBuilder.build();
        BooleanQuery query = null;
        if (!(contextQuery instanceof MatchAllDocsQuery)) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(contextQuery, BooleanClause.Occur.MUST);
            builder.add((Query)documentsQuery, BooleanClause.Occur.MUST);
            query = builder.build();
        } else {
            query = documentsQuery;
        }
        return query;
    }
}

