/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.link.design;

import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.Property;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import java.util.List;

public class RubriqueUsage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String DATAELEMENT = "dataelement";
    private static final String LINE_NUMBER = "line";
    private static final String PAC_FUNCTION = "fct";
    private static final String ORIGIN = "macro";
    private static final String BEGIN_OFFSET = "begin";
    private static final String END_OFFSET = "end";
    private static final String LINE_OFFSET = "lineOff";
    private static final String CONTEXTUAL_LINE = "ctx";
    private String name;
    private int beginOffset;
    private int endOffset;
    private int lineNumber;
    private String line;
    private int lineOffset;
    private String encompassingPacFunction;
    private String macroName;

    public RubriqueUsage(String wName, int wBeginOffset, int wEndOffset, int wLineNumber, int wLineOffset, String wLine) {
        this.name = wName;
        this.beginOffset = wBeginOffset;
        this.endOffset = wEndOffset;
        this.lineNumber = wLineNumber;
        this.line = wLine;
        this.encompassingPacFunction = "";
        this.macroName = "";
        this.lineOffset = wLineOffset;
    }

    public String getName() {
        return this.name;
    }

    public int getBeginOffset() {
        return this.beginOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public String getLine() {
        return this.line;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" between [");
        sb.append(this.getBeginOffset());
        sb.append(", ");
        sb.append(this.getEndOffset());
        sb.append("]\r\nPacFunction=");
        sb.append(this.getEncompassingPacFunction());
        sb.append(",  MacroName=");
        sb.append(this.getMacroName());
        sb.append(",  LineNum=");
        sb.append(this.getLineNumber());
        sb.append(",  LineOffset=");
        sb.append(this.getLineOffset());
        sb.append("\r\nLine contents=");
        sb.append(this.getLine());
        return sb.toString();
    }

    public String getEncompassingPacFunction() {
        return this.encompassingPacFunction;
    }

    public void setEncompassingPacFunction(String encompassingPacFunction) {
        this.encompassingPacFunction = encompassingPacFunction;
    }

    public String getMacroName() {
        return this.macroName;
    }

    public void setMacroName(String macroName) {
        this.macroName = macroName;
    }

    public String buildTargetIdName() {
        int len = this.name.length();
        int deb = 0;
        int i = len - 1;
        while (i > 0) {
            char c = this.name.charAt(i);
            if (c == '-') {
                deb = i + 1;
                break;
            }
            --i;
        }
        return this.name.substring(deb);
    }

    public Reference convertIntoReference(String documentId) {
        Reference aReference = MetaFactory.eINSTANCE.createReference();
        aReference.setSourceId(documentId);
        aReference.setTargetId(this.formatReferenceTargetForLucene(this));
        aReference.setStateId("");
        aReference.setRelation("usage");
        List properties = aReference.getProperties();
        Property property = MetaFactory.eINSTANCE.createProperty();
        property.setName(LINE_NUMBER);
        property.setValue(Integer.toString(this.getLineNumber()));
        properties.add(property);
        property = MetaFactory.eINSTANCE.createProperty();
        property.setName(PAC_FUNCTION);
        property.setValue(this.getEncompassingPacFunction());
        properties.add(property);
        property = MetaFactory.eINSTANCE.createProperty();
        property.setName(ORIGIN);
        property.setValue(this.getMacroName());
        properties.add(property);
        property = MetaFactory.eINSTANCE.createProperty();
        property.setName(BEGIN_OFFSET);
        property.setValue(Integer.toString(this.getBeginOffset()));
        properties.add(property);
        property = MetaFactory.eINSTANCE.createProperty();
        property.setName(END_OFFSET);
        property.setValue(Integer.toString(this.getEndOffset()));
        properties.add(property);
        property = MetaFactory.eINSTANCE.createProperty();
        property.setName(LINE_OFFSET);
        property.setValue(Integer.toString(this.getLineOffset()));
        properties.add(property);
        property = MetaFactory.eINSTANCE.createProperty();
        property.setName(CONTEXTUAL_LINE);
        property.setValue(this.getLine());
        properties.add(property);
        return aReference;
    }

    private String formatReferenceTargetForLucene(RubriqueUsage ru) {
        String id = MetadataService.getId((String)"", (String)"", (String)ru.buildTargetIdName(), null, (String)DATAELEMENT);
        return id;
    }
}

