/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.link.design;

import com.ibm.pdp.mdl.link.design.IMpAnalyser;
import com.ibm.pdp.mdl.link.design.ReferencedEntity;
import java.util.ArrayList;
import java.util.List;

public class MpWfAnalyser
implements IMpAnalyser {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String EMPTY_STRING = "";
    private static final String DATA_UNIT = "dataunit";
    private static final String DATA_AGGREGATE = "dataaggregate";
    private static final String DSL_STRING = "DSL=";
    private static final String DSP_STRING = "DSP=";
    private static final String SEL_STRING = "SEL=";
    private static final String WF_MICRO_PATTERN = "WF";

    @Override
    public String getName() {
        return WF_MICRO_PATTERN;
    }

    @Override
    public boolean accept(String param) {
        return param.indexOf(this.getName()) == 8;
    }

    private String getStringAfterEqual(String snippet, int start) {
        String result = EMPTY_STRING;
        char charToSearch = ' ';
        if (snippet.charAt(start) == '\'') {
            charToSearch = '\'';
            ++start;
        } else if (snippet.charAt(start) == '\"') {
            charToSearch = '\"';
            ++start;
        }
        int i = start;
        while (i < snippet.length()) {
            if (charToSearch != ' ') {
                if (snippet.charAt(i) == charToSearch) {
                    result = snippet.substring(start, i).trim();
                    return result;
                }
            } else if (Character.isWhitespace(snippet.charAt(i))) {
                result = snippet.substring(start, i);
                return result;
            }
            ++i;
        }
        return EMPTY_STRING;
    }

    private void addSegments(List<ReferencedEntity> refEntities, String segments, String ds, int offset) {
        if (segments.length() % 2 != 0) {
            return;
        }
        int i = 0;
        while (i < segments.length()) {
            String seg = segments.substring(i, i + 2);
            if (seg.indexOf(36) == -1) {
                ReferencedEntity re = new ReferencedEntity(String.valueOf(ds) + seg, null, DATA_AGGREGATE, WF_MICRO_PATTERN, offset);
                refEntities.add(re);
            }
            i += 2;
        }
    }

    private void createAndAddDataStructure(List<ReferencedEntity> refEntities, String ds, int offset) {
        ReferencedEntity re = new ReferencedEntity(ds, null, DATA_UNIT, WF_MICRO_PATTERN, offset);
        refEntities.add(re);
    }

    private String removeDollarsAndEqualsSymbols(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '=') {
                i += 3;
                continue;
            }
            if (c == '$') {
                i += 2;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    @Override
    public List<ReferencedEntity> getReferencedEntities(String text, int beginIdx, int endIdx) {
        int dslLength;
        String remainingStr;
        String snippet = text.substring(beginIdx, endIdx);
        int idxDSL = snippet.indexOf(DSL_STRING);
        int idxDSP = snippet.indexOf(DSP_STRING);
        if (idxDSL == -1 && idxDSP == -1) {
            return null;
        }
        int idx = idxDSL;
        if (idxDSL == -1) {
            idx = idxDSP;
        }
        if ((remainingStr = this.getStringAfterEqual(snippet, idx + (dslLength = DSL_STRING.length()))).indexOf(36) != -1) {
            return null;
        }
        String ds = null;
        if (remainingStr.length() == 4) {
            ds = remainingStr.substring(1, 3);
        } else if (remainingStr.length() == 2) {
            ds = remainingStr;
        } else {
            return null;
        }
        ArrayList<ReferencedEntity> refEntities = new ArrayList<ReferencedEntity>();
        int offsetForDSLValue = beginIdx + idxDSL + dslLength;
        this.createAndAddDataStructure(refEntities, ds, offsetForDSLValue);
        int selLength = SEL_STRING.length();
        int idx2 = snippet.indexOf(SEL_STRING);
        if (idx2 == -1) {
            return refEntities;
        }
        remainingStr = this.getStringAfterEqual(snippet, idx2 + selLength);
        String segments = null;
        if (remainingStr.length() > 0) {
            segments = remainingStr.charAt(0) == '\'' || remainingStr.charAt(0) == '\"' ? remainingStr.substring(1, remainingStr.length() - 1) : remainingStr;
        } else {
            return refEntities;
        }
        segments = this.removeDollarsAndEqualsSymbols(segments);
        if (segments.length() == 0) {
            return refEntities;
        }
        int offsetForSELValue = beginIdx + idx2 + selLength;
        this.addSegments(refEntities, segments, ds, offsetForSELValue);
        return refEntities;
    }
}

