/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.link.design;

import com.ibm.pdp.mdl.link.design.CobolVariablesScanner;
import com.ibm.pdp.mdl.link.design.IMpAnalyser;
import com.ibm.pdp.mdl.link.design.ReferencedEntity;
import com.ibm.pdp.mdl.link.design.RubriqueToken;
import com.ibm.pdp.mdl.link.design.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class MpCommonWLineAnalyser
implements IMpAnalyser {
    private static final Pattern WlineBeforeDECode = Pattern.compile("(\\s+|\\d{6}\\s+)\\d{2}\\s+(\\w|\\-)+\\-");
    private static final Pattern DeCode = Pattern.compile("\\w{1,6}");
    private static String DATA_ELEMENT = "dataelement";
    private String oldContent;
    private String afterPrefix;
    private String dataElementCode;
    private StringBuilder newContent;
    private CobolVariablesScanner _cobolVarScanner = new CobolVariablesScanner();
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public abstract String getName();

    @Override
    public abstract boolean accept(String var1);

    private void initialize() {
        this.dataElementCode = null;
        this.afterPrefix = MpCommonWLineAnalyser.BeforeDataElementCode(this.oldContent, this);
        MpCommonWLineAnalyser.DataElementCode(this.afterPrefix, this);
    }

    @Override
    public List<ReferencedEntity> getReferencedEntities(String text, int beginIdx, int endIdx) {
        int realDataIndex = Util.getLineEndOffset((CharSequence)text, (int)beginIdx);
        List list = this._cobolVarScanner.findVariables(text.substring(realDataIndex, endIdx));
        ArrayList<ReferencedEntity> refEntities = new ArrayList<ReferencedEntity>(1);
        if (list.size() == 0) {
            return refEntities;
        }
        for (RubriqueToken token : list) {
            ReferencedEntity re = new ReferencedEntity(token.getShortName(), null, DATA_ELEMENT, this.getName(), token.getIndexInLine() + realDataIndex);
            refEntities.add(re);
        }
        return refEntities;
    }

    public List<ReferencedEntity> getReferencedEntities_OldVersion(String text, int beginIdx, int endIdx) {
        int realDataIndex = Util.getLineEndOffset((CharSequence)text, (int)beginIdx);
        this.oldContent = text.substring(realDataIndex, endIdx);
        this.newContent = new StringBuilder(text.substring(realDataIndex, endIdx));
        this.initialize();
        ArrayList<ReferencedEntity> refEntities = new ArrayList<ReferencedEntity>(1);
        if (this.dataElementCode != null) {
            ReferencedEntity re = new ReferencedEntity(this.dataElementCode, null, DATA_ELEMENT, this.getName());
            refEntities.add(re);
        }
        return refEntities;
    }

    private static String BeforeDataElementCode(String s, MpCommonWLineAnalyser result) {
        Matcher m = WlineBeforeDECode.matcher(s);
        if (m.lookingAt()) {
            result.appendResult(s.substring(0, m.end()));
            return s.substring(m.end());
        }
        return "";
    }

    public void appendResult(String s) {
        this.newContent.append(s);
    }

    public String getDataElementCode() {
        return this.dataElementCode;
    }

    public void setDataElementCode(String code) {
        this.dataElementCode = code;
    }

    private static String DataElementCode(String s, MpCommonWLineAnalyser result) {
        Matcher m = DeCode.matcher(s);
        if (m.lookingAt()) {
            String code = s.substring(0, m.end());
            code = code.toUpperCase();
            result.setDataElementCode(code);
            result.appendResult(code);
            return s.substring(m.end());
        }
        return "";
    }
}

