/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.link.design;

import com.ibm.pdp.mdl.link.design.CobolVariablesScanner;
import com.ibm.pdp.mdl.link.design.MPReferencesFinder;
import com.ibm.pdp.mdl.link.design.MicroPatternsAndDEUsagesResults;
import com.ibm.pdp.mdl.link.design.RubriqueToken;
import com.ibm.pdp.mdl.link.design.RubriqueUsage;
import com.ibm.pdp.mdl.link.design.Util;
import com.ibm.pdp.mdl.meta.Reference;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MacrosMicroPatternsAndDEUsagesParser {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String EMPTY_STRING = "";
    private String _text;
    private String _documentId;
    private CobolVariablesScanner _cblVariablesScanner = new CobolVariablesScanner();

    public static void main(String[] args) {
    }

    private List<Reference> createRubUsagesReferences(List<RubriqueUsage> rubUsages) {
        ArrayList<Reference> references = new ArrayList<Reference>(rubUsages.size());
        int size = rubUsages.size();
        Reference aReference = null;
        int i = 0;
        while (i < size) {
            RubriqueUsage ru = rubUsages.get(i);
            aReference = ru.convertIntoReference(this._documentId);
            references.add(aReference);
            ++i;
        }
        return references;
    }

    protected String getStringFromStream(InputStream stream) {
        String result = EMPTY_STRING;
        try {
            result = Util.convertStreamToString((InputStream)stream);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        return result;
    }

    public MicroPatternsAndDEUsagesResults parse(String documentID, InputStream inputStream) {
        System.currentTimeMillis();
        this._text = this.getStringFromStream(inputStream);
        this._documentId = documentID;
        MicroPatternsAndDEUsagesResults drr = new MicroPatternsAndDEUsagesResults();
        drr.setDocumentId(this._documentId);
        MPReferencesFinder mprf = new MPReferencesFinder();
        Map<String, List<Reference>> mpDesignRefs = mprf.parse(this._documentId, this._text);
        Iterator<String> iter = mpDesignRefs.keySet().iterator();
        if (iter.hasNext()) {
            drr.setMicroPatternRefs(mpDesignRefs.get(iter.next()));
        }
        System.currentTimeMillis();
        List<RubriqueUsage> rubUsages = this.scanProcDivToFindUsages();
        System.currentTimeMillis();
        List<Reference> references = this.createRubUsagesReferences(rubUsages);
        drr.setDetailedUsages(references);
        System.currentTimeMillis();
        return drr;
    }

    private List<RubriqueUsage> findRubriquesOfProcDiv2(int counter, int lineNumber, String line) {
        ArrayList<RubriqueUsage> result = new ArrayList<RubriqueUsage>();
        List variablesInLine = this._cblVariablesScanner.findVariables(line);
        int i = 0;
        while (i < variablesInLine.size()) {
            RubriqueToken aToken = (RubriqueToken)variablesInLine.get(i);
            String aTokenName = aToken.getName();
            int debut = counter + aToken.getIndexInLine();
            int fin = debut + aTokenName.length();
            RubriqueUsage ru = new RubriqueUsage(aTokenName, debut, fin, lineNumber, counter, line.substring(0, line.length() - 2));
            String pacFunction = this.searchEncompassingPacFunction(debut);
            ru.setEncompassingPacFunction(pacFunction);
            ru.setMacroName(EMPTY_STRING);
            result.add(ru);
            ++i;
        }
        return result;
    }

    private List<RubriqueUsage> scanProcDivToFindUsages() {
        int counter = 0;
        int endFileOffset = this._text.length();
        int lineNumber = 1;
        ArrayList<RubriqueUsage> rubUsages = new ArrayList<RubriqueUsage>();
        while (counter < endFileOffset) {
            int end = Util.getLineEndOffset((CharSequence)this._text, (int)counter);
            String line = this._text.substring(counter, end);
            boolean doSearchUsage = true;
            if (line.length() >= 10) {
                List<RubriqueUsage> x;
                if (line.charAt(6) == '*') {
                    if (line.charAt(7) == '!') {
                        if (line.charAt(8) == 'W' && (line.charAt(9) == 'I' || line.charAt(9) == 'E' || line.charAt(9) == 'S')) {
                            ++lineNumber;
                            counter = end;
                            end = Util.getLineEndOffset((CharSequence)this._text, (int)counter);
                            doSearchUsage = false;
                        }
                    } else {
                        doSearchUsage = false;
                    }
                }
                if (doSearchUsage && (x = this.findRubriquesOfProcDiv2(counter, lineNumber, line)).size() > 0) {
                    rubUsages.addAll(x);
                }
            }
            ++lineNumber;
            counter = end;
        }
        return rubUsages;
    }

    private void displayRubriqueUsages(List<RubriqueUsage> list) {
        System.out.println("************************************");
        System.out.println("DesignReferencesFinder trace start");
        int i = 0;
        while (i < list.size()) {
            RubriqueUsage ru = list.get(i);
            System.out.println("************************************");
            System.out.println(ru.toString());
            ++i;
        }
        System.out.println("************************************");
        System.out.println("DesignReferencesFinder trace end");
        System.out.println("************************************");
    }

    private String searchEncompassingPacFunction(int start) {
        int counter = start;
        while (counter > 0) {
            int debut = Util.getLineStartOffset((CharSequence)this._text, (int)(counter - 2));
            String line = this._text.substring(debut, counter);
            if (!((line = line.trim()).length() != 3 && line.length() != 5 || line.charAt(0) != 'F' && line.charAt(0) != 'f')) {
                return line;
            }
            counter = debut;
        }
        return null;
    }
}

