/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.link.design;

import com.ibm.pdp.engine.IAnalyzerResult;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.ITextArtefactLocation;
import com.ibm.pdp.engine.extension.IMicroPatternHeaderHelper;
import com.ibm.pdp.engine.extension.IMicroPatternParsingEventHandler;
import com.ibm.pdp.engine.extension.TextArtefactLocation;
import com.ibm.pdp.engine.turbo.impl.MicroPattern;
import com.ibm.pdp.framework.cobol.micropattern.CobolMicroPatternHeaderHelper;
import com.ibm.pdp.framework.cobol.micropattern.CobolMicroPatternParser;
import com.ibm.pdp.framework.cobol.micropattern.MicroPatternExtractor;
import com.ibm.pdp.framework.cobol.micropattern.MicroPatternMark;
import com.ibm.pdp.mdl.link.design.MPParametersAnalysersMgr;
import com.ibm.pdp.mdl.link.design.ReferencedEntity;
import com.ibm.pdp.mdl.link.design.Util;
import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.Property;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.micropattern.analyzer.MPAnalyzerManager;
import com.ibm.pdp.micropattern.analyzer.MPException;
import com.ibm.pdp.micropattern.analyzer.plugin.IMPAnalyzer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MPReferencesFinder {
    private static final String DATA_DIVISION = " DATA DIVISION.";
    private static final String PROCEDURE_DIVISION = " PROCEDURE DIVISION";
    private static final String EMPTY_STRING = "";
    private static final String CR = System.getProperty("line.separator");
    public static final String OFFSET = "offset";
    private String _text;
    private int _endOffset;
    private int _startOffset;
    private String _documentId;
    private boolean _limitToDataAndProcDivistion = false;
    private boolean _isForCobol = true;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public MPReferencesFinder(boolean limitToDataAndProceDivistion, boolean isForCobol) {
        this._limitToDataAndProcDivistion = limitToDataAndProceDivistion;
        this._isForCobol = isForCobol;
    }

    public MPReferencesFinder() {
    }

    protected String getStringFromStream(InputStream stream) {
        long a = System.currentTimeMillis();
        String result = EMPTY_STRING;
        try {
            result = Util.convertStreamToString((InputStream)stream);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        long b = System.currentTimeMillis();
        return result;
    }

    private List<ReferencedEntity> analyseMPDeclarationV1(String text, int beginIdx, int endIdx) {
        List<ReferencedEntity> refEntities = MPParametersAnalysersMgr.extractDesignEntitiesReferenced(text, beginIdx, endIdx);
        return refEntities;
    }

    private IAnalyzerResult analyseMPDeclarationV2(String text, int beginIdx) {
        try {
            IAnalyzerResult mpAnalyzerResult = MPAnalyzerManager.analyze((String)text, (int)beginIdx, null);
            return mpAnalyzerResult;
        }
        catch (MPException mPException) {
            return null;
        }
    }

    protected List<ReferencedEntity> analyseMPDeclarations(String text, List<MicroPatternMark> mpMarks) {
        long a = System.currentTimeMillis();
        ArrayList<ReferencedEntity> refEntities = new ArrayList<ReferencedEntity>();
        for (MicroPatternMark mpMark : mpMarks) {
            int beginIdx = mpMark.getBeginOffset();
            IAnalyzerResult mpAnalyzerResult = this.analyseMPDeclarationV2(text, beginIdx);
            if (mpAnalyzerResult != null) {
                String mpIdentifier = mpAnalyzerResult.getIdentifier();
                IMPAnalyzer mpAnalyzer = (IMPAnalyzer)MPAnalyzerManager.getMPAnalyzerImplementors().get(mpIdentifier);
                int endIdx = Util.getLineEndOffset((CharSequence)text, (int)beginIdx);
                List list = mpAnalyzer.getReferencedEntities(text, beginIdx, endIdx = Util.getLineEndOffset((CharSequence)text, (int)endIdx), mpAnalyzerResult);
                if (list == null) continue;
                refEntities.addAll(list);
                continue;
            }
            int endIdx = Util.getLineEndOffset((CharSequence)text, (int)beginIdx);
            List<ReferencedEntity> list = this.analyseMPDeclarationV1(text, beginIdx, endIdx = Util.getLineEndOffset((CharSequence)text, (int)endIdx));
            if (list == null) continue;
            refEntities.addAll(list);
        }
        long b = System.currentTimeMillis();
        return refEntities;
    }

    protected String formatReferenceTargetForLucene(ReferencedEntity refEntity) {
        String id = MetadataService.getId((String)EMPTY_STRING, (String)EMPTY_STRING, (String)refEntity.getName(), null, (String)refEntity.getType());
        return id;
    }

    protected List<Reference> createReferences(List<ReferencedEntity> refEntities, String documentID) {
        ArrayList<Reference> references = new ArrayList<Reference>();
        StringBuilder sb = new StringBuilder();
        for (ReferencedEntity refEntity : refEntities) {
            Reference aReference = MetaFactory.eINSTANCE.createReference();
            aReference.setSourceId(documentID);
            aReference.setTargetId(this.formatReferenceTargetForLucene(refEntity));
            aReference.setStateId(EMPTY_STRING);
            sb = new StringBuilder("micropattern");
            sb.append(' ');
            sb.append(refEntity.getMPIdentifier());
            aReference.setRelation(sb.toString());
            if (refEntity.getOffset() != 0) {
                Property property = MetaFactory.eINSTANCE.createProperty();
                property.setName(OFFSET);
                property.setValue(Integer.toString(refEntity.getOffset()));
                aReference.getProperties().add(property);
            }
            references.add(aReference);
        }
        return references;
    }

    private Map<String, List<Reference>> extract_MP_References(String text, int begin, int end) {
        List mpMarks = MicroPatternExtractor.findMPMarks((CharSequence)text, (int)begin, (int)end, (boolean)this._isForCobol);
        List<ReferencedEntity> refEntities = this.analyseMPDeclarations(text, mpMarks);
        HashMap<String, List<Reference>> result = new HashMap<String, List<Reference>>();
        List<Reference> references = this.createReferences(refEntities, this._documentId);
        result.put(this._documentId, references);
        return result;
    }

    protected List<IMicroPattern> fromMarksToMicroPattern(List<MicroPatternMark> mpMarks, String text) {
        ArrayList<IMicroPattern> result = new ArrayList<IMicroPattern>(mpMarks.size());
        CobolMicroPatternParser parser = new CobolMicroPatternParser();
        CobolMicroPatternHeaderHelper helper = new CobolMicroPatternHeaderHelper();
        for (MicroPatternMark mpMark : mpMarks) {
            final MicroPattern microPattern = new MicroPattern();
            microPattern.setHeaderHelper((IMicroPatternHeaderHelper)helper);
            microPattern.setLocation((ITextArtefactLocation)new TextArtefactLocation(mpMark.getBeginOffset(), mpMark.getBeginOffset()));
            parser.setParsingEventHandler(new IMicroPatternParsingEventHandler(){

                public void setAttribute(String name, String value) {
                    microPattern.setAttribute(name, value);
                }

                public void setConfigurationArea(String configurationArea) {
                    microPattern.setConfigurationArea(configurationArea);
                }

                public void setIdentifier(String identifier) {
                    microPattern.setId(identifier);
                }

                public void setHeaderDelimiter(String sequence) {
                    microPattern.setHeaderDelimiterSequence(sequence);
                }

                public void tagAsWellFormed() {
                    microPattern.setWellFormed(true);
                }

                public void setHeader(String header) {
                    microPattern.setHeaderDecl(header);
                }
            });
            String header = parser.getMicroPatternHeader((IMicroPattern)microPattern, (CharSequence)text);
            parser.parse((IMicroPattern)microPattern, header);
            result.add((IMicroPattern)microPattern);
        }
        return result;
    }

    private void init() {
        int counter = 0;
        int endFileOffset = this._text.length();
        this._startOffset = 0;
        this._endOffset = endFileOffset;
        if (!this._limitToDataAndProcDivistion) {
            return;
        }
        boolean dataDivFound = false;
        while (counter < endFileOffset) {
            int end = Util.getLineEndOffset((CharSequence)this._text, (int)counter);
            String line = this._text.substring(counter, end);
            if (!dataDivFound && line.length() > 20 && line.startsWith(DATA_DIVISION, 6)) {
                this._startOffset = end;
                dataDivFound = true;
            }
            if (line.length() > 25 && line.startsWith(PROCEDURE_DIVISION, 6)) {
                this._endOffset = end;
                break;
            }
            counter = end;
        }
    }

    public Map<String, List<Reference>> parse(String fileName, String fileContents) {
        long a = System.currentTimeMillis();
        this._text = fileContents;
        this._documentId = fileName;
        this.init();
        Map<String, List<Reference>> mpDesignRefs = this.extract_MP_References(this._text, this._startOffset, this._endOffset);
        long b = System.currentTimeMillis();
        return mpDesignRefs;
    }

    private static InputStream getInputStream(String fileName) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inputStream;
    }

    public static void main(String[] args) {
        System.out.println("Start of Program.");
        String[] filesNames = new String[]{"c:/tmp/TestGlobalMPScanner/KLJ503.cbl", "c:/tmp/TestGlobalMPScanner/AAAA27.pacmacro", "c:/tmp/TestGlobalMPScanner/MP0130.cbl", "c:/tmp/TestGlobalMPScanner/MP0130_Bigger.cbl", "c:/tmp/TestGlobalMPScanner/AABIPB.pacmacro", "c:/tmp/TestGlobalMPScanner/ABPGEB.pacmacro", "c:/tmp/TestGlobalMPScanner/AMOBKD.pacmacro"};
        MPReferencesFinder mpRefFinder = new MPReferencesFinder();
        String[] stringArray = filesNames;
        int n = filesNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            long a = System.currentTimeMillis();
            int ind = fileName.indexOf("/TestGlobalMPScanner/");
            String newSourceText = mpRefFinder.getStringFromStream(MPReferencesFinder.getInputStream(fileName));
            String shortFileName = String.valueOf(fileName.substring(ind, ind + "/TestGlobalMPScanner".length())) + fileName.substring(ind + "/TestGlobalMPScanner".length());
            Map<String, List<Reference>> mpList = mpRefFinder.parse(shortFileName, newSourceText);
            String doc = mpList.keySet().iterator().next();
            List<Reference> liste = mpList.get(doc);
            long b = System.currentTimeMillis();
            System.out.println("********************************************");
            System.out.println("MPReferencesFinder.parse of " + fileName);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < liste.size()) {
                Reference ref = liste.get(i);
                sb.append(ref.getSourceId());
                sb.append(",");
                sb.append(ref.getTargetId());
                sb.append(",");
                sb.append(ref.getRelation());
                sb.append(",");
                sb.append(ref.getType());
                sb.append(CR);
                ++i;
            }
            System.out.println(sb);
            System.out.println("MPReferencesFinder.parse Nb of References = " + liste.size());
            System.out.println("MPReferencesFinder.parse elapsed = " + (b - a));
            System.out.println("********************************************");
            ++n2;
        }
        System.out.println("End of Program.");
    }
}

