/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.link.design;

import com.ibm.pdp.mdl.link.design.IMpAnalyser;
import com.ibm.pdp.mdl.link.design.MpOSCAnalyser;
import com.ibm.pdp.mdl.link.design.MpOSDAnalyser;
import com.ibm.pdp.mdl.link.design.MpWeAnalyser;
import com.ibm.pdp.mdl.link.design.MpWfAnalyser;
import com.ibm.pdp.mdl.link.design.MpWiAnalyser;
import com.ibm.pdp.mdl.link.design.MpWsAnalyser;
import com.ibm.pdp.mdl.link.design.ReferencedEntity;
import java.util.ArrayList;
import java.util.List;

public class MPParametersAnalysersMgr {
    private static List<IMpAnalyser> _analysers = new ArrayList<IMpAnalyser>();
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        _analysers.add(new MpWfAnalyser());
        _analysers.add(new MpWiAnalyser());
        _analysers.add(new MpWeAnalyser());
        _analysers.add(new MpWsAnalyser());
        _analysers.add(new MpOSCAnalyser());
        _analysers.add(new MpOSDAnalyser());
    }

    protected static IMpAnalyser findHandler(String param) {
        int i = 0;
        while (i < _analysers.size()) {
            IMpAnalyser handler = _analysers.get(i);
            if (handler.accept(param)) {
                return handler;
            }
            ++i;
        }
        return null;
    }

    public static List<ReferencedEntity> extractDesignEntitiesReferenced(String text, int beginIdx, int endIdx) {
        String param = text.substring(beginIdx, endIdx);
        IMpAnalyser handler = MPParametersAnalysersMgr.findHandler(param);
        if (handler == null) {
            return null;
        }
        List<ReferencedEntity> refEntities = handler.getReferencedEntities(text, beginIdx, endIdx);
        return refEntities;
    }
}

