/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.link.design;

import java.util.ArrayList;
import java.util.List;

public class DichoSearch {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String[] TEST_TAB = new String[]{"AAA", "BBB", "DDD", "EEE", "GGG", "III", "PPP", "QQQ", "RRR"};

    public static int search(String elem, List<String> aSortedList) {
        if (elem == null || aSortedList == null) {
            throw new RuntimeException("DichotomicSearch.search(elem, tab). At least one parameter is null !!!");
        }
        int len = aSortedList.size();
        if (len == 0) {
            return -1;
        }
        if (elem.compareTo(aSortedList.get(0)) < 0) {
            return -1;
        }
        if (elem.compareTo(aSortedList.get(len - 1)) > 0) {
            return ~len;
        }
        int inf = 0;
        int sup = len - 1;
        while (inf <= sup) {
            int pivot = (inf + sup) / 2;
            if (elem.compareTo(aSortedList.get(pivot)) == 0) {
                return pivot;
            }
            if (elem.compareTo(aSortedList.get(pivot)) < 0) {
                sup = pivot - 1;
                continue;
            }
            inf = pivot + 1;
        }
        return ~inf;
    }

    public static void main(String[] args) {
        System.out.println("Start of program");
        System.out.print("Input=[");
        ArrayList<String> input = new ArrayList<String>();
        String[] stringArray = TEST_TAB;
        int n = TEST_TAB.length;
        int n2 = 0;
        while (n2 < n) {
            String z = stringArray[n2];
            System.out.print(String.valueOf(z) + ", ");
            input.add(z);
            ++n2;
        }
        System.out.println("]");
        String s = "A";
        int r0 = DichoSearch.search(s, input);
        System.out.println("search for : " + s + " => found @ index : " + r0);
        s = "AAA";
        r0 = DichoSearch.search(s, input);
        System.out.println("search for : " + s + " => found @ index : " + r0);
        s = "BBB";
        r0 = DichoSearch.search(s, input);
        System.out.println("search for : " + s + " => found @ index : " + r0);
        s = "DDD";
        r0 = DichoSearch.search(s, input);
        System.out.println("search for : " + s + " => found @ index : " + r0);
        s = "FFF";
        r0 = DichoSearch.search(s, input);
        System.out.println("search for : " + s + " => found @ index : " + r0);
        s = "GGG";
        r0 = DichoSearch.search(s, input);
        System.out.println("search for : " + s + " => found @ index : " + r0);
        s = "PPP";
        r0 = DichoSearch.search(s, input);
        System.out.println("search for : " + s + " => found @ index : " + r0);
        s = "RRR";
        r0 = DichoSearch.search(s, input);
        System.out.println("search for : " + s + " => found @ index : " + r0);
        s = "ZZZ";
        r0 = DichoSearch.search(s, input);
        System.out.println("search for : " + s + " => found @ index : " + r0);
        s = "ZZZ";
        r0 = DichoSearch.search(s, new ArrayList<String>(0));
        System.out.println("Empty tab. search for : " + s + " => found @ index : " + r0);
        System.out.println("End of program");
    }
}

