/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.link;

import com.ibm.pdp.mdl.link.IVersionManagedTagHandler;
import com.ibm.pdp.mdl.link.PdpFileGenerationLinksParser;
import com.ibm.pdp.mdl.link.PdpFileGenerationLinksParserResult;
import com.ibm.pdp.mdl.link.ResultReference;
import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.Property;
import com.ibm.pdp.mdl.meta.Reference;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class TagHandlerV2
implements IVersionManagedTagHandler {
    PdpFileGenerationLinksParser _parser;
    private String _sourceId;
    private String rank;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    TagHandlerV2(PdpFileGenerationLinksParser parser) {
        this._parser = parser;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        Reference ref;
        String project;
        if (name.equals("GeneratedRefsSection")) {
            String patternGenStateVersion = atts.getValue("patternGenStateVersion");
            this.rank = null;
            this._parser.getResult().setPatternGenStateVersion(patternGenStateVersion);
        }
        if (name.equals("generation_output")) {
            project = atts.getValue("project");
            String packageLogicalMode = atts.getValue("logical_package");
            boolean isPackageLogicalMode = "Y".equals(packageLogicalMode);
            String packageName = atts.getValue("package");
            String refName = atts.getValue("name");
            String type = atts.getValue("type");
            String timesstamp = atts.getValue("timestamp");
            String relation = atts.getValue("relation");
            String genStateId = atts.getValue("genId");
            PdpFileGenerationLinksParserResult result = this._parser.getResult();
            ResultReference reference = new ResultReference(project, isPackageLogicalMode, packageName, null, refName, type, timesstamp, genStateId, relation);
            result.setGenerationOutput(reference);
        } else if (name.equals("subRef")) {
            project = atts.getValue("project");
            String packageLogicalMode = atts.getValue("logical_package");
            boolean isPackageLogicalMode = "Y".equals(packageLogicalMode);
            String packageName = atts.getValue("package");
            String refName = atts.getValue("name");
            String type = atts.getValue("type");
            String timesstamp = atts.getValue("timestamp");
            String genStateId = atts.getValue("genId");
            String relation = atts.getValue("relation");
            if (relation != null && relation.endsWith("entrypoint")) {
                int indexOfRank = relation.indexOf("_");
                int endIndexOfRank = relation.lastIndexOf("_");
                if (indexOfRank >= 0 && endIndexOfRank >= 0 && endIndexOfRank > indexOfRank + 1) {
                    this.rank = relation.substring(indexOfRank + 1, endIndexOfRank);
                }
            }
            String metaType = atts.getValue("metaType");
            PdpFileGenerationLinksParserResult result = this._parser.getResult();
            result.setRank(this.rank);
            ResultReference reference = new ResultReference(project, isPackageLogicalMode, packageName, metaType, refName, type, timesstamp, genStateId, relation);
            result.getSubRefs().add(reference);
        } else if (name.equalsIgnoreCase("MicroPatternRefsSection")) {
            this._sourceId = atts.getValue("src");
        } else if (name.equalsIgnoreCase("MPRef")) {
            ref = MetaFactory.eINSTANCE.createReference();
            ref.setSourceId(this._sourceId);
            ref.setTargetId(atts.getValue("target"));
            ref.setRelation(atts.getValue("relation"));
            PdpFileGenerationLinksParserResult result = this._parser.getResult();
            result.getMicroPatternRefs().add(ref);
        } else if (name.equalsIgnoreCase("RubriquesUsagesRefsSection")) {
            this._sourceId = atts.getValue("src");
        } else if (name.equalsIgnoreCase("RubRef")) {
            ref = MetaFactory.eINSTANCE.createReference();
            ref.setSourceId(this._sourceId);
            ref.setTargetId(atts.getValue("target"));
            ref.setRelation(atts.getValue("relation"));
            Property prop = MetaFactory.eINSTANCE.createProperty();
            prop.setName("line");
            prop.setValue(atts.getValue("line"));
            ref.getProperties().add(prop);
            prop = MetaFactory.eINSTANCE.createProperty();
            prop.setName("fct");
            prop.setValue(atts.getValue("fct"));
            ref.getProperties().add(prop);
            prop = MetaFactory.eINSTANCE.createProperty();
            prop.setName("macro");
            prop.setValue(atts.getValue("macro"));
            ref.getProperties().add(prop);
            prop = MetaFactory.eINSTANCE.createProperty();
            prop.setName("begin");
            prop.setValue(atts.getValue("begin"));
            ref.getProperties().add(prop);
            prop = MetaFactory.eINSTANCE.createProperty();
            prop.setName("end");
            prop.setValue(atts.getValue("end"));
            ref.getProperties().add(prop);
            prop = MetaFactory.eINSTANCE.createProperty();
            prop.setName("lineOff");
            prop.setValue(atts.getValue("lineOff"));
            ref.getProperties().add(prop);
            prop = MetaFactory.eINSTANCE.createProperty();
            prop.setName("ctx");
            prop.setValue(atts.getValue("ctx"));
            ref.getProperties().add(prop);
            PdpFileGenerationLinksParserResult result = this._parser.getResult();
            result.getDetailedUsages().add(ref);
        }
    }
}

