/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.link;

import com.ibm.pdp.mdl.link.IVersionManagedTagHandler;
import com.ibm.pdp.mdl.link.PdpFileGenerationLinksParserResult;
import com.ibm.pdp.mdl.link.ResultReference;
import com.ibm.pdp.mdl.link.TagHandlerV0;
import com.ibm.pdp.mdl.link.TagHandlerV2;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.Property;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PdpFileGenerationLinksParser
extends DefaultHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String FOLDER_DELIMITER = "/";
    private static final String PACKAGE_DELIMITER = ".";
    private PdpFileGenerationLinksParserResult _result;
    private SAXParser _saxParser;
    private Map<String, Map<String, Document>> _filesRepository;

    public PdpFileGenerationLinksParser() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        try {
            this._saxParser = factory.newSAXParser();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void doCommonParsingTreatment(InputStream input) {
        block3: {
            this._result = null;
            try {
                this._saxParser.parse(input, (DefaultHandler)new TagHandler());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                String s = e.getMessage();
                if (s.equals("stop_sax_parsing")) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public Map<Document, List<Reference>> parse(InputStream inputStream, Map<String, Map<String, Document>> filesRepository) {
        this.doCommonParsingTreatment(inputStream);
        return this.analyseParsingResults(filesRepository, false);
    }

    private Map<Document, List<Reference>> analyseParsingResults(Map<String, Map<String, Document>> filesRepository, boolean serverSide) {
        this._filesRepository = filesRepository;
        if (this._filesRepository == null) {
            this._filesRepository = new HashMap<String, Map<String, Document>>();
        }
        if (this._result != null && this._result.getGenerationOutput() != null && this._result.getSubRefs() != null && this._result.getSubRefs().size() != 0) {
            return this.createPdpResource(this._filesRepository, serverSide);
        }
        return null;
    }

    private Map<Document, List<Reference>> createPdpResource(Map<String, Map<String, Document>> filesRepository, boolean serverSide) {
        return PdpFileGenerationLinksParser.createPdpResource(this._result.getGenerationOutput(), this._result.getSubRefs(), filesRepository, serverSide ? this._result.getGenerationOutPutFileName() : null, this._result);
    }

    public Map<Document, List<Reference>> parseForServer(InputStream inputStream, Map<String, Map<String, Document>> filesRepository) {
        this.doCommonParsingTreatment(inputStream);
        return this.analyseParsingResults(filesRepository, true);
    }

    public PdpFileGenerationLinksParserResult parse(InputStream inputStream, Map<String, Map<String, Document>> filesRepository, boolean serverSide) {
        this.doCommonParsingTreatment(inputStream);
        if (this._result.getGenerationOutput() != null && this._result.getSubRefs() != null && this._result.getSubRefs().size() != 0) {
            Map<Document, List<Reference>> theMap;
            Iterator<Document> docs;
            this._filesRepository = filesRepository;
            if (this._filesRepository == null) {
                this._filesRepository = new HashMap<String, Map<String, Document>>();
            }
            String genOutputFileName = null;
            if (serverSide) {
                genOutputFileName = this._result.getGenerationOutPutFileName();
            }
            if ((docs = (theMap = PdpFileGenerationLinksParser.createPdpResource(this._result.getGenerationOutput(), this._result.getSubRefs(), this._filesRepository, genOutputFileName, this._result)).keySet().iterator()).hasNext()) {
                Document aDoc = docs.next();
                this._result.setDocument(aDoc);
                this._result.setGenerationRefs(theMap.get(aDoc));
            }
        }
        return this._result;
    }

    public PdpFileGenerationLinksParserResult parse(String fileName, Map<String, Map<String, Document>> filesRepository, boolean serverSide) {
        InputStream is = this.getContentsAsInputStream(fileName);
        return this.parse(is, filesRepository, serverSide);
    }

    private InputStream getContentsAsInputStream(String fileName) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return fis;
    }

    public PdpFileGenerationLinksParserResult getResult() {
        if (this._result == null) {
            this._result = new PdpFileGenerationLinksParserResult();
        }
        return this._result;
    }

    private static Document createADocument(ResultReference generationOutput, String projectName) {
        String project = projectName;
        if (!generationOutput.isPackageLogicalMode()) {
            project = String.valueOf('%') + project;
        }
        String theGeneratedResourceId = MetadataService.getId((String)project, (String)generationOutput.getPackageName(), (String)generationOutput.getName(), (String)"", (String)generationOutput.getType());
        Document theGeneratedResource = MetaFactory.eINSTANCE.getDocument(theGeneratedResourceId, true);
        return theGeneratedResource;
    }

    private static Document createADocument(String generationOutputFileName) {
        return MetaFactory.eINSTANCE.getDocument(generationOutputFileName, true);
    }

    public static Map<Document, List<Reference>> createPdpResource(ResultReference generationOutput, List<ResultReference> subRefs, Map<String, Map<String, Document>> filesRepository, String generationOutputFileName, PdpFileGenerationLinksParserResult pfglpr) {
        String theGeneratedResourceId;
        Document theGeneratedResource;
        String projectName = generationOutput.getProject();
        String key = null;
        if (generationOutputFileName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(FOLDER_DELIMITER);
            if (!generationOutput.isPackageLogicalMode()) {
                sb.append('%');
            }
            sb.append(projectName);
            sb.append(FOLDER_DELIMITER);
            String packageName = generationOutput.getPackageName().replace(PACKAGE_DELIMITER, FOLDER_DELIMITER);
            sb.append(packageName);
            if (!packageName.isEmpty()) {
                sb.append(FOLDER_DELIMITER);
            }
            sb.append(generationOutput.getName());
            sb.append(PACKAGE_DELIMITER);
            sb.append(generationOutput.getType());
            key = sb.toString();
        } else {
            key = generationOutputFileName;
        }
        Map<String, Document> genResourcesMap = filesRepository.get(projectName);
        if (genResourcesMap != null) {
            theGeneratedResource = genResourcesMap.get(key);
            if (theGeneratedResource != null) {
                theGeneratedResourceId = theGeneratedResource.getId();
            } else {
                theGeneratedResource = generationOutputFileName == null ? PdpFileGenerationLinksParser.createADocument(generationOutput, projectName) : PdpFileGenerationLinksParser.createADocument(generationOutputFileName);
                theGeneratedResourceId = theGeneratedResource.getId();
                genResourcesMap.put(key, theGeneratedResource);
            }
        } else {
            theGeneratedResource = generationOutputFileName == null ? PdpFileGenerationLinksParser.createADocument(generationOutput, projectName) : PdpFileGenerationLinksParser.createADocument(generationOutputFileName);
            genResourcesMap = new HashMap<String, Document>();
            genResourcesMap.put(key, theGeneratedResource);
            theGeneratedResourceId = theGeneratedResource.getId();
            filesRepository.put(projectName, genResourcesMap);
        }
        ArrayList<Reference> metaReferences = new ArrayList<Reference>();
        Reference aReference = null;
        for (ResultReference resultReference : subRefs) {
            boolean isGeneratedDocument = PdpFileGenerationLinksParser.isGeneratedDocument(resultReference.getType());
            StringBuilder sb = new StringBuilder();
            sb.append(FOLDER_DELIMITER);
            if (!resultReference.isPackageLogicalMode() && isGeneratedDocument) {
                sb.append('%');
            }
            projectName = resultReference.getProject();
            sb.append(projectName);
            sb.append(FOLDER_DELIMITER);
            String packageName = resultReference.getPackageName().replace(PACKAGE_DELIMITER, FOLDER_DELIMITER);
            if (!packageName.isEmpty()) {
                sb.append(packageName);
                sb.append(FOLDER_DELIMITER);
            }
            sb.append(resultReference.getName());
            sb.append(PACKAGE_DELIMITER);
            if (resultReference.getMetaType() != null && resultReference.getMetaType().length() > 0) {
                sb.append(resultReference.getMetaType());
                sb.append(PACKAGE_DELIMITER);
            }
            sb.append(resultReference.getType());
            key = sb.toString();
            aReference = MetaFactory.eINSTANCE.createReference();
            aReference.setSourceId(theGeneratedResourceId);
            aReference.setTargetId(key);
            aReference.setStateId(resultReference.getTimesstamp());
            aReference.setRelation(resultReference.getRelation());
            aReference.setType(1);
            Property prop = MetaFactory.eINSTANCE.createProperty();
            prop.setName("pattern");
            prop.setValue(pfglpr.getPatternName());
            aReference.getProperties().add(prop);
            prop = MetaFactory.eINSTANCE.createProperty();
            prop.setName("patternGenStateVersion");
            prop.setValue(pfglpr.getPatternGenStateVersion());
            aReference.getProperties().add(prop);
            String genStateId = resultReference.getGenStateId();
            if (genStateId != null && genStateId.length() != 0) {
                prop = MetaFactory.eINSTANCE.createProperty();
                prop.setName("genId");
                prop.setValue(resultReference.getGenStateId());
                aReference.getProperties().add(prop);
            }
            prop = MetaFactory.eINSTANCE.createProperty();
            prop.setName("rank");
            prop.setValue(pfglpr.getRank());
            aReference.getProperties().add(prop);
            metaReferences.add(aReference);
        }
        HashMap<Document, List<Reference>> result = new HashMap<Document, List<Reference>>();
        result.put(theGeneratedResource, metaReferences);
        return result;
    }

    public static boolean isGeneratedDocument(String type) {
        if (type == null) {
            return true;
        }
        return "cbl".equalsIgnoreCase(type) || "bms".equalsIgnoreCase(type) || "map".equalsIgnoreCase(type) || "mfs".equalsIgnoreCase(type) || "cpy".equalsIgnoreCase(type) || "txt".equalsIgnoreCase(type);
    }

    private class TagHandler
    extends DefaultHandler {
        IVersionManagedTagHandler versionManagedTagHandler = null;
        private boolean InsidePatternTag = false;
        private StringBuilder currentText = null;

        private TagHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            if (this.versionManagedTagHandler != null) {
                this.versionManagedTagHandler.startElement(uri, localName, name, atts);
                return;
            }
            if (name.equals("PatternName")) {
                this.InsidePatternTag = true;
                this.currentText = new StringBuilder();
            }
            if (name.equals("Refs")) {
                String generationOutputFileName = atts.getValue("gen_output_resource_name");
                PdpFileGenerationLinksParser.this.getResult().setGenerationOutPutFileName(generationOutputFileName);
                String version = atts.getValue("version");
                if (version.equals("0") || version.equals("1")) {
                    this.versionManagedTagHandler = new TagHandlerV0(PdpFileGenerationLinksParser.this);
                } else if (version.equals("2")) {
                    this.versionManagedTagHandler = new TagHandlerV2(PdpFileGenerationLinksParser.this);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (name.equals("PatternName")) {
                this.InsidePatternTag = false;
                PdpFileGenerationLinksParser.this.getResult().setPatternName(this.currentText.toString());
                this.currentText = null;
            }
            if (name.equals("Refs")) {
                SAXException e = new SAXException("stop_sax_parsing");
                throw e;
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.InsidePatternTag) {
                this.currentText.append(ch, start, length);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

