/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.kernel.util;

import com.ibm.pdp.mdl.kernel.AbstractValue;
import com.ibm.pdp.mdl.kernel.AggregateValue;
import com.ibm.pdp.mdl.kernel.ByteStringType;
import com.ibm.pdp.mdl.kernel.DataAggregateDescription;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataComponent;
import com.ibm.pdp.mdl.kernel.DataDefinition;
import com.ibm.pdp.mdl.kernel.DataDescription;
import com.ibm.pdp.mdl.kernel.DataDescriptionExtension;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.DateTimeType;
import com.ibm.pdp.mdl.kernel.DateTimeValue;
import com.ibm.pdp.mdl.kernel.DecimalType;
import com.ibm.pdp.mdl.kernel.DecimalValue;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.Field;
import com.ibm.pdp.mdl.kernel.FloatType;
import com.ibm.pdp.mdl.kernel.FloatValue;
import com.ibm.pdp.mdl.kernel.IntegerType;
import com.ibm.pdp.mdl.kernel.IntegerValue;
import com.ibm.pdp.mdl.kernel.Interval;
import com.ibm.pdp.mdl.kernel.KernelFactory;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.MetaEntity;
import com.ibm.pdp.mdl.kernel.MultipleValue;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntityExtension;
import com.ibm.pdp.mdl.kernel.ReferenceType;
import com.ibm.pdp.mdl.kernel.ReferenceValue;
import com.ibm.pdp.mdl.kernel.SimpleType;
import com.ibm.pdp.mdl.kernel.StringCaseValues;
import com.ibm.pdp.mdl.kernel.StringType;
import com.ibm.pdp.mdl.kernel.StringValue;
import com.ibm.pdp.mdl.kernel.TimeStampType;
import com.ibm.pdp.mdl.kernel.TimeStampValue;
import com.ibm.pdp.mdl.kernel.Value;
import com.ibm.pdp.mdl.kernel.VoidValue;
import com.ibm.pdp.mdl.kernel.impl.DecimalTypeImpl;
import com.ibm.pdp.mdl.kernel.util.KernelContext;
import com.ibm.pdp.mdl.kernel.util.KernelLabel;
import com.ibm.pdp.mdl.kernel.util.Marker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String EMPTY_STRING = "";
    public static final int MAX_BYTESTRING_LENGTH = 1000000;
    public static final Pattern decimalPattern = Pattern.compile("[\\+\\-]?[0-9]+|[\\+\\-]?[0-9]+\\.[0-9]+|[\\+\\-]?[0-9]+\\,[0-9]+");
    public static final String _DESIGN_MARKER = "com.ibm.pdp.explorer.design.marker";
    private static final String OS_NAME = System.getProperty("osgi.os");
    private static final boolean IS_WINDOWS_OS = "win32".equals(OS_NAME);
    public static final boolean IS_UNIX_OS = !IS_WINDOWS_OS;
    private static Map<String, SoftReference<RadicalEntity>> softReferences = null;
    private static int MAX_CACHE = 300;

    public static String getDefaultValueForType(SimpleType simpleType) {
        if (simpleType instanceof StringType) {
            return EMPTY_STRING;
        }
        if (simpleType instanceof DecimalType) {
            return "0.0";
        }
        if (simpleType instanceof IntegerType) {
            return "0";
        }
        if (simpleType instanceof FloatType) {
            return "0e0";
        }
        if (simpleType instanceof DateTimeType) {
            DateTimeType dateTimeType = (DateTimeType)simpleType;
            if (dateTimeType.getFormat() != null && !dateTimeType.getFormat().equals(EMPTY_STRING)) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(dateTimeType.getFormat());
                return dateFormat.format(new Date());
            }
            return new Date().toString();
        }
        if (simpleType instanceof TimeStampType) {
            return Long.toString(new Date().getTime());
        }
        return EMPTY_STRING;
    }

    public static DataDescription getDataDescription(MetaEntity metaEntity, AbstractValue value, List<String> paths) {
        if (metaEntity == null || value == null) {
            return null;
        }
        Stack<String> stack = new Stack<String>();
        Entity entity = value;
        while (entity.eContainer() != null) {
            if (!((entity = (Entity)entity.eContainer()) instanceof Field)) continue;
            stack.push(((Field)entity).getName());
        }
        DataDescription dataDescription = metaEntity.getDataDescription();
        if (stack.size() == 0) {
            return null;
        }
        String fieldName = (String)stack.pop();
        while (!stack.isEmpty()) {
            fieldName = (String)stack.pop();
            boolean found = false;
            if (dataDescription instanceof DataAggregateDescription) {
                for (Object object : ((DataAggregateDescription)dataDescription).getComponents()) {
                    DataCall dataCall = (DataCall)object;
                    if (dataCall.getDataDescription() != null && dataCall.getDataDescription().getName().equals(fieldName)) {
                        dataDescription = dataCall.getDataDescription();
                        found = true;
                        break;
                    }
                    if (dataCall.getDataDefinition() == null || !dataCall.getDataDefinition().getProxyName().equals(fieldName)) continue;
                    if (paths != null) {
                        URI proxyURI = dataCall.getDataDefinition().getProxyURI();
                        DataDefinition resolvedDataDefinition = null;
                        if (proxyURI == null) {
                            resolvedDataDefinition = dataCall.getDataDefinition();
                        } else {
                            resolvedDataDefinition = (DataDefinition)Util.resolveRadicalEntity(proxyURI, paths);
                            dataCall.setDataDefinition(resolvedDataDefinition);
                        }
                        if (resolvedDataDefinition == null) continue;
                        dataDescription = resolvedDataDefinition.getDataDescription();
                        found = true;
                        break;
                    }
                    dataDescription = dataCall.getDataDefinition().getDataDescription();
                    found = true;
                    break;
                }
            }
            if (found) continue;
            dataDescription = null;
            break;
        }
        return dataDescription;
    }

    public static DataCall getDataCall(MetaEntity metaEntity, AbstractValue value, List<String> paths) {
        if (metaEntity == null) {
            return null;
        }
        Stack<String> stack = new Stack<String>();
        Entity entity = value;
        while (entity.eContainer() != null) {
            if (!((entity = (Entity)entity.eContainer()) instanceof Field)) continue;
            stack.push(((Field)entity).getName());
        }
        DataDescription dataDescription = metaEntity.getDataDescription();
        DataCall result = null;
        if (stack.size() == 0) {
            return null;
        }
        String fieldName = (String)stack.pop();
        while (!stack.isEmpty()) {
            fieldName = (String)stack.pop();
            boolean found = false;
            if (dataDescription instanceof DataAggregateDescription) {
                for (Object object : ((DataAggregateDescription)dataDescription).getComponents()) {
                    DataCall dataCall = (DataCall)object;
                    if (dataCall.getDataDescription() != null && dataCall.getDataDescription().getName().equals(fieldName)) {
                        dataDescription = dataCall.getDataDescription();
                        result = dataCall;
                        found = true;
                        break;
                    }
                    if (dataCall.getDataDefinition() == null || !dataCall.getDataDefinition().getProxyName().equals(fieldName)) continue;
                    if (paths != null) {
                        URI proxyURI = dataCall.getDataDefinition().getProxyURI();
                        DataDefinition resolvedDataDefinition = null;
                        if (proxyURI == null) {
                            resolvedDataDefinition = dataCall.getDataDefinition();
                        } else {
                            resolvedDataDefinition = (DataDefinition)Util.resolveRadicalEntity(proxyURI, paths);
                            dataCall.setDataDefinition(resolvedDataDefinition);
                        }
                        if (resolvedDataDefinition == null) continue;
                        dataDescription = resolvedDataDefinition.getDataDescription();
                        result = dataCall;
                        found = true;
                        break;
                    }
                    dataDescription = dataCall.getDataDefinition().getDataDescription();
                    result = dataCall;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            result = null;
            break;
        }
        return result;
    }

    public static Double getDecimalValueFor(String value) {
        return Util.getDoubleValueFor(value);
    }

    public static Double getDoubleValueFor(String value) {
        if (value == null || value.trim().length() == 0) {
            return 0.0;
        }
        String aValue = DecimalTypeImpl.backwardCompatibility(value.trim());
        try {
            return Double.valueOf(aValue);
        }
        catch (Exception exception) {
            return Double.valueOf(aValue.replace(',', '.'));
        }
    }

    public static Float getFloatValueFor(String value) {
        if (value == null || value.trim().length() == 0) {
            return new Float(0.0f);
        }
        return Float.valueOf(Float.parseFloat(value.trim().replace('.', ',')));
    }

    public static Long getLongValueFor(String value) {
        if (value == null || value.trim().length() == 0) {
            return new Long(0L);
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            double db = Double.valueOf(value.trim());
            if (db > 9.223372036854776E18) {
                return Long.MAX_VALUE;
            }
            return Long.MIN_VALUE;
        }
    }

    public static Date getDateValueFor(String value, String format) throws ParseException {
        if (value == null || value.length() == 0) {
            return new Date();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.parse(value);
    }

    /*
     * Loose catch block
     */
    public static boolean isValidValueFormatForType(SimpleType simpleType, String value, List<String> paths) {
        block31: {
            if (value == null || value.equals(EMPTY_STRING)) {
                return true;
            }
            if (simpleType instanceof IntegerType) {
                try {
                    long v = Util.getLongValueFor(value.trim());
                    IntegerType type = (IntegerType)simpleType;
                    try {
                        long max;
                        long min = type.getMinValue().trim().length() == 0 ? Long.MIN_VALUE : Util.getLongValueFor(type.getMinValue().trim());
                        long l = max = type.getMaxValue().trim().length() == 0 ? Long.MAX_VALUE : Util.getLongValueFor(type.getMaxValue().trim());
                        return v >= min && v <= max;
                    }
                    catch (Exception exception) {
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if (simpleType instanceof TimeStampType) {
                try {
                    long result = Util.getLongValueFor(value);
                    return result >= 0L;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if (simpleType instanceof DecimalType) {
                String aValue;
                block30: {
                    aValue = DecimalTypeImpl.backwardCompatibility(value.trim());
                    Matcher m = decimalPattern.matcher(aValue);
                    boolean result = m.matches();
                    if (result) break block30;
                    return false;
                    {
                        catch (Exception exception) {
                            return false;
                        }
                    }
                }
                try {
                    DecimalType type = (DecimalType)simpleType;
                    double v = Util.getDoubleValueFor(aValue);
                    double min = Util.getDoubleValueFor(type.getMinValue());
                    double max = Util.getDoubleValueFor(type.getMaxValue());
                    return v >= min && v <= max;
                }
                catch (Exception exception) {
                    break block31;
                }
            }
            if (simpleType instanceof FloatType) {
                try {
                    ParsePosition parsePosition = new ParsePosition(0);
                    new DecimalFormat().parse(value.toUpperCase(), parsePosition);
                    if (parsePosition.getIndex() != value.length()) {
                        return false;
                    }
                    break block31;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (simpleType instanceof DateTimeType) {
                try {
                    DateTimeType dateTimeType = (DateTimeType)simpleType;
                    if (dateTimeType.getFormat() != null && !dateTimeType.getFormat().equals(EMPTY_STRING)) {
                        boolean result = false;
                        ParsePosition parsePosition = new ParsePosition(0);
                        SimpleDateFormat dateFormat = new SimpleDateFormat(dateTimeType.getFormat());
                        Date date = dateFormat.parse(value, parsePosition);
                        if (date != null && parsePosition.getIndex() == value.length()) {
                            result = dateFormat.format(date).equals(value);
                        }
                        if (!result && simpleType.eContainer().eContainer() instanceof DataDefinition) {
                            result = Util.isValidValuePacDateType(dateTimeType, value, paths);
                        }
                        return result;
                    }
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (simpleType instanceof StringType) {
                StringType stringType = (StringType)simpleType;
                boolean result = true;
                if (value.length() > stringType.getMaxLength()) {
                    boolean bl = result = stringType.getMaxLength() == -1;
                }
                if (result && stringType.getCase() == StringCaseValues.UPPER) {
                    result = Util.isUpper(value);
                } else if (result && stringType.getCase() == StringCaseValues.LOWER) {
                    result = Util.isLower(value);
                }
                return result;
            }
        }
        return true;
    }

    public static boolean isValidValuePacDateType(DateTimeType dateTimeType, String value, List<String> paths) {
        boolean result = false;
        Object extensions = ((DataElementDescription)dateTimeType.eContainer()).getExtensions();
        DataDescriptionExtension dsExt = null;
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof DataDescriptionExtension) {
                dsExt = (DataDescriptionExtension)object;
                break;
            }
            ++i;
        }
        DataElement dataElement = (DataElement)dateTimeType.eContainer().eContainer();
        if (dataElement == null) {
            return result;
        }
        extensions = dataElement.getExtensions();
        RadicalEntityExtension radicalExt = null;
        int i2 = 0;
        while (i2 < extensions.size()) {
            Object object = extensions.get(i2);
            if (object instanceof RadicalEntityExtension) {
                radicalExt = (RadicalEntityExtension)object;
                break;
            }
            ++i2;
        }
        String generatedDateFormat = null;
        if (radicalExt != null && radicalExt.eClass().getName().equals("PacDataElement")) {
            generatedDateFormat = Util.getPacGeneratedDateFormat(radicalExt, paths);
        }
        if (generatedDateFormat != null && radicalExt != null && radicalExt.eClass().getName().equals("PacDataElement") && dsExt != null && dsExt.eClass().getName().equals("PacDataElementDescription")) {
            String inputFormat;
            EStructuralFeature feature = dsExt.eClass().getEStructuralFeature("inputFormat");
            String string = inputFormat = dsExt.eGet(feature) == null ? null : dsExt.eGet(feature).toString().trim();
            if (inputFormat != null && inputFormat.length() >= 1) {
                ParsePosition parsePosition;
                SimpleDateFormat dateFormat;
                Date date;
                String alternateFormat = null;
                char sep = '/';
                if (inputFormat.length() > 1) {
                    sep = inputFormat.charAt(1);
                }
                if (inputFormat.charAt(0) == 'D') {
                    alternateFormat = generatedDateFormat.equals("_F") ? "ddMMyy" : "MMddyy";
                } else if (inputFormat.charAt(0) == 'C') {
                    alternateFormat = generatedDateFormat.equals("_F") ? "ddMMyyyy" : "MMddyyyy";
                } else if (inputFormat.charAt(0) == 'E') {
                    alternateFormat = generatedDateFormat.equals("_F") ? "dd" + sep + "MM" + sep + "yy" : "MM" + sep + "dd" + sep + "yy";
                } else if (inputFormat.charAt(0) == 'M') {
                    alternateFormat = generatedDateFormat.equals("_F") ? "dd" + sep + "MM" + sep + "yyyy" : "dd" + sep + "MM" + sep + "yyyy";
                } else if (inputFormat.equals("TS")) {
                    result = true;
                }
                if (alternateFormat != null && (date = (dateFormat = new SimpleDateFormat(alternateFormat)).parse(value, parsePosition = new ParsePosition(0))) != null && parsePosition.getIndex() == value.length()) {
                    result = dateFormat.format(date).equals(value);
                }
            }
        }
        return result;
    }

    public static boolean isValidIntervalValueForType(SimpleType simpleType, Interval interval, String value) {
        int comp;
        if (value == null) {
            return false;
        }
        String minValue = interval.getMinValue() == null ? null : interval.getMinValue().getValue();
        String maxValue = interval.getMaxValue() == null ? null : interval.getMaxValue().getValue();
        boolean result = true;
        if (minValue != null) {
            comp = Util.compareValuesForType(simpleType, minValue, value);
            if (!interval.isMinValueIncluded() && comp == 0) {
                return false;
            }
            if (comp > 0) {
                return false;
            }
        }
        if (maxValue != null) {
            comp = Util.compareValuesForType(simpleType, maxValue, value);
            if (!interval.isMaxValueIncluded() && comp == 0) {
                return false;
            }
            return comp >= 0;
        }
        return result;
    }

    public static List<Field> populateDataCalls(List<DataCall> dataCalls, AggregateValue aggregateValue, boolean onlyRequiredFields, boolean withVoidValue) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (DataCall object : dataCalls) {
            Field field;
            DataCall dataCall = object;
            if (dataCall.getMinimumCardinality() == 0 && onlyRequiredFields) continue;
            if (dataCall.getDataDefinition() != null) {
                MultipleValue multipleValue;
                if (aggregateValue.getField(dataCall.getDataDefinition().getName()) != null) continue;
                field = KernelFactory.eINSTANCE.createField();
                field.setName(dataCall.getDataDefinition().getName());
                fields.add(field);
                if (dataCall.getDataDefinition() instanceof DataElement) {
                    if (dataCall.getMaximumCardinality() == -1 || dataCall.getMaximumCardinality() - dataCall.getMinimumCardinality() > 1) {
                        multipleValue = KernelFactory.eINSTANCE.createMultipleValue();
                        field.setValue(multipleValue);
                        continue;
                    }
                    AbstractValue value = null;
                    value = withVoidValue && dataCall.getMinimumCardinality() == 0 ? KernelFactory.eINSTANCE.createVoidValue() : Util.getValue((DataElementDescription)dataCall.getDataDefinition().getDataDescription());
                    field.setValue(value);
                    continue;
                }
                if (dataCall.getMaximumCardinality() == -1) {
                    multipleValue = KernelFactory.eINSTANCE.createMultipleValue();
                    field.setValue(multipleValue);
                    continue;
                }
                AggregateValue aggregateValue2 = KernelFactory.eINSTANCE.createAggregateValue();
                field.setValue(aggregateValue2);
                continue;
            }
            if (aggregateValue.getField(dataCall.getDataDescription().getName()) != null) continue;
            field = KernelFactory.eINSTANCE.createField();
            field.setName(dataCall.getDataDescription().getName());
            fields.add(field);
            DataDescription description = dataCall.getDataDescription();
            if (description instanceof DataElementDescription) {
                DataElementDescription dataElementDescription = (DataElementDescription)description;
                if (dataCall.getMaximumCardinality() == -1 || dataCall.getMaximumCardinality() - dataCall.getMinimumCardinality() > 1) {
                    MultipleValue multipleValue = KernelFactory.eINSTANCE.createMultipleValue();
                    field.setValue(multipleValue);
                    continue;
                }
                AbstractValue value = null;
                value = withVoidValue && dataCall.getMinimumCardinality() == 0 ? KernelFactory.eINSTANCE.createVoidValue() : Util.getValue(dataElementDescription);
                field.setValue(value);
                continue;
            }
            if (dataCall.getMaximumCardinality() == -1 || dataCall.getMaximumCardinality() - dataCall.getMinimumCardinality() > 1) {
                MultipleValue multipleValue = KernelFactory.eINSTANCE.createMultipleValue();
                field.setValue(multipleValue);
                continue;
            }
            AggregateValue aggregateValue2 = KernelFactory.eINSTANCE.createAggregateValue();
            field.setValue(aggregateValue2);
        }
        return fields;
    }

    public static List<Field> populateDataAggregateDescription(DataAggregateDescription dataAggregateDescription, AggregateValue aggregateValue, boolean onlyRequiredFields, boolean withVoidValue) {
        ArrayList<DataCall> dataCalls = new ArrayList<DataCall>();
        for (Object object : dataAggregateDescription.getComponents()) {
            DataCall dataCall = (DataCall)object;
            dataCalls.add(dataCall);
        }
        return Util.populateDataCalls(dataCalls, aggregateValue, onlyRequiredFields, withVoidValue);
    }

    public static String getInitialValue(DataElementDescription dataElementDescription) {
        String initialValue = null;
        if (dataElementDescription.eContainer() instanceof DataDefinition) {
            initialValue = Util.getPacDataElementDefaultValue((DataDefinition)dataElementDescription.eContainer(), null);
        }
        if (initialValue == null && dataElementDescription.getInitialValue() != null) {
            initialValue = dataElementDescription.getInitialValue().getValue();
            if (!(dataElementDescription.getType() instanceof StringType) && initialValue.toString().equals(EMPTY_STRING)) {
                initialValue = Util.getDefaultValueForType(dataElementDescription.getType());
            }
        } else if (initialValue == null) {
            initialValue = Util.getDefaultValueForType(dataElementDescription.getType());
        }
        return initialValue;
    }

    public static AbstractValue getValue(DataElementDescription dataElementDescription, List<String> paths) {
        DataDefinition dataDefinition;
        AbstractValue value = null;
        String initialValue = null;
        if (dataElementDescription.eContainer() instanceof DataDefinition) {
            initialValue = Util.getPacDataElementDefaultValue((DataDefinition)dataElementDescription.eContainer(), paths);
        }
        if (initialValue == null && dataElementDescription.getInitialValue() != null) {
            initialValue = dataElementDescription.getInitialValue().getValue();
            if (!(dataElementDescription.getType() instanceof StringType) && initialValue.toString().equals(EMPTY_STRING)) {
                initialValue = Util.getDefaultValueForType(dataElementDescription.getType());
            }
        } else if (initialValue == null) {
            initialValue = Util.getDefaultValueForType(dataElementDescription.getType());
        }
        if (dataElementDescription.getType() == null) {
            DataDefinition parent = Util.getPacDataDefinitionParent(dataElementDescription);
            if (parent == null) {
                value = KernelFactory.eINSTANCE.createStringValue();
                ((StringValue)value).setValue(initialValue);
            }
        } else if (dataElementDescription.getType() instanceof ReferenceType) {
            value = KernelFactory.eINSTANCE.createReferenceValue();
            value.setEntity(null);
        } else if (dataElementDescription.getType() instanceof IntegerType) {
            value = KernelFactory.eINSTANCE.createIntegerValue();
            ((IntegerValue)value).setValue(initialValue);
        } else if (dataElementDescription.getType() instanceof StringType) {
            value = KernelFactory.eINSTANCE.createStringValue();
            ((StringValue)value).setValue(initialValue);
        } else if (dataElementDescription.getType() instanceof DecimalType) {
            value = KernelFactory.eINSTANCE.createDecimalValue();
            ((DecimalValue)value).setValue(initialValue);
        } else if (dataElementDescription.getType() instanceof FloatType) {
            value = KernelFactory.eINSTANCE.createFloatValue();
            ((FloatValue)value).setValue(initialValue);
        } else if (dataElementDescription.getType() instanceof ByteStringType) {
            value = KernelFactory.eINSTANCE.createByteStringValue();
        } else if (dataElementDescription.getType() instanceof DateTimeType) {
            value = KernelFactory.eINSTANCE.createDateTimeValue();
            ((DateTimeValue)value).setValue(initialValue);
        } else if (dataElementDescription.getType() instanceof TimeStampType) {
            value = KernelFactory.eINSTANCE.createTimeStampValue();
            ((TimeStampValue)value).setValue(initialValue);
        }
        if (value == null && dataElementDescription.eContainer() instanceof DataElement && (dataDefinition = Util.getPacDataDefinitionParent(dataElementDescription)) != null && dataDefinition.getDataDescription() != null) {
            value = Util.getValue((DataElementDescription)dataDefinition.getDataDescription(), paths);
        }
        return value;
    }

    public static DataDefinition getPacDataDefinitionParent(DataElementDescription dataElementDescription) {
        if (dataElementDescription.eContainer() instanceof DataElement) {
            EList<DataDescriptionExtension> extensions = dataElementDescription.getExtensions();
            DataDescriptionExtension extDescription = null;
            int i = 0;
            while (i < extensions.size()) {
                Object object = extensions.get(i);
                if (object instanceof DataDescriptionExtension) {
                    extDescription = (DataDescriptionExtension)object;
                    break;
                }
                ++i;
            }
            if (extDescription != null && extDescription.eClass().getName().equals("PacDataElementDescription")) {
                DataDefinition dataDefinition = null;
                EStructuralFeature feature = extDescription.eClass().getEStructuralFeature("parent");
                if (feature != null) {
                    dataDefinition = (DataDefinition)extDescription.eGet(feature);
                }
                if (dataDefinition != null) {
                    return dataDefinition;
                }
            }
        }
        return null;
    }

    public static SimpleType getType(DataElementDescription dataElementDescription, List<String> paths) {
        DataDefinition dataDefinition;
        RadicalEntity radicalEntity = dataElementDescription.getOwner();
        if (radicalEntity == null) {
            return null;
        }
        if (radicalEntity.getProject() == null || radicalEntity.getProject().length() == 0) {
            return null;
        }
        SimpleType type = dataElementDescription.getType();
        if (type == null && (dataDefinition = Util.getPacDataDefinitionParent(dataElementDescription)) != null && dataDefinition.getDataDescription() != null) {
            type = ((DataElementDescription)dataDefinition.getDataDescription()).getType();
        }
        return type;
    }

    public static AbstractValue getValue(DataElementDescription dataElementDescription) {
        return Util.getValue(dataElementDescription, null);
    }

    public static void getPacDataElementAllowedValuesAndIntervals(DataDefinition dataDefinition, List<String> allowedValues, List<Interval> intervals, List<String> paths) {
        DataDefinition parentDefinition;
        SimpleType simpleType = dataDefinition.getDataDescription() == null ? null : ((DataElementDescription)dataDefinition.getDataDescription()).getType();
        EList<RadicalEntityExtension> extensions = dataDefinition.getExtensions();
        RadicalEntityExtension radicalExt = null;
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof RadicalEntityExtension) {
                radicalExt = (RadicalEntityExtension)object;
                break;
            }
            ++i;
        }
        if (radicalExt != null && radicalExt.eClass().getName().equals("PacDataElement")) {
            List list;
            boolean needCheckSep;
            EStructuralFeature feature = null;
            String delimitor = null;
            boolean bl = needCheckSep = simpleType instanceof DateTimeType || simpleType instanceof StringType;
            if (needCheckSep) {
                delimitor = Util.getPacAlphanumericDelimiter(radicalExt, paths);
            }
            if (!(list = (List)radicalExt.eGet(feature = radicalExt.eClass().getEStructuralFeature("DLines"))).isEmpty()) {
                EObject currentDLine = null;
                String startLine = null;
                for (Object object : list) {
                    Object obj;
                    currentDLine = (EObject)object;
                    feature = currentDLine.eClass().getEStructuralFeature("lineType");
                    Object lineType = currentDLine.eGet(feature);
                    feature = currentDLine.eClass().getEStructuralFeature("more");
                    Object more = currentDLine.eGet(feature);
                    if (lineType.equals(" ") && (obj = currentDLine.eGet(feature = currentDLine.eClass().getEStructuralFeature("allowedValues"))) != null) {
                        Interval interval;
                        String currentLine = obj.toString();
                        String trimValue = currentLine.trim();
                        if (trimValue.length() == 0 || trimValue.length() == 2 && currentLine.startsWith("*")) continue;
                        if (trimValue.startsWith("(") || trimValue.startsWith(")")) {
                            if (startLine != null) {
                                interval = Util.getInterval(startLine, null, delimitor);
                                if (interval != null) {
                                    intervals.add(interval);
                                }
                                startLine = null;
                            }
                            if (trimValue.endsWith("(") || trimValue.endsWith(")")) {
                                interval = Util.getInterval(currentLine, null, delimitor);
                                if (interval == null) continue;
                                intervals.add(interval);
                                continue;
                            }
                            startLine = currentLine;
                            continue;
                        }
                        if (trimValue.startsWith("+") || more != null && more.toString().trim().equals("+")) {
                            interval = Util.getInterval(startLine, currentLine, delimitor);
                            if (interval != null) {
                                intervals.add(interval);
                            }
                            startLine = null;
                            continue;
                        }
                        if (trimValue.endsWith("(") || trimValue.endsWith(")")) {
                            if (startLine != null) {
                                interval = Util.getInterval(startLine, null, delimitor);
                                if (interval != null) {
                                    intervals.add(interval);
                                }
                                startLine = null;
                            }
                            if ((interval = Util.getInterval(currentLine, null, delimitor)) == null) continue;
                            intervals.add(interval);
                            continue;
                        }
                        if (startLine != null) {
                            interval = Util.getInterval(startLine, null, delimitor);
                            if (interval != null) {
                                intervals.add(interval);
                            }
                            startLine = null;
                        }
                        allowedValues.add(Util.getPacValuefor(currentLine, delimitor));
                    }
                    if (startLine == null) continue;
                    Interval interval = Util.getInterval(startLine, null, delimitor);
                    if (interval != null) {
                        intervals.add(interval);
                    }
                    startLine = null;
                }
            }
        }
        if (simpleType == null && dataDefinition.getDataDescription() instanceof DataElementDescription && (parentDefinition = Util.getPacDataDefinitionParent((DataElementDescription)dataDefinition.getDataDescription())) != null) {
            Util.getPacDataElementAllowedValuesAndIntervals(parentDefinition, allowedValues, intervals, paths);
        }
    }

    public static String getPacDataElementDefaultValue(DataDefinition dataDefinition, List<String> paths) {
        EStructuralFeature feature;
        List list;
        String result = null;
        EList<RadicalEntityExtension> extensions = dataDefinition.getExtensions();
        RadicalEntityExtension radicalExt = null;
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof RadicalEntityExtension) {
                radicalExt = (RadicalEntityExtension)object;
                break;
            }
            ++i;
        }
        if (radicalExt != null && radicalExt.eClass().getName().equals("PacDataElement") && !(list = (List)radicalExt.eGet(feature = radicalExt.eClass().getEStructuralFeature("DLines"))).isEmpty()) {
            boolean needCheckSep;
            EObject currentDLine = null;
            String delimitor = null;
            SimpleType simpleType = dataDefinition.getDataDescription() == null ? null : ((DataElementDescription)dataDefinition.getDataDescription()).getType();
            boolean bl = needCheckSep = simpleType instanceof DateTimeType || simpleType instanceof StringType;
            if (needCheckSep) {
                delimitor = Util.getPacAlphanumericDelimiter(radicalExt, paths);
            }
            for (Object object : list) {
                String currentLine;
                Object obj;
                currentDLine = (EObject)object;
                Object lineType = currentDLine.eGet(feature = currentDLine.eClass().getEStructuralFeature("lineType"));
                if (!lineType.equals("D") || (obj = currentDLine.eGet(feature = currentDLine.eClass().getEStructuralFeature("allowedValues"))) == null) continue;
                result = currentLine = Util.getPacValuefor(obj.toString(), delimitor);
                break;
            }
        }
        return result;
    }

    private static String getPacAlphanumericDelimiter(RadicalEntityExtension radicalExt, List<String> paths) {
        EStructuralFeature feature = radicalExt.eClass().getEStructuralFeature("generationParameter");
        RadicalEntity lib = (RadicalEntity)radicalExt.eGet(feature);
        if (lib != null && paths != null) {
            String result;
            URI proxyURI = lib.getProxyURI();
            RadicalEntity resolvedLib = null;
            resolvedLib = proxyURI == null ? lib : Util.resolveRadicalEntity(proxyURI, paths);
            Object alphanumericDelimiter = resolvedLib.eGet(feature = resolvedLib.eClass().getEStructuralFeature("alphanumericDelimiter"));
            if (alphanumericDelimiter != null && (result = alphanumericDelimiter.toString()).length() > 0) {
                return result;
            }
        }
        return null;
    }

    private static String getPacGeneratedDateFormat(RadicalEntityExtension radicalExt, List<String> paths) {
        EStructuralFeature feature = radicalExt.eClass().getEStructuralFeature("generationParameter");
        RadicalEntity lib = (RadicalEntity)radicalExt.eGet(feature);
        if (lib != null) {
            String result;
            URI proxyURI = lib.getProxyURI();
            RadicalEntity resolvedLib = null;
            resolvedLib = proxyURI == null ? lib : Util.resolveRadicalEntity(proxyURI, paths);
            Object generatedDateFormat = resolvedLib.eGet(feature = resolvedLib.eClass().getEStructuralFeature("generatedDateFormat"));
            if (generatedDateFormat != null && (result = generatedDateFormat.toString()).length() > 0) {
                return result;
            }
        }
        return null;
    }

    private static String getPacValuefor(String string, String delimitor) {
        if (string == null) {
            return null;
        }
        String result = new String(string);
        if (delimitor != null && delimitor.length() > 0) {
            int beginIndex = result.startsWith(delimitor) ? 1 : 0;
            int endIndex = result.endsWith(delimitor) ? result.length() - 1 : result.length();
            result = result.substring(Math.min(beginIndex, result.length()), Math.min(endIndex, result.length()));
        }
        return result;
    }

    public static int compareValuesForType(SimpleType simpleType, String value1, String value2) throws NumberFormatException {
        String val2;
        String val1 = value1 == null || value1.trim().length() == 0 ? null : value1;
        String string = val2 = value2 == null || value2.trim().length() == 0 ? null : value2;
        if (simpleType instanceof StringType) {
            if (val1 == null) {
                val1 = EMPTY_STRING;
            }
            if (val2 == null) {
                val2 = EMPTY_STRING;
            }
            return val1.compareTo(val2);
        }
        if (simpleType instanceof DecimalType) {
            double max;
            double min = val1 == null ? 0.0 : Util.getDecimalValueFor(val1);
            double d = max = val2 == null ? 0.0 : Util.getDecimalValueFor(val2);
            if (min == max) {
                return 0;
            }
            if (min < max) {
                return -1;
            }
            return 1;
        }
        if (simpleType instanceof IntegerType) {
            long max;
            long min = val1 == null ? 0L : Util.getLongValueFor(val1);
            long l = max = val2 == null ? 0L : Util.getLongValueFor(val2);
            if (min == max) {
                return 0;
            }
            if (min < max) {
                return -1;
            }
            return 1;
        }
        if (simpleType instanceof TimeStampType) {
            long max;
            long min = val1 == null ? 0L : Util.getLongValueFor(val1);
            long l = max = val2 == null ? 0L : Util.getLongValueFor(val2);
            if (min == max) {
                return 0;
            }
            if (min < max) {
                return -1;
            }
            return 1;
        }
        if (simpleType instanceof FloatType) {
            float max;
            float min = val1 == null ? 0.0f : Util.getFloatValueFor(val1).floatValue();
            float f = max = val2 == null ? 0.0f : Util.getFloatValueFor(val2).floatValue();
            if (min == max) {
                return 0;
            }
            if (min < max) {
                return -1;
            }
            return 1;
        }
        if (simpleType instanceof DateTimeType) {
            DateTimeType type = (DateTimeType)simpleType;
            String format = type.getFormat();
            if (format != null && !format.equals(EMPTY_STRING)) {
                try {
                    Date minDate = Util.getDateValueFor(val1, type.getFormat());
                    Date maxDate = Util.getDateValueFor(val2, type.getFormat());
                    return minDate.compareTo(maxDate);
                }
                catch (ParseException parseException) {
                    return 0;
                }
            }
            return 0;
        }
        return 0;
    }

    private static Interval getInterval(String start, String end, String delimitor) {
        Interval interval = KernelFactory.eINSTANCE.createInterval();
        Value minValue = KernelFactory.eINSTANCE.createValue();
        Value maxValue = KernelFactory.eINSTANCE.createValue();
        interval.setMinValue(minValue);
        interval.setMaxValue(maxValue);
        String sInterval = EMPTY_STRING;
        if (start != null) {
            sInterval = String.valueOf(sInterval) + start;
        }
        if (end != null) {
            sInterval = String.valueOf(sInterval) + " " + end;
        }
        boolean hasMinimum = (sInterval = sInterval.trim().replace('+', ' ')).startsWith("(") || sInterval.startsWith(")");
        boolean hasMaximum = sInterval.endsWith("(") || sInterval.endsWith(")");
        interval.setMinValueIncluded(sInterval.startsWith("("));
        interval.setMaxValueIncluded(sInterval.endsWith(")"));
        int beginIndex = 0;
        int endIndex = 0;
        beginIndex = hasMinimum ? 1 : 0;
        endIndex = sInterval.length() - (hasMaximum ? 1 : 0);
        try {
            String values = sInterval.substring(Math.min(beginIndex, sInterval.length()), Math.min(endIndex, sInterval.length()));
            StringTokenizer st = new StringTokenizer(values);
            if (hasMinimum) {
                String min = Util.getPacValuefor(st.nextToken(), delimitor);
                minValue.setValue(min);
            }
            if (hasMaximum) {
                String max = Util.getPacValuefor(st.nextToken(), delimitor);
                maxValue.setValue(max);
            }
        }
        catch (Exception exception) {}
        return interval;
    }

    public static RadicalEntity resolveRadicalEntity(URI proxyURI, List<String> paths) {
        if (softReferences == null) {
            softReferences = new HashMap<String, SoftReference<RadicalEntity>>();
        } else if (softReferences.size() > MAX_CACHE) {
            softReferences.clear();
        }
        SoftReference<RadicalEntity> softReference = null;
        int i = 0;
        while (i < paths.size()) {
            softReference = softReferences.get(String.valueOf(proxyURI.toString()) + '#' + paths.get(i));
            if (softReference != null && softReference.get() != null) {
                return softReference.get();
            }
            ++i;
        }
        RadicalEntity radicalEntity = null;
        StringBuffer proxyBuffer = new StringBuffer();
        int i2 = 0;
        while (i2 < proxyURI.segmentCount()) {
            String decoded = URI.decode((String)proxyURI.segment(i2));
            proxyBuffer.append("/" + decoded);
            ++i2;
        }
        String projectName = null;
        int i3 = 0;
        while (radicalEntity == null && i3 < paths.size()) {
            projectName = paths.get(i3);
            StringBuilder uriBuffer = new StringBuilder("/" + projectName);
            String designFolder = KernelContext.getProjectDescriptor().getDesignFolder(projectName);
            if (designFolder != null && designFolder.length() > 0) {
                uriBuffer.append("/").append(designFolder);
            }
            uriBuffer.append(proxyBuffer);
            URI platformURI = URI.createPlatformResourceURI((String)uriBuffer.toString(), (boolean)true);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            try {
                Resource resource = resourceSet.getResource(platformURI, true);
                radicalEntity = (RadicalEntity)resource.getContents().get(0);
            }
            catch (Exception exception) {}
            ++i3;
        }
        softReferences.put(String.valueOf(proxyURI.toString()) + '#' + projectName, new SoftReference<Object>(radicalEntity));
        return radicalEntity;
    }

    public static String getIdentifierKey(AggregateValue aggregateValue, List<String> fields) {
        String key = EMPTY_STRING;
        for (String id : fields) {
            AbstractValue abstractValue;
            Field field = aggregateValue.getField(id);
            if (field == null || (abstractValue = field.getValue()) == null) continue;
            if (abstractValue instanceof ReferenceValue) {
                ReferenceValue referenceValue = (ReferenceValue)abstractValue;
                RadicalEntity entity = referenceValue.getEntity();
                if (entity == null) continue;
                key = String.valueOf(key) + entity.getDesignURI();
                continue;
            }
            if (!(abstractValue instanceof VoidValue) && !(abstractValue instanceof AggregateValue)) {
                EStructuralFeature feature = abstractValue.eClass().getEStructuralFeature("value");
                String value = abstractValue.eGet(feature).toString();
                if (value == null) continue;
                try {
                    if (abstractValue instanceof IntegerValue || abstractValue instanceof TimeStampValue) {
                        key = String.valueOf(key) + Util.getLongValueFor(value);
                        continue;
                    }
                    if (abstractValue instanceof DecimalValue) {
                        key = String.valueOf(key) + Util.getDecimalValueFor(value);
                        continue;
                    }
                    if (abstractValue instanceof FloatValue) {
                        key = String.valueOf(key) + Util.getFloatValueFor(value);
                        continue;
                    }
                    key = String.valueOf(key) + value;
                }
                catch (Exception exception) {
                    key = String.valueOf(key) + value;
                }
                continue;
            }
            if (!(abstractValue instanceof VoidValue)) continue;
            key = String.valueOf(key) + abstractValue.hashCode();
        }
        return key;
    }

    public static String convertByteArrayToHexString(byte[] in, int maxLength) {
        byte ch = 0;
        int i = 0;
        if (in == null || in.length <= 0) {
            return EMPTY_STRING;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer out = new StringBuffer(in.length * 2);
        while (i < in.length) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
            if (maxLength != -1 && i > maxLength) break;
            ++i;
        }
        String rslt = new String(out);
        return rslt;
    }

    public static byte[] convertHexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public static int checkDataElementDescriptionMarkers(boolean isRecursive, boolean markResource, DataElementDescription dataElementDescription, List<String> paths, List<Marker> markers) {
        int severity;
        block51: {
            EReference feature;
            String message;
            EAttribute feature2;
            Object[] array;
            int maxLength;
            severity = -1;
            String value = dataElementDescription.getInitialValue() == null ? null : dataElementDescription.getInitialValue().getValue();
            RadicalEntity radicalEntity = dataElementDescription.getOwner();
            if (!Util.isValidValueFormatForType(dataElementDescription.getType(), value, paths)) {
                severity = Math.max(severity, 2);
                Object[] array2 = new String[]{value, dataElementDescription.getName(), dataElementDescription.getType().eClass().getName()};
                Iterator feature3 = KernelPackage.eINSTANCE.getDataElementDescription_InitialValue();
                String message2 = KernelLabel.getString(KernelLabel._WRONG_INITIAL_VALUE, array2);
                if (markers != null) {
                    markers.add(new Marker(2, (EStructuralFeature)feature3, message2));
                }
                if (markResource) {
                    Util.addMarker(dataElementDescription.getOwner(), (EStructuralFeature)feature3, message2, 2, 2);
                }
            }
            if (!(dataElementDescription.getType() instanceof ReferenceType) && !(dataElementDescription.getType() instanceof ByteStringType)) {
                for (Object object : dataElementDescription.getAllowedValues()) {
                    severity = Math.max(severity, Util.checkAllowedValuesMarkers(isRecursive, markResource, (Value)object, paths, markers));
                }
                for (Object object : dataElementDescription.getAllowedIntervals()) {
                    severity = Math.max(severity, Util.checkIntervalsMarkers(isRecursive, markResource, (Interval)object, paths, markers));
                }
            }
            if (dataElementDescription.getType() instanceof ByteStringType && (maxLength = ((ByteStringType)dataElementDescription.getType()).getMaxLength()) > 1000000) {
                severity = Math.max(severity, 2);
                Object[] array3 = new String[]{Integer.toString(maxLength), Integer.toString(1000000)};
                EAttribute feature4 = KernelPackage.eINSTANCE.getDecimalType_MinValue();
                String message3 = KernelLabel.getString(KernelLabel._WRONG_MAX_BYTE_LENGTH, array3);
                if (markers != null) {
                    markers.add(new Marker(2, (EStructuralFeature)feature4, message3));
                }
                if (markResource) {
                    Util.addMarker(radicalEntity, (EStructuralFeature)feature4, message3, 2, 2);
                }
            }
            String minValue = null;
            String maxValue = null;
            if (dataElementDescription.getType() instanceof DecimalType) {
                minValue = ((DecimalType)dataElementDescription.getType()).getMinValue();
                maxValue = ((DecimalType)dataElementDescription.getType()).getMaxValue();
            } else if (dataElementDescription.getType() instanceof IntegerType) {
                minValue = ((IntegerType)dataElementDescription.getType()).getMinValue();
                maxValue = ((IntegerType)dataElementDescription.getType()).getMaxValue();
            } else if (dataElementDescription.getType() instanceof TimeStampType) {
                minValue = ((TimeStampType)dataElementDescription.getType()).getMinValue();
                maxValue = ((TimeStampType)dataElementDescription.getType()).getMaxValue();
            }
            if (EMPTY_STRING.equals(minValue)) {
                minValue = null;
            }
            if (EMPTY_STRING.equals(maxValue)) {
                maxValue = minValue == null ? null : minValue;
            }
            if (minValue != null && !Util.isValidValueFormatForType(dataElementDescription.getType(), minValue, paths)) {
                severity = Math.max(severity, 2);
                array = new String[]{minValue, dataElementDescription.getName(), dataElementDescription.getType().eClass().getName()};
                feature2 = KernelPackage.eINSTANCE.getDecimalType_MinValue();
                message = KernelLabel.getString(KernelLabel._WRONG_MIN_VALUE, array);
                if (markers != null) {
                    markers.add(new Marker(2, (EStructuralFeature)feature2, message));
                }
                if (markResource) {
                    Util.addMarker(radicalEntity, (EStructuralFeature)feature2, message, 2, 2);
                }
            }
            if (maxValue != null && !Util.isValidValueFormatForType(dataElementDescription.getType(), maxValue, paths)) {
                severity = Math.max(severity, 2);
                array = new String[]{maxValue, dataElementDescription.getName(), dataElementDescription.getType().eClass().getName()};
                feature2 = KernelPackage.eINSTANCE.getDecimalType_MaxValue();
                message = KernelLabel.getString(KernelLabel._WRONG_MAX_VALUE, array);
                if (markers != null) {
                    markers.add(new Marker(2, (EStructuralFeature)feature2, message));
                }
                if (markResource) {
                    Util.addMarker(radicalEntity, (EStructuralFeature)feature2, message, 2, 2);
                }
            }
            boolean wrongMinMaxValue = false;
            if (minValue == null && maxValue != null || minValue != null && maxValue == null) {
                severity = Math.max(severity, 2);
                wrongMinMaxValue = true;
            } else if (minValue != null || maxValue != null) {
                if (dataElementDescription.getType() instanceof DecimalType) {
                    try {
                        if (Util.getDecimalValueFor(minValue) > Util.getDecimalValueFor(maxValue)) {
                            severity = Math.max(severity, 2);
                            wrongMinMaxValue = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        wrongMinMaxValue = true;
                    }
                } else if (dataElementDescription.getType() instanceof IntegerType) {
                    try {
                        if (Util.getLongValueFor(minValue) > Util.getLongValueFor(maxValue)) {
                            severity = Math.max(severity, 2);
                            wrongMinMaxValue = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        wrongMinMaxValue = true;
                    }
                } else if (dataElementDescription.getType() instanceof TimeStampType) {
                    try {
                        if (Util.getDoubleValueFor(minValue) > Util.getDoubleValueFor(maxValue)) {
                            severity = Math.max(severity, 2);
                            wrongMinMaxValue = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        wrongMinMaxValue = true;
                    }
                }
            }
            if (wrongMinMaxValue) {
                Object[] array4 = new String[]{maxValue, minValue, dataElementDescription.getName()};
                message = KernelLabel.getString(KernelLabel._WRONG_MIN_MAX_VALUE, array4);
                feature = KernelPackage.eINSTANCE.getDataElementDescription_AllowedIntervals();
                if (markers != null) {
                    markers.add(new Marker(2, (EStructuralFeature)feature, message));
                }
                if (markResource) {
                    Util.addMarker(radicalEntity, (EStructuralFeature)feature, message, 2, 2);
                }
            }
            if (dataElementDescription.getType() instanceof DateTimeType) {
                Object[] array5;
                String format = ((DateTimeType)dataElementDescription.getType()).getFormat();
                if (format == null || format.equals(EMPTY_STRING)) {
                    severity = Math.max(severity, 2);
                    array5 = new String[]{dataElementDescription.getName()};
                    feature = KernelPackage.eINSTANCE.getDateTimeType_Format();
                    String message4 = KernelLabel.getString(KernelLabel._MISSING_DATA_FORMAT, array5);
                    if (markers != null) {
                        markers.add(new Marker(2, (EStructuralFeature)feature, message4));
                    }
                    if (markResource) {
                        Util.addMarker(radicalEntity, (EStructuralFeature)feature, message4, 2, 2);
                    }
                } else {
                    try {
                        new SimpleDateFormat(format);
                    }
                    catch (Exception exception) {
                        severity = Math.max(severity, 2);
                        array5 = new String[]{format, dataElementDescription.getName()};
                        feature = KernelPackage.eINSTANCE.getDateTimeType_Format();
                        String message5 = KernelLabel.getString(KernelLabel._WRONG_DATA_FORMAT, array5);
                        if (markers != null) {
                            markers.add(new Marker(2, (EStructuralFeature)feature, message5));
                        }
                        if (!markResource) break block51;
                        Util.addMarker(radicalEntity, (EStructuralFeature)feature, message5, 2, 2);
                    }
                }
            }
        }
        return severity;
    }

    public static int checkDataAggregateDescriptionMarkers(boolean isRecursive, boolean markResource, DataAggregateDescription dataAggregateDescription, List<String> paths, List<Marker> markers) {
        int severity = -1;
        ArrayList<String> names = new ArrayList<String>();
        RadicalEntity radicalEntity = dataAggregateDescription.getOwner();
        for (DataComponent component : dataAggregateDescription.getComponents()) {
            DataCall parentDataCall;
            if (!(component instanceof DataCall)) continue;
            DataCall dataCall = (DataCall)component;
            DataDefinition dataDefinition = dataCall.getDataDefinition();
            DataDescription dataDescription = dataCall.getDataDescription();
            String name = null;
            if (dataDefinition != null) {
                URI proxyURI = dataCall.getDataDefinition().getProxyURI();
                DataDefinition resolvedDataDefinition = null;
                if (proxyURI == null) {
                    resolvedDataDefinition = dataCall.getDataDefinition();
                } else {
                    resolvedDataDefinition = (DataDefinition)Util.resolveRadicalEntity(proxyURI, paths);
                    dataCall.setDataDefinition(resolvedDataDefinition);
                }
                if (resolvedDataDefinition != null) {
                    name = resolvedDataDefinition.getProxyName();
                    dataDescription = resolvedDataDefinition.getDataDescription();
                }
            } else {
                if (dataDescription == null) continue;
                name = dataDescription.getName();
            }
            if (names.contains(name)) {
                severity = Math.max(severity, 2);
                Object[] array = new String[]{name, dataAggregateDescription.getName()};
                String message = KernelLabel.getString(KernelLabel._DATA_AGGREGATE_UNIQUE_NAME, array);
                EAttribute feature = KernelPackage.eINSTANCE.getDataDescription_Name();
                if (markers != null) {
                    markers.add(new Marker(2, (EStructuralFeature)feature, message));
                }
                if (markResource) {
                    Util.addMarker(radicalEntity, (EStructuralFeature)feature, message, 2, 2);
                }
            } else {
                names.add(name);
            }
            EAttribute featureMaxCardinality = KernelPackage.eINSTANCE.getDataComponent_MaximumCardinality();
            if (dataCall.getMaximumCardinality() == 0) {
                severity = Math.max(severity, 2);
                Object[] array = new String[]{featureMaxCardinality.getName()};
                String message = String.valueOf(KernelLabel.getString(KernelLabel._GREATER_0, array)) + " (" + name + ")";
                if (markResource) {
                    Util.addMarker(radicalEntity, (EStructuralFeature)featureMaxCardinality, message, 2, 2);
                }
                if (markers != null) {
                    markers.add(new Marker(2, (EStructuralFeature)featureMaxCardinality, message));
                }
            }
            if (isRecursive && dataDescription != dataAggregateDescription && dataDescription instanceof DataAggregateDescription) {
                severity = Math.max(severity, Util.checkDataAggregateDescriptionMarkers(isRecursive, markResource, (DataAggregateDescription)dataDescription, paths, markers));
            }
            if (!(dataCall.eContainer().eContainer() instanceof DataCall) || (parentDataCall = (DataCall)dataCall.eContainer().eContainer()).getIdentifier() == null || !parentDataCall.getIdentifier().getCalls().contains((Object)dataCall) || dataCall.getMinimumCardinality() == 1 && dataCall.getMaximumCardinality() == 1) continue;
            severity = Math.max(severity, 2);
            Object[] array = new String[]{name};
            String message = KernelLabel.getString(KernelLabel._WRONG_IDENTIFIER_CARDINALITY, array);
            if (markResource) {
                Util.addMarker(radicalEntity, (EStructuralFeature)KernelPackage.eINSTANCE.getDataComponent_MinimumCardinality(), message, 2, 2);
            }
            if (markers == null) continue;
            markers.add(new Marker(2, (EStructuralFeature)KernelPackage.eINSTANCE.getDataComponent_MinimumCardinality(), message));
        }
        return severity;
    }

    public static int checkAllowedValuesMarkers(boolean isRecursive, boolean markResource, Value value, List<String> paths, List<Marker> markers) {
        int severity = -1;
        DataElementDescription dataElementDescription = (DataElementDescription)value.eContainer();
        if (!Util.isValidValueFormatForType(dataElementDescription.getType(), value.getValue(), paths)) {
            severity = Math.max(severity, 2);
            String name = dataElementDescription.eContainer() instanceof DataDefinition ? ((DataDefinition)dataElementDescription.eContainer()).getName() : dataElementDescription.getName();
            Object[] array = new String[]{value.getValue(), name, dataElementDescription.getType().eClass().getName()};
            EReference feature = KernelPackage.eINSTANCE.getDataElementDescription_AllowedValues();
            String message = KernelLabel.getString(KernelLabel._WRONG_ALLOWED_VALUE, array);
            if (markers != null) {
                markers.add(new Marker(2, (EStructuralFeature)feature, message));
            }
            if (markResource) {
                Util.addMarker(value.getOwner(), (EStructuralFeature)feature, message, 2, 2);
            }
        }
        return severity;
    }

    public static int checkIntervalsMarkers(boolean isRecursive, boolean markResource, Interval interval, List<String> paths, List<Marker> markers) {
        String message;
        EReference feature;
        Object[] array;
        String name;
        int severity = -1;
        DataElementDescription dataElementDescription = (DataElementDescription)interval.eContainer();
        if (!Util.isValidValueFormatForType(dataElementDescription.getType(), interval.getMinValue().getValue(), paths)) {
            severity = Math.max(severity, 2);
            name = dataElementDescription.eContainer() instanceof DataDefinition ? ((DataDefinition)dataElementDescription.eContainer()).getName() : dataElementDescription.getName();
            array = new String[]{interval.getMinValue().getValue(), name, dataElementDescription.getType().eClass().getName()};
            feature = KernelPackage.eINSTANCE.getInterval_MinValue();
            message = KernelLabel.getString(KernelLabel._WRONG_INTERVAL_MIN_VALUE, array);
            if (markers != null) {
                markers.add(new Marker(2, (EStructuralFeature)feature, message));
            }
            if (markResource) {
                Util.addMarker(interval.getOwner(), (EStructuralFeature)feature, message, 2, 2);
            }
        }
        if (!Util.isValidValueFormatForType(dataElementDescription.getType(), interval.getMaxValue().getValue(), paths)) {
            severity = Math.max(severity, 2);
            name = dataElementDescription.eContainer() instanceof DataDefinition ? ((DataDefinition)dataElementDescription.eContainer()).getName() : dataElementDescription.getName();
            array = new String[]{interval.getMaxValue().getValue(), name, dataElementDescription.getType().eClass().getName()};
            feature = KernelPackage.eINSTANCE.getInterval_MaxValue();
            message = KernelLabel.getString(KernelLabel._WRONG_INTERVAL_MAX_VALUE, array);
            if (markers != null) {
                markers.add(new Marker(2, (EStructuralFeature)feature, message));
            }
            if (markResource) {
                Util.addMarker(interval.getOwner(), (EStructuralFeature)feature, message, 2, 2);
            }
        }
        if (severity != -1) {
            return severity;
        }
        String minValue = interval.getMinValue().getValue();
        String maxValue = interval.getMaxValue().getValue();
        if (minValue == null || maxValue == null) {
            severity = Math.max(severity, 2);
        } else {
            try {
                if (Util.compareValuesForType(dataElementDescription.getType(), minValue, maxValue) > 0) {
                    severity = Math.max(severity, 2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                severity = Math.max(severity, 2);
            }
        }
        if (severity != -1) {
            String name2 = dataElementDescription.eContainer() instanceof DataDefinition ? ((DataDefinition)dataElementDescription.eContainer()).getName() : dataElementDescription.getName();
            Object[] array2 = new String[]{interval.getMaxValue().getValue(), interval.getMinValue().getValue(), name2};
            String message2 = KernelLabel.getString(KernelLabel._WRONG_INTERVAL_MIN_MAX_VALUE, array2);
            EReference feature2 = KernelPackage.eINSTANCE.getDataElementDescription_AllowedIntervals();
            if (markers != null) {
                markers.add(new Marker(2, (EStructuralFeature)feature2, message2));
            }
            if (markResource) {
                Util.addMarker(interval.getOwner(), (EStructuralFeature)feature2, message2, 2, 2);
            }
        }
        return severity;
    }

    private static void addMarker(RadicalEntity entity, EStructuralFeature feature, String message, int severity, int priority) {
        try {
            if (entity == null) {
                return;
            }
            IFile markerResource = entity.getFile(null);
            if (markerResource != null) {
                IMarker marker = markerResource.createMarker(_DESIGN_MARKER);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", severity);
                marker.setAttribute("priority", priority);
                marker.setAttribute("location", (Object)feature.getName());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static String getUserInfo(IPath relativePath) throws CoreException, IOException {
        return Util.getFieldValue("userInfo", relativePath);
    }

    private static String getFieldValue(String fieldTag, IPath relativePath) throws CoreException, IOException {
        String fieldValue = EMPTY_STRING;
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(relativePath);
        InputStream inputStream = file.getContents();
        StringBuilder buffer = new StringBuilder(fieldTag);
        buffer.append('=').append('\"');
        String token = buffer.toString();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream), 10000);
        String line = EMPTY_STRING;
        int i = 0;
        while (i < 2 && (line = reader.readLine()) != null) {
            int start = line.indexOf(token);
            if (start != -1) {
                int end = line.indexOf("\"", start += token.length());
                fieldValue = line.substring(start, end);
                break;
            }
            ++i;
        }
        if (reader != null) {
            reader.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        return fieldValue;
    }

    public static boolean isUpper(String s) {
        if (s == null) {
            return true;
        }
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isUpperCase(c) && !Character.isDigit(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isLower(String s) {
        if (s == null) {
            return true;
        }
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLowerCase(c) && !Character.isDigit(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void addRppSpecificEmfOptions(Map<Object, Object> options) {
        options.put("EXTENDED_META_DATA", true);
        options.put("EXTENDED_META_DATA", new BasicExtendedMetaData(){

            public EPackage getPackage(String namespace) {
                if ("http:///cobol.ecore".equals(namespace)) {
                    return super.getPackage("http:///rpp.cobol.ecore");
                }
                return super.getPackage(namespace);
            }
        });
    }
}

