/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.kernel.util;

import com.ibm.pdp.mdl.kernel.AbstractValue;
import com.ibm.pdp.mdl.kernel.AggregateValue;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataDescription;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.DateTimeType;
import com.ibm.pdp.mdl.kernel.DateTimeValue;
import com.ibm.pdp.mdl.kernel.DecimalValue;
import com.ibm.pdp.mdl.kernel.Field;
import com.ibm.pdp.mdl.kernel.FloatValue;
import com.ibm.pdp.mdl.kernel.IntegerValue;
import com.ibm.pdp.mdl.kernel.SimpleType;
import com.ibm.pdp.mdl.kernel.Sort;
import com.ibm.pdp.mdl.kernel.StringValue;
import com.ibm.pdp.mdl.kernel.VoidValue;
import com.ibm.pdp.mdl.kernel.util.Util;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateValueComparator<T>
implements Comparator<AbstractValue> {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2011, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String EMPTY_STRING = "";
    Sort _sort;

    public AggregateValueComparator(Sort _sort) {
        this._sort = _sort;
    }

    @Override
    private int compare(AggregateValue value1, AggregateValue value2) {
        int result = 0;
        for (Object object : this._sort.getComparator().getCalls()) {
            DataCall call = (DataCall)object;
            String fieldName = null;
            fieldName = call.getDataDefinition() != null ? call.getDataDefinition().getName() : call.getDataDescription().getName();
            Field field1 = value1.getField(fieldName);
            Field field2 = value2.getField(fieldName);
            if (field1 == null && field2 == null) {
                result = 0;
            } else if (field1 == null) {
                result = -1;
            } else if (field2 == null) {
                result = 1;
            } else {
                AbstractValue abstractValue1 = field1.getValue();
                AbstractValue abstractValue2 = field2.getValue();
                result = this.compare(abstractValue1, abstractValue2);
            }
            if (result == 0) continue;
            if (this._sort.isDescending()) {
                return result * -1;
            }
            return result;
        }
        return 0;
    }

    @Override
    public int compare(AbstractValue abstractValue1, AbstractValue abstractValue2) {
        if (abstractValue1 instanceof AggregateValue && abstractValue2 instanceof AggregateValue) {
            return this.compare((AggregateValue)abstractValue1, (AggregateValue)abstractValue2);
        }
        if (abstractValue1 instanceof VoidValue && abstractValue2 instanceof VoidValue) {
            return 0;
        }
        if (abstractValue1 instanceof VoidValue) {
            return -1;
        }
        if (abstractValue2 instanceof VoidValue) {
            return 1;
        }
        EStructuralFeature feature = abstractValue1.eClass().getEStructuralFeature("value");
        if (feature == null) {
            return 0;
        }
        String value1 = abstractValue1.eGet(feature).toString();
        String value2 = abstractValue2.eGet(feature).toString();
        if (value1 == null) {
            value1 = EMPTY_STRING;
        }
        if (value2 == null) {
            value2 = EMPTY_STRING;
        }
        if (abstractValue1 instanceof StringValue) {
            return value1.compareTo(value2);
        }
        if (abstractValue1 instanceof IntegerValue) {
            Long int1 = 0L;
            Long int2 = 0L;
            if (!EMPTY_STRING.equals(value1)) {
                try {
                    int1 = Util.getLongValueFor(value1);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (!EMPTY_STRING.equals(value2)) {
                try {
                    int2 = Util.getLongValueFor(value2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return int1.compareTo(int2);
        }
        if (abstractValue1 instanceof DateTimeValue) {
            SimpleType type;
            DataDescription dataDescription = Util.getDataDescription(abstractValue1.getMetaEntity(), abstractValue1, null);
            if (dataDescription instanceof DataElementDescription && (type = ((DataElementDescription)dataDescription).getType()) instanceof DateTimeType) {
                String format = ((DateTimeType)type).getFormat();
                try {
                    Date date1 = Util.getDateValueFor(value1, format);
                    Date date2 = Util.getDateValueFor(value2, format);
                    return date1.compareTo(date2);
                }
                catch (Exception exception) {}
            }
            return 0;
        }
        if (abstractValue1 instanceof DecimalValue) {
            Double d1 = 0.0;
            Double d2 = 0.0;
            if (!EMPTY_STRING.equals(value1)) {
                try {
                    d1 = Util.getDecimalValueFor(value1);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (!EMPTY_STRING.equals(value2)) {
                try {
                    d2 = Util.getDecimalValueFor(value2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return d1.compareTo(d2);
        }
        if (abstractValue1 instanceof FloatValue) {
            Double d1 = 0.0;
            Double d2 = 0.0;
            if (!EMPTY_STRING.equals(value1)) {
                try {
                    d1 = Util.getDoubleValueFor(value1);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (!EMPTY_STRING.equals(value2)) {
                try {
                    d2 = Util.getDoubleValueFor(value2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return d1.compareTo(d2);
        }
        return 0;
    }
}

