/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.kernel.impl;

import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.SimpleType;
import com.ibm.pdp.mdl.kernel.StringCaseValues;
import com.ibm.pdp.mdl.kernel.StringType;
import com.ibm.pdp.mdl.kernel.impl.SimpleTypeImpl;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTypeImpl
extends SimpleTypeImpl
implements StringType {
    protected static final int MAX_LENGTH_EDEFAULT = -1;
    protected int maxLength = -1;
    protected static final StringCaseValues CASE_EDEFAULT = StringCaseValues.ANY;
    protected StringCaseValues case_ = CASE_EDEFAULT;
    static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected StringTypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return KernelPackage.Literals.STRING_TYPE;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void setMaxLength(int newMaxLength) {
        int oldMaxLength = this.maxLength;
        this.maxLength = newMaxLength;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldMaxLength, this.maxLength));
        }
    }

    @Override
    public StringCaseValues getCase() {
        return this.case_;
    }

    @Override
    public void setCase(StringCaseValues newCase) {
        StringCaseValues oldCase = this.case_;
        StringCaseValues stringCaseValues = this.case_ = newCase == null ? CASE_EDEFAULT : newCase;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldCase, (Object)this.case_));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getMaxLength();
            }
            case 3: {
                return this.getCase();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setMaxLength((Integer)newValue);
                return;
            }
            case 3: {
                this.setCase((StringCaseValues)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setMaxLength(-1);
                return;
            }
            case 3: {
                this.setCase(CASE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.maxLength != -1;
            }
            case 3: {
                return this.case_ != CASE_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (maxLength: ");
        result.append(this.maxLength);
        result.append(", case: ");
        result.append((Object)this.case_);
        result.append(')');
        return result.toString();
    }

    @Override
    public boolean isCompatible(SimpleType simpleType) {
        if (simpleType == null) {
            return true;
        }
        if (!(simpleType instanceof StringType)) {
            return false;
        }
        StringType stringType = (StringType)simpleType;
        return stringType.getMaxLength() == this.getMaxLength();
    }

    @Override
    public boolean isValidValueForSimpleType(String value, List<String> paths) {
        boolean result;
        block5: {
            block6: {
                result = true;
                if (value == null || value.length() < 1) break block5;
                if (this.getMaxLength() > 0) {
                    boolean bl = result = value.length() <= this.getMaxLength();
                }
                if (this.getCase() != StringCaseValues.LOWER) break block6;
                char[] cArray = value.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (Character.isUpperCase(c)) {
                        result = false;
                        break block5;
                    }
                    ++n2;
                }
                break block5;
            }
            if (this.getCase() != StringCaseValues.UPPER) break block5;
            char[] cArray = value.toCharArray();
            int n = cArray.length;
            int n3 = 0;
            while (n3 < n) {
                char c = cArray[n3];
                if (Character.isLowerCase(c)) {
                    result = false;
                    break;
                }
                ++n3;
            }
        }
        return result;
    }
}

