/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.kernel.impl;

import com.ibm.pdp.mdl.kernel.DescriptionType;
import com.ibm.pdp.mdl.kernel.Documentation;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.ExportInfo;
import com.ibm.pdp.mdl.kernel.Field;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.Keyword;
import com.ibm.pdp.mdl.kernel.MetaEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntityExtension;
import com.ibm.pdp.mdl.kernel.impl.EntityImpl;
import com.ibm.pdp.mdl.kernel.util.IResolver;
import com.ibm.pdp.mdl.kernel.util.KernelContext;
import com.ibm.pdp.mdl.kernel.util.KernelLabel;
import com.ibm.pdp.mdl.kernel.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RadicalEntityImpl
extends EntityImpl
implements RadicalEntity {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String MODEL_VERSION_EDEFAULT = "1.00";
    protected String modelVersion = "1.00";
    protected static final String USER_INFO_EDEFAULT = "";
    protected String userInfo = "";
    protected static final String PACKAGE_EDEFAULT = "";
    protected String package_ = "";
    protected static final String NAME_EDEFAULT = "";
    protected String name = "";
    protected static final String LABEL_EDEFAULT = "";
    protected String label = "";
    protected EList<Keyword> keywords;
    protected Documentation technicalDocumentation;
    protected Documentation functionalDocumentation;
    protected Documentation userDocumentation;
    protected EList<RadicalEntityExtension> extensions;
    protected ExportInfo exportInfo;
    protected Field field;
    protected MetaEntity metaEntity;
    protected EList<DescriptionType> descriptionTypes;
    protected static final String MASTER_STATE_ID_EDEFAULT = "";
    protected String masterStateId = "";
    protected static final String ENTITY_VERSION_EDEFAULT = "";
    protected String entityVersion = "";
    private static final String _SLASH = "/";
    protected static final String _DOT = ".";
    private String _location = null;
    private String _project = null;
    private String _stateId = null;
    private boolean _eNotify = true;
    private String eClassName = null;

    protected RadicalEntityImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return KernelPackage.Literals.RADICAL_ENTITY;
    }

    @Override
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Override
    public void setModelVersion(String newModelVersion) {
        String oldModelVersion = this.modelVersion;
        this.modelVersion = newModelVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldModelVersion, (Object)this.modelVersion));
        }
    }

    @Override
    public String getUserInfo() {
        return this.userInfo;
    }

    @Override
    public void setUserInfo(String newUserInfo) {
        String oldUserInfo = this.userInfo;
        this.userInfo = newUserInfo;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldUserInfo, (Object)this.userInfo));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String newLabel) {
        String oldLabel = this.label;
        this.label = newLabel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldLabel, (Object)this.label));
        }
    }

    @Override
    public String getPackage() {
        return this.package_;
    }

    @Override
    public void setPackage(String newPackage) {
        String oldPackage = this.package_;
        this.package_ = newPackage;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldPackage, (Object)this.package_));
        }
    }

    @Override
    public EList<Keyword> getKeywords() {
        if (this.keywords == null) {
            this.keywords = new EObjectContainmentEList(Keyword.class, (InternalEObject)this, 5);
        }
        return this.keywords;
    }

    @Override
    public Documentation getTechnicalDocumentation() {
        return this.technicalDocumentation;
    }

    public NotificationChain basicSetTechnicalDocumentation(Documentation newTechnicalDocumentation, NotificationChain msgs) {
        Documentation oldTechnicalDocumentation = this.technicalDocumentation;
        this.technicalDocumentation = newTechnicalDocumentation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldTechnicalDocumentation, (Object)newTechnicalDocumentation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setTechnicalDocumentation(Documentation newTechnicalDocumentation) {
        if (newTechnicalDocumentation != this.technicalDocumentation) {
            NotificationChain msgs = null;
            if (this.technicalDocumentation != null) {
                msgs = ((InternalEObject)this.technicalDocumentation).eInverseRemove((InternalEObject)this, -7, null, msgs);
            }
            if (newTechnicalDocumentation != null) {
                msgs = ((InternalEObject)newTechnicalDocumentation).eInverseAdd((InternalEObject)this, -7, null, msgs);
            }
            if ((msgs = this.basicSetTechnicalDocumentation(newTechnicalDocumentation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)newTechnicalDocumentation, (Object)newTechnicalDocumentation));
        }
    }

    @Override
    public Documentation getFunctionalDocumentation() {
        return this.functionalDocumentation;
    }

    public NotificationChain basicSetFunctionalDocumentation(Documentation newFunctionalDocumentation, NotificationChain msgs) {
        Documentation oldFunctionalDocumentation = this.functionalDocumentation;
        this.functionalDocumentation = newFunctionalDocumentation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldFunctionalDocumentation, (Object)newFunctionalDocumentation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setFunctionalDocumentation(Documentation newFunctionalDocumentation) {
        if (newFunctionalDocumentation != this.functionalDocumentation) {
            NotificationChain msgs = null;
            if (this.functionalDocumentation != null) {
                msgs = ((InternalEObject)this.functionalDocumentation).eInverseRemove((InternalEObject)this, -8, null, msgs);
            }
            if (newFunctionalDocumentation != null) {
                msgs = ((InternalEObject)newFunctionalDocumentation).eInverseAdd((InternalEObject)this, -8, null, msgs);
            }
            if ((msgs = this.basicSetFunctionalDocumentation(newFunctionalDocumentation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newFunctionalDocumentation, (Object)newFunctionalDocumentation));
        }
    }

    @Override
    public Documentation getUserDocumentation() {
        return this.userDocumentation;
    }

    public NotificationChain basicSetUserDocumentation(Documentation newUserDocumentation, NotificationChain msgs) {
        Documentation oldUserDocumentation = this.userDocumentation;
        this.userDocumentation = newUserDocumentation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldUserDocumentation, (Object)newUserDocumentation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setUserDocumentation(Documentation newUserDocumentation) {
        if (newUserDocumentation != this.userDocumentation) {
            NotificationChain msgs = null;
            if (this.userDocumentation != null) {
                msgs = ((InternalEObject)this.userDocumentation).eInverseRemove((InternalEObject)this, -9, null, msgs);
            }
            if (newUserDocumentation != null) {
                msgs = ((InternalEObject)newUserDocumentation).eInverseAdd((InternalEObject)this, -9, null, msgs);
            }
            if ((msgs = this.basicSetUserDocumentation(newUserDocumentation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newUserDocumentation, (Object)newUserDocumentation));
        }
    }

    @Override
    public EList<RadicalEntityExtension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new EObjectContainmentEList(RadicalEntityExtension.class, (InternalEObject)this, 9);
        }
        return this.extensions;
    }

    @Override
    public ExportInfo getExportInfo() {
        return this.exportInfo;
    }

    public NotificationChain basicSetExportInfo(ExportInfo newExportInfo, NotificationChain msgs) {
        ExportInfo oldExportInfo = this.exportInfo;
        this.exportInfo = newExportInfo;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldExportInfo, (Object)newExportInfo);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setExportInfo(ExportInfo newExportInfo) {
        if (newExportInfo != this.exportInfo) {
            NotificationChain msgs = null;
            if (this.exportInfo != null) {
                msgs = ((InternalEObject)this.exportInfo).eInverseRemove((InternalEObject)this, -11, null, msgs);
            }
            if (newExportInfo != null) {
                msgs = ((InternalEObject)newExportInfo).eInverseAdd((InternalEObject)this, -11, null, msgs);
            }
            if ((msgs = this.basicSetExportInfo(newExportInfo, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)newExportInfo, (Object)newExportInfo));
        }
    }

    @Override
    public Field getField() {
        return this.field;
    }

    public NotificationChain basicSetField(Field newField, NotificationChain msgs) {
        Field oldField = this.field;
        this.field = newField;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldField, (Object)newField);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setField(Field newField) {
        if (newField != this.field) {
            NotificationChain msgs = null;
            if (this.field != null) {
                msgs = ((InternalEObject)this.field).eInverseRemove((InternalEObject)this, -12, null, msgs);
            }
            if (newField != null) {
                msgs = ((InternalEObject)newField).eInverseAdd((InternalEObject)this, -12, null, msgs);
            }
            if ((msgs = this.basicSetField(newField, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)newField, (Object)newField));
        }
    }

    @Override
    public MetaEntity getMetaEntity() {
        this.getMetaEntityGen();
        RadicalEntity resolvedObject = this.resolveReference(this.metaEntity);
        if (resolvedObject instanceof MetaEntity) {
            this.metaEntity = (MetaEntity)resolvedObject;
        }
        return this.metaEntity;
    }

    public MetaEntity getMetaEntityGen() {
        if (this.metaEntity != null && this.metaEntity.eIsProxy()) {
            InternalEObject oldMetaEntity = (InternalEObject)this.metaEntity;
            this.metaEntity = (MetaEntity)this.eResolveProxy(oldMetaEntity);
            if (this.metaEntity != oldMetaEntity && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 12, (Object)oldMetaEntity, (Object)this.metaEntity));
            }
        }
        return this.metaEntity;
    }

    public MetaEntity basicGetMetaEntity() {
        return this.metaEntity;
    }

    @Override
    public void setMetaEntity(MetaEntity newMetaEntity) {
        MetaEntity oldMetaEntity = this.metaEntity;
        this.metaEntity = newMetaEntity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldMetaEntity, (Object)this.metaEntity));
        }
    }

    @Override
    public EList<DescriptionType> getDescriptionTypes() {
        if (this.descriptionTypes == null) {
            this.descriptionTypes = new EObjectContainmentEList(DescriptionType.class, (InternalEObject)this, 13);
        }
        return this.descriptionTypes;
    }

    @Override
    public String getMasterStateId() {
        return this.masterStateId;
    }

    @Override
    public void setMasterStateId(String newMasterStateId) {
        this.masterStateId = newMasterStateId;
    }

    @Override
    public String getEntityVersion() {
        return this.entityVersion;
    }

    @Override
    public void setEntityVersion(String newEntityVersion) {
        String oldEntityVersion = this.entityVersion;
        this.entityVersion = newEntityVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldEntityVersion, (Object)this.entityVersion));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getKeywords()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return this.basicSetTechnicalDocumentation(null, msgs);
            }
            case 7: {
                return this.basicSetFunctionalDocumentation(null, msgs);
            }
            case 8: {
                return this.basicSetUserDocumentation(null, msgs);
            }
            case 9: {
                return ((InternalEList)this.getExtensions()).basicRemove((Object)otherEnd, msgs);
            }
            case 10: {
                return this.basicSetExportInfo(null, msgs);
            }
            case 11: {
                return this.basicSetField(null, msgs);
            }
            case 13: {
                return ((InternalEList)this.getDescriptionTypes()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getModelVersion();
            }
            case 1: {
                return this.getUserInfo();
            }
            case 2: {
                return this.getPackage();
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return this.getLabel();
            }
            case 5: {
                return this.getKeywords();
            }
            case 6: {
                return this.getTechnicalDocumentation();
            }
            case 7: {
                return this.getFunctionalDocumentation();
            }
            case 8: {
                return this.getUserDocumentation();
            }
            case 9: {
                return this.getExtensions();
            }
            case 10: {
                return this.getExportInfo();
            }
            case 11: {
                return this.getField();
            }
            case 12: {
                if (resolve) {
                    return this.getMetaEntity();
                }
                return this.basicGetMetaEntity();
            }
            case 13: {
                return this.getDescriptionTypes();
            }
            case 14: {
                return this.getMasterStateId();
            }
            case 15: {
                return this.getEntityVersion();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setModelVersion((String)newValue);
                return;
            }
            case 1: {
                this.setUserInfo((String)newValue);
                return;
            }
            case 2: {
                this.setPackage((String)newValue);
                return;
            }
            case 3: {
                this.setName((String)newValue);
                return;
            }
            case 4: {
                this.setLabel((String)newValue);
                return;
            }
            case 5: {
                this.getKeywords().clear();
                this.getKeywords().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setTechnicalDocumentation((Documentation)newValue);
                return;
            }
            case 7: {
                this.setFunctionalDocumentation((Documentation)newValue);
                return;
            }
            case 8: {
                this.setUserDocumentation((Documentation)newValue);
                return;
            }
            case 9: {
                this.getExtensions().clear();
                this.getExtensions().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.setExportInfo((ExportInfo)newValue);
                return;
            }
            case 11: {
                this.setField((Field)newValue);
                return;
            }
            case 12: {
                this.setMetaEntity((MetaEntity)newValue);
                return;
            }
            case 13: {
                this.getDescriptionTypes().clear();
                this.getDescriptionTypes().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.setMasterStateId((String)newValue);
                return;
            }
            case 15: {
                this.setEntityVersion((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setModelVersion(MODEL_VERSION_EDEFAULT);
                return;
            }
            case 1: {
                this.setUserInfo("");
                return;
            }
            case 2: {
                this.setPackage("");
                return;
            }
            case 3: {
                this.setName("");
                return;
            }
            case 4: {
                this.setLabel("");
                return;
            }
            case 5: {
                this.getKeywords().clear();
                return;
            }
            case 6: {
                this.setTechnicalDocumentation(null);
                return;
            }
            case 7: {
                this.setFunctionalDocumentation(null);
                return;
            }
            case 8: {
                this.setUserDocumentation(null);
                return;
            }
            case 9: {
                this.getExtensions().clear();
                return;
            }
            case 10: {
                this.setExportInfo(null);
                return;
            }
            case 11: {
                this.setField(null);
                return;
            }
            case 12: {
                this.setMetaEntity(null);
                return;
            }
            case 13: {
                this.getDescriptionTypes().clear();
                return;
            }
            case 14: {
                this.setMasterStateId("");
                return;
            }
            case 15: {
                this.setEntityVersion("");
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return MODEL_VERSION_EDEFAULT == null ? this.modelVersion != null : !MODEL_VERSION_EDEFAULT.equals(this.modelVersion);
            }
            case 1: {
                return "" == null ? this.userInfo != null : !"".equals(this.userInfo);
            }
            case 2: {
                return "" == null ? this.package_ != null : !"".equals(this.package_);
            }
            case 3: {
                return "" == null ? this.name != null : !"".equals(this.name);
            }
            case 4: {
                return "" == null ? this.label != null : !"".equals(this.label);
            }
            case 5: {
                return this.keywords != null && !this.keywords.isEmpty();
            }
            case 6: {
                return this.technicalDocumentation != null;
            }
            case 7: {
                return this.functionalDocumentation != null;
            }
            case 8: {
                return this.userDocumentation != null;
            }
            case 9: {
                return this.extensions != null && !this.extensions.isEmpty();
            }
            case 10: {
                return this.exportInfo != null;
            }
            case 11: {
                return this.field != null;
            }
            case 12: {
                return this.metaEntity != null;
            }
            case 13: {
                return this.descriptionTypes != null && !this.descriptionTypes.isEmpty();
            }
            case 14: {
                return "" == null ? this.masterStateId != null : !"".equals(this.masterStateId);
            }
            case 15: {
                return "" == null ? this.entityVersion != null : !"".equals(this.entityVersion);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (!this.eIsProxy()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("project: ");
            buffer.append(this.getProject());
            buffer.append(", package: ");
            buffer.append(this.package_);
            buffer.append(", name: ");
            buffer.append(this.name);
            buffer.append(", label: ");
            buffer.append(this.label);
            buffer.append(", masterStateId: ");
            buffer.append(this.masterStateId);
            buffer.append(", entityVersion: ");
            buffer.append(this.entityVersion);
            return buffer.toString();
        }
        return this.getProxyURI().toString();
    }

    @Override
    public IFile getFile(List<String> paths) {
        if (paths == null) {
            paths = new ArrayList<String>();
            paths.add(this.getProject());
        }
        for (String projectName : paths) {
            IPath path = this.getPath(projectName);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (!(resource instanceof IFile) || !resource.isAccessible()) continue;
            return (IFile)resource;
        }
        return null;
    }

    @Override
    public boolean isResolved(List<String> paths) {
        IResolver resolver;
        if (this.eResource() != null && this.eResource().getResourceSet() instanceof IResolver && (resolver = (IResolver)this.eResource().getResourceSet()).isTransient()) {
            return true;
        }
        return this.getFile(paths) != null;
    }

    @Override
    public String getLocation() {
        if (this._location == null) {
            this._location = "";
        }
        return this._location;
    }

    @Override
    public void setLocation(String location) {
        this._location = location;
    }

    @Override
    public String getProject() {
        if (this._project == null) {
            this._project = "";
        }
        return this._project;
    }

    @Override
    public void setProject(String project) {
        this._project = project;
    }

    @Override
    public URI getProxyURI() {
        return this.eProxyURI();
    }

    @Override
    public void setProxyURI(URI uri) {
        this.eSetProxyURI(uri);
    }

    @Override
    public String getProxyName() {
        String proxyName = this.getName();
        if (proxyName == null || proxyName.length() == 0) {
            try {
                proxyName = URI.decode((String)this.eProxyURI().lastSegment());
                int endIndex = proxyName.indexOf(46, 1);
                proxyName = proxyName.substring(0, endIndex);
            }
            catch (Exception exception) {
                Object[] array = new String[]{"null"};
                if (this.eProxyURI() != null) {
                    array = new String[]{this.eProxyURI().toString()};
                }
                String label = KernelLabel.getString(KernelLabel._MALFORMED_URL, array);
                throw new RuntimeException(label);
            }
        }
        return proxyName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public URI getDesignURI() {
        StringBuilder buffer = new StringBuilder("design:");
        if (this.eIsProxy()) {
            URI proxyURI = this.eProxyURI();
            if (proxyURI.segmentCount() <= 0) return proxyURI;
            int i = 0;
            while (i < proxyURI.segmentCount()) {
                String decoded = URI.decode((String)proxyURI.segment(i));
                buffer.append(_SLASH).append(decoded);
                ++i;
            }
        } else {
            if (this.getPackage() != null && this.getPackage().length() > 0) {
                buffer.append(_SLASH);
                int i = 0;
                while (i < this.getPackage().length()) {
                    char c = this.getPackage().charAt(i);
                    if (c == '.') {
                        buffer.append('/');
                    } else {
                        buffer.append(c);
                    }
                    ++i;
                }
            }
            buffer.append(_SLASH).append(this.getIdentifier());
        }
        String encoded = URI.encodeFragment((String)buffer.toString(), (boolean)false);
        return URI.createURI((String)(String.valueOf(encoded) + "#/"), (boolean)true, (int)1);
    }

    @Override
    public IPath getPath(String projectName) {
        StringBuilder uriBuffer = new StringBuilder(_SLASH);
        uriBuffer.append(projectName).append(_SLASH);
        String designFolder = KernelContext.getProjectDescriptor().getDesignFolder(projectName);
        if (designFolder != null && designFolder.length() > 0) {
            uriBuffer.append(designFolder);
        }
        if (this.eIsProxy()) {
            URI proxyURI = this.eProxyURI();
            int i = 0;
            while (i < proxyURI.segmentCount()) {
                String decoded = URI.decode((String)proxyURI.segment(i));
                uriBuffer.append(_SLASH).append(decoded);
                ++i;
            }
        } else {
            if (this.getPackage() != null && this.getPackage().length() > 0) {
                uriBuffer.append(_SLASH).append(this.getPackage().replace('.', '/'));
            }
            uriBuffer.append(_SLASH).append(this.getIdentifier());
        }
        return new Path(uriBuffer.toString());
    }

    @Override
    public String getIdentifier() {
        StringBuilder buffer = new StringBuilder("");
        if (this.eIsProxy()) {
            buffer.append(this.getProxyName());
        } else {
            buffer.append(this.getName());
        }
        buffer.append(_DOT).append(this.getEClassName());
        return buffer.toString();
    }

    private String getEClassName() {
        if (this.eClassName == null) {
            this.eClassName = this.eClass().getName().toLowerCase().intern();
        }
        return this.eClassName;
    }

    @Override
    public String getDesignId(String projectName) {
        StringBuilder uriBuffer = new StringBuilder(_SLASH);
        uriBuffer.append(projectName);
        if (this.eIsProxy()) {
            URI proxyURI = this.eProxyURI();
            int i = 0;
            while (i < proxyURI.segmentCount()) {
                String decoded = URI.decode((String)proxyURI.segment(i));
                uriBuffer.append(_SLASH).append(decoded);
                ++i;
            }
        } else {
            if (this.getPackage() != null && this.getPackage().length() > 0) {
                uriBuffer.append(_SLASH).append(this.getPackage().replace('.', '/'));
            }
            uriBuffer.append(_SLASH).append(this.getIdentifier());
        }
        return uriBuffer.toString().intern();
    }

    @Override
    public Map _getSolidRelations() {
        RadicalEntity[] array;
        Map calledInstances = super._getSolidRelations();
        URI designURI = this.getDesignURI();
        RadicalEntity[] radicalEntityArray = array = calledInstances.keySet().toArray(new RadicalEntity[0]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            RadicalEntity radicalObject = radicalEntityArray[n2];
            if (radicalObject.getDesignURI().equals(designURI)) {
                calledInstances.remove(radicalObject);
                break;
            }
            ++n2;
        }
        return calledInstances;
    }

    @Override
    public Set<RadicalEntity> getCalledProxies() {
        RadicalEntity[] array;
        Set<RadicalEntity> calledProxies = super.getCalledProxies();
        URI designURI = this.getDesignURI();
        RadicalEntity[] radicalEntityArray = array = calledProxies.toArray(new RadicalEntity[0]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            RadicalEntity radicalObject = radicalEntityArray[n2];
            if (radicalObject.getDesignURI().equals(designURI)) {
                calledProxies.remove(radicalObject);
                break;
            }
            ++n2;
        }
        return calledProxies;
    }

    @Override
    public int findMaxProblemSeverity(String type, boolean includeSubtypes, int depth) {
        if (this.getFile(null) != null) {
            try {
                return this.getFile(null).findMaxProblemSeverity(type, includeSubtypes, depth);
            }
            catch (CoreException coreException) {}
        }
        return -1;
    }

    @Override
    public void save() throws IOException {
        Resource nativeResource = this.eResource();
        this.buildSerializationContext();
        this.eResource().save(this.getOptions());
        if (nativeResource != null) {
            nativeResource.getContents().add((Object)this);
        }
    }

    @Override
    public String getStateId() {
        if (this._stateId == null || this._stateId.length() == 0) {
            Resource nativeResource = this.eResource();
            String masterStateId = this.getMasterStateId();
            this.setMasterStateId("");
            this.buildSerializationContext();
            try {
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    this.eResource().save((OutputStream)outputStream, this.getOptions());
                    String contents = new String(outputStream.toByteArray());
                    if (Util.IS_UNIX_OS && contents.indexOf(13) < 0) {
                        contents = contents.replace("\n", "\r\n");
                    }
                    Integer hashCode = new Integer(contents.trim().hashCode());
                    this._stateId = hashCode.toString();
                }
                catch (IOException iOException) {
                    this.setMasterStateId(masterStateId);
                    if (nativeResource != null) {
                        nativeResource.getContents().add((Object)this);
                    }
                }
            }
            finally {
                this.setMasterStateId(masterStateId);
                if (nativeResource != null) {
                    nativeResource.getContents().add((Object)this);
                }
            }
        }
        return this._stateId;
    }

    public void resetStateId() {
        this._stateId = null;
    }

    private Map<Object, Object> getOptions() {
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("SKIP_ESCAPE_URI", Boolean.FALSE);
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if ("UTF-8".equals(root.getDefaultCharset())) {
                options.put("ENCODING", "UTF-8");
            }
        }
        catch (CoreException coreException) {}
        return options;
    }

    private void buildSerializationContext() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        IPath path = this.getPath(this.getProject());
        URI uri = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)this);
    }

    @Override
    public void enableENotification(boolean eNotify) {
        this._eNotify = eNotify;
    }

    @Override
    public boolean eNotificationRequired() {
        return this._eNotify;
    }

    @Override
    public void eNotify(Notification notification) {
        if (this._eNotify) {
            this._stateId = null;
            super.eNotify(notification);
        }
    }

    @Override
    public boolean isSame(Entity eObject) {
        boolean isSame = false;
        if (eObject instanceof RadicalEntity) {
            RadicalEntity inputObject = (RadicalEntity)eObject;
            URI uri = this.getDesignURI();
            URI inputUri = inputObject.getDesignURI();
            isSame = uri.equals(inputUri);
        }
        return isSame;
    }

    @Override
    public int isSameHashCode() {
        int hashCode = this.eClass().getName().hashCode();
        return hashCode += this.getDesignURI().hashCode();
    }

    @Override
    public String getGenStateId(Map<String, List<String>> patternExceptions) {
        if (patternExceptions == null) {
            return null;
        }
        String result = this.getGenStateContent(patternExceptions);
        return "" + result.trim().hashCode();
    }

    public boolean renameFreeReferences(String type, String oldName, String newName) {
        return this.renameFreeReferences(this.eClass().getName(), type, oldName, newName, null);
    }

    public List<String> getChangedArtifactIdsIfRename(String type, String oldName, String newName) {
        ArrayList<String> changedArtifactIds = new ArrayList<String>();
        this.renameFreeReferences(this.eClass().getName(), type, oldName, newName, changedArtifactIds);
        return changedArtifactIds;
    }
}

