/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.kernel.impl;

import com.ibm.pdp.mdl.kernel.AbstractValue;
import com.ibm.pdp.mdl.kernel.AggregateValue;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.MetaEntity;
import com.ibm.pdp.mdl.kernel.MultipleValue;
import com.ibm.pdp.mdl.kernel.SimpleType;
import com.ibm.pdp.mdl.kernel.impl.AbstractValueImpl;
import com.ibm.pdp.mdl.kernel.util.AggregateValueComparator;
import com.ibm.pdp.mdl.kernel.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleValueImpl
extends AbstractValueImpl
implements MultipleValue {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected EList<AbstractValue> values;

    protected MultipleValueImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return KernelPackage.Literals.MULTIPLE_VALUE;
    }

    @Override
    public EList<AbstractValue> getValues() {
        if (this.values == null) {
            this.values = new EObjectContainmentEList(AbstractValue.class, (InternalEObject)this, 0);
        }
        return this.values;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getValues()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getValues();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getValues().clear();
                this.getValues().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getValues().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.values != null && !this.values.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    protected boolean isValidValueForSimpleType(SimpleType simpleType) {
        return true;
    }

    @Override
    protected EClass getRequiredSimpleTypeClass() {
        return null;
    }

    @Override
    public List<AbstractValue> getSortedValues() {
        ArrayList<AbstractValue> sortedValues = new ArrayList<AbstractValue>();
        if (this.getOwner() == null || this.getValues().size() == 0 || !(this.getValues().get(0) instanceof AggregateValue)) {
            sortedValues.addAll((Collection<AbstractValue>)this.getValues());
            return sortedValues;
        }
        MetaEntity metaEntity = this.getMetaEntity();
        URI proxyURI = metaEntity.getProxyURI();
        if (proxyURI != null) {
            sortedValues.addAll((Collection<AbstractValue>)this.getValues());
            return sortedValues;
        }
        DataCall dataCall = Util.getDataCall(metaEntity, this, null);
        if (dataCall != null && dataCall.getSort() != null && dataCall.getSort().getComparator() != null && !dataCall.getSort().getComparator().getCalls().isEmpty()) {
            AggregateValueComparator comparator = new AggregateValueComparator(dataCall.getSort());
            sortedValues.addAll((Collection<AbstractValue>)this.getValues());
            Collections.sort(sortedValues, comparator);
            return sortedValues;
        }
        sortedValues.addAll((Collection<AbstractValue>)this.getValues());
        return sortedValues;
    }
}

