/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.kernel.impl;

import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.Field;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.RadicalEntityImpl;
import com.ibm.pdp.mdl.kernel.util.IResolver;
import com.ibm.pdp.mdl.kernel.util.Marker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityImpl
extends EObjectImpl
implements Entity {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final MethodSecurityManager securityManager = new MethodSecurityManager();

    protected EntityImpl() {
    }

    protected EClass eStaticClass() {
        return KernelPackage.Literals.ENTITY;
    }

    protected RadicalEntity resolveReference(RadicalEntity radicalObject) {
        RadicalEntity owner = this.getOwner();
        if (owner != null && radicalObject != null) {
            if (owner.getDesignURI().equals(radicalObject.getDesignURI())) {
                radicalObject = owner;
            } else {
                ResourceSet resourceSet;
                radicalObject.setLocation(this.getLocation());
                if (radicalObject.eResource() != null && (resourceSet = radicalObject.eResource().getResourceSet()) instanceof IResolver) {
                    IResolver resolver = (IResolver)resourceSet;
                    radicalObject = resolver.resolveReference(owner, radicalObject);
                }
            }
        }
        return radicalObject;
    }

    public boolean eNotificationRequired() {
        RadicalEntityImpl owner;
        if (!(this instanceof RadicalEntity) && (owner = (RadicalEntityImpl)this.getOwner()) != null) {
            return owner.eNotificationRequired();
        }
        return super.eNotificationRequired();
    }

    public void eNotify(Notification notification) {
        RadicalEntity owner;
        if (!(this instanceof RadicalEntity) && (owner = this.getOwner()) != null && owner.eDeliver()) {
            RadicalEntity oldObject;
            boolean notify = true;
            if (notification.getOldValue() instanceof RadicalEntity && notification.getNewValue() instanceof RadicalEntity && (oldObject = (RadicalEntity)notification.getOldValue()).eIsProxy()) {
                notify = false;
            }
            if (notify) {
                owner.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, notification.getOldValue(), notification.getNewValue()));
            }
            return;
        }
        super.eNotify(notification);
    }

    private IResource getMarkerResource() {
        RadicalEntity owner = this.getOwner();
        if (owner != null) {
            return owner.getFile(null);
        }
        return null;
    }

    @Override
    public void addMarker(EStructuralFeature feature, String type, String message, int severity, int priority) {
        try {
            IResource markerResource = this.getMarkerResource();
            if (markerResource != null) {
                IMarker marker = this.getMarkerResource().createMarker(type);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", severity);
                marker.setAttribute("priority", priority);
                marker.setAttribute("location", (Object)feature.getName());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addMarker(EStructuralFeature feature, String type, String message, int severity, int priority, int start, int end, int lineNb) {
        try {
            IResource markerResource = this.getMarkerResource();
            if (markerResource != null) {
                IMarker marker = this.getMarkerResource().createMarker(type);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", severity);
                marker.setAttribute("priority", priority);
                marker.setAttribute("FEATURE", (Object)feature.getName());
                marker.setAttribute("charStart", start);
                marker.setAttribute("charEnd", end);
                marker.setAttribute("lineNumber", lineNb);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected int checkFreeRelation(RadicalEntity calledObject, EStructuralFeature eFeature, boolean markResource, List<String> paths, List<Marker> markers) {
        return -1;
    }

    @Override
    public RadicalEntity getOwner() {
        RadicalEntity owner = null;
        EObject parent = this.eContainer();
        while (parent != null && !(parent instanceof RadicalEntity)) {
            parent = parent.eContainer();
        }
        if (this instanceof RadicalEntity) {
            owner = (RadicalEntity)((Object)this);
        } else if (parent instanceof RadicalEntity) {
            owner = (RadicalEntity)parent;
        }
        return owner;
    }

    @Override
    public String getLocation() {
        return this.getOwner().getLocation();
    }

    @Override
    public final Map<RadicalEntity, List<String>> getSolidRelations() {
        return this._getSolidRelations();
    }

    protected Map _getSolidRelations() {
        HashMap solidRelations = new HashMap();
        HashMap uris = new HashMap();
        this._getSolidRelations(this.eClass().getName(), solidRelations, uris);
        return solidRelations;
    }

    protected void _getSolidRelations(String nodePath, Map solidRelations, Map uris) {
        EList eReferences = this.eClass().getEAllReferences();
        for (EReference eReference : eReferences) {
            int size;
            int i;
            List eObjects;
            KernelPackage kernelPackage;
            if (eReference.isVolatile() || eReference.isTransient() || eReference == (kernelPackage = KernelPackage.eINSTANCE).getRadicalEntity_FunctionalDocumentation() || eReference == kernelPackage.getRadicalEntity_TechnicalDocumentation() || eReference == kernelPackage.getRadicalEntity_UserDocumentation() || eReference == kernelPackage.getRadicalEntity_Keywords() || eReference == kernelPackage.getRadicalEntity_ExportInfo()) continue;
            Object eObject = this.eGet((EStructuralFeature)eReference);
            if (eReference.isContainment()) {
                if (eObject instanceof Entity) {
                    StringBuilder buffer = new StringBuilder(nodePath);
                    buffer.append("(").append(eReference.getName()).append(")");
                    buffer.append("/").append(((Entity)eObject).eClass().getName());
                    if (eObject instanceof Field) {
                        buffer.append("=").append(((Field)eObject).getName());
                    }
                    ((EntityImpl)eObject)._getSolidRelations(buffer.toString(), solidRelations, uris);
                    continue;
                }
                if (!(eObject instanceof List)) continue;
                eObjects = (List)eObject;
                i = 0;
                size = eObjects.size();
                while (i < size) {
                    eObject = eObjects.get(i);
                    if (eObject instanceof Entity) {
                        StringBuilder buffer = new StringBuilder(nodePath);
                        buffer.append("(").append(eReference.getName()).append("[])");
                        buffer.append("/").append(((Entity)eObject).eClass().getName());
                        if (eObject instanceof Field) {
                            buffer.append("=").append(((Field)eObject).getName());
                        }
                        ((EntityImpl)eObject)._getSolidRelations(buffer.toString(), solidRelations, uris);
                    }
                    ++i;
                }
                continue;
            }
            if (eObject instanceof RadicalEntity) {
                EntityImpl.registerRelation(nodePath, eReference.getName(), (RadicalEntity)eObject, solidRelations, uris);
                continue;
            }
            if (!(eObject instanceof List)) continue;
            eObjects = (List)eObject;
            i = 0;
            size = eObjects.size();
            while (i < size) {
                eObject = eObjects.get(i);
                if (eObject instanceof RadicalEntity) {
                    EntityImpl.registerRelation(nodePath, eReference.getName(), (RadicalEntity)eObject, solidRelations, uris);
                }
                ++i;
            }
        }
    }

    @Override
    public Map<RadicalEntity, List<String>> getFreeRelations() {
        Map freeRelations = this._getFreeRelations();
        HashMap<RadicalEntity, List<String>> compactedFreeRelations = new HashMap<RadicalEntity, List<String>>();
        HashMap<String, RadicalEntity> calledInstances = new HashMap<String, RadicalEntity>();
        for (Map.Entry entry : freeRelations.entrySet()) {
            ArrayList relations;
            String identifier = ((RadicalEntity)entry.getKey()).getIdentifier();
            RadicalEntity calledInstance = (RadicalEntity)calledInstances.get(identifier);
            if (calledInstance == null) {
                calledInstances.put(identifier, (RadicalEntity)entry.getKey());
                relations = new ArrayList((Collection)entry.getValue());
                compactedFreeRelations.put((RadicalEntity)entry.getKey(), relations);
                continue;
            }
            relations = (ArrayList)compactedFreeRelations.get(calledInstance);
            relations.addAll((Collection)entry.getValue());
        }
        return compactedFreeRelations;
    }

    protected Map _getFreeRelations() {
        HashMap freeRelations = new HashMap();
        this._getFreeRelations(this.eClass().getName(), freeRelations);
        return freeRelations;
    }

    protected void _getFreeRelations(String nodePath, Map freeRelations) {
        EList eReferences = this.eClass().getEAllReferences();
        for (EReference eReference : eReferences) {
            KernelPackage kernelPackage;
            if (eReference.isVolatile() || eReference.isTransient() || eReference == (kernelPackage = KernelPackage.eINSTANCE).getRadicalEntity_FunctionalDocumentation() || eReference == kernelPackage.getRadicalEntity_TechnicalDocumentation() || eReference == kernelPackage.getRadicalEntity_UserDocumentation() || eReference == kernelPackage.getRadicalEntity_Keywords() || eReference == kernelPackage.getRadicalEntity_ExportInfo()) continue;
            Object eObject = this.eGet((EStructuralFeature)eReference);
            if (!eReference.isContainment()) continue;
            if (eObject instanceof Entity) {
                StringBuilder buffer = new StringBuilder(nodePath);
                buffer.append("(").append(eReference.getName()).append(")");
                buffer.append("/").append(((Entity)eObject).eClass().getName());
                if (eObject instanceof Field) {
                    buffer.append("=").append(((Field)eObject).getName());
                }
                ((EntityImpl)eObject)._getFreeRelations(buffer.toString(), freeRelations);
                continue;
            }
            if (!(eObject instanceof List)) continue;
            List eObjects = (List)eObject;
            int i = 0;
            int size = eObjects.size();
            while (i < size) {
                eObject = eObjects.get(i);
                if (eObject instanceof Entity) {
                    StringBuilder buffer = new StringBuilder(nodePath);
                    buffer.append("(").append(eReference.getName()).append("[])");
                    buffer.append("/").append(((Entity)eObject).eClass().getName());
                    if (eObject instanceof Field) {
                        buffer.append("=").append(((Field)eObject).getName());
                    }
                    ((EntityImpl)eObject)._getFreeRelations(buffer.toString(), freeRelations);
                }
                ++i;
            }
        }
    }

    @Override
    public Set<RadicalEntity> getCalledProxies() {
        HashMap calledProxies = new HashMap();
        this._getSolidRelations(this.eClass().getName(), calledProxies, null);
        return calledProxies.keySet();
    }

    protected static void registerRelation(String nodePath, String relationName, RadicalEntity targetObject, Map<RadicalEntity, List<String>> allRelations, Map<URI, RadicalEntity> uris) {
        List<String> relations;
        if (uris != null && targetObject.eIsProxy()) {
            URI proxyURI = targetObject.getProxyURI();
            RadicalEntity calledProxy = uris.get(proxyURI);
            if (calledProxy == null) {
                uris.put(proxyURI, targetObject);
            } else {
                targetObject = calledProxy;
            }
        }
        if ((relations = allRelations.get(targetObject)) == null) {
            relations = new ArrayList<String>();
            allRelations.put(targetObject, relations);
        }
        StringBuilder buffer = new StringBuilder(nodePath);
        buffer.append('#').append(relationName);
        relations.add(buffer.toString());
    }

    @Override
    public boolean isDefault() {
        EList features = this.eClass().getEAllStructuralFeatures();
        int i = 0;
        while (i < features.size()) {
            EStructuralFeature eFeature = (EStructuralFeature)features.get(i);
            Object defaultValue = eFeature.getDefaultValue();
            Object currentValue = this.eGet(eFeature);
            if (!(currentValue instanceof List && ((List)currentValue).size() == 0 || currentValue == null || currentValue.equals(defaultValue))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isSame(Entity eObject) {
        boolean isSame = false;
        if (this.eClass() == eObject.eClass()) {
            isSame = true;
        }
        return isSame;
    }

    @Override
    public int isSameHashCode() {
        int hashCode = this.eClass().getName().hashCode();
        return hashCode;
    }

    protected boolean isSameGeneric(Entity eOtherObject, boolean isRecursive) {
        if (eOtherObject.getClass() == this.getClass()) {
            for (EAttribute eAttribute : this.eClass().getEAllAttributes()) {
                if (!this.isSameIdentifierFeature((EStructuralFeature)eAttribute)) continue;
                Object eAttr = this.eGet((EStructuralFeature)eAttribute);
                Object eOtherAttr = eOtherObject.eGet((EStructuralFeature)eAttribute);
                if (eAttr == null && eOtherAttr == null) continue;
                if (eAttr == null || eOtherAttr == null) {
                    return false;
                }
                if (eAttr.equals(eOtherAttr)) continue;
                return false;
            }
            if (isRecursive) {
                for (EReference eReference : this.eClass().getEAllReferences()) {
                    Entity eOtherEntity;
                    if (!Entity.class.isAssignableFrom(eReference.getContainerClass()) || !this.isSameIdentifierFeature((EStructuralFeature)eReference)) continue;
                    if (eReference.isMany()) {
                        List entities = (List)this.eGet((EStructuralFeature)eReference);
                        List otherEntities = (List)this.eGet((EStructuralFeature)eReference);
                        if (entities.size() != otherEntities.size()) {
                            return false;
                        }
                        int i = 0;
                        while (i < entities.size()) {
                            if (!((Entity)entities.get(i)).isSame((Entity)otherEntities.get(i))) {
                                return false;
                            }
                            ++i;
                        }
                        continue;
                    }
                    Entity eEntity = (Entity)this.eGet((EStructuralFeature)eReference);
                    if (eEntity.isSame(eOtherEntity = (Entity)eOtherObject.eGet((EStructuralFeature)eReference))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected int isSameHashCodeGeneric(boolean isRecursive) {
        int hashCode = this.eClass().getName().hashCode();
        if (isRecursive) {
            for (EReference eReference : this.eClass().getEAllReferences()) {
                if (!this.isSameIdentifierFeature((EStructuralFeature)eReference) || !Entity.class.isAssignableFrom(eReference.getContainerClass())) continue;
                hashCode += eReference.getEGenericType().getEClassifier().getName().hashCode();
            }
        }
        return hashCode;
    }

    protected boolean isSameIdentifierFeature(EStructuralFeature feature) {
        return false;
    }

    public String toString() {
        return "";
    }

    public boolean isLoadingInstance() {
        return securityManager.isCallerClassPresent(XMLHelperImpl.class);
    }

    String getGenStateContent(Map<String, List<String>> patternExceptions) {
        EClass eClass = this.eClass();
        EList eStructuralFeatures = eClass.getEAllStructuralFeatures();
        String className = eClass.getName();
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(className) + '[');
        boolean firstAttibuteDone = false;
        List<String> attributeExceptions = null;
        if (patternExceptions != null) {
            attributeExceptions = patternExceptions.get(className);
        }
        for (EStructuralFeature eStructuralFeature : eStructuralFeatures) {
            if (eStructuralFeature.isVolatile() || eStructuralFeature.isTransient() || attributeExceptions != null && attributeExceptions.contains(eStructuralFeature.getName())) continue;
            Object eObject = this.eGet(eStructuralFeature);
            if (eStructuralFeature instanceof EAttribute) {
                if (firstAttibuteDone) {
                    sb.append(",");
                }
                if (eObject != null) {
                    sb.append(eObject.toString());
                }
                firstAttibuteDone = true;
            }
            if (!(eStructuralFeature instanceof EReference)) continue;
            EReference eReference = (EReference)eStructuralFeature;
            if (eReference.isContainment()) {
                if (eObject instanceof Entity) {
                    String s = ((EntityImpl)eObject).getGenStateContent(patternExceptions);
                    if (firstAttibuteDone) {
                        sb.append(",");
                    }
                    sb.append(s);
                    continue;
                }
                if (!(eObject instanceof List)) continue;
                List eObjects = (List)eObject;
                int i = 0;
                int size = eObjects.size();
                while (i < size) {
                    eObject = eObjects.get(i);
                    if (eObject instanceof Entity) {
                        String s = ((EntityImpl)eObject).getGenStateContent(patternExceptions);
                        if (firstAttibuteDone) {
                            sb.append(",");
                        }
                        sb.append(s);
                    }
                    ++i;
                }
                continue;
            }
            if (firstAttibuteDone) {
                sb.append(",");
            }
            if (eObject != null) {
                if (eObject instanceof RadicalEntity) {
                    sb.append(((RadicalEntity)eObject).getDesignURI());
                } else {
                    sb.append(eObject.toString());
                }
            }
            firstAttibuteDone = true;
        }
        sb.append("]");
        return sb.toString();
    }

    protected boolean renameFreeReferences(String nodePath, String type, String oldName, String newName, List<String> changedArtifactIds) {
        boolean result = false;
        EList eReferences = this.eClass().getEAllReferences();
        for (EReference eReference : eReferences) {
            KernelPackage kernelPackage;
            if (eReference.isVolatile() || eReference.isTransient() || eReference == (kernelPackage = KernelPackage.eINSTANCE).getRadicalEntity_FunctionalDocumentation() || eReference == kernelPackage.getRadicalEntity_TechnicalDocumentation() || eReference == kernelPackage.getRadicalEntity_UserDocumentation() || eReference == kernelPackage.getRadicalEntity_Keywords() || eReference == kernelPackage.getRadicalEntity_ExportInfo()) continue;
            Object eObject = this.eGet((EStructuralFeature)eReference);
            if (!eReference.isContainment()) continue;
            if (eObject instanceof Entity) {
                boolean subResult;
                StringBuilder buffer = new StringBuilder(nodePath);
                buffer.append("(").append(eReference.getName()).append(")");
                buffer.append("/").append(((Entity)eObject).eClass().getName());
                if (eObject instanceof Field) {
                    buffer.append("=").append(((Field)eObject).getName());
                }
                if (!(subResult = ((EntityImpl)eObject).renameFreeReferences(buffer.toString(), type, oldName, newName, changedArtifactIds))) continue;
                result = true;
                continue;
            }
            if (!(eObject instanceof List)) continue;
            List eObjects = (List)eObject;
            int i = 0;
            int size = eObjects.size();
            while (i < size) {
                eObject = eObjects.get(i);
                if (eObject instanceof Entity) {
                    boolean subResult;
                    StringBuilder buffer = new StringBuilder(nodePath);
                    buffer.append("(").append(eReference.getName()).append("[])");
                    buffer.append("/").append(((Entity)eObject).eClass().getName());
                    if (eObject instanceof Field) {
                        buffer.append("=").append(((Field)eObject).getName());
                    }
                    if (subResult = ((EntityImpl)eObject).renameFreeReferences(buffer.toString(), type, oldName, newName, changedArtifactIds)) {
                        result = true;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MethodSecurityManager
    extends SecurityManager {
        MethodSecurityManager() {
        }

        public boolean isCallerClassPresent(Class<?> aClass) {
            Class<?>[] classArray = this.getClassContext();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> current = classArray[n2];
                if (current == aClass) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

