/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.kernel.impl;

import com.ibm.pdp.mdl.kernel.AggregateValue;
import com.ibm.pdp.mdl.kernel.DataAggregateDescription;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataDescription;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.Field;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.MetaEntity;
import com.ibm.pdp.mdl.kernel.impl.AbstractValueImpl;
import com.ibm.pdp.mdl.kernel.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateValueImpl
extends AbstractValueImpl
implements AggregateValue {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected EList<Field> fields;

    protected AggregateValueImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return KernelPackage.Literals.AGGREGATE_VALUE;
    }

    @Override
    public EList<Field> getFields() {
        if (this.fields == null) {
            this.fields = new EObjectContainmentEList(Field.class, (InternalEObject)this, 0);
        }
        return this.fields;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getFields()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getFields();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getFields().clear();
                this.getFields().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getFields().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.fields != null && !this.fields.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Field getField(String fieldName) {
        for (Object object : this.getFields()) {
            Field field = (Field)object;
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    @Override
    protected EClass getRequiredSimpleTypeClass() {
        return null;
    }

    @Override
    public List<Field> getSortedFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        MetaEntity metaEntity = this.getMetaEntity();
        if (metaEntity == null) {
            fields.addAll((Collection<Field>)this.getFields());
            return fields;
        }
        URI proxyURI = metaEntity.getProxyURI();
        if (proxyURI != null) {
            fields.addAll((Collection<Field>)this.getFields());
            return fields;
        }
        DataDescription dataDescription = Util.getDataDescription(metaEntity, this, null);
        if (!(dataDescription instanceof DataAggregateDescription)) {
            fields.addAll((Collection<Field>)this.getFields());
            return fields;
        }
        DataAggregateDescription aggregateDescription = (DataAggregateDescription)dataDescription;
        int size = aggregateDescription.getComponents().size();
        int i = 0;
        while (i < size) {
            DataCall dataCall = (DataCall)aggregateDescription.getComponents().get(i);
            if (dataCall != null) {
                String fieldName = null;
                if (dataCall.getDataDefinition() != null) {
                    fieldName = dataCall.getDataDefinition().getProxyName();
                } else if (dataCall.getDataDescription() != null) {
                    fieldName = dataCall.getDataDescription().getName();
                }
                Field field = this.getField(fieldName);
                if (field != null) {
                    fields.add(field);
                }
            }
            ++i;
        }
        for (Object object : this.getFields()) {
            if (fields.contains(object)) continue;
            fields.add((Field)object);
        }
        return fields;
    }

    @Override
    public boolean isSame(Entity eObject) {
        if (eObject instanceof AggregateValue) {
            AggregateValue aggregateValue = (AggregateValue)eObject;
            if (aggregateValue.getFields().size() != this.getFields().size()) {
                return false;
            }
            int i = 0;
            while (i < this.getFields().size()) {
                Field field2;
                Field field1 = (Field)this.getFields().get(i);
                if (!field1.isSame(field2 = (Field)aggregateValue.getFields().get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public int isSameHashCode() {
        int hashCode = this.eClass().getName().hashCode();
        int i = 0;
        while (i < this.getFields().size()) {
            Field field1 = (Field)this.getFields().get(i);
            hashCode += field1.isSameHashCode();
            ++i;
        }
        return hashCode;
    }
}

