/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.compare.change.edit;

import com.ibm.pdp.mdl.compare.PTChangeLabel;
import com.ibm.pdp.mdl.compare.PTCompareModelPlugin;
import com.ibm.pdp.mdl.compare.change.AttributeChange;
import com.ibm.pdp.mdl.compare.change.ChangeElement;
import com.ibm.pdp.mdl.compare.change.ChangeGroup;
import com.ibm.pdp.mdl.compare.change.ConflictAttributeChange;
import com.ibm.pdp.mdl.compare.change.ConflictChange;
import com.ibm.pdp.mdl.compare.change.ConflictReferenceChange;
import com.ibm.pdp.mdl.compare.change.FeatureChange;
import com.ibm.pdp.mdl.compare.change.LeftPending;
import com.ibm.pdp.mdl.compare.change.ReferenceChange;
import com.ibm.pdp.mdl.compare.change.RightPending;
import com.ibm.pdp.mdl.compare.change.edit.ChangeDecorator;
import com.ibm.pdp.mdl.kernel.label.PTLabelFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ChangeItemLabelProvider
extends LabelProvider {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String _NULL = "'null'";
    private ChangeDecorator _decorator = ChangeDecorator.getInstance();

    public Image getImage(Object object) {
        PTCompareModelPlugin plugin = PTCompareModelPlugin.getDefault();
        Image image = plugin.getImage("unknown");
        if (object instanceof ChangeElement) {
            ChangeElement change = (ChangeElement)object;
            if (!change.isConflicting()) {
                if (change instanceof FeatureChange) {
                    EAttribute eFeature = null;
                    if (change instanceof AttributeChange) {
                        image = plugin.getImage("attributeDelta");
                        eFeature = ((AttributeChange)change).getAttribute();
                    } else if (change instanceof ReferenceChange) {
                        image = plugin.getImage("referenceDelta");
                        eFeature = ((ReferenceChange)change).getReference();
                    }
                    if (PTLabelFactory.isLockedFeature(eFeature)) {
                        int quadrant = 1;
                        String overlayKey = "lock_ovr";
                        image = this._decorator.decorateImage(image, overlayKey, quadrant);
                    }
                } else if (change instanceof LeftPending) {
                    image = plugin.getImage("addDelta");
                } else if (change instanceof RightPending) {
                    image = plugin.getImage("removeDelta");
                } else if (change instanceof ChangeGroup) {
                    image = plugin.getImage("deltaGroup");
                }
            } else if (change instanceof FeatureChange) {
                image = plugin.getImage("conflictDelta");
            } else if (change instanceof ChangeGroup) {
                image = plugin.getImage("deltaGroup");
                int quadrant = 3;
                String overlayKey = "conflict_ovr";
                image = this._decorator.decorateImage(image, overlayKey, quadrant);
            }
        }
        return image;
    }

    public String getText(Object object) {
        String label = "Unknown";
        if (object instanceof FeatureChange) {
            FeatureChange change = (FeatureChange)object;
            if (object instanceof AttributeChange) {
                EAttribute eAttribute = ((AttributeChange)change).getAttribute();
                if (eAttribute != null) {
                    String attLabel = PTLabelFactory.getAttributeLabel((String)eAttribute.getName(), (boolean)true);
                    String leftLabel = PTLabelFactory.getLabel((EObject)change.getLeftObject());
                    Object leftValue = change.getLeftObject().eGet((EStructuralFeature)eAttribute);
                    Object rightValue = change.getRightObject().eGet((EStructuralFeature)eAttribute);
                    if (object instanceof ConflictAttributeChange) {
                        Object[] array = new Object[]{attLabel, leftLabel, leftValue, rightValue};
                        label = PTChangeLabel.getString(PTChangeLabel._ConflictingAttributeChange, array);
                    } else if (change.isRemote()) {
                        Object[] array = new Object[]{attLabel, leftLabel, leftValue, rightValue};
                        label = PTChangeLabel.getString(PTChangeLabel._RemoteAttributeChange, array);
                    } else {
                        Object[] array = new Object[]{attLabel, leftLabel, rightValue, leftValue};
                        label = PTChangeLabel.getString(PTChangeLabel._AttributeChange, array);
                    }
                }
            } else if (object instanceof ReferenceChange) {
                EReference eReference = ((ReferenceChange)change).getReference();
                if (eReference != null) {
                    String refLabel = PTLabelFactory.getReferenceLabel((String)eReference.getName(), (boolean)true);
                    String leftLabel = PTLabelFactory.getLabel((EObject)change.getLeftObject());
                    String leftValueLabel = _NULL;
                    Object leftValue = change.getLeftObject().eGet((EStructuralFeature)eReference);
                    if (leftValue != null) {
                        leftValueLabel = PTLabelFactory.getShortLabel((EObject)((EObject)leftValue));
                    }
                    String rightValueLabel = _NULL;
                    Object rightValue = change.getRightObject().eGet((EStructuralFeature)eReference);
                    if (rightValue != null) {
                        rightValueLabel = PTLabelFactory.getShortLabel((EObject)((EObject)rightValue));
                    }
                    if (object instanceof ConflictReferenceChange) {
                        Object[] array = new Object[]{refLabel, leftLabel, leftValueLabel, rightValueLabel};
                        label = PTChangeLabel.getString(PTChangeLabel._ConflictingReferenceChange, array);
                    } else if (change.isRemote()) {
                        Object[] array = new Object[]{refLabel, leftLabel, leftValueLabel, rightValueLabel};
                        label = PTChangeLabel.getString(PTChangeLabel._RemoteReferenceChange, array);
                    } else {
                        Object[] array = new Object[]{refLabel, leftLabel, rightValueLabel, leftValueLabel};
                        label = PTChangeLabel.getString(PTChangeLabel._ReferenceChange, array);
                    }
                }
            } else if (object instanceof ConflictChange) {
                String leftLabel = PTLabelFactory.getLabel((EObject)change.getLeftObject());
                String rightLabel = PTLabelFactory.getLabel((EObject)change.getRightObject());
                Object[] array = new Object[]{leftLabel, rightLabel};
                label = PTChangeLabel.getString(PTChangeLabel._ConflictingChange, array);
            }
        } else if (object instanceof LeftPending) {
            LeftPending leftPending = (LeftPending)object;
            String leftLabel = PTLabelFactory.getLabel((EObject)leftPending.getLeftObject());
            Object[] array = new Object[]{leftLabel};
            label = leftPending.isRemote() ? PTChangeLabel.getString(PTChangeLabel._RemoteRemoveReference, array) : PTChangeLabel.getString(PTChangeLabel._AddReference, array);
        } else if (object instanceof RightPending) {
            RightPending rightPending = (RightPending)object;
            String rightLabel = PTLabelFactory.getLabel((EObject)rightPending.getRightObject());
            Object[] array = new Object[]{rightLabel};
            label = rightPending.isRemote() ? PTChangeLabel.getString(PTChangeLabel._RemoteAddReference, array) : PTChangeLabel.getString(PTChangeLabel._RemoveReference, array);
        } else if (object instanceof ChangeGroup) {
            ChangeGroup changeGroup = (ChangeGroup)object;
            String groupLabel = PTLabelFactory.getLabel((EObject)changeGroup.getObject());
            int nbConflict = changeGroup.nbAllConflictChanges();
            if (nbConflict > 0) {
                Object[] array = new Object[]{changeGroup.nbAllChanges(), groupLabel, nbConflict};
                label = PTChangeLabel.getString(PTChangeLabel._ChangeGroupWithConflict, array);
            } else {
                Object[] array = new Object[]{changeGroup.nbAllChanges(), groupLabel};
                label = PTChangeLabel.getString(PTChangeLabel._ChangeGroup, array);
            }
        } else {
            label = object.toString();
        }
        return label;
    }
}

