/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.cobol.util;

import com.ibm.pdp.mdl.cobol.util.CobolPictureParser;
import com.ibm.pdp.mdl.kernel.DecimalType;
import com.ibm.pdp.mdl.kernel.IntegerType;
import com.ibm.pdp.mdl.kernel.KernelFactory;
import com.ibm.pdp.mdl.kernel.SimpleType;
import com.ibm.pdp.mdl.kernel.StringType;

public class CobolTypeConverter {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static SimpleType normalize(String _picture) {
        String picture = CobolTypeConverter.getRealPicture(_picture);
        StringType simpleType = null;
        CobolPictureParser pictureParser = new CobolPictureParser(picture);
        if (pictureParser.isAlphabetic() || pictureParser.isAlphanumeric()) {
            StringType stringType = KernelFactory.eINSTANCE.createStringType();
            int maxLength = pictureParser.getCapacity();
            stringType.setMaxLength(maxLength == 0 ? 1 : maxLength);
            simpleType = stringType;
        } else if (pictureParser.isNumeric()) {
            if (pictureParser.getDecimals() == 0) {
                IntegerType integerType = KernelFactory.eINSTANCE.createIntegerType();
                String max = "";
                String min = "0";
                int i = 0;
                while (i < pictureParser.getCapacity()) {
                    max = String.valueOf(max) + "9";
                    ++i;
                }
                if (pictureParser.hasSign()) {
                    min = "-" + max;
                }
                integerType.setMaxValue(max);
                integerType.setMinValue(min);
                simpleType = integerType;
            } else {
                DecimalType decimalType = KernelFactory.eINSTANCE.createDecimalType();
                String max = "";
                String min = "0";
                int intLength = pictureParser.getCapacity() - pictureParser.getDecimals();
                int i = 0;
                while (i < intLength) {
                    max = String.valueOf(max) + "9";
                    ++i;
                }
                max = String.valueOf(max) + ".";
                i = 0;
                while (i < pictureParser.getDecimals()) {
                    max = String.valueOf(max) + "9";
                    ++i;
                }
                if (max.startsWith(".")) {
                    max = String.valueOf('0') + max;
                }
                if (min.startsWith(".")) {
                    min = String.valueOf('0') + min;
                }
                if (pictureParser.hasSign()) {
                    min = "-" + max;
                }
                decimalType.setMaxValue(max);
                decimalType.setMinValue(min);
                simpleType = decimalType;
            }
        }
        return simpleType;
    }

    private static String getRealPicture(String _picture) {
        if (_picture == null) {
            return null;
        }
        String[] items = _picture.split(" ");
        if (items.length > 1 && items[1].charAt(0) == '(') {
            return (String.valueOf(items[0]) + items[1]).trim().replace(" ", "");
        }
        return items[0];
    }
}

