/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.cobol.util;

public class CobolPictureParser {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String picture;
    private boolean isParsed = false;
    private int type = -1;
    private int length = 0;
    private int decimales = 0;
    private static int ALPHABETIC = 0;
    private static int ALPHANUMERIC = 1;
    private static int NUMERIC = 2;

    public CobolPictureParser(String picture) {
        this.picture = picture == null ? "" : picture.trim();
    }

    public int getCapacity() {
        if (!this.isParsed) {
            this.parse();
        }
        return this.length;
    }

    public int getDecimals() {
        if (!this.isParsed) {
            this.parse();
        }
        return this.decimales;
    }

    public boolean hasSign() {
        return this.isNumeric() && (this.picture.trim().startsWith("S") || this.picture.trim().endsWith("S"));
    }

    public boolean isAlphabetic() {
        if (!this.isParsed) {
            this.parse();
        }
        return this.type == ALPHABETIC;
    }

    public boolean isAlphanumeric() {
        if (!this.isParsed) {
            this.parse();
        }
        return this.type == ALPHANUMERIC;
    }

    public int getType() {
        this.isParsed = false;
        this.parse(false);
        int aType = this.type;
        if (this.type == -1) {
            this.type = ALPHABETIC;
        }
        return aType;
    }

    public boolean isNumeric() {
        if (!this.isParsed) {
            this.parse();
        }
        return this.type == NUMERIC;
    }

    /*
     * Unable to fully structure code
     */
    private void parse(boolean forceTypeToAlpha) {
        this.isParsed = true;
        if (this.picture.length() == 0) {
            return;
        }
        this.picture = this.picture.toUpperCase();
        ilen = this.picture.length();
        c = new char[ilen];
        this.picture.getChars(0, ilen, c, 0);
        partieEntiere = true;
        partieDecimale = false;
        openpar = false;
        if (forceTypeToAlpha) {
            this.type = CobolPictureParser.ALPHABETIC;
        }
        parenthesisLength = 0;
        i = 0;
        while (i < ilen) {
            block17: {
                block19: {
                    block18: {
                        block16: {
                            if (c[i] != 'V') break block16;
                            this.type = CobolPictureParser.NUMERIC;
                            partieEntiere = false;
                            partieDecimale = true;
                            break block17;
                        }
                        if (c[i] != '(') break block18;
                        openpar = true;
                        parenthesisLength = 0;
                        if (partieEntiere) {
                            --this.length;
                        }
                        if (partieDecimale) {
                            this.decimales = Math.max(0, this.decimales - 1);
                        }
                        break block17;
                    }
                    if (c[i] != ')') break block19;
                    openpar = false;
                    if (partieEntiere) {
                        this.length += parenthesisLength;
                    }
                    if (partieDecimale) {
                        this.decimales += parenthesisLength;
                    }
                    break block17;
                }
                if (!openpar) ** GOTO lbl45
                if (Character.isDigit(c[i])) {
                    inb = Integer.parseInt(String.valueOf(c[i]));
                    parenthesisLength = parenthesisLength * 10 + inb;
                } else {
                    this.type = -1;
lbl45:
                    // 2 sources

                    if (c[i] == 'A') {
                        this.type = CobolPictureParser.ALPHABETIC;
                    }
                    if (c[i] == '9' || c[i] == 'Z' || c[i] == '+' || c[i] == '-') {
                        this.type = CobolPictureParser.NUMERIC;
                    }
                    if (c[i] == '1') {
                        this.type = CobolPictureParser.NUMERIC;
                    }
                    if (c[i] == 'X' || c[i] == 'N') {
                        this.type = CobolPictureParser.ALPHANUMERIC;
                    }
                    if (c[i] != 'S' && c[i] != 'P') {
                        if (partieEntiere) {
                            ++this.length;
                        }
                        if (partieDecimale) {
                            ++this.decimales;
                        }
                    }
                }
            }
            ++i;
        }
        this.length += this.decimales;
    }

    private void parse() {
        this.parse(true);
    }
}

