/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.cobol.util;

import com.ibm.pdp.mdl.cobol.util.CobolPictureParser;

public class CobolFormatControl {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int INTERNAL = 0;
    private static CobolFormatControl _instance = null;
    private static final String validAphaStrings = "ABCDEGIKMNPSTVXZ";
    private static final String validNumStrings = "0123456789";
    private static final String validSpecialStrings = ",.+-*/$()!";
    private static final String validSimpleStrings = "ABCDEGIKMNPSTVXZ0123456789,.+-*/$()!";
    private static final String[] validDoubleStrings = new String[]{"CR", "DB", "TS"};
    private static final String AlphaNumericSign = "X";
    private static final String AlphabeticSign = "A";
    private static final String NumericSign = "9";
    private static final String[] LargeObjectsValidValues = new String[]{"K", "M", "G"};

    public static CobolFormatControl getInstance() {
        if (_instance == null) {
            _instance = new CobolFormatControl();
        }
        return _instance;
    }

    public boolean controlFormat(String format) {
        return this.commonChecks(format.trim().toUpperCase());
    }

    private boolean commonChecks(String format) {
        CobolPictureParser parser = new CobolPictureParser(format);
        if (!(parser.getType() >= 0 || parser.getCapacity() == 0 || format.endsWith(LargeObjectsValidValues[0]) || format.endsWith(LargeObjectsValidValues[1]) || format.endsWith(LargeObjectsValidValues[2]) || this.isAllNumeric(format))) {
            return false;
        }
        int i = 0;
        while (i < validDoubleStrings.length) {
            if (format.startsWith(validDoubleStrings[i])) {
                return this.commonChecks(format.substring(2));
            }
            if (format.endsWith(validDoubleStrings[i])) {
                return this.commonChecks(format.substring(format.length()));
            }
            ++i;
        }
        int[] nbParenthesis = new int[2];
        int i2 = 0;
        while (i2 < format.length()) {
            char c = format.charAt(i2);
            if (!validSimpleStrings.contains(format.subSequence(i2, i2 + 1))) {
                return false;
            }
            if (c == '(') {
                nbParenthesis[0] = nbParenthesis[0] + 1;
            }
            if (c == ')') {
                nbParenthesis[1] = nbParenthesis[1] + 1;
            }
            ++i2;
        }
        if (nbParenthesis[0] != nbParenthesis[1]) {
            return false;
        }
        if (nbParenthesis[0] > 0 && !this.checkFormatWithParenthesis(format.trim())) {
            return false;
        }
        if (format.trim().contains(" ")) {
            return false;
        }
        if (parser.isAlphabetic() && format.contains(AlphaNumericSign) || parser.isAlphanumeric() && format.contains(AlphabeticSign)) {
            return false;
        }
        if (parser.hasSign() && (format.contains(AlphabeticSign) || format.contains(AlphaNumericSign))) {
            return false;
        }
        String virtualFormat = this.removeParenthesisValuesFromFormat(format);
        return !virtualFormat.contains(NumericSign) || !parser.isAlphabetic() && !parser.isAlphanumeric();
    }

    private boolean checkFormatWithParenthesis(String format) {
        boolean result = true;
        String value = "";
        while (format.contains("(") && format.contains(")")) {
            try {
                value = format.substring(format.indexOf("(") + 1, format.indexOf(")", format.indexOf("(")));
                Integer.parseInt(value);
                format = format.substring(format.indexOf(41) + 1);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return result;
    }

    private String removeParenthesisValuesFromFormat(String format) {
        char[] result = format.toCharArray();
        char[] chars = format.toCharArray();
        boolean insert = true;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '(') {
                insert = false;
            }
            result[i] = insert ? chars[i] : 32;
            if (chars[i] == ')') {
                insert = true;
            }
            ++i;
        }
        return String.valueOf(result);
    }

    private boolean isAllNumeric(String format) {
        try {
            int pic = Integer.parseInt(format);
            return pic == 3000;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

