/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.rpp.micropattern;

import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternGenerationProperties;
import com.ibm.pdp.engine.IMicroPatternHandler;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.framework.Reference;
import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.UserEntity;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class AbstractGlobalMicroPatternHandler
implements IMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String USER_GLOBAL_ID = "GlobalId";
    private static final String UNDERSCORE = "_";

    public void init() {
    }

    public String getNamespace() {
        return null;
    }

    public abstract String getId();

    public final void registerReference(IMicroPattern microPattern, Object element) {
        RadicalEntity radicalEntity;
        if (microPattern == null || element == null || !(element instanceof RadicalElement) && !(element instanceof RadicalEntity)) {
            return;
        }
        RadicalEntity radicalEntity2 = radicalEntity = element instanceof RadicalEntity ? (RadicalEntity)element : (RadicalEntity)((com.ibm.pdp.maf.rpp.kernel.impl.RadicalElement)element).getWrapperObject();
        if (radicalEntity != null) {
            String metaType = null;
            if (radicalEntity instanceof UserEntity) {
                metaType = ((UserEntity)radicalEntity).getMetaEntity().getName();
            }
            Reference reference = new Reference(radicalEntity.getProject(), true, radicalEntity.getPackage(), metaType, radicalEntity.getName(), radicalEntity.eClass().getName().toLowerCase(), radicalEntity.getStateId(), null, String.valueOf(this.getClass().getCanonicalName()) + UNDERSCORE + radicalEntity.getName());
            microPattern.getProcessingContext().registerGenerationReference((Object)reference);
        }
    }

    public abstract void process(IMicroPattern var1, IGenInfoBuilder var2, Object var3);

    public final void process(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        int currentMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        String designFilePath = microPattern.getProcessingContext().getGeneratedInfo().getProperty("TranscientDesignFilePath");
        RadicalEntity radicalEntity = null;
        if (designFilePath == null) {
            String _designFilePath;
            IMicroPatternGenerationProperties properties = microPattern.getProcessingContext().getGenerationProperties();
            if (properties != null && (_designFilePath = properties.getProperty("DESIGN_PATH")) != null) {
                PTEditorService.getInstance();
                radicalEntity = PTEditorService.getSharedResource((IPath)new Path(_designFilePath));
            }
        } else {
            PTEditorService.getInstance();
            radicalEntity = PTEditorService.getSharedResource((IPath)new Path(designFilePath));
        }
        microPattern.getAttributes().put(USER_GLOBAL_ID, String.valueOf(this.getId()) + UNDERSCORE + System.currentTimeMillis());
        if (PTModelManager.getPreferredFacet().equals("pacbase")) {
            RadicalElement radicalElement = null;
            if (radicalEntity != null) {
                radicalElement = MAFModelManager.getInstance().getRadicalElement(radicalEntity);
            }
            this.process(microPattern, genInfoBuilder, radicalElement);
        } else {
            this.process(microPattern, genInfoBuilder, radicalEntity);
        }
        PTEditorService.setResolvingMode((int)currentMode);
    }
}

