/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.maf.rpp.service;

import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IControllerFactory;
import com.ibm.pdp.framework.interfaces.IGenResult;
import com.ibm.pdp.framework.service.GenerationService;
import com.ibm.pdp.references.service.ReferenceService;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;

public class MAFSourceService {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static MAFSourceService instance = null;

    private MAFSourceService() {
    }

    public static MAFSourceService getInstance() {
        if (instance == null) {
            instance = new MAFSourceService();
        }
        return instance;
    }

    public IEditTree getEditTree(String sourceFileName) {
        return GenerationService.getEditTree((String)sourceFileName);
    }

    public boolean checkDesynchronizationWithDesigns(String sourceFileName) {
        return ReferenceService.checkDesynchronizationWithDesigns((String)sourceFileName);
    }

    public IGenResult generate(String designId, String patternId, IProgressMonitor monitor) {
        return GenerationService.generate((String)designId, (String)patternId, (IProgressMonitor)monitor);
    }

    private String normalizeFileName(String fileName) {
        return new File(fileName).getPath().replace('\\', '/');
    }

    private IController getController(String sourceFileName) {
        String _sourceFileName = this.normalizeFileName(sourceFileName);
        IControllerFactory _factory = ControllerFactory.getInstance();
        if (_factory == null) {
            return null;
        }
        return _factory.getController(_sourceFileName, false);
    }
}

