/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.maf.rpp.menu.internal;

import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.service.IPTElement;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.plugin.IPTActionContributor;
import com.ibm.pdp.explorer.view.service.PTViewService;
import com.ibm.pdp.maf.rpp.Activator;
import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.menu.IMAFDesignExplorerMenuActionContributor;
import com.ibm.pdp.maf.rpp.message.Messages;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.meta.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.actions.ActionGroup;

public class MAFDesignExplorerMenuManager
implements IPTActionContributor {
    public static final String copyright = "IBM Confidential\r\nOCO Source Materials\r\n5725-H03\r\n(C) Copyright IBM Corp. 2011, 2016\r\nThe source code for this program is not published or \r\notherwise divested of its trade secrets, irrespective of \r\nwhat has been deposited with the U.S. Copyright Office.";

    public void menuAboutToShow(IMenuManager menu) {
        try {
            IStructuredSelection selection = PTViewService.getSelection();
            if (selection.isEmpty() || !(selection.getFirstElement() instanceof IPTElement)) {
                return;
            }
            String type = ((IPTElement)selection.getFirstElement()).getDocument().getType();
            ArrayList<IPTElement> elements = new ArrayList<IPTElement>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (!(object instanceof IPTElement) || !type.equals(((IPTElement)selection.getFirstElement()).getDocument().getType())) {
                    return;
                }
                elements.add((IPTElement)object);
                ++n2;
            }
            if (!elements.isEmpty()) {
                MAFActionGroup actionGroup = new MAFActionGroup();
                menu.add((IContributionItem)new Separator(MAFActionGroup._SEPARATOR));
                actionGroup.fillContextMenu(menu, elements);
            }
        }
        catch (Throwable throwable) {}
    }

    public void doubleClick(DoubleClickEvent event) {
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public static class MAFActionGroup
    extends ActionGroup {
        public static final String _ID = String.valueOf(MAFActionGroup.class.getName()) + "_ID";
        public static final String _SEPARATOR = String.valueOf(MAFActionGroup.class.getName()) + "_SEPARATOR";

        public void fillContextMenu(IMenuManager menu, List<IPTElement> elements) throws CoreException {
            IPTElement iptElement = elements.get(0);
            Document document = iptElement.getDocument();
            String menuLabel = Messages._MENU_MAF;
            MenuManager subMenuRef = new MenuManager(menuLabel, _ID);
            subMenuRef.add((IContributionItem)new Separator());
            Map<IMAFDesignExplorerMenuActionContributor, Set<String>> contributors = Activator.getDefault().getDesignExplorerMenuActionContributors();
            for (IMAFDesignExplorerMenuActionContributor actionContributor : contributors.keySet()) {
                Set<String> entities = contributors.get(actionContributor);
                if (entities.size() != 0 && !entities.contains(document.getType())) continue;
                IMAFModelService modelService = MAFModelManager.getServiceInstance();
                ArrayList<Object> radicalElements = new ArrayList<Object>();
                for (IPTElement element : elements) {
                    document = element.getDocument();
                    if (PTModelManager.getPreferredFacet().equals("pacbase")) {
                        try {
                            RadicalElement aRadicalElement = modelService.getRadicalElement(PTModelService.getDesignId((String)document.getProject(), (String)document.getPackage(), (String)document.getName(), (String)document.getMetaType(), (String)document.getType()));
                            if (aRadicalElement == null) continue;
                            radicalElements.add(aRadicalElement);
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            radicalElements.add(((MAFModelManager)modelService).searchRadicalEntity(element.getProject().getName(), element.getPackage().getName(), document.getMetaType(), element.getName(), document.getType()));
                        }
                        continue;
                    }
                    radicalElements.add(((MAFModelManager)modelService).searchRadicalEntity(element.getProject().getName(), element.getPackage().getName(), document.getMetaType(), element.getName(), document.getType()));
                }
                IAction action = actionContributor.getAction(radicalElements);
                subMenuRef.add(action);
            }
            subMenuRef.add((IContributionItem)new Separator());
            menu.add((IContributionItem)subMenuRef);
        }
    }
}

