/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.maf.rpp;

import com.ibm.pdp.maf.rpp.menu.IMAFDesignExplorerMenuActionContributor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PLUGIN_ID = "com.ibm.pdp.maf.rpp";
    private static Activator plugin;
    private Map<IMAFDesignExplorerMenuActionContributor, Set<String>> contributors = null;
    private static final String MAF_MENU_EXTENSION_POINT_NAME = "mafDesignExplorerMenuActionContributor";
    public static final String ENTITIES_PARAM = "entityTypes";

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.loadDesignExplorerMenuActionContributors();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        if (this.contributors != null) {
            this.contributors.clear();
            this.contributors = null;
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public Map<IMAFDesignExplorerMenuActionContributor, Set<String>> getDesignExplorerMenuActionContributors() throws CoreException {
        if (this.contributors == null) {
            this.loadDesignExplorerMenuActionContributors();
        }
        return this.contributors;
    }

    public void loadDesignExplorerMenuActionContributors() throws CoreException {
        if (this.contributors == null) {
            IExtension[] extensions;
            this.contributors = new HashMap<IMAFDesignExplorerMenuActionContributor, Set<String>>();
            IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
            if (extRegistry == null) {
                return;
            }
            IExtensionPoint extPoint = extRegistry.getExtensionPoint(PLUGIN_ID, MAF_MENU_EXTENSION_POINT_NAME);
            if (extPoint != null && (extensions = extPoint.getExtensions()).length > 0) {
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    IConfigurationElement[] configs = extension.getConfigurationElements();
                    if (configs.length > 0) {
                        int j = 0;
                        while (j < configs.length) {
                            IConfigurationElement config = configs[j];
                            try {
                                IMAFDesignExplorerMenuActionContributor contributor = (IMAFDesignExplorerMenuActionContributor)config.createExecutableExtension("class");
                                String entities = config.getAttribute(ENTITIES_PARAM);
                                HashSet<String> types = new HashSet<String>();
                                if (entities != null) {
                                    StringTokenizer stringTokenizer = new StringTokenizer(entities, ",");
                                    while (stringTokenizer.hasMoreTokens()) {
                                        types.add(stringTokenizer.nextToken().trim());
                                    }
                                }
                                this.contributors.put(contributor, types);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

