/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.maf.rpp.util.impl;

import com.ibm.pdp.mdl.kernel.DataDescriptionExtension;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacFolderView;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class MAFResolver {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int _MAF_NORMAL = 0;
    public static final int _MAF_REGISTRY = 1;
    private static MAFResolver _instance = null;
    private int _mafResolvingMode = 0;
    private List<String> _mafPaths = null;
    private Map<String, RadicalEntity> _mafRegistry = null;

    public static MAFResolver getInstance() {
        if (_instance == null) {
            _instance = new MAFResolver();
            MAFResolver._instance._mafPaths = new ArrayList<String>();
            MAFResolver._instance._mafRegistry = new HashMap<String, RadicalEntity>();
        }
        return _instance;
    }

    public int getMAFResolvingMode() {
        if (this._mafResolvingMode == 0 || this._mafResolvingMode == 1) {
            return this._mafResolvingMode;
        }
        return 0;
    }

    public void setMAFResolvingMode(int mafResolvingMode) {
        this._mafResolvingMode = mafResolvingMode;
    }

    public Map<String, RadicalEntity> getMAFRegistry() {
        if (this._mafRegistry == null) {
            this._mafRegistry = new HashMap<String, RadicalEntity>();
        }
        return this._mafRegistry;
    }

    public List<String> getMAFPaths() {
        if (this._mafPaths == null) {
            this._mafPaths = new ArrayList<String>();
        }
        return this._mafPaths;
    }

    public RadicalEntity getParent(RadicalEntity radicalObject) {
        PacDialog parentObject = null;
        if (radicalObject instanceof DataElement) {
            DataElement dataElement = (DataElement)radicalObject;
            EList extensions = ((DataElementDescription)dataElement.getDataDescription()).getExtensions();
            for (DataDescriptionExtension extension : extensions) {
                if (!(extension instanceof PacDataElementDescription)) continue;
                PacDataElementDescription pacExtension = (PacDataElementDescription)extension;
                parentObject = pacExtension.getParent();
                break;
            }
        } else if (radicalObject instanceof PacScreen) {
            PacScreen pacScreen = (PacScreen)radicalObject;
            parentObject = pacScreen.getDialog();
        } else if (radicalObject instanceof PacFolder) {
            PacFolder pacFolder = (PacFolder)radicalObject;
            parentObject = pacFolder.getPacDialogFolder();
        } else if (radicalObject instanceof PacCommunicationMonitor) {
            PacCommunicationMonitor pacCommunicationMonitor = (PacCommunicationMonitor)radicalObject;
            parentObject = pacCommunicationMonitor.getPacDialogCommunicationMonitor();
        } else if (radicalObject instanceof PacFolderView) {
            PacFolderView pacFolderView = (PacFolderView)radicalObject;
            parentObject = pacFolderView.getFolder();
        } else if (radicalObject instanceof PacServer) {
            PacServer pacServer = (PacServer)radicalObject;
            parentObject = pacServer.getDialog();
        }
        return parentObject;
    }
}

