/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.maf.rpp.service.impl;

import com.ibm.pdp.maf.rpp.kernel.IProblem;
import com.ibm.pdp.maf.rpp.kernel.MetaEntityType;
import com.ibm.pdp.maf.rpp.kernel.UserEntity;
import com.ibm.pdp.maf.rpp.kernel.impl.MetaDataAggregate;
import com.ibm.pdp.maf.rpp.kernel.impl.MetaEntity;
import com.ibm.pdp.maf.rpp.kernel.impl.RadicalElement;
import com.ibm.pdp.maf.rpp.kernel.impl.RadicalElementType;
import com.ibm.pdp.maf.rpp.pac.blockbase.AbstractBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.BlockBaseCategoryValues;
import com.ibm.pdp.maf.rpp.pac.blockbase.CodasylBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.SocrateBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.impl.HierarchicalBlockBase;
import com.ibm.pdp.maf.rpp.pac.blockbase.impl.RelationalBlockBase;
import com.ibm.pdp.maf.rpp.pac.copybook.impl.Copybook;
import com.ibm.pdp.maf.rpp.pac.dataelement.DataElement;
import com.ibm.pdp.maf.rpp.pac.datastructure.DataStructure;
import com.ibm.pdp.maf.rpp.pac.dialog.Dialog;
import com.ibm.pdp.maf.rpp.pac.dialog.impl.Screen;
import com.ibm.pdp.maf.rpp.pac.dialogcommunicationmonitor.CommunicationMonitor;
import com.ibm.pdp.maf.rpp.pac.dialogcommunicationmonitor.DialogCommunicationMonitor;
import com.ibm.pdp.maf.rpp.pac.dialogfolder.Folder;
import com.ibm.pdp.maf.rpp.pac.dialogfolder.impl.DialogFolder;
import com.ibm.pdp.maf.rpp.pac.dialogfolderview.DialogFolderView;
import com.ibm.pdp.maf.rpp.pac.dialogfolderview.impl.FolderView;
import com.ibm.pdp.maf.rpp.pac.dialogserver.DialogServer;
import com.ibm.pdp.maf.rpp.pac.dialogserver.Server;
import com.ibm.pdp.maf.rpp.pac.errorlabel.ErrorLabel;
import com.ibm.pdp.maf.rpp.pac.inputaid.impl.InputAid;
import com.ibm.pdp.maf.rpp.pac.library.Library;
import com.ibm.pdp.maf.rpp.pac.macro.Macro;
import com.ibm.pdp.maf.rpp.pac.program.impl.Program;
import com.ibm.pdp.maf.rpp.pac.report.Report;
import com.ibm.pdp.maf.rpp.pac.segment.AbstractSegment;
import com.ibm.pdp.maf.rpp.pac.segment.LogicalView;
import com.ibm.pdp.maf.rpp.pac.segment.StandardSegment;
import com.ibm.pdp.maf.rpp.pac.segment.impl.MonoStructureSegment;
import com.ibm.pdp.maf.rpp.pac.segment.impl.Table;
import com.ibm.pdp.maf.rpp.pac.text.Text;
import com.ibm.pdp.maf.rpp.pac.volume.impl.Volume;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.IMAFSearchPattern;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.maf.rpp.util.impl.ValuesService;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacCopybook;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacDialogFolderView;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacErrorLabel;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacFolderView;
import com.ibm.pdp.mdl.pacbase.PacInputAid;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacMacro;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacReport;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.PacText;
import com.ibm.pdp.mdl.pacbase.PacVolume;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMAFModelService
implements IMAFModelService {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public final DataElement getDataElement(String projectName, String packageName, String entityName) {
        return (DataElement)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.DATA_ELEMENT);
    }

    public final Library getLibrary(String projectName, String packageName, String entityName) {
        return (Library)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.LIBRARY);
    }

    public final DataStructure getDataStructure(String projectName, String packageName, String entityName) {
        return (DataStructure)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.DATA_STRUCTURE);
    }

    public final StandardSegment getStandardSegment(String projectName, String packageName, String entityName) {
        return (StandardSegment)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.STANDARD_SEGMENT);
    }

    public final com.ibm.pdp.maf.rpp.pac.segment.Table getTable(String projectName, String packageName, String entityName) {
        return (com.ibm.pdp.maf.rpp.pac.segment.Table)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.TABLE);
    }

    public final LogicalView getLogicalView(String projectName, String packageName, String entityName) {
        return (LogicalView)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.LOGICAL_VIEW);
    }

    public final com.ibm.pdp.maf.rpp.pac.segment.MonoStructureSegment getMonoStructureSegment(String projectName, String packageName, String entityName) {
        return (com.ibm.pdp.maf.rpp.pac.segment.MonoStructureSegment)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.MONO_STRUCTURE_SEGMENT);
    }

    public final com.ibm.pdp.maf.rpp.pac.blockbase.RelationalBlockBase getRelationalBlockBase(String projectName, String packageName, String entityName) {
        return (com.ibm.pdp.maf.rpp.pac.blockbase.RelationalBlockBase)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.RELATIONAL_BLOCKBASE);
    }

    public final com.ibm.pdp.maf.rpp.pac.blockbase.HierarchicalBlockBase getHierarchicalBlockBase(String projectName, String packageName, String entityName) {
        return (com.ibm.pdp.maf.rpp.pac.blockbase.HierarchicalBlockBase)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.HIERARCHICAL_BLOCKBASE);
    }

    public final CodasylBlockBase getCodasylBlockBase(String projectName, String packageName, String entityName) {
        return (CodasylBlockBase)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.CODASYL_BLOCKBASE);
    }

    public final SocrateBlockBase getSocrateBlockBase(String projectName, String packageName, String entityName) {
        return (SocrateBlockBase)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.SOCRATE_BLOCKBASE);
    }

    public final Report getReport(String projectName, String packageName, String entityName) {
        return (Report)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.REPORT);
    }

    public final com.ibm.pdp.maf.rpp.pac.program.Program getProgram(String projectName, String packageName, String entityName) {
        return (com.ibm.pdp.maf.rpp.pac.program.Program)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.PROGRAM);
    }

    public final Macro getMacro(String projectName, String packageName, String entityName) {
        return (Macro)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.MACRO);
    }

    public final Text getText(String projectName, String packageName, String entityName) {
        return (Text)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.TEXT);
    }

    public final UserEntity getUserEntity(String projectName, String packageName, String metaEntityName, String entityName) {
        return (UserEntity)this.getRadicalElement(projectName, packageName, metaEntityName, entityName, RadicalElementType.USER_ENTITY);
    }

    public final Dialog getDialog(String projectName, String packageName, String entityName) {
        return (Dialog)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.DIALOG);
    }

    public final com.ibm.pdp.maf.rpp.kernel.MetaEntity getMetaEntity(String projectName, String packageName, String entityName) {
        return (com.ibm.pdp.maf.rpp.kernel.MetaEntity)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.META_ENTITY);
    }

    public final MetaEntityType getMetaEntityType(String projectName, String packageName, String entityName) {
        return (MetaEntityType)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.META_ENTITY_TYPE);
    }

    public final com.ibm.pdp.maf.rpp.kernel.MetaDataAggregate getMetaDataAggregate(String projectName, String packageName, String entityName) {
        return (com.ibm.pdp.maf.rpp.kernel.MetaDataAggregate)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.META_DATA_AGGREGATE);
    }

    public final com.ibm.pdp.maf.rpp.pac.dialog.Screen getScreen(String projectName, String packageName, String entityName) {
        return (com.ibm.pdp.maf.rpp.pac.dialog.Screen)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.SCREEN);
    }

    public final Server getServer(String projectName, String packageName, String entityName) {
        return (Server)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.SERVER);
    }

    public final DialogServer getDialogServer(String projectName, String packageName, String entityName) {
        return (DialogServer)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.DIALOG_SERVER);
    }

    public final DialogCommunicationMonitor getDialogCommunicationMonitor(String projectName, String packageName, String entityName) {
        return (DialogCommunicationMonitor)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.DIALOG_CM);
    }

    public final CommunicationMonitor getCommunicationMonitor(String projectName, String packageName, String entityName) {
        return (CommunicationMonitor)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.COMMUNICATION_MONITOR);
    }

    public final com.ibm.pdp.maf.rpp.pac.dialogfolder.DialogFolder getDialogFolder(String projectName, String packageName, String entityName) {
        return (com.ibm.pdp.maf.rpp.pac.dialogfolder.DialogFolder)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.DIALOG_FOLDER);
    }

    public final Folder getFolder(String projectName, String packageName, String entityName) {
        return (Folder)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.FOLDER);
    }

    public final DialogFolderView getDialogFolderView(String projectName, String packageName, String entityName) {
        return (DialogFolderView)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.DIALOG_FOLDER_VIEW);
    }

    public final com.ibm.pdp.maf.rpp.pac.dialogfolderview.FolderView getFolderView(String projectName, String packageName, String entityName) {
        return (com.ibm.pdp.maf.rpp.pac.dialogfolderview.FolderView)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.FOLDER_VIEW);
    }

    public final com.ibm.pdp.maf.rpp.pac.inputaid.InputAid getInputAid(String projectName, String packageName, String entityName) {
        return (com.ibm.pdp.maf.rpp.pac.inputaid.InputAid)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.INPUTAID);
    }

    public final AbstractSegment getAbstractSegment(String projectName, String packageName, String entityName) {
        RadicalElementType radicalElementType = RadicalElementType.STANDARD_SEGMENT;
        com.ibm.pdp.maf.rpp.kernel.RadicalElement radicalElement = this.getRadicalElement(projectName, packageName, entityName, radicalElementType);
        if (radicalElement != null) {
            return (AbstractSegment)radicalElement;
        }
        radicalElementType = RadicalElementType.LOGICAL_VIEW;
        radicalElement = this.getRadicalElement(projectName, packageName, entityName, radicalElementType);
        if (radicalElement != null) {
            return (AbstractSegment)radicalElement;
        }
        radicalElementType = RadicalElementType.MONO_STRUCTURE_SEGMENT;
        radicalElement = this.getRadicalElement(projectName, packageName, entityName, radicalElementType);
        if (radicalElement != null) {
            return (AbstractSegment)radicalElement;
        }
        radicalElementType = RadicalElementType.TABLE;
        radicalElement = this.getRadicalElement(projectName, packageName, entityName, radicalElementType);
        if (radicalElement != null) {
            return (AbstractSegment)radicalElement;
        }
        return null;
    }

    public final AbstractBlockBase getAbstractBlockBase(String projectName, String packageName, String entityName) {
        RadicalElementType radicalElementType = RadicalElementType.CODASYL_BLOCKBASE;
        com.ibm.pdp.maf.rpp.kernel.RadicalElement radicalElement = this.getRadicalElement(projectName, packageName, entityName, radicalElementType);
        if (radicalElement != null) {
            return (AbstractBlockBase)radicalElement;
        }
        radicalElementType = RadicalElementType.HIERARCHICAL_BLOCKBASE;
        radicalElement = this.getRadicalElement(projectName, packageName, entityName, radicalElementType);
        if (radicalElement != null) {
            return (AbstractBlockBase)radicalElement;
        }
        radicalElementType = RadicalElementType.RELATIONAL_BLOCKBASE;
        radicalElement = this.getRadicalElement(projectName, packageName, entityName, radicalElementType);
        if (radicalElement != null) {
            return (AbstractBlockBase)radicalElement;
        }
        radicalElementType = RadicalElementType.SOCRATE_BLOCKBASE;
        radicalElement = this.getRadicalElement(projectName, packageName, entityName, radicalElementType);
        if (radicalElement != null) {
            return (AbstractBlockBase)radicalElement;
        }
        return null;
    }

    public abstract List<IProblem> getProblems(com.ibm.pdp.maf.rpp.kernel.RadicalElement var1);

    public final com.ibm.pdp.maf.rpp.kernel.RadicalElement getRadicalElement(String projectName, String packageName, String metaEntityName, String entityName, String entityType) {
        if ("dataaggregate".equals(entityType)) {
            return this.getAbstractSegment(projectName, packageName, entityName);
        }
        if ("pacblockbase".equals(entityType)) {
            return this.getAbstractBlockBase(projectName, packageName, entityName);
        }
        RadicalElementType[] radicalElementTypeArray = RadicalElementType.values();
        int n = radicalElementTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RadicalElementType elementType = radicalElementTypeArray[n2];
            if (elementType.getType().equals(entityType)) {
                return this.getRadicalElement(projectName, packageName, metaEntityName, entityName, elementType);
            }
            ++n2;
        }
        return null;
    }

    public final com.ibm.pdp.maf.rpp.kernel.RadicalElement getRadicalElement(String projectName, String packageName, String entityName, String entityType) {
        return this.getRadicalElement(projectName, packageName, null, entityName, entityType);
    }

    public final List<com.ibm.pdp.maf.rpp.kernel.RadicalElement> references(com.ibm.pdp.maf.rpp.kernel.RadicalElement radicalElement, boolean subReferences) {
        return MAFModelManager.getInstance().references(radicalElement, subReferences, null);
    }

    public final int countReferences(String designId, int direction) {
        return MAFModelManager.getInstance().countReferences(designId, direction);
    }

    public abstract List<com.ibm.pdp.maf.rpp.kernel.RadicalElement> search(IMAFSearchPattern var1);

    public List<String> searchIds(IMAFSearchPattern searchPattern) {
        List<com.ibm.pdp.maf.rpp.kernel.RadicalElement> list = this.search(searchPattern);
        ArrayList<String> ids = new ArrayList<String>(list.size() + 10);
        for (com.ibm.pdp.maf.rpp.kernel.RadicalElement radicalElement : list) {
            ids.add(radicalElement.getDesignId());
        }
        return ids;
    }

    public List<String> referencesIds(com.ibm.pdp.maf.rpp.kernel.RadicalElement radicalElement, boolean subReferences) {
        List<com.ibm.pdp.maf.rpp.kernel.RadicalElement> list = this.references(radicalElement, subReferences);
        ArrayList<String> ids = new ArrayList<String>(list.size() + 10);
        for (com.ibm.pdp.maf.rpp.kernel.RadicalElement radicalElementRef : list) {
            ids.add(radicalElementRef.getDesignId());
        }
        return ids;
    }

    public final ErrorLabel getErrorLabel(String projectName, String packageName, String entityName) {
        return (ErrorLabel)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.ERRORLABEL);
    }

    public final com.ibm.pdp.maf.rpp.pac.copybook.Copybook getCopybook(String projectName, String packageName, String entityName) {
        return (com.ibm.pdp.maf.rpp.pac.copybook.Copybook)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.COPYBOOK);
    }

    public final com.ibm.pdp.maf.rpp.pac.volume.Volume getVolume(String projectName, String packageName, String entityName) {
        return (com.ibm.pdp.maf.rpp.pac.volume.Volume)this.getRadicalElement(projectName, packageName, entityName, RadicalElementType.VOLUME);
    }

    public abstract com.ibm.pdp.maf.rpp.kernel.RadicalElement getRadicalElement(String var1);

    public abstract boolean isLocationOpen(String var1);

    public abstract boolean openLocation(String var1);

    public abstract boolean closeLocation(String var1);

    public static final RadicalElementType getRadicalElementType(RadicalEntity radicalEntity) {
        if (radicalEntity instanceof PacBlockBase) {
            PacBlockBase blockBase = (PacBlockBase)radicalEntity;
            BlockBaseCategoryValues value = ValuesService.getBlockBaseCategoryValue(blockBase.getBlockType().getName());
            if (value == BlockBaseCategoryValues._R) {
                return RadicalElementType.RELATIONAL_BLOCKBASE;
            }
            if (value == BlockBaseCategoryValues._H) {
                return RadicalElementType.HIERARCHICAL_BLOCKBASE;
            }
            if (value == BlockBaseCategoryValues._S) {
                return RadicalElementType.SOCRATE_BLOCKBASE;
            }
            if (value == BlockBaseCategoryValues._C) {
                return RadicalElementType.CODASYL_BLOCKBASE;
            }
        } else {
            if (radicalEntity instanceof DataAggregate) {
                PacDataAggregate pacDataAggregate = null;
                for (Object extension : radicalEntity.getExtensions()) {
                    if (!(extension instanceof PacDataAggregate)) continue;
                    pacDataAggregate = (PacDataAggregate)extension;
                    break;
                }
                if (pacDataAggregate != null) {
                    switch (pacDataAggregate.getDataAggregateType().getValue()) {
                        case 0: {
                            if (radicalEntity.getName().endsWith("00")) {
                                return RadicalElementType.MONO_STRUCTURE_SEGMENT;
                            }
                            return RadicalElementType.STANDARD_SEGMENT;
                        }
                        case 1: {
                            return RadicalElementType.LOGICAL_VIEW;
                        }
                        case 2: {
                            return RadicalElementType.TABLE;
                        }
                    }
                    return RadicalElementType.STANDARD_SEGMENT;
                }
                return RadicalElementType.STANDARD_SEGMENT;
            }
            RadicalElementType[] radicalElementTypeArray = RadicalElementType.values();
            int n = radicalElementTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RadicalElementType elementType = radicalElementTypeArray[n2];
                if (elementType.getType().equals(radicalEntity.eClass().getName().toLowerCase())) {
                    return elementType;
                }
                ++n2;
            }
        }
        return null;
    }

    public static String getRadicalEntityType(RadicalElementType entityType) {
        switch (entityType) {
            case DATA_ELEMENT: {
                return RadicalElementType.DATA_ELEMENT.getType();
            }
            case DATA_STRUCTURE: {
                return RadicalElementType.DATA_STRUCTURE.getType();
            }
            case LIBRARY: {
                return RadicalElementType.LIBRARY.getType();
            }
            case STANDARD_SEGMENT: 
            case TABLE: 
            case MONO_STRUCTURE_SEGMENT: 
            case LOGICAL_VIEW: {
                return RadicalElementType.STANDARD_SEGMENT.getType();
            }
            case USER_ENTITY: {
                return RadicalElementType.USER_ENTITY.getType();
            }
            case META_ENTITY: {
                return RadicalElementType.META_ENTITY.getType();
            }
            case META_ENTITY_TYPE: {
                return RadicalElementType.META_ENTITY_TYPE.getType();
            }
            case META_DATA_AGGREGATE: {
                return RadicalElementType.META_DATA_AGGREGATE.getType();
            }
            case PROGRAM: {
                return RadicalElementType.PROGRAM.getType();
            }
            case RELATIONAL_BLOCKBASE: 
            case HIERARCHICAL_BLOCKBASE: 
            case CODASYL_BLOCKBASE: 
            case SOCRATE_BLOCKBASE: {
                return RadicalElementType.CODASYL_BLOCKBASE.getType();
            }
            case REPORT: {
                return RadicalElementType.REPORT.getType();
            }
            case MACRO: {
                return RadicalElementType.MACRO.getType();
            }
            case DIALOG: {
                return RadicalElementType.DIALOG.getType();
            }
            case SCREEN: {
                return RadicalElementType.SCREEN.getType();
            }
            case SERVER: {
                return RadicalElementType.SERVER.getType();
            }
            case DIALOG_SERVER: {
                return RadicalElementType.DIALOG_SERVER.getType();
            }
            case TEXT: {
                return RadicalElementType.TEXT.getType();
            }
            case INPUTAID: {
                return RadicalElementType.INPUTAID.getType();
            }
            case VOLUME: {
                return RadicalElementType.VOLUME.getType();
            }
            case ERRORLABEL: {
                return RadicalElementType.ERRORLABEL.getType();
            }
            case COPYBOOK: {
                return RadicalElementType.COPYBOOK.getType();
            }
            case DIALOG_CM: {
                return RadicalElementType.DIALOG_CM.getType();
            }
            case COMMUNICATION_MONITOR: {
                return RadicalElementType.COMMUNICATION_MONITOR.getType();
            }
            case DIALOG_FOLDER: {
                return RadicalElementType.DIALOG_FOLDER.getType();
            }
            case FOLDER: {
                return RadicalElementType.FOLDER.getType();
            }
            case FOLDER_VIEW: {
                return RadicalElementType.FOLDER_VIEW.getType();
            }
            case DIALOG_FOLDER_VIEW: {
                return RadicalElementType.DIALOG_FOLDER_VIEW.getType();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static com.ibm.pdp.maf.rpp.kernel.RadicalElement createRadicalElement(Document document) {
        RadicalElement radicalElement = null;
        String type = document.getType();
        if (RadicalElementType.DATA_ELEMENT.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dataelement.impl.DataElement(document);
        } else if (RadicalElementType.USER_ENTITY.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.kernel.impl.UserEntity(document);
        } else if (RadicalElementType.LIBRARY.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.library.impl.Library(document);
        } else if (RadicalElementType.DATA_STRUCTURE.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.datastructure.impl.DataStructure(document);
        } else if (RadicalElementType.REPORT.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.report.impl.Report(document);
        } else if (RadicalElementType.MACRO.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.macro.impl.Macro(document);
        } else if (RadicalElementType.TEXT.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.text.impl.Text(document);
        } else if (RadicalElementType.DIALOG.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dialog.impl.Dialog(document);
        } else if (RadicalElementType.SCREEN.getType().equals(type)) {
            radicalElement = new Screen(document);
        } else if (RadicalElementType.DIALOG_SERVER.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dialogserver.impl.DialogServer(document);
        } else if (RadicalElementType.SERVER.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dialogserver.impl.Server(document);
        } else if (RadicalElementType.PROGRAM.getType().equals(type)) {
            radicalElement = new Program(document);
        } else if (RadicalElementType.INPUTAID.getType().equals(type)) {
            radicalElement = new InputAid(document);
        } else if (RadicalElementType.META_ENTITY.getType().equals(type)) {
            radicalElement = new MetaEntity(document);
        } else if (RadicalElementType.META_ENTITY_TYPE.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.kernel.impl.MetaEntityType(document);
        } else if (RadicalElementType.META_DATA_AGGREGATE.getType().equals(type)) {
            radicalElement = new MetaDataAggregate(document);
        } else if (RadicalElementType.ERRORLABEL.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.errorlabel.impl.ErrorLabel(document);
        } else if (RadicalElementType.COPYBOOK.getType().equals(type)) {
            radicalElement = new Copybook(document);
        } else if (RadicalElementType.VOLUME.getType().equals(type)) {
            radicalElement = new Volume(document);
        } else if (RadicalElementType.DIALOG_CM.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dialogcommunicationmonitor.impl.DialogCommunicationMonitor(document);
        } else if (RadicalElementType.COMMUNICATION_MONITOR.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dialogcommunicationmonitor.impl.CommunicationMonitor(document);
        } else if (RadicalElementType.DIALOG_FOLDER.getType().equals(type)) {
            radicalElement = new DialogFolder(document);
        } else if (RadicalElementType.FOLDER.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dialogfolder.impl.Folder(document);
        } else if (RadicalElementType.DIALOG_FOLDER_VIEW.getType().equals(type)) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dialogfolderview.impl.DialogFolderView(document);
        } else if (RadicalElementType.FOLDER_VIEW.getType().equals(type)) {
            radicalElement = new FolderView(document);
        } else {
            RadicalEntity radicalEntity = MAFModelManager.getInstance().searchRadicalEntity(document.getProject(), document.getPackage(), document.getMetaType(), document.getName(), document.getType());
            if (radicalEntity != null) {
                radicalElement = (RadicalElement)AbstractMAFModelService.createRadicalElement(radicalEntity);
                radicalElement.releaseRadicalEntity(document);
            }
        }
        return radicalElement;
    }

    public static com.ibm.pdp.maf.rpp.kernel.RadicalElement createRadicalElement(RadicalEntity radicalEntity) {
        RadicalElement radicalElement = null;
        if (radicalEntity instanceof com.ibm.pdp.mdl.kernel.DataElement) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dataelement.impl.DataElement(radicalEntity);
        } else if (radicalEntity instanceof PacLibrary) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.library.impl.Library(radicalEntity);
        } else if (radicalEntity instanceof DataUnit) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.datastructure.impl.DataStructure(radicalEntity);
        } else if (radicalEntity instanceof PacReport) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.report.impl.Report(radicalEntity);
        } else if (radicalEntity instanceof PacMacro) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.macro.impl.Macro(radicalEntity);
        } else if (radicalEntity instanceof PacText) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.text.impl.Text(radicalEntity);
        } else if (radicalEntity instanceof PacDialog) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dialog.impl.Dialog(radicalEntity);
        } else if (radicalEntity instanceof PacScreen) {
            radicalElement = new Screen(radicalEntity);
        } else if (radicalEntity instanceof PacDialogServer) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dialogserver.impl.DialogServer(radicalEntity);
        } else if (radicalEntity instanceof PacServer) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dialogserver.impl.Server(radicalEntity);
        } else if (radicalEntity instanceof PacDialogCommunicationMonitor) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dialogcommunicationmonitor.impl.DialogCommunicationMonitor(radicalEntity);
        } else if (radicalEntity instanceof PacCommunicationMonitor) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dialogcommunicationmonitor.impl.CommunicationMonitor(radicalEntity);
        } else if (radicalEntity instanceof PacDialogFolder) {
            radicalElement = new DialogFolder(radicalEntity);
        } else if (radicalEntity instanceof PacFolder) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dialogfolder.impl.Folder(radicalEntity);
        } else if (radicalEntity instanceof PacDialogFolderView) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.dialogfolderview.impl.DialogFolderView(radicalEntity);
        } else if (radicalEntity instanceof PacFolderView) {
            radicalElement = new FolderView(radicalEntity);
        } else if (radicalEntity instanceof PacInputAid) {
            radicalElement = new InputAid(radicalEntity);
        } else if (radicalEntity instanceof PacVolume) {
            radicalElement = new Volume(radicalEntity);
        } else if (radicalEntity instanceof PacErrorLabel) {
            radicalElement = new com.ibm.pdp.maf.rpp.pac.errorlabel.impl.ErrorLabel(radicalEntity);
        } else if (radicalEntity instanceof PacCopybook) {
            radicalElement = new Copybook(radicalEntity);
        } else if (radicalEntity instanceof com.ibm.pdp.mdl.kernel.MetaEntityType) {
            radicalElement = new com.ibm.pdp.maf.rpp.kernel.impl.MetaEntityType(radicalEntity);
        } else if (radicalEntity instanceof com.ibm.pdp.mdl.kernel.MetaEntity) {
            radicalElement = new MetaEntity(radicalEntity);
        } else if (radicalEntity instanceof com.ibm.pdp.mdl.kernel.MetaDataAggregate) {
            radicalElement = new MetaDataAggregate(radicalEntity);
        } else if (radicalEntity instanceof com.ibm.pdp.mdl.kernel.UserEntity) {
            radicalElement = new com.ibm.pdp.maf.rpp.kernel.impl.UserEntity(radicalEntity);
        } else if (radicalEntity instanceof PacProgram) {
            radicalElement = new Program(radicalEntity);
        } else {
            RadicalElementType radicalElementType = AbstractMAFModelService.getRadicalElementType(radicalEntity);
            if (radicalElementType != null) {
                switch (radicalElementType) {
                    case RELATIONAL_BLOCKBASE: {
                        radicalElement = new RelationalBlockBase(radicalEntity);
                        break;
                    }
                    case HIERARCHICAL_BLOCKBASE: {
                        radicalElement = new HierarchicalBlockBase(radicalEntity);
                        break;
                    }
                    case SOCRATE_BLOCKBASE: {
                        radicalElement = new com.ibm.pdp.maf.rpp.pac.blockbase.impl.SocrateBlockBase(radicalEntity);
                        break;
                    }
                    case CODASYL_BLOCKBASE: {
                        radicalElement = new com.ibm.pdp.maf.rpp.pac.blockbase.impl.CodasylBlockBase(radicalEntity);
                        break;
                    }
                    case MONO_STRUCTURE_SEGMENT: {
                        radicalElement = new MonoStructureSegment(radicalEntity);
                        break;
                    }
                    case STANDARD_SEGMENT: {
                        radicalElement = new com.ibm.pdp.maf.rpp.pac.segment.impl.StandardSegment(radicalEntity);
                        break;
                    }
                    case LOGICAL_VIEW: {
                        radicalElement = new com.ibm.pdp.maf.rpp.pac.segment.impl.LogicalView(radicalEntity);
                        break;
                    }
                    case TABLE: {
                        radicalElement = new Table(radicalEntity);
                        break;
                    }
                }
            } else {
                throw new UnsupportedOperationException("The type " + radicalEntity.getClass().getName() + " is not implemented in MAF.\n" + radicalEntity.toString());
            }
        }
        return radicalElement;
    }

    private com.ibm.pdp.maf.rpp.kernel.RadicalElement getRadicalElement(String projectName, String packageName, String entityName, RadicalElementType entityType) {
        return this.getRadicalElement(projectName, packageName, null, entityName, entityType);
    }

    private com.ibm.pdp.maf.rpp.kernel.RadicalElement getRadicalElement(String projectName, String packageName, String metaTypeName, String entityName, RadicalElementType radicalElementType) {
        return MAFModelManager.getInstance().getRadicalElement(projectName, packageName, metaTypeName, entityName, radicalElementType);
    }
}

