/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.maf.rpp.service.impl;

import com.ibm.pdp.maf.rpp.container.impl.MAFArrayList;
import com.ibm.pdp.maf.rpp.pac.segment.Statistics;
import com.ibm.pdp.maf.rpp.pac.segment.impl.LevelAddressLength;
import com.ibm.pdp.maf.rpp.service.impl.IMAFModelManagerService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntityExtension;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.mdl.pacbase.PacRadicalEntity;
import com.ibm.pdp.mdl.pacbase.lal.util.GenerationContext;
import com.ibm.pdp.mdl.pacbase.lal.util.LengthAndPositionVisitor;
import com.ibm.pdp.mdl.pacbase.lal.util.PacbaseLalDescription;
import com.ibm.pdp.mdl.pacbase.util.PacTransformationProgramVariantType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractMAFModelManagerService
implements IMAFModelManagerService {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public final Statistics getStatistics(DataAggregate dataAggregate) {
        com.ibm.pdp.maf.rpp.pac.segment.impl.Statistics st = new com.ibm.pdp.maf.rpp.pac.segment.impl.Statistics();
        char v = PacTransformationProgramVariantType.transformProgramVariant((PacProgramVariantValues)this.searchPacGenerationParameterFromDataAggregate(dataAggregate).getCobolType()).charAt(0);
        LengthAndPositionVisitor visitor = new LengthAndPositionVisitor(null, new GenerationContext(v));
        visitor.doSwitch((EObject)dataAggregate);
        visitor.getTopParentLal().calculateNumbers();
        st.setNbElementaryFields(visitor.getTopParentLal().getNbElementaryFields());
        st.setNbDataElements(visitor.getTopParentLal().getNbDataElements());
        st.setTotalInputLength(Integer.parseInt(visitor.getTopParentLal().getTotalInputLength()));
        st.setTotalInternalLength(Integer.parseInt(visitor.getTopParentLal().getTotalInternalLength()));
        st.setTotalOutputLength(Integer.parseInt(visitor.getTopParentLal().getTotalOutputLength()));
        st.setNbSegmentCalls(visitor.getTopParentLal().getNbSegmentCalls());
        return st;
    }

    @Override
    public final List<com.ibm.pdp.maf.rpp.pac.segment.LevelAddressLength> getLevelAddressLength(DataAggregate dataAggregate) {
        MAFArrayList<com.ibm.pdp.maf.rpp.pac.segment.LevelAddressLength> LevelAddressLengthLines = new MAFArrayList<com.ibm.pdp.maf.rpp.pac.segment.LevelAddressLength>();
        char v = PacTransformationProgramVariantType.transformProgramVariant((PacProgramVariantValues)this.searchPacGenerationParameterFromDataAggregate(dataAggregate).getCobolType()).charAt(0);
        LengthAndPositionVisitor visitor = new LengthAndPositionVisitor(null, new GenerationContext(v));
        visitor.doSwitch((EObject)dataAggregate);
        visitor.getTopParentLal().calculateNumbers();
        ArrayList lines = visitor.getTopParentLal().getChildren(true);
        ArrayList<PacbaseLalDescription> linesN = new ArrayList<PacbaseLalDescription>();
        this.setTableItems(lines, linesN);
        Iterator<PacbaseLalDescription> iterLines = linesN.iterator();
        while (iterLines.hasNext()) {
            LevelAddressLength lal = new LevelAddressLength();
            PacbaseLalDescription line = iterLines.next();
            lal.setLevel(line.getLevel());
            lal.setName(line.getName());
            lal.setLabel(line.getLabel());
            lal.setRelLabel(line.getRelLabel());
            int occurs = line.getOccurs();
            if (occurs > 0) {
                lal.setOccurs(line.getOccurs());
            } else {
                lal.setOccurs(-1);
            }
            lal.setInternalFormat(line.getInternalFormat());
            lal.setUsage(line.getUsage());
            lal.setInternalLength(this.getInternalLength(line));
            lal.setInternalAddress(line.getInternalAddress());
            lal.setInputFormat(line.getInputFormat());
            lal.setInputLength(this.getInputLength(line));
            lal.setInputAddress(line.getInputAddress());
            lal.setOutputFormat(line.getInputFormat());
            lal.setOutputLength(this.getInputLength(line));
            lal.setOutputAddress(line.getInputAddress());
            LevelAddressLengthLines._add(lal);
        }
        return LevelAddressLengthLines;
    }

    private PacLibrary searchPacGenerationParameterFromDataAggregate(DataAggregate dataAggregate) {
        RadicalEntity re = MAFModelManager.getInstance().searchRadicalEntity(dataAggregate.getProject(), dataAggregate.getPackage(), "", dataAggregate.getName().substring(0, 2), "dataunit");
        PacLibrary lib = null;
        if (re != null && re instanceof DataUnit) {
            for (RadicalEntityExtension ree : re.getExtensions()) {
                if (!(ree instanceof PacRadicalEntity)) continue;
                lib = ((PacRadicalEntity)ree).getGenerationParameter();
            }
        }
        return lib;
    }

    private void setTableItems(ArrayList<PacbaseLalDescription> lines, ArrayList<PacbaseLalDescription> newLines) {
        for (PacbaseLalDescription lal : lines) {
            newLines.add(lal);
            if (lal.getChildren().isEmpty()) continue;
            this.setTableItems(lal.getChildren(), newLines);
        }
    }

    private int getInternalLength(PacbaseLalDescription lal) {
        if (lal.getChildren().isEmpty()) {
            return lal.getInternalLength();
        }
        return -1;
    }

    private int getInputLength(PacbaseLalDescription lal) {
        if (lal.getChildren().isEmpty()) {
            return lal.getInputLength();
        }
        return -1;
    }

    private int getOutputLength(PacbaseLalDescription lal) {
        if (lal.getChildren().isEmpty()) {
            return lal.getOutputLength();
        }
        return -1;
    }

    @Override
    public com.ibm.pdp.maf.rpp.pac.segment.LevelAddressLength getLengthDE(DataElement dataElement) {
        LevelAddressLength lalDE = new LevelAddressLength();
        char v = PacTransformationProgramVariantType.transformProgramVariant((PacProgramVariantValues)this.searchPacGenerationParameterFromDataElement(dataElement).getCobolType()).charAt(0);
        GenerationContext ctx = new GenerationContext(v);
        LengthAndPositionVisitor visitor = new LengthAndPositionVisitor(null, ctx);
        visitor.doSwitch((EObject)dataElement);
        PacbaseLalDescription lal = visitor.getTopParentLal();
        lalDE.setInternalLength(this.getInternalLength(lal));
        lalDE.setInputLength(this.getInputLength(lal));
        lalDE.setOutputLength(this.getOutputLength(lal));
        return lalDE;
    }

    private PacLibrary searchPacGenerationParameterFromDataElement(DataElement dataElement) {
        RadicalEntity re = MAFModelManager.getInstance().searchRadicalEntity(dataElement.getProject(), dataElement.getPackage(), "", dataElement.getName(), "dataelement");
        PacLibrary lib = null;
        if (re != null && re instanceof DataElement) {
            for (RadicalEntityExtension ree : re.getExtensions()) {
                if (!(ree instanceof PacRadicalEntity)) continue;
                lib = ((PacRadicalEntity)ree).getGenerationParameter();
            }
        }
        return lib;
    }
}

