/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.maf.rpp.pac.segment.impl;

import com.ibm.pdp.maf.rpp.container.impl.MAFArrayList;
import com.ibm.pdp.maf.rpp.pac.common.GLine;
import com.ibm.pdp.maf.rpp.pac.common.impl.AbstractRadicalElement;
import com.ibm.pdp.maf.rpp.pac.datastructure.DataStructure;
import com.ibm.pdp.maf.rpp.pac.library.Library;
import com.ibm.pdp.maf.rpp.pac.segment.LevelAddressLength;
import com.ibm.pdp.maf.rpp.pac.segment.SegmentTypeValues;
import com.ibm.pdp.maf.rpp.pac.segment.Statistics;
import com.ibm.pdp.maf.rpp.pac.segment.impl.CELine;
import com.ibm.pdp.maf.rpp.pac.segment.impl.DataElementComponent;
import com.ibm.pdp.maf.rpp.pac.segment.impl.Filler;
import com.ibm.pdp.maf.rpp.pac.segment.impl.GroupComponent;
import com.ibm.pdp.maf.rpp.pac.segment.impl.LVDataElementComponent;
import com.ibm.pdp.maf.rpp.pac.segment.impl.LVGroupComponent;
import com.ibm.pdp.maf.rpp.pac.segment.impl.LVSegmentComponent;
import com.ibm.pdp.maf.rpp.pac.segment.impl.LVUndefinedDataElementComponent;
import com.ibm.pdp.maf.rpp.pac.segment.impl.RedefinesGroup;
import com.ibm.pdp.maf.rpp.pac.segment.impl.SegmentComponent;
import com.ibm.pdp.maf.rpp.pac.segment.impl.UndefinedDataElementComponent;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.maf.rpp.util.impl.ValuesService;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataAggregateDescription;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataDescription;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.DataUnionDescription;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDataCall;
import com.ibm.pdp.mdl.pacbase.PacLogicalViewCall;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public abstract class AbstractSegment
extends AbstractRadicalElement
implements com.ibm.pdp.maf.rpp.pac.segment.AbstractSegment {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Library generationLibrary = null;
    MAFArrayList<GLine> GELines = null;
    MAFArrayList<GLine> GOLines = null;
    MAFArrayList<GLine> GGLines = null;
    MAFArrayList<GLine> GCLines = null;
    MAFArrayList<com.ibm.pdp.maf.rpp.pac.segment.CELine> CELines = null;
    MAFArrayList<LevelAddressLength> LevelAddressLengthLines = null;
    private com.ibm.pdp.maf.rpp.pac.segment.impl.Statistics st = null;

    public AbstractSegment(Object wrapperObject) {
        super(wrapperObject);
    }

    @Override
    public List<GLine> getGCLines() {
        if (this.GCLines == null && this.getPacDefinition().getGCLines() != null) {
            this.GCLines = new MAFArrayList();
            for (Object object : this.getPacDefinition().getGCLines()) {
                this.GCLines = ValuesService.getGLines(this.GCLines, object);
            }
        }
        return this.GCLines;
    }

    public SegmentTypeValues getType() {
        int value = this.getPacDefinition().getDataAggregateType().getValue();
        return ValuesService.getSegmentTypeValue(value);
    }

    public DataStructure getDataStructure() {
        String dsName = this.getPacSegment().getName().substring(0, 2);
        return MAFModelManager.getServiceInstance().getDataStructure(this.getProject(), this.getPackage(), dsName);
    }

    public int getTableSize() {
        return this.getPacDefinition().getTableSize();
    }

    public int getOccurrencesNumber() {
        return this.getPacDefinition().getOccurencesNumber();
    }

    public Library getGenerationLibrary() {
        PacDataAggregate dataAggregateDefinition;
        if (this.generationLibrary == null && (dataAggregateDefinition = this.getPacDefinition()) != null) {
            this.generationLibrary = (Library)AbstractSegment.getRadicalElement((RadicalEntity)dataAggregateDefinition.getGenerationParameter());
        }
        return this.generationLibrary;
    }

    public List<GLine> getGELines() {
        if (this.GELines == null && this.getPacDefinition().getGELines() != null) {
            this.GELines = new MAFArrayList();
            for (Object object : this.getPacDefinition().getGELines()) {
                this.GELines = ValuesService.getGLines(this.GELines, object);
            }
        }
        return this.GELines;
    }

    public List<GLine> getGOLines() {
        if (this.GOLines == null && this.getPacDefinition().getGOLines() != null) {
            this.GOLines = new MAFArrayList();
            for (Object object : this.getPacDefinition().getGOLines()) {
                this.GOLines = ValuesService.getGLines(this.GOLines, object);
            }
        }
        return this.GOLines;
    }

    public List<GLine> getGGLines() {
        if (this.GGLines == null && this.getPacDefinition().getGGLines() != null) {
            this.GGLines = new MAFArrayList();
            for (Object object : this.getPacDefinition().getGGLines()) {
                this.GGLines = ValuesService.getGLines(this.GGLines, object);
            }
        }
        return this.GGLines;
    }

    public List<com.ibm.pdp.maf.rpp.pac.segment.CELine> getCELines() {
        if (this.CELines == null && this.getDescription().getComponents() != null) {
            this.CELines = new MAFArrayList();
            for (Object object : this.getDescription().getComponents()) {
                if (object instanceof com.ibm.pdp.mdl.kernel.Filler) {
                    Filler celine = new Filler();
                    celine.setWrapperObject((Entity)object);
                    this.CELines._add(celine);
                    continue;
                }
                DataCall dc = (DataCall)object;
                if (dc.getDataDefinition() == null && dc.getDataDescription() instanceof DataUnionDescription) {
                    RedefinesGroup celine = new RedefinesGroup();
                    celine.setWrapperObject((Entity)object);
                    this.CELines._add(celine);
                    continue;
                }
                for (Object obj : dc.getExtensions()) {
                    CELine celine;
                    if (obj instanceof PacLogicalViewCall) {
                        if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataElement) {
                            celine = new LVDataElementComponent();
                            celine.setWrapperObject((Entity)object);
                            this.CELines._add(celine);
                            continue;
                        }
                        if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataAggregate) {
                            celine = new LVSegmentComponent();
                            celine.setWrapperObject((Entity)object);
                            this.CELines._add(celine);
                            continue;
                        }
                        if (dc.getDataDescription() != null && dc.getDataDescription() instanceof DataAggregateDescription) {
                            celine = new LVGroupComponent();
                            celine.setWrapperObject((Entity)object);
                            this.CELines._add(celine);
                            continue;
                        }
                        if (dc.getDataDescription() != null && dc.getDataDescription() instanceof DataUnionDescription) {
                            celine = new RedefinesGroup();
                            celine.setWrapperObject((Entity)object);
                            this.CELines._add(celine);
                            continue;
                        }
                        if (dc.getDataDescription() == null || !(dc.getDataDescription() instanceof DataElementDescription)) continue;
                        celine = new LVUndefinedDataElementComponent();
                        celine.setWrapperObject((Entity)object);
                        this.CELines._add(celine);
                        continue;
                    }
                    if (!(obj instanceof PacDataCall)) continue;
                    if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataElement) {
                        celine = new DataElementComponent();
                        celine.setWrapperObject((Entity)object);
                        this.CELines._add(celine);
                        continue;
                    }
                    if (dc.getDataDefinition() != null && dc.getDataDefinition() instanceof DataAggregate) {
                        celine = new SegmentComponent();
                        celine.setWrapperObject((Entity)object);
                        this.CELines._add(celine);
                        continue;
                    }
                    if (dc.getDataDescription() != null && dc.getDataDescription() instanceof DataElementDescription) {
                        celine = new UndefinedDataElementComponent();
                        celine.setWrapperObject((Entity)object);
                        this.CELines._add(celine);
                        continue;
                    }
                    if (dc.getDataDescription() != null && dc.getDataDescription() instanceof DataAggregateDescription) {
                        celine = new GroupComponent();
                        celine.setWrapperObject((Entity)object);
                        this.CELines._add(celine);
                        continue;
                    }
                    if (dc.getDataDescription() == null || !(dc.getDataDescription() instanceof DataUnionDescription)) continue;
                    celine = new RedefinesGroup();
                    celine.setWrapperObject((Entity)object);
                    this.CELines._add(celine);
                }
            }
        }
        return this.CELines;
    }

    public Statistics getStatistics() {
        if (this.st != null) {
            return this.st;
        }
        this.st = (com.ibm.pdp.maf.rpp.pac.segment.impl.Statistics)MAFModelManager.getInstance().getStatistics((DataAggregate)this.getWrapperObject());
        return this.st;
    }

    public List<LevelAddressLength> getLevelAddressLength() {
        if (this.LevelAddressLengthLines != null) {
            return this.LevelAddressLengthLines;
        }
        this.LevelAddressLengthLines = (MAFArrayList)MAFModelManager.getInstance().getLevelAddressLength((DataAggregate)this.getWrapperObject());
        return this.LevelAddressLengthLines;
    }

    public DataAggregate getPacSegment() {
        return (DataAggregate)this.getWrapperObject();
    }

    public PacDataAggregate getPacDefinition() {
        PacDataAggregate pacDefinition = null;
        EList extensions = this.getPacSegment().getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataAggregate) {
                pacDefinition = (PacDataAggregate)object;
                break;
            }
            ++i;
        }
        return pacDefinition;
    }

    public DataAggregateDescription getPacDescription() {
        DataAggregateDescription pacDescription = null;
        DataDescription description = this.getPacSegment().getDataDescription();
        if (description != null) {
            EList extensions = description.getExtensions();
            int i = 0;
            while (i < extensions.size()) {
                Object object = extensions.get(i);
                if (object instanceof DataAggregateDescription) {
                    pacDescription = (DataAggregateDescription)object;
                    break;
                }
                ++i;
            }
        }
        return pacDescription;
    }

    public DataAggregateDescription getDescription() {
        return (DataAggregateDescription)this.getPacSegment().getDataDescription();
    }
}

