/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.maf.rpp.pac.program.impl;

import com.ibm.pdp.maf.rpp.container.impl.MAFArrayList;
import com.ibm.pdp.maf.rpp.kernel.impl.RadicalElementType;
import com.ibm.pdp.maf.rpp.pac.common.GLine;
import com.ibm.pdp.maf.rpp.pac.common.ProgramVariantValues;
import com.ibm.pdp.maf.rpp.pac.common.impl.AbstractRadicalElement;
import com.ibm.pdp.maf.rpp.pac.library.Library;
import com.ibm.pdp.maf.rpp.pac.program.CDLine;
import com.ibm.pdp.maf.rpp.pac.program.ProgramPresenceValidationValues;
import com.ibm.pdp.maf.rpp.pac.program.ProgramStructureValues;
import com.ibm.pdp.maf.rpp.pac.program.ProgramUsageValues;
import com.ibm.pdp.maf.rpp.pac.program.impl.CDLineDataStructure;
import com.ibm.pdp.maf.rpp.pac.program.impl.CDLineReport;
import com.ibm.pdp.maf.rpp.pac.program.impl.CPLine;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.maf.rpp.util.impl.ValuesService;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractCDLine;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.util.PacGenerationTargetUtil;
import java.util.List;

public class Program
extends AbstractRadicalElement
implements com.ibm.pdp.maf.rpp.pac.program.Program {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    MAFArrayList<GLine> GCLines = null;
    MAFArrayList<GLine> GELines = null;
    MAFArrayList<GLine> GOLines = null;
    MAFArrayList<CDLine> CDLines = null;
    MAFArrayList<com.ibm.pdp.maf.rpp.pac.program.CPLine> CPLines = null;
    Library library = null;

    public Program(Object wrapperObject) {
        super(wrapperObject);
    }

    protected PacProgram getPacProgram() {
        return (PacProgram)this.getWrapperObject();
    }

    @Override
    public RadicalElementType getRadicalElementType() {
        return RadicalElementType.PROGRAM;
    }

    public String getProgramId() {
        return this.getPacProgram().getProgramID();
    }

    public ProgramVariantValues getVariant() {
        return ValuesService.getProgramVariantValue(this.getPacProgram().getVariante().getValue());
    }

    public ProgramStructureValues getProgramStructure() {
        return ValuesService.getProgramStructureValue(this.getPacProgram().getProgramStructure().getValue());
    }

    public ProgramPresenceValidationValues getPresenceValidation() {
        return ValuesService.getProgramPresenceValidationValue(this.getPacProgram().getPresenceValidation().getValue());
    }

    public boolean getSQLIndicator() {
        return this.getPacProgram().isSQLIndicator();
    }

    public Library getGenerationLibrary() {
        if (this.library == null && ((PacProgram)this.getWrapperObject()).getGenerationParameter() != null) {
            this.library = (Library)Program.getRadicalElement((RadicalEntity)((PacProgram)this.getWrapperObject()).getGenerationParameter());
        }
        return this.library;
    }

    @Override
    public List<GLine> getGCLines() {
        if (this.GCLines == null && this.getPacProgram().getGCLines() != null) {
            this.GCLines = new MAFArrayList();
            for (Object object : this.getPacProgram().getGCLines()) {
                this.GCLines = ValuesService.getGLines(this.GCLines, object);
            }
        }
        return this.GCLines;
    }

    public List<GLine> getGELines() {
        if (this.GELines == null && this.getPacProgram().getGELines() != null) {
            this.GELines = new MAFArrayList();
            for (Object object : this.getPacProgram().getGELines()) {
                this.GCLines = ValuesService.getGLines(this.GCLines, object);
                this.GELines = ValuesService.getGLines(this.GELines, object);
            }
        }
        return this.GELines;
    }

    public List<GLine> getGOLines() {
        if (this.GOLines == null && this.getPacProgram().getGOLines() != null) {
            this.GOLines = new MAFArrayList();
            for (Object object : this.getPacProgram().getGOLines()) {
                this.GOLines = ValuesService.getGLines(this.GOLines, object);
            }
        }
        return this.GOLines;
    }

    public List<com.ibm.pdp.maf.rpp.pac.program.CPLine> getCPLines() {
        if (this.CPLines == null && this.getPacProgram().getCPLines() != null) {
            this.CPLines = new MAFArrayList();
            for (Object object : this.getPacProgram().getCPLines()) {
                CPLine cpline = new CPLine();
                cpline.setWrapperObject((Entity)object);
                this.CPLines._add(cpline);
            }
        }
        return this.CPLines;
    }

    public List<CDLine> getCDLines() {
        if (this.CDLines == null && this.getPacProgram().getCDLines() != null) {
            this.CDLines = new MAFArrayList();
            for (Object object : this.getPacProgram().getCDLines()) {
                PacAbstractCDLine pacdl = (PacAbstractCDLine)object;
                ProgramUsageValues puv = ValuesService.getProgramUsageValue(pacdl.getUsage().getValue());
                if (puv.equals((Object)ProgramUsageValues._I) || puv.equals((Object)ProgramUsageValues._J)) {
                    CDLineReport cdliner = new CDLineReport();
                    cdliner.setWrapperObject((Entity)object);
                    this.CDLines._add(cdliner);
                    continue;
                }
                CDLineDataStructure cdlineds = new CDLineDataStructure();
                cdlineds.setWrapperObject((Entity)object);
                this.CDLines._add(cdlineds);
            }
        }
        return this.CDLines;
    }

    public String getCobolProject() {
        String result = this.getPacProgram().getCobolProject();
        if (result == null || result.trim().length() == 0) {
            if (this.getPacProgram().getGenerationParameter() != null && ((result = PacGenerationTargetUtil.getLibraryProjectName((RadicalEntity)this.getPacProgram(), (PacLibrary)this.getPacProgram().getGenerationParameter(), (String)"com.ibm.pdp.pacbase.batch", (int)1)) == null || result.trim().length() == 0)) {
                result = this.getPacProgram().getGenerationParameter().getCobolProject();
            }
            if (result == null || result.trim().length() == 0) {
                result = this.getProject();
            }
        }
        return result;
    }

    public String getCobolFolder() {
        String result = this.getPacProgram().getCobolFolder();
        if (result == null || result.trim().length() == 0) {
            if (this.getPacProgram().getGenerationParameter() != null && ((result = PacGenerationTargetUtil.getLibraryFolderName((RadicalEntity)this.getPacProgram(), (PacLibrary)this.getPacProgram().getGenerationParameter(), (String)"com.ibm.pdp.pacbase.batch", (int)1)) == null || result.trim().length() == 0)) {
                result = this.getPacProgram().getGenerationParameter().getCobolFolder();
            }
            if (result == null || result.trim().length() == 0) {
                result = String.valueOf(MAFModelManager.getInstance().getGenRootFolder(this.getProject())) + '/' + this.getPackage().replace('.', '/');
            }
        }
        return result;
    }
}

