/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.maf.rpp.pac.library.impl;

import com.ibm.pdp.maf.rpp.container.impl.MAFArrayList;
import com.ibm.pdp.maf.rpp.kernel.impl.RadicalElementType;
import com.ibm.pdp.maf.rpp.pac.common.AlphanumericDelimiterValues;
import com.ibm.pdp.maf.rpp.pac.common.CenturySystemDateValues;
import com.ibm.pdp.maf.rpp.pac.common.CommentsInsertionOptionValues;
import com.ibm.pdp.maf.rpp.pac.common.DecimalDelimiterValues;
import com.ibm.pdp.maf.rpp.pac.common.GLine;
import com.ibm.pdp.maf.rpp.pac.common.GeneratedDateFormatValues;
import com.ibm.pdp.maf.rpp.pac.common.GeneratedLanguageValues;
import com.ibm.pdp.maf.rpp.pac.common.MapTypeValues;
import com.ibm.pdp.maf.rpp.pac.common.ProgramVariantValues;
import com.ibm.pdp.maf.rpp.pac.common.impl.AbstractRadicalElement;
import com.ibm.pdp.maf.rpp.pac.library.impl.GenerationProject;
import com.ibm.pdp.maf.rpp.util.impl.ValuesService;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import java.util.List;

public class Library
extends AbstractRadicalElement
implements com.ibm.pdp.maf.rpp.pac.library.Library {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    MAFArrayList<GLine> GCLines = null;
    MAFArrayList<GLine> GOLines = null;
    MAFArrayList<com.ibm.pdp.maf.rpp.pac.library.GenerationProject> ProjectLines = null;

    public Library(Object wrapperObject) {
        super(wrapperObject);
    }

    @Override
    public List<GLine> getGCLines() {
        if (this.GCLines == null && this.getPacLibrary().getGCLines() != null) {
            this.GCLines = new MAFArrayList();
            for (Object object : this.getPacLibrary().getGCLines()) {
                this.GCLines = ValuesService.getGLines(this.GCLines, object);
            }
        }
        return this.GCLines;
    }

    @Override
    public RadicalElementType getRadicalElementType() {
        return RadicalElementType.LIBRARY;
    }

    public AlphanumericDelimiterValues getAlphanumericDelimiter() {
        String value = this.getPacLibrary().getAlphanumericDelimiter();
        return ValuesService.getAlphanumericDelimiterValue(value);
    }

    public GeneratedDateFormatValues getGeneratedDateFormat() {
        int value = this.getPacLibrary().getGeneratedDateFormat().getValue();
        return ValuesService.getGeneratedDateFormatValue(value);
    }

    public ProgramVariantValues getCobolType() {
        int value = this.getPacLibrary().getCobolType().getValue();
        return ValuesService.getProgramVariantValue(value);
    }

    public MapTypeValues getMapType() {
        int value = this.getPacLibrary().getMapType().getValue();
        return ValuesService.getMapTypeValue(value);
    }

    public GeneratedLanguageValues getGeneratedLanguage() {
        int value = this.getPacLibrary().getGeneratedLanguage().getValue();
        return ValuesService.getGeneratedLanguageValue(value);
    }

    public DecimalDelimiterValues getDecimalPointDelimiter() {
        String value = this.getPacLibrary().getDecimalPointDelimiter();
        return ValuesService.getDecimalDelimiterValue(value);
    }

    public CommentsInsertionOptionValues getCommentsInsertionOption() {
        int value = this.getPacLibrary().getCommentsInsertionOption().getValue();
        return ValuesService.getCommentsInsertionOptionValue(value);
    }

    public CenturySystemDateValues getCenturySystemDate() {
        int value = this.getPacLibrary().getCenturySystemDate().getValue();
        return ValuesService.getCenturySystemDateValue(value);
    }

    public int getCenturyReferenceYear() {
        return this.getPacLibrary().getCenturyReferenceYear();
    }

    public boolean getCobolFormatting() {
        return this.getPacLibrary().isCobolFormatting();
    }

    public List<GLine> getGOLines() {
        if (this.GOLines == null && this.getPacLibrary().getGOLines() != null) {
            this.GOLines = new MAFArrayList();
            for (Object object : this.getPacLibrary().getGOLines()) {
                this.GOLines = ValuesService.getGLines(this.GOLines, object);
            }
        }
        return this.GOLines;
    }

    private PacLibrary getPacLibrary() {
        return (PacLibrary)this.getWrapperObject();
    }

    public List<com.ibm.pdp.maf.rpp.pac.library.GenerationProject> getGenerationProjects() {
        if (this.ProjectLines == null && this.getPacLibrary().getGenerationProjects() != null) {
            this.ProjectLines = new MAFArrayList();
            for (Object object : this.getPacLibrary().getGenerationProjects()) {
                GenerationProject dline = new GenerationProject();
                dline.setWrapperObject((Entity)object);
                this.ProjectLines._add(dline);
            }
        }
        return this.ProjectLines;
    }
}

