/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.maf.rpp.pac.blockbase.impl;

import com.ibm.pdp.maf.rpp.container.impl.MAFArrayList;
import com.ibm.pdp.maf.rpp.pac.blockbase.BlockBaseCategoryValues;
import com.ibm.pdp.maf.rpp.pac.blockbase.BlockBaseTypeValues;
import com.ibm.pdp.maf.rpp.pac.blockbase.OptionGenerationValues;
import com.ibm.pdp.maf.rpp.pac.common.GLine;
import com.ibm.pdp.maf.rpp.pac.common.impl.AbstractRadicalElement;
import com.ibm.pdp.maf.rpp.pac.library.Library;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.maf.rpp.util.impl.ValuesService;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import java.util.List;

public abstract class AbstractBlockBase
extends AbstractRadicalElement
implements com.ibm.pdp.maf.rpp.pac.blockbase.AbstractBlockBase {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Library generationLibrary = null;
    MAFArrayList<GLine> GCLines = null;
    MAFArrayList<GLine> GGLines = null;
    MAFArrayList<GLine> GOLines = null;

    public AbstractBlockBase(Object wrapperObject) {
        super(wrapperObject);
    }

    public String getExternalName() {
        return this.getPacBlockBase().getExternalName();
    }

    public BlockBaseTypeValues getBlockType() {
        return ValuesService.getBlockBaseTypeValue(this.getPacBlockBase().getBlockType().getValue());
    }

    public BlockBaseCategoryValues getType() {
        return ValuesService.getBlockBaseCategoryValue(this.getPacBlockBase().getBlockType().getName());
    }

    public String getVersionNumber() {
        return this.getPacBlockBase().getVersion();
    }

    @Override
    public List<GLine> getGCLines() {
        if (this.GCLines == null && this.getPacBlockBase().getGCLines() != null) {
            this.GCLines = new MAFArrayList();
            ValuesService.setGGblockbase(false);
            for (Object object : this.getPacBlockBase().getGCLines()) {
                this.GCLines = ValuesService.getGLines(this.GCLines, object);
            }
        }
        return this.GCLines;
    }

    public List<GLine> getGGLines() {
        if (this.GGLines == null && this.getPacBlockBase().getGGLines() != null) {
            this.GGLines = new MAFArrayList();
            ValuesService.setGGblockbase(true);
            for (Object object : this.getPacBlockBase().getGGLines()) {
                this.GGLines = ValuesService.getGLines(this.GGLines, object);
            }
        }
        return this.GGLines;
    }

    public List<GLine> getGOLines() {
        if (this.GOLines == null && this.getPacBlockBase().getGOLines() != null) {
            this.GOLines = new MAFArrayList();
            ValuesService.setGGblockbase(false);
            for (Object object : this.getPacBlockBase().getGOLines()) {
                this.GOLines = ValuesService.getGLines(this.GOLines, object);
            }
        }
        return this.GOLines;
    }

    public Library getGenerationLibrary() {
        PacBlockBase blockBase;
        if (this.generationLibrary == null && (blockBase = this.getPacBlockBase()) != null) {
            this.generationLibrary = (Library)AbstractBlockBase.getRadicalElement((RadicalEntity)blockBase.getGenerationParameter());
        }
        return this.generationLibrary;
    }

    protected PacBlockBase getPacBlockBase() {
        return (PacBlockBase)this.getWrapperObject();
    }

    public String getGenerateProject() {
        String result = this.getPacBlockBase().getGenerateProject();
        if (result == null || result.trim().length() == 0) {
            String string = result = this.getPacBlockBase().getGenerationParameter() == null ? null : this.getPacBlockBase().getGenerationParameter().getCobolProject();
        }
        if (result == null || result.trim().length() == 0) {
            result = this.getProject();
        }
        return result;
    }

    public String getGenerateFolder() {
        String result = this.getPacBlockBase().getGenerateFolder();
        if (result == null || result.trim().length() == 0) {
            String string = result = this.getPacBlockBase().getGenerationParameter() == null ? null : this.getPacBlockBase().getGenerationParameter().getCobolFolder();
        }
        if (result == null || result.trim().length() == 0) {
            result = String.valueOf(MAFModelManager.getInstance().getGenRootFolder(this.getProject())) + '/' + this.getPackage().replace('.', '/');
        }
        return result;
    }

    public OptionGenerationValues getGenerationOption() {
        return ValuesService.getOptionGenerationValue(this.getPacBlockBase().getGenerationOption().getValue());
    }
}

