/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.maf.rpp.model.internal.local;

import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.kernel.UserEntity;
import com.ibm.pdp.maf.rpp.kernel.impl.RadicalElementType;
import com.ibm.pdp.mdl.meta.Document;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class MAFModelServiceCache {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static MAFModelServiceCache instance;
    private Map<String, SoftReference<RadicalElement>> softReferences = null;
    private Map<String, String> mapDocuments = null;
    private boolean isEnabled = "true".equals(System.getProperty("rppMafCacheEnabled"));

    public static MAFModelServiceCache getInstance() {
        if (instance == null) {
            MAFModelServiceCache.init();
        }
        return instance;
    }

    private static synchronized void init() {
        instance = new MAFModelServiceCache();
        MAFModelServiceCache.instance.softReferences = new HashMap<String, SoftReference<RadicalElement>>();
        MAFModelServiceCache.instance.mapDocuments = new HashMap<String, String>();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void clear() {
        this.softReferences = new HashMap<String, SoftReference<RadicalElement>>();
    }

    public void addRadicalElement(RadicalElement radicalElement) {
        if (this.isEnabled) {
            String metaType = "";
            if (radicalElement instanceof UserEntity) {
                metaType = ((UserEntity)radicalElement).getMetaEntity().getName();
            }
            this.softReferences.put(String.valueOf(radicalElement.getProject()) + '#' + (radicalElement.getPackage() == null ? "" : radicalElement.getPackage()) + '#' + metaType + '#' + radicalElement.getName() + '#' + ((com.ibm.pdp.maf.rpp.kernel.impl.RadicalElement)radicalElement).getRadicalElementType(), new SoftReference<RadicalElement>(radicalElement));
        }
    }

    public RadicalElement getRadicalElement(String projectName, String packageName, String metaTypeName, String entityName, RadicalElementType radicalElementType) {
        SoftReference<RadicalElement> softReference;
        if (this.isEnabled && (softReference = this.softReferences.get(String.valueOf(projectName) + '#' + (packageName == null ? "" : packageName) + '#' + (metaTypeName == null ? "" : metaTypeName) + '#' + entityName + '#' + radicalElementType)) != null && softReference.get() != null) {
            return softReference.get();
        }
        return null;
    }

    public void addRadicalElement(Document document, RadicalElement radicalElement) {
        if (this.isEnabled) {
            String key = PTModelService.getDesignId((String)document.getProject(), (String)document.getPackage(), (String)document.getName(), (String)document.getMetaType(), (String)document.getType());
            String metaType = "";
            if (radicalElement instanceof UserEntity) {
                metaType = ((UserEntity)radicalElement).getMetaEntity().getName();
            }
            this.mapDocuments.put(key, String.valueOf(radicalElement.getProject()) + '#' + (radicalElement.getPackage() == null ? "" : radicalElement.getPackage()) + '#' + metaType + '#' + radicalElement.getName() + '#' + ((com.ibm.pdp.maf.rpp.kernel.impl.RadicalElement)radicalElement).getRadicalElementType());
        }
    }

    public RadicalElement getRadicalElement(Document document) {
        SoftReference<RadicalElement> softReference;
        String key;
        String softKey;
        if (this.isEnabled && (softKey = this.mapDocuments.get(key = PTModelService.getDesignId((String)document.getProject(), (String)document.getPackage(), (String)document.getName(), (String)document.getMetaType(), (String)document.getType()))) != null && (softReference = this.softReferences.get(softKey)) != null && softReference.get() != null) {
            return softReference.get();
        }
        return null;
    }
}

