/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.maf.rpp.model.internal.local;

import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.service.IPTElement;
import com.ibm.pdp.explorer.model.service.IPTLocation;
import com.ibm.pdp.explorer.model.service.IPTSearchPattern;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.model.service.PTSearchPattern;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.maf.rpp.kernel.IProblem;
import com.ibm.pdp.maf.rpp.kernel.Level;
import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.kernel.impl.Problem;
import com.ibm.pdp.maf.rpp.model.internal.local.MAFModelManagerService;
import com.ibm.pdp.maf.rpp.service.IMAFSearchPattern;
import com.ibm.pdp.maf.rpp.service.impl.AbstractMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;

public class MAFModelService
extends AbstractMAFModelService {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static MAFModelService instance = null;
    private static Map<String, String> locationsMaps = null;

    protected static MAFModelService getInstance() {
        if (instance == null) {
            instance = new MAFModelService();
        }
        return instance;
    }

    public boolean isLocationOpen(String locationName) {
        IPTLocation iptLocation = ((MAFModelManagerService)MAFModelManager.getInstance()).getLocation(locationName);
        if (iptLocation != null) {
            return iptLocation.isOpened();
        }
        return false;
    }

    public boolean openLocation(String locationName) {
        IPTLocation iptLocation = ((MAFModelManagerService)MAFModelManager.getInstance()).getLocation(locationName);
        if (iptLocation != null) {
            try {
                ((MAFModelManagerService)MAFModelManager.getInstance()).openLocation(iptLocation);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public boolean closeLocation(String locationName) {
        IPTLocation iptLocation = ((MAFModelManagerService)MAFModelManager.getInstance()).getLocation(locationName);
        if (iptLocation != null) {
            try {
                ((MAFModelManagerService)MAFModelManager.getInstance()).closeLocation(iptLocation);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public List<IProblem> getProblems(RadicalElement radicalElement) {
        IFile file;
        RadicalEntity radicalEntity;
        ArrayList<IProblem> problems = new ArrayList<IProblem>();
        if (radicalElement != null && (radicalEntity = (RadicalEntity)((com.ibm.pdp.maf.rpp.kernel.impl.RadicalElement)radicalElement).getWrapperObject()) != null && (file = radicalEntity.getFile(null)) != null) {
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    Integer severity = (Integer)marker.getAttribute("severity");
                    String message = (String)marker.getAttribute("message");
                    String location = (String)marker.getAttribute("location");
                    Level level = null;
                    if (severity == 0) {
                        level = Level.INFO;
                    } else if (severity == 1) {
                        level = Level.WARNING;
                    } else if (severity == 2) {
                        level = Level.ERROR;
                    }
                    Problem problem = new Problem(level, message, location);
                    problems.add((IProblem)problem);
                    ++n2;
                }
            }
            catch (Exception ce) {
                throw (RuntimeException)ce;
            }
        }
        return problems;
    }

    private RadicalElement getRadicalElement(IPTElement element) {
        return MAFModelService.createRadicalElement((Document)element.getDocument());
    }

    public List<RadicalElement> search(IMAFSearchPattern searchPattern) {
        ArrayList<RadicalElement> search = new ArrayList<RadicalElement>();
        PTSearchPattern searchP = new PTSearchPattern();
        searchP.setExpression(searchPattern.getExpression());
        searchP.setCaseSensitive(searchPattern.isCaseSensitive());
        if (searchPattern.getFilteredTypes().isEmpty()) {
            searchP.setSearchFor(0);
        } else {
            searchP.setSearchFor(1);
            searchP.getSearchForTypes().addAll(searchPattern.getFilteredTypes());
        }
        searchP.setLimitTo(searchPattern.getLimitTo());
        if (searchPattern.getLocationName() == null || searchPattern.getLocationName().length() == 0) {
            searchP.setLocationScope(0);
        } else {
            searchP.setLocationScope(1);
            searchP.setLocationName(searchPattern.getLocationName());
        }
        searchP.setDomain(searchPattern.getDomain());
        searchP.setLevelOperand(searchPattern.getLevelOperand());
        searchP.setLevel(searchPattern.getLevel());
        searchP.setSearchIn(searchPattern.getSearchIn());
        if (searchPattern.getSearchIn() == 1) {
            searchP.getSearchInProjects().addAll(searchPattern.getSearchInProjects());
        }
        List elements = PTModelService.search((IPTSearchPattern)searchP);
        for (IPTElement element : elements) {
            search.add(this.getRadicalElement(element));
        }
        return search;
    }

    public List<String> searchIds(IMAFSearchPattern searchPattern) {
        List<RadicalElement> list = this.search(searchPattern);
        ArrayList<String> ids = new ArrayList<String>(list.size() + 10);
        for (RadicalElement radicalElement : list) {
            ids.add(radicalElement.getDesignId());
        }
        return ids;
    }

    public List<String> referencesIds(RadicalElement radicalElement, boolean subReferences) {
        List list = this.references(radicalElement, subReferences);
        ArrayList<String> ids = new ArrayList<String>(list.size() + 10);
        for (RadicalElement radicalElementRef : list) {
            ids.add(radicalElementRef.getDesignId());
        }
        return ids;
    }

    public RadicalElement getRadicalElement(String designId) {
        PTLocation location;
        IPTElement element;
        String locationName;
        String projectName = MetadataService.getProject((String)designId);
        if (locationsMaps == null) {
            locationsMaps = new HashMap<String, String>();
        }
        if ((locationName = locationsMaps.get(projectName)) == null) {
            PTNature nature = PTNature.getNature((String)projectName);
            if (nature == null) {
                return null;
            }
            locationName = nature.getLocation();
            if (locationName == null) {
                return null;
            }
            locationsMaps.put(projectName, locationName);
        }
        if ((element = (location = PTModelManager.getLocation((String)locationName)).getElement(designId)) != null) {
            return this.getRadicalElement(element.getProject().getName(), element.getPackage().getName(), element.getDocument().getMetaType(), element.getName(), element.getDocument().getType());
        }
        return null;
    }
}

