/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.maf.rpp.model.internal.local;

import com.ibm.pdp.explorer.model.service.IPTElement;
import com.ibm.pdp.explorer.model.service.IPTLocation;
import com.ibm.pdp.explorer.model.service.IPTReference;
import com.ibm.pdp.explorer.model.service.IPTRelation;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.maf.rpp.container.impl.MAFArrayList;
import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.kernel.UserEntity;
import com.ibm.pdp.maf.rpp.kernel.impl.RadicalElementType;
import com.ibm.pdp.maf.rpp.model.internal.local.MAFModelService;
import com.ibm.pdp.maf.rpp.model.internal.local.MAFModelServiceCache;
import com.ibm.pdp.maf.rpp.service.IMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.AbstractMAFModelManagerService;
import com.ibm.pdp.maf.rpp.service.impl.AbstractMAFModelService;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.maf.rpp.util.impl.MAFResolver;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.pdppath.service.PdpPathService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class MAFModelManagerService
extends AbstractMAFModelManagerService {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public String getGenRootFolder(String project) {
        return PdpPathService.getGenRootFolder((String)project);
    }

    public IMAFModelService getServiceInstance() {
        return MAFModelService.getInstance();
    }

    public RadicalElement getRadicalElement(String projectName, String packageName, String metaTypeName, String entityName, RadicalElementType radicalElementType) {
        RadicalElement radicalElement = MAFModelServiceCache.getInstance().getRadicalElement(projectName, packageName, metaTypeName, entityName, radicalElementType);
        if (radicalElement != null) {
            return radicalElement;
        }
        RadicalEntity radicalEntity = this.searchRadicalEntity(projectName, packageName, metaTypeName, entityName, AbstractMAFModelService.getRadicalEntityType((RadicalElementType)radicalElementType));
        if (radicalEntity != null) {
            radicalElement = this.createRadicalElement(radicalEntity);
        }
        if (radicalElement != null && ((com.ibm.pdp.maf.rpp.kernel.impl.RadicalElement)radicalElement).getRadicalElementType() == radicalElementType) {
            MAFModelServiceCache.getInstance().addRadicalElement(radicalElement);
            return radicalElement;
        }
        return null;
    }

    public RadicalElement getRadicalElement(RadicalEntity radicalEntity) {
        if (radicalEntity == null) {
            return null;
        }
        RadicalElement radicalElement = MAFModelServiceCache.getInstance().getRadicalElement(radicalEntity.getProject(), radicalEntity.getPackage(), radicalEntity instanceof UserEntity ? ((UserEntity)radicalEntity).getMetaEntity().getName() : null, radicalEntity.getName(), AbstractMAFModelService.getRadicalElementType((RadicalEntity)radicalEntity));
        if (radicalElement != null) {
            return radicalElement;
        }
        if (radicalEntity.eIsProxy() && MAFResolver.getInstance().getMAFResolvingMode() == 1) {
            for (String path : MAFResolver.getInstance().getMAFPaths()) {
                String designId = MetadataService.getId((String)path, (String)"", (String)radicalEntity.getProxyName(), (String)"", (String)radicalEntity.eClass().getName().toLowerCase());
                RadicalEntity registeredObject = (RadicalEntity)MAFResolver.getInstance().getMAFRegistry().get(designId);
                if (registeredObject == null || (radicalElement = MAFModelManager.getInstance().getRadicalElement(registeredObject)) == null) continue;
                return radicalElement;
            }
        }
        return this.createRadicalElement(radicalEntity);
    }

    public List<RadicalElement> references(RadicalElement radicalElement, boolean subReferences, String relationName) {
        MAFArrayList references = new MAFArrayList();
        RadicalEntity radicalEntity = (RadicalEntity)((com.ibm.pdp.maf.rpp.kernel.impl.RadicalElement)radicalElement).getWrapperObject();
        String locationName = radicalEntity.getLocation();
        IPTLocation location = this.getLocation(locationName);
        if (location == null) {
            return references;
        }
        if (!location.isOpened()) {
            return references;
        }
        String designId = radicalEntity.getDesignId(radicalEntity.getProject());
        block0: for (IPTReference reference : PTModelService.getReferences((String)designId, (int)(subReferences ? 0 : 1))) {
            if (relationName == null) {
                IPTElement superElement = location.getElement(subReferences ? reference.getTargetId() : reference.getSourceId());
                RadicalElement ref = this.getRadicalElement(superElement.getDocument());
                if (ref == null) continue;
                references._add((Object)ref);
                continue;
            }
            for (IPTRelation relation : reference.getRelations().values()) {
                IPTElement superElement;
                RadicalElement ref;
                if (!relation.getName().equals(relationName) || (ref = this.getRadicalElement((superElement = location.getElement(reference.getSourceId())).getDocument())) == null) continue;
                references._add((Object)ref);
                continue block0;
            }
        }
        return references;
    }

    public RadicalEntity searchRadicalEntity(String fromProject, String packageName, String metaTypeName, String entityCodeToSearch, String entityType) {
        String pkg;
        RadicalEntity radicalEntity = null;
        String packName = packageName == null ? "" : packageName;
        ArrayList<String> packages = new ArrayList<String>();
        int i = 0;
        while (i < packName.length()) {
            if (packName.charAt(i) == '.') {
                packages.add(packName.substring(0, i));
            }
            ++i;
        }
        packages.add(packName);
        i = packages.size() - 1;
        while (i >= 0) {
            pkg = (String)packages.get(i);
            IPath path = null;
            path = metaTypeName == null ? PTModelService.getPath((String)fromProject, (String)pkg, (String)entityCodeToSearch, (String)entityType) : PTModelService.getPath((String)fromProject, (String)pkg, (String)entityCodeToSearch, (String)metaTypeName, (String)entityType);
            RadicalEntity re = PTModelService.getResource((IPath)path);
            if (re != null) {
                radicalEntity = re;
                break;
            }
            --i;
        }
        if (radicalEntity == null) {
            i = packages.size() - 1;
            while (i >= 0) {
                pkg = (String)packages.get(i);
                RadicalEntity re = null;
                re = metaTypeName == null ? PTModelService.resolveResource((String)fromProject, (String)pkg, (String)entityCodeToSearch, (String)entityType) : PTModelService.resolveResource((String)fromProject, (String)pkg, (String)entityCodeToSearch, (String)metaTypeName, (String)entityType);
                if (re != null) {
                    radicalEntity = re;
                    break;
                }
                --i;
            }
        }
        return radicalEntity;
    }

    private RadicalElement createRadicalElement(RadicalEntity radicalEntity) {
        RadicalElement radicalElement = AbstractMAFModelService.createRadicalElement((RadicalEntity)radicalEntity);
        MAFModelServiceCache.getInstance().addRadicalElement(radicalElement);
        return radicalElement;
    }

    public RadicalElement getRadicalElement(Document document) {
        RadicalElement radicalElement = MAFModelServiceCache.getInstance().getRadicalElement(document);
        if (radicalElement != null) {
            return radicalElement;
        }
        radicalElement = AbstractMAFModelService.createRadicalElement((Document)document);
        MAFModelServiceCache.getInstance().addRadicalElement(document, radicalElement);
        return radicalElement;
    }

    protected IPTLocation getLocation(String locationName) {
        Iterator locations = PTModelService.locations();
        while (locations.hasNext()) {
            IPTLocation current = (IPTLocation)locations.next();
            if (!current.getName().equals(locationName)) continue;
            return current;
        }
        return null;
    }

    protected void openLocation(IPTLocation iptLocation) throws Exception {
        Class[] parameterTypes = new Class[]{Boolean.TYPE, Boolean.TYPE};
        Method openMethod = iptLocation.getClass().getMethod("open", parameterTypes);
        Object[] args = new Object[]{true, false};
        openMethod.invoke((Object)iptLocation, args);
    }

    protected void closeLocation(IPTLocation iptLocation) throws Exception {
        Class[] parameterTypes = new Class[]{};
        Method openMethod = iptLocation.getClass().getMethod("close", parameterTypes);
        Object[] args = new Object[]{};
        openMethod.invoke((Object)iptLocation, args);
    }

    public int countReferences(String designId, int direction) {
        return PTModelService.countReferences((String)designId, (int)direction);
    }
}

