/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.view.tool;

import com.ibm.pdp.explorer.view.tool.PTAttributeItem;
import com.ibm.pdp.explorer.wizard.PTWizardLabel;
import com.ibm.pdp.macro.pacbase.nls.PdpMacroPacbaseLabels;
import com.ibm.pdp.macro.pacbase.view.MacroParameter;
import com.ibm.pdp.macro.pacbase.view.tool.IMacroXRefFieldConstants;
import com.ibm.pdp.macro.pacbase.view.tool.MacroXRefSerializableItem;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.csv.CsvWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class MacroXRefSerializer
implements IMacroXRefFieldConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015,2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int _BUFFER_SIZE = 10000;
    private static final String _PARAM_PREFIX = "$";

    public static void processSerialization(List<MacroXRefSerializableItem> serializables, List<PTAttributeItem> preferredAttributes, String outputFile) {
        ByteArrayOutputStream csvStream = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(csvStream), 10000);
        String separator = PTWizardLabel.getString((String)PTWizardLabel._CSV_SEPARATOR);
        char csvSep = ',';
        if (separator.length() > 0) {
            csvSep = separator.charAt(0);
        }
        CsvWriter csvWriter = new CsvWriter((Writer)writer, csvSep, '\"', System.getProperty("line.separator"));
        for (PTAttributeItem attribute : preferredAttributes) {
            if (attribute.getId().startsWith(_PARAM_PREFIX)) {
                csvWriter.addCell(NLS.bind((String)PdpMacroPacbaseLabels._PARAM_VALUE, (Object)attribute.getId()));
                csvWriter.addCell(NLS.bind((String)PdpMacroPacbaseLabels._PARAM_COMMENT, (Object)attribute.getId()));
                continue;
            }
            csvWriter.addCell(attribute.getLabel());
        }
        csvWriter.endOfRow();
        for (MacroXRefSerializableItem serializable : serializables) {
            Map<String, MacroParameter> macroParameters = MacroXRefSerializer.getMacroParameters(serializable);
            for (PTAttributeItem attribute : preferredAttributes) {
                if (attribute.getId().equals("Project")) {
                    String projectName = serializable.getMacroXRef().getElement().getProject().getName();
                    if (projectName.length() > 0 && projectName.charAt(0) == '%') {
                        projectName = projectName.substring(1);
                    }
                    csvWriter.addCell(projectName);
                    continue;
                }
                if (attribute.getId().equals("Package")) {
                    csvWriter.addCell(serializable.getMacroXRef().getElement().getPackage().getName());
                    continue;
                }
                if (attribute.getId().equals("Class")) {
                    csvWriter.addCell(serializable.getMacroXRef().getElement().getFolder().getName());
                    continue;
                }
                if (attribute.getId().equals("Name")) {
                    csvWriter.addCell(serializable.getMacroXRef().getElement().getName());
                    continue;
                }
                if (attribute.getId().equals("LineNumber")) {
                    csvWriter.addCell(serializable.getMacroXRef().getCpLineNumber());
                    continue;
                }
                if (attribute.getId().equals("Comment")) {
                    csvWriter.addCell(serializable.getMacroXRef().getCpLineComment());
                    continue;
                }
                if (!attribute.getId().startsWith(_PARAM_PREFIX)) continue;
                MacroParameter macroParameter = macroParameters.get(attribute.getId());
                csvWriter.addCell(macroParameter.getValue());
                csvWriter.addCell(macroParameter.getComment());
            }
            csvWriter.endOfRow();
        }
        csvWriter.close();
        try {
            FileOutputStream fos = new FileOutputStream(outputFile);
            BufferedOutputStream outputStreamBuffer = new BufferedOutputStream(fos, 10000);
            outputStreamBuffer.write(csvStream.toByteArray());
            outputStreamBuffer.close();
            fos.close();
        }
        catch (IOException e) {
            Util.rethrow((Throwable)e);
        }
    }

    private static Map<String, MacroParameter> getMacroParameters(MacroXRefSerializableItem serializable) {
        HashMap<String, MacroParameter> macroParameters = new HashMap<String, MacroParameter>();
        int parametersSize = serializable.getMacroXRef().getNbNewParameter();
        int i = 0;
        while (i < _PARAM_KEYS.length) {
            if (i < parametersSize) {
                macroParameters.put(_PARAM_KEYS[i], serializable.getMacroXRef().getParameter(i));
            } else {
                macroParameters.put(_PARAM_KEYS[i], new MacroParameter("", ""));
            }
            ++i;
        }
        return macroParameters;
    }
}

