/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.view;

import com.ibm.pdp.explorer.associate.IPTContextualDocumentWrapper;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.IPTSortedItem;
import com.ibm.pdp.explorer.model.PTArtifact;
import com.ibm.pdp.explorer.model.PTFacet;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.PTPredefinedFolder;
import com.ibm.pdp.explorer.model.service.IPTElement;
import com.ibm.pdp.macro.pacbase.view.MacroParameter;
import com.ibm.pdp.macro.pacbase.view.PTCrossReferenceView;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.io.MetadataAccess;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacMacroParameter;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;

public class ReferencedEntity
implements IPTContextualDocumentWrapper,
IPTSortedItem,
IAdaptable {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Document metaDocument = MetaFactory.eINSTANCE.createDocument();
    private String _context = null;
    private IPath eltPath;
    private int cpLineNumber;
    private String cpLineComment;
    private boolean cpLineToModify = false;
    private MacroParameter[] parameters;

    public ReferencedEntity(RadicalEntity re, PacCPLine cpLine) {
        this.metaDocument.setProject(re.getProject());
        this.metaDocument.setPackage(re.getPackage());
        this.metaDocument.setName(re.getName());
        this.metaDocument.setType(re.eClass().getName().toLowerCase());
        this.metaDocument.setLabel(re.getLabel());
        this.eltPath = re.getPath(re.getProject());
        this.cpLineNumber = cpLine.getLineNumber();
        this.cpLineComment = cpLine.getComment();
        this.initParameters(cpLine);
    }

    private void initParameters(PacCPLine cpLine) {
        this.parameters = new MacroParameter[20];
        int i = 0;
        while (i < this.parameters.length) {
            if (i < cpLine.getParameters().size()) {
                PacMacroParameter parameter = (PacMacroParameter)cpLine.getParameters().get(i);
                this.parameters[i] = new MacroParameter(parameter.getValue(), parameter.getComment());
            } else {
                this.parameters[i] = new MacroParameter("", "");
            }
            ++i;
        }
    }

    public Document getDocument() {
        return this.metaDocument;
    }

    public String getCpLineNumber() {
        String lineNumber = "";
        if (this.cpLineNumber != 0) {
            lineNumber = String.valueOf(this.cpLineNumber);
        }
        return lineNumber;
    }

    public String getCpLineComment() {
        return String.valueOf(this.cpLineComment);
    }

    public PacCPLine getCPLine(String macroName) {
        RadicalEntity re = PTEditorService.getSharedResource((IPath)this.eltPath);
        Iterator<?> cpLinesIterator = PTCrossReferenceView.SearchCPLinesFrom(re);
        if (cpLinesIterator != null) {
            while (cpLinesIterator.hasNext()) {
                PacCPLine cpLine;
                Object obj = cpLinesIterator.next();
                if (!(obj instanceof PacCPLine) || !(cpLine = (PacCPLine)obj).getMacro().getName().equals(macroName) || cpLine.getLineNumber() != this.cpLineNumber) continue;
                return cpLine;
            }
        }
        return null;
    }

    public IPTElement getElement() {
        RadicalEntity re = PTEditorService.getSharedResource((IPath)this.eltPath);
        return PTModelManager.getLocation((String)re.getLocation()).getElement(re.getDesignId(re.getProject()));
    }

    public MacroParameter getParameter(int i) {
        return this.parameters[i];
    }

    public int getNbNewParameter() {
        int nbNewParameter = 0;
        MacroParameter[] macroParameterArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            MacroParameter parameter = macroParameterArray[n2];
            if (parameter.getValue().trim().length() > 0 || parameter.getComment().trim().length() > 0) {
                ++nbNewParameter;
            }
            ++n2;
        }
        return nbNewParameter;
    }

    public boolean isModified() {
        return this.cpLineToModify;
    }

    public void setModified(boolean modified) {
        this.cpLineToModify = modified;
    }

    public void setParameter(int i, MacroParameter parameter) {
        this.cpLineToModify = true;
        this.parameters[i] = parameter;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == PTArtifact.class) {
            return new PTArtifact(this.getDocument());
        }
        return null;
    }

    public String getContext() {
        if (this._context == null) {
            this._context = ReferencedEntity.getContext(this.getDocument());
        }
        return this._context;
    }

    public static String getContext(Document metaDocument) {
        MetadataAccess metadataAccess;
        List metaReferences;
        String context = metaDocument.getProject();
        if (!PTModelManager.accept((String)metaDocument.getType()) && (metaReferences = (metadataAccess = MetadataAccess.getMetadataAccess()).readReferences("entrypoint", metaDocument.getId(), 0)).size() > 0) {
            String[] tokens = MetadataService.getTokens((String)((Reference)metaReferences.get(0)).getTargetId());
            context = tokens[0];
        }
        return context;
    }

    public boolean isResolved() {
        return this.metaDocument.getProject().length() != 0;
    }

    public String getName() {
        return String.valueOf(this.getDocument().getName()) + this.completeWithZero(this.getCpLineNumber());
    }

    public String getPackageName() {
        return this.getDocument().getPackage();
    }

    public String getProjectName() {
        return this.getDocument().getProject();
    }

    public String getFolderName() {
        PTFacet preferredFacet = PTModelManager.getFacet((String)PTModelManager.getPreferredFacet());
        for (PTPredefinedFolder folder : preferredFacet.getFolders()) {
            if (!this.getType().equals(folder.getName())) continue;
            return String.valueOf(folder.getDisplayName()) + this.completeWithZero(this.getCpLineNumber());
        }
        return "";
    }

    private String completeWithZero(String lineNumber) {
        StringBuffer sb = new StringBuffer("");
        int i = lineNumber.length();
        while (i < 2) {
            sb.append("0");
            ++i;
        }
        sb.append(lineNumber);
        return sb.toString();
    }

    public String getType() {
        return this.getDocument().getType();
    }
}

