/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.view;

import com.ibm.pdp.explorer.designpath.PTDesignPath;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.reference.PTReferenceItem;
import com.ibm.pdp.explorer.model.result.PTSearchRefResult;
import com.ibm.pdp.explorer.model.service.IPTReference;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.model.tool.PTProjectScope;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.explorer.plugin.IPTMenuContributor;
import com.ibm.pdp.explorer.plugin.IPTPreferences;
import com.ibm.pdp.explorer.view.IPTSerializableView;
import com.ibm.pdp.explorer.view.IPTStructuredViewer;
import com.ibm.pdp.explorer.view.IPTTypeFilteredView;
import com.ibm.pdp.explorer.view.PTView;
import com.ibm.pdp.explorer.view.action.PTExportQueryAction;
import com.ibm.pdp.explorer.view.action.PTOpenAction;
import com.ibm.pdp.explorer.view.actiongroup.PTDisplayActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTGenerateActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTOpenActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTReferenceFilterActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTSearchRefActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTSortActionGroup;
import com.ibm.pdp.explorer.view.service.IPTView;
import com.ibm.pdp.explorer.view.tool.IPTVisionListener;
import com.ibm.pdp.explorer.view.tool.PTAttributeItem;
import com.ibm.pdp.explorer.view.tool.PTSerializerConfiguration;
import com.ibm.pdp.explorer.view.tool.PTViewerComparator;
import com.ibm.pdp.explorer.view.tool.PTVisionGroup;
import com.ibm.pdp.explorer.wizard.PTWizardLabel;
import com.ibm.pdp.macro.pacbase.action.EditParametersAction;
import com.ibm.pdp.macro.pacbase.action.PTModifyParameterAction;
import com.ibm.pdp.macro.pacbase.action.PacHistoryDropdownAction;
import com.ibm.pdp.macro.pacbase.action.PacReplayAction;
import com.ibm.pdp.macro.pacbase.nls.PdpMacroPacbaseLabels;
import com.ibm.pdp.macro.pacbase.outline.OutlineCrossRefTableContentProvider;
import com.ibm.pdp.macro.pacbase.outline.OutlineCrossRefTableLabelProvider;
import com.ibm.pdp.macro.pacbase.view.PTCrossReferenceTreeViewer;
import com.ibm.pdp.macro.pacbase.view.ReferencedEntity;
import com.ibm.pdp.macro.pacbase.view.tool.IMacroXRefFieldConstants;
import com.ibm.pdp.macro.pacbase.view.tool.MacroXRefSerializableItem;
import com.ibm.pdp.macro.pacbase.view.tool.MacroXRefSerializer;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.util.PacCommunicationMonitorWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacDialogWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacFolderWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacProgramWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacScreenWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacServerWrapper;
import com.ibm.pdp.pac.explorer.model.PacCrossRefManager;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.widgets.ui.celleditor.PDPGenericCellEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class PTCrossReferenceView
extends PTView
implements IPTSerializableView,
IPTTypeFilteredView,
IPTVisionListener,
IMacroXRefFieldConstants,
IPTPreferences {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PTSortActionGroup _sortActionGroup;
    private PTDisplayActionGroup _displayActionGroup;
    private PTReferenceFilterActionGroup _filterActionGroup;
    private PTOpenActionGroup _openActionGroup;
    private PTGenerateActionGroup _generateActionGroup;
    private PTSearchRefActionGroup _searchRefActionGroup;
    private PacReplayAction _replayAction;
    private PacHistoryDropdownAction _historyAction;
    private Set<String> _excludedTypes;
    private String _context = "";
    private int _vision = 3;
    private PTVisionGroup _grpVision;
    private PTSearchRefResult _inputResult = null;
    public static final String _HELP_PLUGIN = "com.ibm.pdp.doc.cshelp";
    private String CONTEXT_ID_FOR_HELP = "Macro_x";
    private List<ReferencedEntity> paramsTable;
    private List<IPTReference> entitiesList;
    private Document _macroDocument;
    public static final String _VIEW_ID = String.valueOf(PTCrossReferenceView.class.getName()) + "_ID";
    private PTModifyParameterAction _modifyParameterAction;
    private EditParametersAction _editParameterAction;
    private PTExportQueryAction _exportQueryAction;

    public static boolean IsModificationAuthorized(List<IPTReference> entitiesList) {
        boolean okToModify = true;
        Iterator<IPTReference> iteratorN = entitiesList.iterator();
        while (iteratorN.hasNext() && okToModify) {
            IPTReference obj = iteratorN.next();
            String ref = obj.getSourceId();
            IPath path = PTModelService.getPath((String)ref);
            boolean bl = okToModify = okToModify && !PTEditorService.hasRegisteredEditor((IPath)path, null);
        }
        return okToModify;
    }

    public static List<ReferencedEntity> SearchMacroParameterFor(RadicalEntity re, String nameOfMacroRef) {
        Iterator<?> cpLinesIterator = PTCrossReferenceView.SearchCPLinesFrom(re);
        ArrayList<ReferencedEntity> params = new ArrayList<ReferencedEntity>();
        if (cpLinesIterator != null) {
            while (cpLinesIterator.hasNext()) {
                PacCPLine cpLine;
                String nameOfMacro;
                Object obj = cpLinesIterator.next();
                if (!(obj instanceof PacCPLine) || !nameOfMacroRef.equals(nameOfMacro = (cpLine = (PacCPLine)obj).getMacro().getName())) continue;
                params.add(new ReferencedEntity(re, cpLine));
            }
        }
        return params;
    }

    public static Iterator<?> SearchCPLinesFrom(RadicalEntity re) {
        Iterator cpLinesIterator = null;
        switch (re.eClass().getClassifierID()) {
            case 39: {
                PacProgramWrapper p = new PacProgramWrapper((PacProgram)re);
                cpLinesIterator = p.getCPLines().iterator();
                break;
            }
            case 72: {
                PacDialogWrapper p = new PacDialogWrapper((PacDialog)re);
                cpLinesIterator = p.getCPLines().iterator();
                break;
            }
            case 70: {
                PacScreenWrapper p = new PacScreenWrapper((PacScreen)re);
                cpLinesIterator = p.getCPLines().iterator();
                break;
            }
            case 99: {
                PacDialogServer p = (PacDialogServer)re;
                cpLinesIterator = p.getCPLines().iterator();
                break;
            }
            case 101: {
                PacServerWrapper p = new PacServerWrapper((PacServer)re);
                cpLinesIterator = p.getCPLines().iterator();
                break;
            }
            case 119: {
                PacDialogFolder p = (PacDialogFolder)re;
                cpLinesIterator = p.getCPLines().iterator();
                break;
            }
            case 120: {
                PacFolderWrapper p = new PacFolderWrapper((PacFolder)re);
                cpLinesIterator = p.getCPLines().iterator();
                break;
            }
            case 126: {
                PacDialogCommunicationMonitor p = (PacDialogCommunicationMonitor)re;
                cpLinesIterator = p.getCPLines().iterator();
                break;
            }
            case 127: {
                PacCommunicationMonitorWrapper p = new PacCommunicationMonitorWrapper((PacCommunicationMonitor)re);
                cpLinesIterator = p.getCPLines().iterator();
            }
        }
        return cpLinesIterator;
    }

    public void createPartControl(Composite parent) {
        String[] excludedTypes;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextId());
        super.createPartControl(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        gridLayout.verticalSpacing = 1;
        gridLayout.horizontalSpacing = 1;
        parent.setLayout((Layout)gridLayout);
        this._sortMode = 1;
        this._displayMode = 5;
        this._sortMode = this._prefs.getInt("_PREF_REFERENCE_VIEW_SORT", this._sortMode);
        this._displayMode = this._prefs.getInt("_PREF_REFERENCE_VIEW_DISPLAY", this._displayMode);
        String[] stringArray = excludedTypes = this._prefs.get("_PREF_REFERENCE_VIEW_EXCLUDED_TYPES", "").split(",");
        int n = excludedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String excludedType = stringArray[n2];
            if (excludedType.trim().length() > 0) {
                this.getExcludedTypes().add(excludedType);
            }
            ++n2;
        }
        this._grpVision = new PTVisionGroup(parent, 0);
        this._grpVision.setContext(this._context);
        this._grpVision.setVision(this._vision);
        this._grpVision.addListener((IPTVisionListener)this);
        this._trvViewer = new PTCrossReferenceTreeViewer(parent, this, 67588);
        this._trvViewer.setContentProvider((IContentProvider)new OutlineCrossRefTableContentProvider(this.getExcludedTypes(), this._trvViewer));
        this._trvViewer.setLabelProvider((IBaseLabelProvider)new OutlineCrossRefTableLabelProvider(this._displayMode));
        this._trvViewer.setComparator((ViewerComparator)new PTViewerComparator(this._sortMode));
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        data.minimumHeight = 50;
        data.minimumWidth = 50;
        data.widthHint = 300;
        data.heightHint = 300;
        this._trvViewer.getTree().setLayoutData((Object)data);
        int[] sortModes = new int[]{1, 3};
        this._sortActionGroup = new PTSortActionGroup((IPTStructuredViewer)this, sortModes);
        int[] displayModes = new int[]{4};
        this._displayActionGroup = new PTDisplayActionGroup((IPTStructuredViewer)this, displayModes);
        this._filterActionGroup = new PTReferenceFilterActionGroup((IPTView)this);
        this._modifyParameterAction = new PTModifyParameterAction(this);
        this._editParameterAction = new EditParametersAction(this);
        this._exportQueryAction = new PTExportQueryAction((IPTSerializableView)this);
        this._replayAction = new PacReplayAction((IPTView)this);
        this._historyAction = new PacHistoryDropdownAction((IPTView)this);
        this._openActionGroup = new PTOpenActionGroup((IPTView)this);
        this._generateActionGroup = new PTGenerateActionGroup();
        this._searchRefActionGroup = new PTSearchRefActionGroup((IPTView)this);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.fillToolBarMenu(toolBarManager);
        IMenuManager barMenuMgr = this.getViewSite().getActionBars().getMenuManager();
        barMenuMgr.setRemoveAllWhenShown(true);
        this.fillActionBarMenu(barMenuMgr);
        barMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                PTCrossReferenceView.this.fillActionBarMenu(menu);
            }
        });
        this.setupData();
        this.setHelp(parent);
        this._trvViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object object = selection.getFirstElement();
                if (object instanceof ReferencedEntity) {
                    PTOpenAction openAction = new PTOpenAction((IPTView)PTCrossReferenceView.this);
                    openAction.run();
                }
            }
        });
        this._trvViewer.getControl().addListener(12, this._tooltipListener);
        this._trvViewer.getControl().addListener(1, this._tooltipListener);
        this._trvViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000C) {
                    PTOpenAction openAction = new PTOpenAction((IPTView)PTCrossReferenceView.this);
                    openAction.run();
                }
            }
        });
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                PTCrossReferenceView.this.fillContextMenu(menu);
                try {
                    for (IPTMenuContributor menuContributor : PTModelManager.getMenuContributors()) {
                        menuContributor.menuAboutToShow(_VIEW_ID, (Viewer)PTCrossReferenceView.this.getTreeViewer(), menu);
                    }
                }
                catch (Exception e) {
                    throw Util.rethrow((Throwable)e);
                }
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this._trvViewer.getTree());
        this._trvViewer.getTree().setMenu(menu);
        this.setupData();
    }

    public void setFocus() {
    }

    public void setInput(Document macroDocument, List<IPTReference> inputObject, boolean hasChanged) {
        this.entitiesList = inputObject;
        this._macroDocument = macroDocument;
        this.paramsTable = new ArrayList<ReferencedEntity>();
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(NLS.bind((String)PdpMacroPacbaseLabels.READ_CROSSREF, (Object)PTCrossReferenceView.this._macroDocument.getName()), PTCrossReferenceView.this.entitiesList.size());
                for (IPTReference reference : PTCrossReferenceView.this.entitiesList) {
                    IPath path = PTModelService.getPath((String)reference.getSourceId());
                    monitor.subTask(NLS.bind((String)PdpMacroPacbaseLabels.READ_CROSSREF_CONTENT, (Object)reference.getSourceId()));
                    RadicalEntity re = PTModelService.getResource((IPath)path);
                    PTCrossReferenceView.this.paramsTable.addAll(PTCrossReferenceView.SearchMacroParameterFor(re, PTCrossReferenceView.this._macroDocument.getName()));
                    monitor.worked(1);
                    if (monitor.isCanceled()) break;
                }
            }
        };
        PTWizardLabel.getString((String)PTWizardLabel._REBUILD_ERROR_LABEL);
        try {
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
            progressDialog.run(true, true, operation);
        }
        catch (Exception e) {
            throw Util.rethrow((Throwable)e);
        }
        if (this._context.equals(null) || this._context.trim().length() < 1 || hasChanged) {
            this._context = ReferencedEntity.getContext(this._macroDocument);
        }
        TreeSet<String> projects = new TreeSet<String>();
        HashSet<String> locations = new HashSet<String>();
        PTNature nature = PTNature.getNature((String)macroDocument.getProject());
        locations.add(nature.getLocation());
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            nature = PTNature.getNature((String)project.getName());
            if (nature != null && locations.contains(nature.getLocation())) {
                projects.add(project.getName());
            }
            ++n2;
        }
        this._grpVision.setList(projects);
        this._grpVision.setContext(this._context);
        this.setPartName(this.getTitle());
        this.setTitleToolTip(this.getPartName());
    }

    public void rebuildViewContent() {
        this.setInput(this._macroDocument, this.entitiesList, false);
    }

    public void setModification(boolean modificationAuthorized) {
        if (!modificationAuthorized && ((PTCrossReferenceTreeViewer)this._trvViewer).isModificationAuthorized()) {
            this.saveCurrentChanges();
        }
        this._editParameterAction.setChecked(modificationAuthorized);
        ((PTCrossReferenceTreeViewer)this._trvViewer).setModificationAuthorized(modificationAuthorized);
    }

    public void saveCurrentChanges() {
        List<ReferencedEntity> allCalledEntities = this.getParamsTable();
        if (allCalledEntities == null) {
            return;
        }
        this.applyCurrentChange();
        boolean rebuildViewContent = false;
        int i = 0;
        while (i < allCalledEntities.size()) {
            ReferencedEntity calledEntity = allCalledEntities.get(i);
            if (calledEntity.isModified()) {
                rebuildViewContent = true;
                MessageBox messageBox = new MessageBox(this.getShell(), 196);
                messageBox.setMessage(PdpMacroPacbaseLabels._REF_CROSSREF_PENDING_CHANGES);
                messageBox.setText(this.getTitle());
                int response = messageBox.open();
                if (response == 64) {
                    this._modifyParameterAction.run();
                    break;
                }
            }
            ++i;
        }
        if (rebuildViewContent) {
            this.rebuildViewContent();
        }
    }

    public String getTitle() {
        StringBuilder buffer = new StringBuilder(PdpMacroPacbaseLabels._REF_CROSSREF_TITLE);
        if (this._macroDocument != null) {
            buffer.append(": ").append(this._macroDocument.getName()).append("  [").append(this._macroDocument.getProject());
            if (this._macroDocument.getPackage().length() > 0) {
                buffer.append("/").append(this._macroDocument.getPackage());
            }
            buffer.append("]");
        }
        return buffer.toString();
    }

    public List<ReferencedEntity> getParamsTable() {
        return this.paramsTable;
    }

    public String getMacroName() {
        return this._macroDocument.getName();
    }

    private void fillToolBarMenu(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this._replayAction);
        toolBarManager.add((IAction)this._historyAction);
        toolBarManager.add((IAction)this._editParameterAction);
        toolBarManager.add((IAction)this._modifyParameterAction);
        toolBarManager.add((IAction)this._exportQueryAction);
    }

    public List<IPTReference> getEntitiesList() {
        return this.entitiesList;
    }

    public PTSerializerConfiguration getSerializerConfiguration() {
        PTAttributeItem[] allAttributes = new PTAttributeItem[]{new PTAttributeItem("Project"), new PTAttributeItem("Package"), new PTAttributeItem("Name"), new PTAttributeItem("Class"), new PTAttributeItem("LineNumber", PdpMacroPacbaseLabels._LINE_NUMBER), new PTAttributeItem("Comment", PdpMacroPacbaseLabels._COMMENT), new PTAttributeItem(_PARAM_KEYS[0], _PARAM_KEYS[0]), new PTAttributeItem(_PARAM_KEYS[1], _PARAM_KEYS[1]), new PTAttributeItem(_PARAM_KEYS[2], _PARAM_KEYS[2]), new PTAttributeItem(_PARAM_KEYS[3], _PARAM_KEYS[3]), new PTAttributeItem(_PARAM_KEYS[4], _PARAM_KEYS[4]), new PTAttributeItem(_PARAM_KEYS[5], _PARAM_KEYS[5]), new PTAttributeItem(_PARAM_KEYS[6], _PARAM_KEYS[6]), new PTAttributeItem(_PARAM_KEYS[7], _PARAM_KEYS[7]), new PTAttributeItem(_PARAM_KEYS[8], _PARAM_KEYS[8]), new PTAttributeItem(_PARAM_KEYS[9], _PARAM_KEYS[9]), new PTAttributeItem(_PARAM_KEYS[10], _PARAM_KEYS[10]), new PTAttributeItem(_PARAM_KEYS[11], _PARAM_KEYS[11]), new PTAttributeItem(_PARAM_KEYS[12], _PARAM_KEYS[12]), new PTAttributeItem(_PARAM_KEYS[13], _PARAM_KEYS[13]), new PTAttributeItem(_PARAM_KEYS[14], _PARAM_KEYS[14]), new PTAttributeItem(_PARAM_KEYS[15], _PARAM_KEYS[15]), new PTAttributeItem(_PARAM_KEYS[16], _PARAM_KEYS[16]), new PTAttributeItem(_PARAM_KEYS[17], _PARAM_KEYS[17]), new PTAttributeItem(_PARAM_KEYS[18], _PARAM_KEYS[18]), new PTAttributeItem(_PARAM_KEYS[19], _PARAM_KEYS[19])};
        String[] defAttributeIds = new String[]{"Project", "Class", "Name", "LineNumber", "Comment", _PARAM_KEYS[0], _PARAM_KEYS[1], _PARAM_KEYS[2], _PARAM_KEYS[3], _PARAM_KEYS[4], _PARAM_KEYS[5], _PARAM_KEYS[6], _PARAM_KEYS[7], _PARAM_KEYS[8], _PARAM_KEYS[9], _PARAM_KEYS[10], _PARAM_KEYS[11], _PARAM_KEYS[12], _PARAM_KEYS[13], _PARAM_KEYS[14], _PARAM_KEYS[15], _PARAM_KEYS[16], _PARAM_KEYS[17], _PARAM_KEYS[18], _PARAM_KEYS[19]};
        String prefKey = _VIEW_ID;
        return new PTSerializerConfiguration(allAttributes, defAttributeIds, prefKey);
    }

    public void serialize(List<PTAttributeItem> preferredAttributes, String outputFile) {
        if (this.paramsTable == null) {
            return;
        }
        ArrayList<MacroXRefSerializableItem> serializables = new ArrayList<MacroXRefSerializableItem>();
        for (ReferencedEntity macroXRef : this.paramsTable) {
            MacroXRefSerializableItem serializable = new MacroXRefSerializableItem(macroXRef);
            serializables.add(serializable);
        }
        MacroXRefSerializer.processSerialization(serializables, preferredAttributes, outputFile);
    }

    private void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.size() > 0) {
            Object firstSelected = selection.getFirstElement();
            if (firstSelected instanceof ReferencedEntity) {
                menu.add((IContributionItem)new Separator(PTOpenActionGroup._SEPARATOR));
                this._openActionGroup.activateOpenWith();
                this._openActionGroup.fillContextMenu(menu);
            }
            if (selection.size() == 1) {
                menu.add((IContributionItem)new Separator(PTGenerateActionGroup._SEPARATOR));
                this._generateActionGroup.fillContextMenu(menu, this.getStructuredSelection());
            }
            menu.add((IContributionItem)new Separator(PTSearchRefActionGroup._SEPARATOR));
            this._searchRefActionGroup.fillContextMenu(menu);
            menu.add((IContributionItem)new Separator("rpp.additions"));
            menu.add((IContributionItem)new Separator("rpp.additions.end"));
        }
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void setInput(Object _entry) {
        if (_entry instanceof ISearchResult) {
            ISearchResult searchResult = (ISearchResult)_entry;
            PTReferenceItem selectedMacro = ((PTSearchRefResult)searchResult).getReferenceItem();
            Document macroH = selectedMacro.getDocument();
            List superReferences = PTModelService.getReferences((String)macroH.getId(), (int)1);
            this.setInput(macroH, superReferences, true);
        }
    }

    public Document getDocument() {
        return this._macroDocument;
    }

    public void refresh() {
        if (this.entitiesList != null) {
            this._trvViewer.refresh();
            int i = 0;
            while (i < this._trvViewer.getTree().getColumnCount()) {
                this._trvViewer.getTree().getColumn(i).pack();
                ++i;
            }
        }
        this.setPartName(this.getTitle());
        this.setTitleToolTip(this.getPartName());
    }

    protected String getContextId() {
        return "com.ibm.pdp.doc.cshelp." + this.CONTEXT_ID_FOR_HELP;
    }

    public void setHelp(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getContextId());
    }

    public void locationSelected(PTLocation location) {
    }

    public void resourceChanged(IResourceDelta deltaEvent) {
    }

    private void fillActionBarMenu(IMenuManager menu) {
        this._sortActionGroup.fillMenu(menu);
        this._displayActionGroup.fillMenu(menu);
        menu.add((IContributionItem)new Separator());
        this._filterActionGroup.fillMenu(menu, this.getExcludedTypes());
    }

    public Set<String> getExcludedTypes() {
        if (this._excludedTypes == null) {
            this._excludedTypes = new HashSet<String>();
        }
        return this._excludedTypes;
    }

    private void setupData() {
        this._sortActionGroup.check(this._sortMode);
        this._displayActionGroup.check(this._displayMode);
        this.refresh();
    }

    public void setDisplayMode(int displayMode) {
        this._displayMode = displayMode;
        IBaseLabelProvider subProvider = this._trvViewer.getLabelProvider();
        ((OutlineCrossRefTableLabelProvider)subProvider).setDisplayMode(this._displayMode);
    }

    public void handleContextFocusGained() {
    }

    public void handleVisionChange(String context, int vision) {
        this._context = context;
        this._vision = vision;
        if (this.entitiesList == null) {
            return;
        }
        if (this._trvViewer.getControl().isDisposed()) {
            return;
        }
        PTNature nature = PTNature.getNature((String)context);
        if (nature == null) {
            return;
        }
        PTLocation location = PTModelManager.getLocation((String)nature.getLocation());
        if (location == null || !location.isOpened()) {
            return;
        }
        this.getShell().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
        ArrayList<ReferencedEntity> entities = new ArrayList<ReferencedEntity>();
        String streamID = "_LOCAL_STREAM";
        PTDesignPath designPath = location.getDesignPath(false);
        PTProjectScope projectScope = new PTProjectScope(streamID, nature.getLocation(), designPath.getElementaryPaths());
        projectScope.setVision(this._vision);
        projectScope.setContext(this.getContext());
        Set projects = projectScope.getRetainedProjects(streamID, location.getName());
        for (ReferencedEntity referencedEntity : this.paramsTable) {
            if (!projects.contains(referencedEntity.getContext())) continue;
            entities.add(referencedEntity);
        }
        this._trvViewer.setInput(entities);
        this.refresh();
        this.getShell().setCursor(null);
    }

    public boolean isInEditMode() {
        return this._editParameterAction.isChecked();
    }

    public void applyCurrentChange() {
        if (this.getTreeViewer().isCellEditorActive()) {
            CellEditor[] cellEditorArray = this.getTreeViewer().getCellEditors();
            int n = cellEditorArray.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditor editor = cellEditorArray[n2];
                PDPGenericCellEditor abstractCellEditor = (PDPGenericCellEditor)editor;
                if (editor != null && editor.isActivated()) {
                    this.getTreeViewer().getCellModifier().modify(abstractCellEditor.getElement(), abstractCellEditor.getProperty(), abstractCellEditor.getValue());
                    break;
                }
                ++n2;
            }
            this.getTreeViewer().cancelEditing();
        }
    }

    public List<?> getHistoryEntries() {
        return PacCrossRefManager.getSearchCrossRefResults();
    }

    public String getContext() {
        return this._context;
    }
}

