/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.view;

import com.ibm.pdp.macro.pacbase.nls.PdpMacroPacbaseLabels;
import com.ibm.pdp.macro.pacbase.outline.OutlineCrossRefTableContentProvider;
import com.ibm.pdp.macro.pacbase.outline.OutlineCrossRefTableLabelProvider;
import com.ibm.pdp.macro.pacbase.view.MacroParameter;
import com.ibm.pdp.macro.pacbase.view.PDPFreeRefForXP;
import com.ibm.pdp.macro.pacbase.view.PTCrossReferenceView;
import com.ibm.pdp.macro.pacbase.view.ReferencedEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.util.PDPAbstractTreeViewer;
import com.ibm.pdp.widgets.ui.celleditor.PDPAbstractCellModifier;
import com.ibm.pdp.widgets.ui.celleditor.PDPSwitchCellEditor;
import com.ibm.pdp.widgets.ui.celleditor.PDPTextCellEditor;
import com.ibm.pdp.widgets.ui.control.PDPAbstractControl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class PTCrossReferenceTreeViewer
extends PDPAbstractTreeViewer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015,2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String[] _columnsNames = new String[]{PdpMacroPacbaseLabels._CALLED_ENTITIES, PdpMacroPacbaseLabels._LINE_NUMBER, PdpMacroPacbaseLabels._COMMENT, "$1", "$2", "$3", "$4", "$5", "$6", "$7", "$8", "$9", "$0", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H", "$I", "$J"};
    public static final int[] _columnsWidth = new int[]{15, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
    public static final String[] _columnsToolTipNames = new String[]{PdpMacroPacbaseLabels._CALLED_ENTITIES, PdpMacroPacbaseLabels._LINE_NUMBER, PdpMacroPacbaseLabels._COMMENT, "$1", "$2", "$3", "$4", "$5", "$6", "$7", "$8", "$9", "$0", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H", "$I", "$J"};
    private boolean modificationAuthorized = true;
    private PTCrossReferenceView ptCrossReferenceView = null;

    public PTCrossReferenceTreeViewer(Composite parent, PTCrossReferenceView ptCrossReferenceView, int style) {
        super(parent, style, null, 0, false);
        this.ptCrossReferenceView = ptCrossReferenceView;
    }

    public ColumnViewer getColumnViewer() {
        return this;
    }

    public Object[] getColumnProperties() {
        return super.getColumnProperties();
    }

    public CellEditor[] getCellEditors(String[] columnProperties) {
        if (this.getCellModifier() == null) {
            this.setCellModifier((ICellModifier)new ReferencedEntityCellModifier((ColumnViewer)this));
        }
        int editorsize = columnProperties.length;
        CellEditor[] cellEditors = new CellEditor[editorsize];
        int i = 0;
        while (i < editorsize) {
            PDPSwitchCellEditor editor = null;
            if (i > 2) {
                editor = new PDPSwitchCellEditor((Composite)this.getTree(), columnProperties[i]){

                    protected PDPAbstractControl getPDPControl(Composite parent, Object element, String property) {
                        PDPFreeRefForXP textControl = new PDPFreeRefForXP(parent, this.getStyle(), PTCrossReferenceTreeViewer.this.getTree(), "");
                        ((Text)textControl.getSwtControl()).setTextLimit(60);
                        ((Text)textControl.getSwtControl()).setFont(PTCrossReferenceTreeViewer.this.getTree().getFont());
                        return textControl;
                    }
                };
                cellEditors[i] = editor;
            } else if (i < 3) {
                editor = new PDPTextCellEditor((Composite)this.getTree(), columnProperties[i]);
                Text text = (Text)editor.getPDPControl().getSwtControl();
                text.setFont(this.getTree().getFont());
                cellEditors[i] = editor;
            }
            ++i;
        }
        return cellEditors;
    }

    protected ITableLabelProvider getPDPLabelProvider() {
        return new OutlineCrossRefTableLabelProvider(0);
    }

    protected ITreeContentProvider getPDPContentProvider() {
        return new OutlineCrossRefTableContentProvider(null, (TreeViewer)this);
    }

    protected RadicalEntity getLocalObject() {
        return null;
    }

    protected Object getInstances() {
        return null;
    }

    public String[] getColumnsNames() {
        return _columnsNames;
    }

    public String getFirstColumnName() {
        return PdpMacroPacbaseLabels._CALLED_ENTITIES;
    }

    public int[] getColumnsLimits() {
        return _columnsWidth;
    }

    public String[] getColumnsToolTipNames() {
        return _columnsToolTipNames;
    }

    protected EStructuralFeature getFeature() {
        return null;
    }

    public void setModificationAuthorized(boolean b) {
        this.modificationAuthorized = b;
    }

    public boolean isModificationAuthorized() {
        return this.modificationAuthorized;
    }

    private static class ReferencedEntityCellModifier
    extends PDPAbstractCellModifier {
        public ReferencedEntityCellModifier(ColumnViewer viewer) {
            super(viewer);
        }

        public boolean canModifyValue(Object element, String property) {
            if (((PTCrossReferenceTreeViewer)this.viewer).ptCrossReferenceView != null && !((PTCrossReferenceTreeViewer)this.viewer).ptCrossReferenceView.isInEditMode()) {
                return false;
            }
            if (!((PTCrossReferenceTreeViewer)this.viewer).modificationAuthorized) {
                return false;
            }
            return !(element instanceof ReferencedEntity) || !PdpMacroPacbaseLabels._CALLED_ENTITIES.equals(property) && !PdpMacroPacbaseLabels._LINE_NUMBER.equals(property) && !PdpMacroPacbaseLabels._COMMENT.equals(property);
        }

        public Object getElementValue(Object element, String property) {
            if (element instanceof ReferencedEntity) {
                if (PdpMacroPacbaseLabels._CALLED_ENTITIES == property) {
                    return ((ReferencedEntity)element).getName();
                }
                if (PdpMacroPacbaseLabels._LINE_NUMBER == property) {
                    return ((ReferencedEntity)element).getCpLineNumber();
                }
                if (PdpMacroPacbaseLabels._COMMENT == property) {
                    return ((ReferencedEntity)element).getCpLineComment();
                }
                int columnPropertiesSize = _columnsNames.length;
                int i = 3;
                while (i < columnPropertiesSize) {
                    if (_columnsNames[i].equals(property)) {
                        return ((ReferencedEntity)element).getParameter(i - 3).getValue();
                    }
                    ++i;
                }
            }
            return "TODO";
        }

        public void setElementValue(Object element, String property, Object value) {
            int columnPropertiesSize = _columnsNames.length;
            int numParam = 0;
            int i = 3;
            while (i < columnPropertiesSize) {
                if (_columnsNames[i].equals(property)) {
                    numParam = i - 3;
                    break;
                }
                ++i;
            }
            ((ReferencedEntity)element).setParameter(numParam, new MacroParameter(value.toString(), ""));
        }
    }
}

