/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.view;

import com.ibm.pdp.explorer.model.service.IPTFolder;
import com.ibm.pdp.explorer.model.service.IPTLocation;
import com.ibm.pdp.explorer.model.service.IPTPackage;
import com.ibm.pdp.explorer.model.service.IPTProject;
import com.ibm.pdp.macro.pacbase.view.ReferencedEntity;
import com.ibm.pdp.mdl.meta.Document;
import java.util.Comparator;

public class PTCrossRefComparator
implements Comparator<Object> {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int _sortMode;

    public PTCrossRefComparator(int sortMode) {
        this._sortMode = sortMode;
    }

    @Override
    public int compare(Object object1, Object object2) {
        String criteria1 = "";
        String criteria2 = "";
        if (object1 instanceof IPTLocation && object2 instanceof IPTLocation) {
            criteria1 = ((IPTLocation)object1).getName();
            criteria2 = ((IPTLocation)object2).getName();
        } else if (object1 instanceof IPTFolder && object2 instanceof IPTFolder) {
            criteria1 = ((IPTFolder)object1).getDisplayName();
            criteria2 = ((IPTFolder)object2).getDisplayName();
        } else if (object1 instanceof IPTPackage && object2 instanceof IPTPackage) {
            criteria1 = ((IPTPackage)object1).getName();
            criteria2 = ((IPTPackage)object2).getName();
        } else if (object1 instanceof IPTProject && object2 instanceof IPTProject) {
            criteria1 = ((IPTProject)object1).getName();
            criteria2 = ((IPTProject)object2).getName();
        } else if (object1 instanceof ReferencedEntity && object2 instanceof ReferencedEntity) {
            criteria1 = this.getCriteria((ReferencedEntity)object1);
            criteria2 = this.getCriteria((ReferencedEntity)object2);
        } else if (object1 instanceof String && object2 instanceof String) {
            criteria1 = (String)object1;
            criteria2 = (String)object2;
        }
        if (criteria1 == null || criteria2 == null) {
            return 0;
        }
        return criteria1.compareTo(criteria2);
    }

    private String getCriteria(ReferencedEntity sortedItem) {
        String criteria = "";
        Document metaDocument = sortedItem.getDocument();
        if (this._sortMode == 1) {
            criteria = String.valueOf(sortedItem.getName()) + '.' + metaDocument.getPackage();
        } else if (this._sortMode == 2) {
            criteria = String.valueOf(metaDocument.getPackage().toString()) + '-' + sortedItem.getName();
        } else if (this._sortMode == 3) {
            criteria = String.valueOf(metaDocument.getProject().toString()) + '-' + sortedItem.getName() + '.' + metaDocument.getPackage();
        } else if (this._sortMode == 4) {
            criteria = String.valueOf(metaDocument.getType()) + '-' + sortedItem.getName() + '.' + metaDocument.getPackage();
        }
        return criteria;
    }

    public void setSortMode(int sortMode) {
        this._sortMode = sortMode;
    }
}

