/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.view;

import com.ibm.pdp.explorer.designpath.PTDesignPath;
import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.PTResourceManager;
import com.ibm.pdp.explorer.model.service.IPTElement;
import com.ibm.pdp.explorer.model.tool.PTProjectScope;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.macro.pacbase.outline.OutlineCrossRefTableLabelProvider;
import com.ibm.pdp.macro.pacbase.view.ReferencedEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.editor.util.Util;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.widgets.ui.control.PDPText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class PDPFreeRefForXP
extends PDPText {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Tree _tree;
    String _entityType;
    protected Object oldValueBeginning;
    protected Object oldValueEnding;

    public PDPFreeRefForXP(Composite parent, int style, Tree tree, String entityType) {
        super(parent, style);
        this._tree = tree;
        this._entityType = entityType;
    }

    protected void initialize(int style) {
        super.initialize(style);
        this.initContentAssist((ILabelProvider)new OutlineCrossRefTableLabelProvider(16), (Composite)this._tree, false);
        this.setEditable(true, true);
    }

    public List<Object> getContentProposals(List<Object> proposals, String contents, int position) {
        ArrayList<Object> objects = new ArrayList<Object>();
        String delim = this.getDelim(contents);
        String textBefore = contents.substring(0, position);
        String textAfter = "";
        if (contents.length() > position) {
            textAfter = contents.substring(position);
        }
        if (contents.trim().length() == 0) {
            this.oldValueBeginning = null;
            this.oldValueEnding = null;
        } else if (position == 0) {
            this.oldValueBeginning = null;
            this.oldValueEnding = contents;
        } else if (position < 4) {
            this.oldValueBeginning = null;
            this.oldValueEnding = null;
        } else {
            this.oldValueBeginning = textBefore;
            this.oldValueEnding = textAfter;
        }
        int currentPossition = position;
        List elements = null;
        int lastdelim = textBefore.lastIndexOf(delim) + 1;
        currentPossition -= lastdelim;
        if (contents.length() >= lastdelim) {
            this.oldValueBeginning = contents.substring(0, lastdelim);
            textBefore = textBefore.substring(lastdelim);
        } else {
            this.oldValueBeginning = null;
        }
        if (this.element != null && this.element instanceof ReferencedEntity) {
            if (this._entityType.trim().length() > 0) {
                ReferencedEntity elt = (ReferencedEntity)this.element;
                String context = elt.getContext();
                PTNature nature = PTNature.getNature((String)context);
                PTLocation location = PTModelManager.getLocation((String)nature.getLocation());
                PTDesignPath designPath = location.getDesignPath(false);
                String streamID = "_LOCAL_STREAM";
                PTProjectScope projectScope = new PTProjectScope(streamID, nature.getLocation(), designPath.getElementaryPaths());
                projectScope.setVision(1);
                projectScope.setContext(context);
                Set projects = projectScope.getRetainedProjects(streamID, location.getName());
                ArrayList path = new ArrayList(projects);
                elements = Util.filter((List)PTLocation.getSelected().getByFolder(this._entityType), path);
                for (IPTElement element : elements) {
                    String text = element.getName();
                    if (text == null || text.length() < textBefore.length() || !text.substring(0, currentPossition).equals(textBefore)) continue;
                    objects.add(element);
                }
            } else {
                objects = new ArrayList<String>(Arrays.asList("E=", "D=", "S="));
                this.setAutoRaiseContentAssit(true);
            }
        }
        return objects;
    }

    private String getDelim(String contents) {
        String delim = "";
        if (this.element != null && this.element instanceof ReferencedEntity) {
            if (contents.contains("E=")) {
                this._entityType = "dataelement";
            } else if (contents.contains("D=")) {
                this._entityType = "dataunit";
            } else if (contents.contains("S=")) {
                this._entityType = "dataaggregate";
            }
            delim = "=";
        } else {
            delim = "-";
        }
        return delim;
    }

    public void setDisplayText(Object value) {
        if (value instanceof PTElement) {
            List paths = null;
            RadicalEntity radicalObject = PTResourceManager.loadResource((Document)((PTElement)value).getDocument(), paths, null);
            super.setDisplayText((Object)radicalObject.getName());
        } else {
            super.setDisplayText(value);
        }
    }

    public void setValue(Object value) {
        if (this.oldValueBeginning != null || this.oldValueEnding != null) {
            StringBuffer newValue = new StringBuffer("");
            if (this.oldValueBeginning != null) {
                newValue.append(this.oldValueBeginning.toString());
            }
            if (value instanceof PTElement) {
                List paths = null;
                RadicalEntity radicalObject = PTResourceManager.loadResource((Document)((PTElement)value).getDocument(), paths, null);
                newValue.append(radicalObject.getName());
            } else {
                newValue.append(value.toString());
            }
            if (this.oldValueEnding != null) {
                newValue.append(this.oldValueEnding.toString());
            }
            super.setValue((Object)newValue.toString());
        } else {
            super.setValue(value);
        }
    }
}

