/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.outline;

import com.ibm.pdp.explorer.editor.provider.PTFacetLabelProvider;
import com.ibm.pdp.explorer.model.PTFacet;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.PTPredefinedFolder;
import com.ibm.pdp.explorer.plugin.IPTArtifactContributor;
import com.ibm.pdp.explorer.view.provider.PTElementLabelProvider;
import com.ibm.pdp.macro.pacbase.view.ReferencedEntity;
import com.ibm.pdp.mdl.pacbase.editor.page.section.ITableToolTipLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class OutlineCrossRefTableLabelProvider
extends PTElementLabelProvider
implements ITableLabelProvider,
ITableToolTipLabelProvider {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public OutlineCrossRefTableLabelProvider(int displayMode) {
        super(displayMode);
    }

    public String getText(Object object) {
        if (object instanceof String) {
            return object.toString();
        }
        return super.getText(object);
    }

    public Image getImage(Object object) {
        Image image = null;
        if (!(object instanceof String)) {
            return super.getImage(object);
        }
        return image;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image;
        block1: {
            String type;
            block2: {
                image = null;
                if (columnIndex != 0 || !(element instanceof ReferencedEntity)) break block1;
                ReferencedEntity referencedEntity = (ReferencedEntity)element;
                type = referencedEntity.getDocument().getType();
                PTFacet facet = PTModelManager.getFacet((String)"pacbase".toLowerCase());
                if (!PTModelManager.accept((String)type)) break block2;
                PTFacetLabelProvider labelProvider = facet.getLabelProvider(type);
                if (labelProvider == null) break block1;
                image = labelProvider.getImage((Object)referencedEntity.getDocument());
                break block1;
            }
            for (IPTArtifactContributor artifactContributor : PTModelManager.getArtifactContributors()) {
                if (!artifactContributor.accept(type)) continue;
                image = artifactContributor.getImage(type);
                break;
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        ReferencedEntity p = (ReferencedEntity)element;
        if (columnIndex == 0) {
            return super.getText((Object)p.getElement());
        }
        if (columnIndex == 1) {
            return p.getCpLineNumber();
        }
        if (columnIndex == 2) {
            return p.getCpLineComment();
        }
        return p.getParameter(columnIndex - 3).getValue();
    }

    public void addListener(ILabelProviderListener arg0) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }

    public String getColumnToolTipText(Object obj, int index, int severity) {
        ReferencedEntity referencedEntity = (ReferencedEntity)obj;
        String type = referencedEntity.getDocument().getType();
        String name = referencedEntity.getDocument().getName();
        StringBuilder buffer = new StringBuilder();
        if (index == 0) {
            if (PTModelManager.accept((String)type)) {
                buffer.append(this.getFolderName(type));
            } else {
                buffer.append(referencedEntity.getDocument().getType().toUpperCase());
            }
            buffer.append("  ").append(name);
        } else if (index > 2 && referencedEntity.getParameter(index - 3) != null) {
            String paramComment = referencedEntity.getParameter(index - 3).getComment();
            buffer.append(paramComment);
        }
        return buffer.toString();
    }

    public String getFolderName(String type) {
        PTFacet preferredFacet = PTModelManager.getFacet((String)PTModelManager.getPreferredFacet());
        for (PTPredefinedFolder folder : preferredFacet.getFolders()) {
            if (!type.equals(folder.getName())) continue;
            return folder.getDisplayName();
        }
        return "";
    }
}

