/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.merge;

import com.ibm.pdp.mdl.pacbase.PacAbstractCELine;
import com.ibm.pdp.mdl.pacbase.PacCELineCategory;
import com.ibm.pdp.mdl.pacbase.PacCELineField;
import com.ibm.pdp.mdl.pacbase.PacCELineLabel;
import com.ibm.pdp.mdl.pacbase.PacCELineScreenCall;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacScreenCECategoryNatureValues;
import com.ibm.pdp.mdl.pacbase.PacScreenFieldTypeValues;
import java.util.HashMap;

public class Util {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static HashMap GetDataElementRank(PacScreen screen) {
        HashMap listCELines = new HashMap();
        InternalVariables iv = new InternalVariables();
        listCELines = Util.GetDataElementRankInCElines(screen, false, listCELines, iv, true);
        return listCELines;
    }

    private static HashMap GetDataElementRankInCElines(PacScreen screen, boolean screenCalled, HashMap<String, DetailForCEline> listCELines, InternalVariables iv, boolean recursive) {
        for (PacAbstractCELine cel : screen.getCELines()) {
            if (cel instanceof PacCELineField) {
                String nameOfCEline = ((PacCELineField)cel).getFieldType().equals(PacScreenFieldTypeValues._PASSWORD_LITERAL) ? "*PASWD" : (((PacCELineField)cel).getFieldType().equals(PacScreenFieldTypeValues._PF_KEY_LITERAL) ? "PFKEY" : (((PacCELineField)cel).getFieldType().equals(PacScreenFieldTypeValues._ERR_MSG_LITERAL) ? "ERMSG" : (((PacCELineField)cel).getFieldType().equals(PacScreenFieldTypeValues._LI_ERR_LITERAL) ? "LIERR" : ((PacCELineField)cel).getDataElement().getName())));
                listCELines.put(nameOfCEline, Util.InitializeDetailForCELine(cel, iv));
            } else if (cel instanceof PacCELineLabel) {
                iv.incrementRang();
            } else if (cel instanceof PacCELineCategory) {
                Util.UpdateRangForCategory(cel, screenCalled, iv);
            }
            if (recursive && cel instanceof PacCELineScreenCall) {
                PacCELineScreenCall aPacCElineScreen = (PacCELineScreenCall)cel;
                PacScreen calledScreen = aPacCElineScreen.getScreen();
                iv.setNameForCalledScreen(calledScreen.getName());
                boolean noIncrementNuligSC = false;
                if (iv.getPriorCategory() != null && iv.getPriorCategory().equals("R") && iv.isRepetVerticalCateg() && !iv.isIncrementNuligAfterCategRinScrenCalled()) {
                    noIncrementNuligSC = true;
                    if (!(aPacCElineScreen.getLinePosition() != 0 || aPacCElineScreen.getColumnPosition() != 0 || iv.getNameForScreenCalledForCategR() != null && calledScreen.getName().equals(iv.getNameForScreenCalledForCategR()))) {
                        noIncrementNuligSC = false;
                    }
                }
                if (!noIncrementNuligSC) {
                    iv.incrementRang();
                }
                screenCalled = true;
                Util.GetDataElementRankInCElines(calledScreen, screenCalled, listCELines, iv, false);
                screenCalled = false;
                iv.setNameForCalledScreen("");
            }
            if (recursive || !(cel instanceof PacCELineScreenCall)) continue;
            iv.incrementRang();
        }
        return listCELines;
    }

    private static DetailForCEline InitializeDetailForCELine(PacAbstractCELine cel, InternalVariables iv) {
        DetailForCEline var = new DetailForCEline();
        PacScreenCECategoryNatureValues nat = iv.getNat();
        if (nat != null) {
            var.setNatureCateg(nat);
        }
        var.setRangCEline(Util.rangConversion(iv.incrementRang()));
        return var;
    }

    private static void UpdateRangForCategory(PacAbstractCELine cel, boolean screenCalled, InternalVariables iv) {
        PacCELineCategory aPacCElineCat = (PacCELineCategory)cel;
        iv.setNat(aPacCElineCat.getCategoryNature());
        String currentCategory = String.valueOf(aPacCElineCat.getCategoryNature()).substring(1);
        String nameForScreenCalledForCategR = null;
        String currentNameForCalledScreen = null;
        boolean noIncrementNulig = false;
        if (screenCalled) {
            currentNameForCalledScreen = iv.getNameForCalledScreen();
            if (iv.getNameForScreenCalledForCategR() != null) {
                nameForScreenCalledForCategR = iv.getNameForScreenCalledForCategR();
            }
        }
        if (currentCategory.equals("R") && aPacCElineCat.getVerticalRepetition() > 1) {
            iv.setRepetVerticalCateg(true);
        }
        if (iv.isRepetVerticalCateg() && currentCategory.equals("R") && screenCalled) {
            iv.setIncrementNuligAfterCategRinScrenCalled(true);
            iv.setNameForScreenCalledForCategR(currentNameForCalledScreen);
        }
        if (screenCalled && currentCategory.equals("Z") && nameForScreenCalledForCategR != null && currentNameForCalledScreen.equals(nameForScreenCalledForCategR)) {
            iv.setIncrementNuligAfterCategRinScrenCalled(false);
        }
        if (iv.isRepetVerticalCateg() && currentCategory.equals("Z") && iv.getPriorCategory() != null && iv.getPriorCategory().equals("R") && !iv.isIncrementNuligAfterCategRinScrenCalled()) {
            noIncrementNulig = true;
        }
        if (!noIncrementNulig) {
            iv.incrementRang();
        }
        iv.setPriorCategory(currentCategory);
    }

    private static String rangConversion(int rang) {
        String convertedRang;
        String correspondingLetter = "A";
        String[] tableauAlphabeticLetter = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        String rangS = String.valueOf(rang);
        int nbDigit = rangS.length();
        String uniteS = rangS.substring(nbDigit - 1);
        if (rang < 260) {
            String dizainS;
            if (nbDigit == 2) {
                dizainS = rangS.substring(0, 1);
                correspondingLetter = tableauAlphabeticLetter[Integer.parseInt(dizainS)];
            }
            if (nbDigit > 2 && nbDigit < 4 && Integer.parseInt(dizainS = rangS.substring(0, 2)) < 26) {
                correspondingLetter = tableauAlphabeticLetter[Integer.parseInt(dizainS)];
            }
            convertedRang = correspondingLetter.concat(uniteS);
        } else {
            int inulir;
            int nuli8 = rang - 259;
            int ca9 = inulir = nuli8 / 36;
            int inulil = 1 + nuli8 - ca9 * 36;
            correspondingLetter = tableauAlphabeticLetter[inulil - 1];
            convertedRang = String.valueOf(ca9).concat(correspondingLetter);
        }
        return convertedRang;
    }

    public static class DetailForCEline {
        public PacScreenCECategoryNatureValues natureCateg;
        public String rangCEline;

        public PacScreenCECategoryNatureValues getNatureCateg() {
            return this.natureCateg;
        }

        public String getRangCEline() {
            return this.rangCEline;
        }

        public void setNatureCateg(PacScreenCECategoryNatureValues nat) {
            this.natureCateg = nat;
        }

        public void setRangCEline(String rg) {
            this.rangCEline = rg;
        }
    }

    public static class InternalVariables {
        int rang = 0;
        PacScreenCECategoryNatureValues nat = null;
        boolean repetVerticalCateg = false;
        boolean incrementNuligAfterCategRinScrenCalled = false;
        String priorCategory = "";
        String nameForCalledScreen = null;
        String screenCalledForCategR = null;

        public int getRang() {
            return this.rang;
        }

        public int incrementRang() {
            return ++this.rang;
        }

        public PacScreenCECategoryNatureValues getNat() {
            return this.nat;
        }

        public void setNat(PacScreenCECategoryNatureValues n) {
            this.nat = n;
        }

        public boolean isRepetVerticalCateg() {
            return this.repetVerticalCateg;
        }

        void setRepetVerticalCateg(boolean rvc) {
            this.repetVerticalCateg = rvc;
        }

        public boolean isIncrementNuligAfterCategRinScrenCalled() {
            return this.incrementNuligAfterCategRinScrenCalled;
        }

        void setIncrementNuligAfterCategRinScrenCalled(boolean inacsc) {
            this.incrementNuligAfterCategRinScrenCalled = inacsc;
        }

        public String getPriorCategory() {
            return this.priorCategory;
        }

        public void setPriorCategory(String pc) {
            this.priorCategory = pc;
        }

        public String getNameForCalledScreen() {
            return this.nameForCalledScreen;
        }

        public void setNameForCalledScreen(String ncs) {
            this.nameForCalledScreen = ncs;
        }

        public String getNameForScreenCalledForCategR() {
            return this.screenCalledForCategR;
        }

        public void setNameForScreenCalledForCategR(String ncsR) {
            this.screenCalledForCategR = ncsR;
        }
    }
}

