/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.merge;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IBuilderTree;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.macro.common.merge.Node;
import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.common.merge.NodeText;
import com.ibm.pdp.macro.common.merge.NodeTree;
import com.ibm.pdp.macro.common.merge.NodeTreeConverter;
import com.ibm.pdp.macro.pacbase.merge.Merge;
import com.ibm.pdp.macro.pacbase.merge.PacbaseComparator;
import com.ibm.pdp.macro.pacbase.merge.PacbaseNodeTag;
import com.ibm.pdp.macro.pacbase.merge.PacbaseSort;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacGeneratedSkeletonLanguageValues;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.util.PacProgramWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacScreenWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacServerWrapper;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;

public class PacbaseNodeTreeConverter
extends NodeTreeConverter {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PROPERTY_SUP_IN_MACRO = "SUPinMacro";
    private static final String PROPERTY_MSP = "msp";
    private List<String> listIndexForFonctionToSup = new ArrayList<String>();
    private List<String> listIndexForFonctionSQL = new ArrayList<String>();
    private String model = null;
    static List<String> AllReservedWords = new ArrayList<String>();
    static List<String> ReservedWordsForDataAggregate;
    private String new_line = null;
    private List<String> listForNmicroPatterns = new ArrayList<String>();
    private NodeTag tagToDelete;

    static {
        AllReservedWords.add("ALIM");
        AllReservedWords.add("BEGV");
        AllReservedWords.add("CALL");
        AllReservedWords.add("CATA");
        AllReservedWords.add("CATR");
        AllReservedWords.add("CATT");
        AllReservedWords.add("CATZ");
        AllReservedWords.add("CCNX");
        AllReservedWords.add("CHCK");
        AllReservedWords.add("CHKD");
        AllReservedWords.add("CHUP");
        AllReservedWords.add("CLOS");
        AllReservedWords.add("DCNX");
        AllReservedWords.add("DONE");
        AllReservedWords.add("ENDV");
        AllReservedWords.add("ERRS");
        AllReservedWords.add("ERRV");
        AllReservedWords.add("INIT");
        AllReservedWords.add("LOCK");
        AllReservedWords.add("OPEN");
        AllReservedWords.add("RETC");
        AllReservedWords.add("SELC");
        AllReservedWords.add("SLCT");
        AllReservedWords.add("SRVA");
        AllReservedWords.add("SRVE");
        AllReservedWords.add("SRVL");
        AllReservedWords.add("SRVM");
        AllReservedWords.add("SRVT");
        AllReservedWords.add("SRVX");
        AllReservedWords.add("TRAN");
        AllReservedWords.add("TRDT");
        AllReservedWords.add("TRER");
        AllReservedWords.add("TRVW");
        AllReservedWords.add("UNLK");
        AllReservedWords.add("UPDT");
        AllReservedWords.add("USER");
        ReservedWordsForDataAggregate = new ArrayList<String>();
        ReservedWordsForDataAggregate.add("CHCK");
        ReservedWordsForDataAggregate.add("UPDT");
        ReservedWordsForDataAggregate.add("SLCT");
        ReservedWordsForDataAggregate.add("USRS");
    }

    public PacbaseNodeTreeConverter(RadicalEntity radicalEntity) {
    }

    public boolean isTrueTag(NodeTag nt) {
        NodeTag parent = nt.getParentNode() == null ? nt : nt.getParentNode();
        while (parent.getParentNode() != null) {
            parent = parent.getParentNode();
        }
        String tagName = nt.getName().trim();
        if (tagName.endsWith("-FN") && !nt.getProperty("sort").startsWith("9")) {
            return true;
        }
        return !PdpTool.isFilteredTagName((String)tagName, (String)parent.getProperty("model"));
    }

    public void calculateProperties(NodeTag node) {
        if (node != null && node.getProperties() != null) {
            node.getProperties().remove("remove_properties");
            if (node.getProperty(PROPERTY_MSP) != null && node.getProperty("level") != null && node.getName().startsWith("F80") && "09.5".equals(node.getProperty("level"))) {
                node.getProperties().setProperty("level", "10");
            }
            if (node.getProperty("ref") != null && node.getProperty("ref").trim().length() > 0) {
                if ("server".equals(node.getNodeTree().getRootTag().getProperty("model"))) {
                    node.getProperties().setProperty("refMIA", PacbaseNodeTreeConverter.calculateServerEtiquetteFrom(node));
                } else if (!"batch".equals(node.getNodeTree().getRootTag().getProperty("model"))) {
                    node.getProperties().setProperty("refMIA", PacbaseNodeTreeConverter.calculateDialogEtiquetteFrom(node));
                }
            }
        }
    }

    public static final String calculateDialogEtiquetteFrom(NodeTag tag) {
        StringBuilder reference = new StringBuilder();
        StringTokenizer st = new StringTokenizer(tag.getProperty("ref"));
        String ref = st.nextToken();
        reference.append("F").append(tag.getProperty("sort").substring(1, 3));
        if (tag.getName().startsWith("F80")) {
            reference.append("-");
            reference.append(ref);
        } else {
            String categ = tag.getProperty("categ");
            if (categ != null) {
                categ = categ.trim().length() > 0 ? categ : "A";
                reference.append(categ);
            }
            reference.append("-");
            reference.append(ref.trim());
        }
        return reference.toString();
    }

    public static final String calculateServerEtiquetteFrom(NodeTag tag) {
        String etiquettes = null;
        String logicalView = null;
        while (tag != null) {
            if (etiquettes == null && tag.getProperty("ref") != null) {
                etiquettes = tag.getProperty("ref");
            }
            if (logicalView == null) {
                if (tag.getProperty("LogicalView") != null) {
                    logicalView = tag.getProperty("LogicalView");
                } else {
                    String sort = tag.getProperty("sort");
                    if (sort != null && sort.startsWith("9K")) {
                        logicalView = sort.substring(2, 6);
                    }
                }
            }
            tag = tag.getParentNode();
        }
        if (etiquettes == null) {
            return null;
        }
        if (logicalView != null && etiquettes.startsWith(logicalView)) {
            return logicalView;
        }
        StringBuilder result = new StringBuilder("F");
        StringTokenizer st = new StringTokenizer(etiquettes);
        String dataAggregate = null;
        etiquettes = new String();
        String word = st.nextToken();
        boolean isLogicalView = true;
        isLogicalView = !ReservedWordsForDataAggregate.contains(word);
        etiquettes = String.valueOf(etiquettes) + word;
        etiquettes = String.valueOf(etiquettes) + "-";
        while (st.hasMoreTokens()) {
            word = st.nextToken();
            if (!AllReservedWords.contains(word) && !isLogicalView) {
                dataAggregate = word;
                continue;
            }
            etiquettes = String.valueOf(etiquettes) + word;
            etiquettes = String.valueOf(etiquettes) + "-";
        }
        if (etiquettes.endsWith("-")) {
            etiquettes = etiquettes.substring(0, etiquettes.length() - 1);
        }
        if (!isLogicalView && dataAggregate != null) {
            result.append(dataAggregate);
        } else {
            result.append(logicalView);
        }
        result.append("-").append(etiquettes);
        return result.toString();
    }

    private void removeAllSQLsMP(IGenInfoBuilder gib) {
        if ("dialog".equals(this.model)) {
            Collections.reverse(this.listIndexForFonctionSQL);
            Iterator<String> it = this.listIndexForFonctionSQL.iterator();
            IBuilderTag parent = gib.tagFromName("N80");
            IBuilderTag tag = parent.nextTag();
            while (tag.getProperty("ref") != null) {
                tag = tag.nextTag();
            }
            IBuilderTag currentTag = tag;
            ArrayList<IBuilderTree> tagsToInsert = new ArrayList<IBuilderTree>();
            while (it.hasNext()) {
                tag = gib.tagFromName(it.next());
                if (tag == null || !tag.getProperty("sort").endsWith("000")) continue;
                parent = tag.getParent();
                tagsToInsert.add(0, gib.removeTreeAndText(tag));
                gib.removeTreeAndText(parent);
            }
            Iterator itt = tagsToInsert.iterator();
            while (itt.hasNext()) {
                gib.addTree(currentTag.getBeginIndex(), (IBuilderTree)itt.next(), "F80");
            }
        }
    }

    public static String GetplValueFor(String firstLine, String sortProperty) {
        boolean endWithDOT = false;
        int length = firstLine.length();
        if (firstLine.endsWith("DOT")) {
            endWithDOT = true;
            length -= 3;
            while (firstLine.charAt(length - 1) == ' ') {
                --length;
            }
        }
        StringBuilder newHeader = new StringBuilder(firstLine.subSequence(0, length));
        int lengthBefore = newHeader.length();
        if (newHeader.charAt(length - 1) != ' ') {
            newHeader.append(" ");
        }
        if (sortProperty == null) {
            return firstLine;
        }
        newHeader.append("pl=");
        if (sortProperty.charAt(0) == '9') {
            if (sortProperty.length() >= 3) {
                newHeader.append(sortProperty.substring(1, 3));
                if (sortProperty.length() >= 6) {
                    newHeader.append(sortProperty.substring(4, 6));
                    if (sortProperty.length() >= 9) {
                        newHeader.append(sortProperty.substring(6, 9));
                    } else {
                        newHeader.append(sortProperty.substring(6));
                    }
                } else {
                    newHeader.append(sortProperty.substring(4));
                }
            } else {
                newHeader.append(sortProperty.substring(1));
            }
        } else if (sortProperty.length() >= 6) {
            newHeader.append(sortProperty.substring(1, 6));
        } else {
            newHeader.append(sortProperty.substring(1));
        }
        int lengthAfter = newHeader.length();
        if (endWithDOT) {
            newHeader.append(firstLine.substring(length - lengthBefore + lengthAfter));
        } else {
            newHeader.append(firstLine.substring(length));
        }
        return newHeader.toString();
    }

    public static String GetLevelFrom(IBuilderTag tag) {
        String lev = PacbaseNodeTreeConverter.GetPropertyFor(tag, "level");
        if (lev == null) {
            return "10";
        }
        return lev;
    }

    protected static String GetPropertyFor(IBuilderTag tag, String propertyName) {
        String propName = "+" + propertyName;
        String propValue = tag.getProperty(propName);
        if (propValue != null) {
            return propValue;
        }
        propValue = tag.getProperty(propertyName);
        return propValue;
    }

    private void moveTagFrom(IBuilderTag tagToMove, IGenInfoBuilder gib) {
        IBuilderTag parent = tagToMove.getParent();
        float levelCurrent = Float.parseFloat(PacbaseNodeTreeConverter.GetLevelFrom(tagToMove));
        IBuilderTag previousTag = parent.previousTag();
        while (previousTag != null && PacbaseNodeTreeConverter.GetPropertyFor(previousTag, "level") == null) {
            previousTag = previousTag.getParent();
        }
        if (previousTag != null) {
            boolean toRemove = true;
            if (previousTag.getName().length() > 2 && tagToMove.getName().length() > 2 && !previousTag.getName().substring(0, 3).equals(tagToMove.getName().substring(0, 3))) {
                toRemove = false;
            }
            float levelPrevious = Float.parseFloat(PacbaseNodeTreeConverter.GetLevelFrom(previousTag));
            IBuilderTag nextTag = parent.nextTag();
            float levelNext = 0.0f;
            if (nextTag != null) {
                levelNext = Float.parseFloat(PacbaseNodeTreeConverter.GetLevelFrom(nextTag));
            }
            if (toRemove && levelPrevious < levelCurrent && (levelPrevious >= levelNext || levelCurrent <= levelNext)) {
                if (levelPrevious == 5.0f) {
                    IBuilderTree bt = gib.removeTreeAndText(tagToMove);
                    gib.addTree(parent.previousTag().getEndIndex(), bt, previousTag.getName());
                    return;
                }
                IBuilderTag lastSon = previousTag;
                String lev = PacbaseNodeTreeConverter.GetPropertyFor(lastSon, "level");
                while (lastSon.hasSon() && lev != null && Float.parseFloat(lev) < levelCurrent) {
                    lastSon = lastSon.lastSon();
                    lev = PacbaseNodeTreeConverter.GetPropertyFor(lastSon, "level");
                }
                if (lev == null || Float.parseFloat(lev) >= levelCurrent) {
                    lastSon = lastSon.getParent();
                }
                IBuilderTree bt = gib.removeTreeAndText(tagToMove);
                String fName = this.getLabelFrom(lastSon);
                String text = lastSon.getText().toString();
                int index = text.lastIndexOf(String.valueOf(this.new_line) + "       " + fName + "-FN.");
                int index900 = text.lastIndexOf(String.valueOf(this.new_line) + "       " + fName + "-900");
                if (index900 != -1) {
                    index = index900;
                }
                gib.addTree(lastSon.getBeginIndex() + (index += this.new_line.length()), bt, lastSon.getName());
            }
        }
    }

    protected String getLabelFrom(IBuilderTag tag) {
        if (PacbaseNodeTreeConverter.GetPropertyFor(tag, PROPERTY_MSP) != null) {
            return tag.getName();
        }
        if (PacbaseNodeTreeConverter.GetPropertyFor(tag, "sort") != null && PacbaseNodeTreeConverter.GetPropertyFor(tag, "refMIA") != null) {
            String sort = PacbaseNodeTreeConverter.GetPropertyFor(tag, "sort");
            return "F" + sort.substring(1, 3) + sort.substring(4, 6);
        }
        return tag.getName();
    }

    public void visit(NodeTag node) {
        if (node == this.tagToDelete) {
            this.tagToDelete = null;
            return;
        }
        super.visit(node);
    }

    public void visit(NodeTree nodeTree) {
        this.model = nodeTree.getRootTag().getProperty("model");
        super.visit(nodeTree);
        IGenInfoBuilder gib = this.getGeneratedInfo().toGeneratedInfoBuilder();
        if (!this.listIndexForFonctionSQL.isEmpty()) {
            this.removeAllSQLsMP(gib);
        }
        if (!this.listForNmicroPatterns.isEmpty()) {
            for (String tagName : this.listForNmicroPatterns) {
                IBuilderTag tag = gib.tagFromName(tagName);
                if (tag == null) continue;
                this.clean_N_MPFromTag(tag);
            }
        }
        if ("dialog".equals(this.model) || "client".equals(this.model)) {
            this.specialTreatmentForDialogPattern(gib);
        }
        if ("server".equals(this.model) || "server_ITtyp".equals(this.model) || "folder_monit".equals(this.model) || "folder".equals(this.model)) {
            this.specialTreatmentForEbusinessPattern(gib);
        }
        gib.setProperty("version", "002");
        this.genInfoResult = gib.toGeneratedInfo();
    }

    private void clean_N_MPFromTag(IBuilderTag tag) {
        IGenInfoBuilder gib = tag.getGenInfoBuilder();
        String text = tag.getText().toString();
        StringTokenizer st = new StringTokenizer(text, this.new_line);
        StringBuilder newText = new StringBuilder();
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.length() > 9 && line.substring(6, 10).equals("*!N ")) continue;
            newText.append(line).append(this.new_line);
        }
        if (newText.length() > 0) {
            tag.setText((CharSequence)newText);
        } else {
            gib.removeTagAndText(tag);
        }
    }

    private void specialTreatmentForEbusinessPattern(IGenInfoBuilder gib) {
        if (gib.tagFromName("F80") != null) {
            this.createF80SubFunctions(gib);
            this.suppressF80SubFunctions(gib);
        }
    }

    private void suppressF80SubFunctions(IGenInfoBuilder gib) {
        IBuilderTag tag = null;
        Iterator<String> it = this.listIndexForFonctionSQL.iterator();
        while (it.hasNext()) {
            tag = gib.tagFromName(it.next());
            boolean suppressOK = this.searchComment(tag.getParent());
            if (!suppressOK) continue;
            if (tag.previousTag() != null) {
                gib.removeTagAndText(tag.previousTag());
            }
            tag.getParent().lastSon().setTextAfter((CharSequence)"");
            gib.removeTag(tag.getParent());
        }
    }

    private boolean searchComment(IBuilderTag tag) {
        if (tag != null) {
            if (tag.hasSon()) {
                IBuilderTag son = tag.firstSon();
                if (son.getName().length() == 11 && son.getText().charAt(6) != '*') {
                    return false;
                }
                return this.searchComment(son.nextTag());
            }
            if (tag.nextTag() != null) {
                IBuilderTag next = tag.nextTag();
                if (next.getName().length() == 11 && next.getText().charAt(6) != '*') {
                    return false;
                }
                return this.searchComment(next.nextTag());
            }
        }
        return true;
    }

    private void createF80SubFunctions(IGenInfoBuilder gib) {
        IBuilderTag tag = gib.tagFromName("F80");
        ArrayList<IBuilderTag> resultBegin = new ArrayList<IBuilderTag>();
        ArrayList<IBuilderTag> resultEnd = new ArrayList<IBuilderTag>();
        ArrayList<String> segments = new ArrayList<String>();
        this.modifyGIB(tag);
        this.collectSegmentsForFunctionTagsForServer(tag, resultBegin, resultEnd, segments);
        int i = 0;
        while (i < resultBegin.size()) {
            IBuilderTag tagFirst = resultBegin.get(i);
            StringBuilder sb = new StringBuilder(8);
            sb.append("F80");
            String[] ls = segments.get(i).split(" ");
            int j = 0;
            while (j < ls.length) {
                sb.append("-");
                sb.append(ls[j]);
                ++j;
            }
            IBuilderTag tagLast = this.searchLastResultEndForSegment(resultEnd, sb.toString(), tagFirst.getProperty("ref"));
            gib.addTag(tagFirst.getBeginIndex(), tagLast.getEndIndex(), sb.toString(), tagFirst.getParent().getName());
            ++i;
        }
    }

    private void modifyGIB(IBuilderTag tag) {
        boolean tagFound = false;
        if ("*R".equals(tag.getProperty("action")) && tag.getProperty("ref") != null) {
            String refProperty = tag.getProperty("ref");
            int index = (refProperty = refProperty.trim()).indexOf(32);
            if (index != -1) {
                refProperty = refProperty.replace(' ', '-');
                String tagName = "F80-" + refProperty;
                if (tag.getGenInfoBuilder().tagFromName(tagName) == null) {
                    tag = tag.getGenInfoBuilder().addTag(tag.getBeginIndex(), tag.getEndIndex(), tagName, tag.getParent().getName());
                    tag.setProperty("level", "09.5");
                    tagFound = true;
                }
            }
        }
        if (!tagFound && tag.hasSon()) {
            this.modifyGIB(tag.firstSon());
        }
        if (tag.nextTag() != null) {
            this.modifyGIB(tag.nextTag());
        }
    }

    private IBuilderTag searchLastResultEndForSegment(ArrayList<IBuilderTag> resultEnd, String s, String ref) {
        IBuilderTag tagLast = null;
        if (ref != null && ref.trim().indexOf(" ") == -1) {
            int i = 0;
            while (i < resultEnd.size()) {
                IBuilderTag ib = resultEnd.get(i);
                String ibRef = ib.getProperty("ref");
                if (ibRef != null && ibRef.trim().equals(ref.trim())) {
                    tagLast = ib;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < resultEnd.size()) {
                IBuilderTag ib = resultEnd.get(i);
                if (ib.getName().startsWith(s)) {
                    tagLast = ib;
                }
                ++i;
            }
        }
        return tagLast;
    }

    private void specialTreatmentForDialogPattern(IGenInfoBuilder gib) {
        IBuilderTag tagF2599;
        int[] tab;
        IBuilderTag tag;
        IBuilderTag f25Tag;
        boolean notFound;
        IBuilderTag tag2;
        int[] tab2;
        if (gib.tagFromName("F25") == null) {
            tab2 = PacbaseNodeTreeConverter.SearchSubFunctionFrom(gib.tagFromName("PROCEDURE"), "F25");
            tag2 = gib.tagFromName("END-OF-RECEPTION");
            boolean bl = notFound = tab2[0] == tab2[1] && tab2[0] == 0;
            tag2 = notFound && tag2 != null ? gib.addTagBefore("F25", "END-OF-RECEPTION") : (tag2 != null && tag2.getBeginIndex() <= tab2[0] ? gib.addTagBefore("F25", "END-OF-RECEPTION") : gib.addTag(tab2[0], tab2[1], "F25", "PROCEDURE"));
            tag2.setProperty("TagForXnnMP", "TagForXnnMP");
            tag2.setProperty("level", "05");
        }
        if (gib.tagFromName("F35") == null) {
            tab2 = PacbaseNodeTreeConverter.SearchSubFunctionFrom(gib.tagFromName("PROCEDURE"), "F35");
            tag2 = gib.tagFromName("END-OF-RECEPTION");
            boolean bl = notFound = tab2[0] == tab2[1] && tab2[0] == 0;
            tag2 = notFound && tag2 != null ? gib.addTagBefore("F35", "END-OF-RECEPTION") : (tag2 != null && tag2.getBeginIndex() <= tab2[0] ? gib.addTagBefore("F35", "END-OF-RECEPTION") : gib.addTag(tab2[0], tab2[1], "F35", "PROCEDURE"));
            tag2.setProperty("TagForXnnMP", "TagForXnnMP");
            tag2.setProperty("level", "05");
        }
        if ((f25Tag = gib.tagFromName("F25")) != null && !f25Tag.getParent().getName().equals("PROCEDURE")) {
            gib.removeTag("F25");
            tag2 = gib.addTagBefore("F25", "F35");
            tag2.setProperty("TagForXnnMP", "TagForXnnMP");
            tag2.setProperty("level", "05");
        }
        if (gib.tagFromName("F60") == null && (tag = gib.addTag((tab = PacbaseNodeTreeConverter.SearchSubFunctionFrom(gib.tagFromName("PROCEDURE"), "F60"))[0], tab[1], "F60", "PROCEDURE")) != null) {
            tag.setProperty("TagForXnnMP", "TagForXnnMP");
            tag.setProperty("level", "05");
        }
        if ((tagF2599 = gib.tagFromName("F2599")) != null && tagF2599.getLength() == 0) {
            tagF2599.setProperty("hidden", "true");
        }
        if (gib.tagFromName("F80") != null) {
            this.modifyF80subFunctions(gib);
        }
    }

    private void modifyF80subFunctions(IGenInfoBuilder genInfoBuilder) {
        IBuilderTag tag = genInfoBuilder.tagFromName("F80");
        List<IBuilderTag> allFunctiontags = this.collectSubFunctionTags(tag);
        Iterator<IBuilderTag> itTags = allFunctiontags.iterator();
        ArrayList<String> grandParentList = new ArrayList<String>();
        while (itTags.hasNext()) {
            String parentTagName;
            tag = itTags.next();
            String refProperty = tag.getProperty("ref");
            String fctName = tag.getName();
            boolean fctWithSUP = false;
            Iterator<String> iterator = this.listIndexForFonctionToSup.iterator();
            while (iterator.hasNext() && !fctWithSUP) {
                String string = iterator.next();
                fctWithSUP = string.startsWith(fctName);
            }
            if (refProperty == null || fctWithSUP) continue;
            int index = (refProperty = refProperty.trim()).indexOf(32);
            String segmentCode = refProperty.substring(0, index == -1 ? refProperty.length() : index);
            String grandParentTagName = "F80-" + segmentCode;
            if (index != -1 && genInfoBuilder.tagFromName(grandParentTagName) == null && !grandParentList.contains(grandParentTagName)) {
                grandParentList.add(grandParentTagName);
            }
            if ((parentTagName = "F80-" + refProperty.replace(' ', '-')).equals(tag.getParent().getName())) continue;
            int begin = tag.getBeginIndex();
            int end = tag.getEndIndex();
            if (genInfoBuilder.tagFromName(parentTagName) != null) {
                begin = genInfoBuilder.tagFromName(parentTagName).getBeginIndex();
                genInfoBuilder.removeTag(genInfoBuilder.tagFromName(parentTagName));
            }
            IBuilderTag tagCreated = genInfoBuilder.addTag(begin, end, parentTagName, tag.getParent().getName());
            this.copyPropertiesFrom(tag, tagCreated, true);
            tagCreated.setProperty("level", "09.5");
        }
        Iterator itGP = grandParentList.iterator();
        while (itGP.hasNext()) {
            tag = genInfoBuilder.tagFromName("F80");
            String tagNameToCreate = (String)itGP.next();
            String endOfTagToCreate = tagNameToCreate.substring(tagNameToCreate.indexOf("-") + 1);
            tag = tag.firstSon();
            int beginIndex = 0;
            int endIndex = 0;
            IBuilderTag originalTag = null;
            while (tag != null) {
                if (tag.getName().startsWith(tagNameToCreate) || "SF80".equals(tag.getProperty("SpecialF80")) && tag.getProperty("ref") != null && tag.getProperty("ref").startsWith(endOfTagToCreate)) {
                    if (beginIndex == 0) {
                        originalTag = tag;
                        beginIndex = tag.getBeginIndex();
                        endIndex = tag.getEndIndex();
                    } else {
                        endIndex = tag.getEndIndex();
                    }
                }
                tag = tag.nextTag();
            }
            if (beginIndex == 0 || endIndex == beginIndex) continue;
            IBuilderTag tagCreated = genInfoBuilder.addTag(beginIndex, endIndex, tagNameToCreate, "F80");
            this.copyPropertiesFrom(originalTag, tagCreated, false);
            tagCreated.setProperty("level", "09.5");
        }
    }

    private void copyPropertiesFrom(IBuilderTag originalTag, IBuilderTag newTag, boolean firstLevelCopy) {
        Iterator itp = originalTag.propertyNames();
        while (itp.hasNext()) {
            String propertyName = (String)itp.next();
            if ("origine".equals(propertyName) || "params".equals(propertyName) || PROPERTY_MSP.equals(propertyName) || "level".equals(propertyName) || "action".equals(propertyName) && !firstLevelCopy) continue;
            newTag.setProperty(propertyName, originalTag.getProperty(propertyName));
        }
    }

    private void collectSegmentsForFunctionTagsForServer(IBuilderTag tag, ArrayList<IBuilderTag> resultBegin, ArrayList<IBuilderTag> resultEnd, List<String> segments) {
        String[] string = tag.getName().split("-");
        String[] ref = null;
        if (tag.getProperty("ref") != null) {
            ref = tag.getProperty("ref").split(" ");
        }
        if (string.length == 3 || string.length == 4 && string[3].equals("ALL")) {
            if (segments.indexOf(string[1]) == -1) {
                segments.add(string[1]);
                resultBegin.add(tag);
                resultEnd.add(tag);
            } else {
                resultEnd.add(tag);
            }
        } else if (string.length == 1 && "*R".equals(tag.getProperty("action")) && ref.length > 0 && !"HELP".equals(ref[0]) && !"LE00".equals(ref[0]) && !"OKKO".equals(ref[0])) {
            if (segments.indexOf(ref[0]) == -1) {
                segments.add(ref[0]);
                resultBegin.add(tag);
                resultEnd.add(tag);
            } else {
                resultEnd.add(tag);
            }
        } else if (tag.firstSon() != null) {
            tag = tag.firstSon();
            do {
                this.collectSegmentsForFunctionTagsForServer(tag, resultBegin, resultEnd, segments);
            } while ((tag = tag.nextTag()) != null);
        }
    }

    private List<IBuilderTag> collectSubFunctionTags(IBuilderTag tag) {
        ArrayList<IBuilderTag> result = new ArrayList<IBuilderTag>();
        if (tag.getProperty(PROPERTY_MSP) != null && tag.getProperty("level") != null && "*R".equals(tag.getProperty("action")) && (!"ZZ".equals(tag.getProperty("refInPgm")) || "F8095".equals(tag.getName()) || "F8098".equals(tag.getName()) || "F8099".equals(tag.getName()))) {
            if ("SF80".equals(tag.getProperty("SpecialF80"))) {
                return result;
            }
            String refProperty = tag.getProperty("ref");
            if (refProperty == null) {
                return result;
            }
            if ("HELP".equals(refProperty = refProperty.trim()) || "LE00".equals(refProperty) || "OKKO".equals(refProperty)) {
                String sortProperty = tag.getProperty("sort");
                if (sortProperty == null) {
                    return result;
                }
                if ("HELP".equals(refProperty) && sortProperty.startsWith("980095") || "LE00".equals(refProperty) && sortProperty.startsWith("980098") || "OKKO".equals(refProperty) && sortProperty.startsWith("980099")) {
                    result.add(tag);
                }
            } else {
                result.add(tag);
            }
            return result;
        }
        if (tag.firstSon() != null) {
            tag = tag.firstSon();
            do {
                result.addAll(this.collectSubFunctionTags(tag));
            } while ((tag = tag.nextTag()) != null);
        }
        return result;
    }

    protected String getNewLine(String text) {
        if (this.new_line == null) {
            this.new_line = PdpTool.determineDelimiterOfV2((CharSequence)text);
        }
        return this.new_line;
    }

    private boolean isEmptyTag(Node node) {
        if (node == null) {
            return false;
        }
        String text = null;
        if (node.isNodeText()) {
            text = ((NodeText)node).getContent();
        } else if (node.isNodeTag() && ((NodeTag)node).getChildren().size() == 1) {
            text = ((NodeTag)node).getFirstNodeText().getContent();
        }
        return text != null && text.length() != 0 && text.charAt(0) != ' ' && text.trim().length() <= 6;
    }

    public void visit(NodeText node) {
        String[] lines;
        String text = node.getContent();
        String newLine = this.getNewLine(text);
        int index = text.indexOf("*!");
        if (index != -1) {
            lines = PdpTool.splitTextIntoArrayLines((String)text);
            StringBuilder newText = new StringBuilder();
            int i = 0;
            while (i < lines.length) {
                String currentLine = lines[i];
                if (currentLine.length() > 8 && currentLine.charAt(6) == '*' && currentLine.charAt(7) == '!' && Character.isLetter(currentLine.charAt(8))) {
                    int length;
                    int ind = (currentLine = Merge.trimRight(currentLine)).indexOf(32, 8);
                    if (ind != -1 && (length = currentLine.length()) > 72 && currentLine.endsWith("DOT")) {
                        length -= 3;
                        while (currentLine.charAt(length - 1) == ' ') {
                            --length;
                        }
                        if (ind == length) {
                            ind = -1;
                        }
                    }
                    if (ind == -1) {
                        PacbaseNodeTag tg = (PacbaseNodeTag)node.getParentNode();
                        currentLine = PacbaseNodeTreeConverter.GetplValueFor(currentLine, tg.getProperty("sort"));
                    }
                }
                newText.append(currentLine);
                newText.append(newLine);
                ++i;
            }
            node.setModifyContent(newText.toString());
        }
        this.dealWithMacroLevel(node);
        if (PacbaseNodeTreeConverter.markAtEndOfLine()) {
            String newText = this.addMarkToRightMargin(node, this.getEntityName((PacbaseNodeTag)node.getParentNode()));
            this.createArtificialCreateTagIfNeeded(node, newText);
        } else {
            super.visit(node);
        }
        text = node.getContent();
        if (text.contains("*!")) {
            lines = PdpTool.splitTextIntoArrayLines((String)text);
            int i = 0;
            while (i < lines.length) {
                String line = lines[i];
                if (line.contains("*!SUP")) {
                    this.listIndexForFonctionToSup.add(node.getParentNode().getName());
                    break;
                }
                if (line.contains("*!SQL")) {
                    this.listIndexForFonctionSQL.add(node.getParentNode().getName());
                    break;
                }
                if (line.contains("*!N ")) {
                    this.listForNmicroPatterns.add(node.getParentNode().getName());
                    break;
                }
                ++i;
            }
        }
    }

    private void createArtificialCreateTagIfNeeded(NodeText node, String text) {
        if ("artificialCreate".equals(node.getParentNode().getProperty(PROPERTY_MSP))) {
            Node n = node.getNextSibling();
            NodeTag firstSibling = null;
            if (n instanceof NodeTag) {
                firstSibling = (NodeTag)n;
            }
            Stack<NodeTag> allEmptyNodes = new Stack<NodeTag>();
            while (this.isEmptyTag(n)) {
                if (n instanceof NodeTag) {
                    allEmptyNodes.push((NodeTag)n);
                }
                n = n.getNextSibling();
            }
            if (n != null && n instanceof PacbaseNodeTag) {
                PacbaseNodeTag pnt = (PacbaseNodeTag)n;
                String name = null;
                if ("server".equals(this.model)) {
                    StringBuilder newName = new StringBuilder(pnt.getName().substring(0, 5));
                    if (pnt.getName().length() == 8) {
                        newName.append(pnt.getName().substring(5));
                        newName.append("_Label");
                    } else {
                        newName.append(pnt.getName().substring(5, 8));
                    }
                    name = newName.toString();
                } else {
                    PacbaseSort ps = pnt.getPacbaseSort((PacbaseComparator)node.getNodeTree().getComparator());
                    StringBuilder newName = new StringBuilder("F");
                    newName.append(ps.getFunction());
                    if (pnt.isForSubFunction()) {
                        newName.append(ps.getOnlySubFunction());
                    }
                    String lineNumber1 = ps.endTag.substring(0, Math.min(3, ps.endTag.length()));
                    String lineNumber2 = "";
                    if (ps.endTag.length() > 3) {
                        lineNumber2 = ps.endTag.substring(3, Math.min(6, ps.endTag.length()));
                    }
                    newName.append(lineNumber1.trim());
                    if (lineNumber2.trim().length() == 0) {
                        newName.append("_Label");
                    }
                    name = newName.toString();
                }
                if (firstSibling != null) {
                    while (!allEmptyNodes.isEmpty() && this.tagToDelete == null) {
                        NodeTag nt = (NodeTag)allEmptyNodes.pop();
                        if (!name.equals(nt.getName())) continue;
                        this.tagToDelete = nt;
                    }
                    if (this.tagToDelete == null && name.equals(firstSibling.getName())) {
                        this.tagToDelete = firstSibling;
                    }
                }
                this.genInfofactory.beginTag(name);
                this.genInfofactory.setProperty(PROPERTY_MSP, "artificialCreate");
                this.genInfofactory.appendText((CharSequence)text);
                this.genInfofactory.endTag();
                return;
            }
        }
        this.genInfofactory.appendText((CharSequence)text);
    }

    private void dealWithMacroLevel(NodeText node) {
        NodeTag parentNode = node.getParentNode();
        if (parentNode.getProperty("sort").startsWith("9")) {
            NodeTag bodyTag = null;
            String levelProperty = parentNode.getProperty("level");
            if (parentNode.getName().endsWith("-BODY")) {
                bodyTag = parentNode;
            }
            while (parentNode != null && levelProperty == null) {
                if ((parentNode = parentNode.getParentNode()) == null) continue;
                if (parentNode.getName().endsWith("-BODY")) {
                    bodyTag = parentNode;
                }
                levelProperty = parentNode.getProperty("level");
            }
            if (parentNode != null && parentNode.getProperty(PROPERTY_MSP) != null && !"MSPVIRT".equals(parentNode.getProperty(PROPERTY_MSP)) && parentNode.getProperty("level") != null && bodyTag != null && bodyTag.getFirstNodeText() != null && bodyTag.getFirstNodeText().equals(node)) {
                String text = node.getContent();
                String newLine = this.getNewLine(text);
                String[] lines = PdpTool.splitTextIntoArrayLines((String)text);
                StringBuilder newText = new StringBuilder();
                boolean update = false;
                int i = 0;
                while (i < lines.length) {
                    String line = lines[i];
                    if (!update) {
                        String label = this.getLineLabel(line);
                        if (label != null && !label.endsWith("-FN")) {
                            newText.append(this.addValueToRightMargin(line, "lv" + levelProperty));
                            newText.append(newLine);
                            update = true;
                        } else {
                            newText.append(line);
                            newText.append(newLine);
                        }
                    } else {
                        newText.append(line);
                        newText.append(newLine);
                    }
                    ++i;
                }
                if (update) {
                    node.setModifyContent(newText.toString());
                }
            }
        }
    }

    private String getLineLabel(String line) {
        if (line.length() < 10 || line.charAt(6) == '*' || line.charAt(6) == '-') {
            return null;
        }
        boolean found = false;
        int i = 7;
        if (line.charAt(7) == 'F' || line.charAt(7) == 'f') {
            found = true;
            int c = 32;
            i = 8;
            while (i < line.length()) {
                c = line.charAt(i);
                if (c == 46) break;
                ++i;
            }
        }
        if (!found) {
            return null;
        }
        return line.substring(7, i);
    }

    private String addValueToRightMargin(String currentLine, String markToAppend) {
        if (currentLine.trim().length() == 0) {
            return currentLine;
        }
        String rightMargin = null;
        StringBuilder line = null;
        boolean isMarkToAppend = true;
        if (currentLine.length() > 71) {
            rightMargin = currentLine.substring(72);
            if (rightMargin.trim().length() == 0) {
                line = new StringBuilder(currentLine.substring(0, 72));
            } else {
                line = new StringBuilder(currentLine);
                isMarkToAppend = false;
            }
        } else {
            line = new StringBuilder(currentLine);
            while (line.length() < 72) {
                line.append(" ");
            }
        }
        if (isMarkToAppend) {
            line.append(markToAppend);
        }
        return line.toString();
    }

    private String addMarkToRightMargin(NodeText node, String markToAppend) {
        String text = node.getContent();
        if (text.trim().length() == 0) {
            return text;
        }
        boolean isProcedure = node.getParentNode().getProperty("sort").startsWith("9");
        String newLine = this.getNewLine(text);
        String[] lines = PdpTool.splitTextIntoArrayLines((String)text);
        StringBuilder newText = new StringBuilder();
        boolean isLabel = false;
        String entityName = node.getNodeTree().getRootTag().getFirstNodeTag().getName();
        if (entityName.startsWith("ENTITY_")) {
            entityName = entityName.substring(7);
        }
        boolean isDialog = "dialog".equals(node.getNodeTree().getRootTag().getProperty("model"));
        int i = 0;
        while (i < lines.length) {
            block10: {
                block11: {
                    block8: {
                        block9: {
                            String rightMargin;
                            if (!isProcedure) break block8;
                            isLabel = false;
                            if (lines[i].length() > 8 && lines[i].charAt(6) == ' ' && lines[i].charAt(7) != ' ') {
                                String subText = lines[i].substring(7);
                                isLabel = true;
                                if (isDialog && (subText.startsWith("F25-FN.") || subText.startsWith("F35-FN.") || subText.startsWith("F60-FN.") || subText.startsWith("F65-FN.")) && markToAppend.equals(entityName)) {
                                    isLabel = false;
                                }
                                if (subText.startsWith("PROCEDURE")) {
                                    isLabel = false;
                                }
                            }
                            if (lines[i].length() <= 71 || ((rightMargin = lines[i].substring(72).trim()).length() <= 0 || !rightMargin.equals("DOT") || isLabel) && !rightMargin.startsWith("lv") && !rightMargin.equals("COA")) break block9;
                            newText.append(lines[i]);
                            newText.append(newLine);
                            break block10;
                        }
                        if (isLabel) {
                            int ind = lines[i].length() > 71 ? 72 : lines[i].length();
                            newText.append(lines[i].substring(0, ind));
                        } else {
                            newText.append(this.addValueToRightMargin(lines[i], markToAppend));
                        }
                        break block11;
                    }
                    newText.append(this.addValueToRightMargin(lines[i], markToAppend));
                }
                newText.append(newLine);
            }
            ++i;
        }
        return newText.toString();
    }

    public String getEntityName(PacbaseNodeTag node) {
        if (node.getProperty(PROPERTY_MSP) != null) {
            return node.getProperty(PROPERTY_MSP);
        }
        NodeTag rt = node.getNodeTree().getRootTag().getFirstNodeTag();
        String entityName = rt.getName();
        if (entityName.startsWith("ENTITY_")) {
            entityName = entityName.substring(7);
        }
        return entityName;
    }

    public String getEntityName(String tagName) {
        String entityName = tagName;
        if (entityName.startsWith("ENTITY_")) {
            entityName = entityName.substring(7);
        }
        return entityName;
    }

    public static int[] SearchSubFunctionsCategoryFrom(IBuilderTag startTag, String category) {
        int[] tabRes = new int[2];
        IBuilderTag currentTag = startTag.firstSon();
        boolean found = false;
        boolean firstFound = false;
        while (!found && currentTag != null) {
            String categ = currentTag.getProperty("categ");
            if (category.equals(categ)) {
                if (!firstFound) {
                    tabRes[0] = currentTag.getBeginIndex();
                }
                tabRes[1] = currentTag.getEndIndex();
            } else {
                found = firstFound;
            }
            currentTag = currentTag.nextTag();
        }
        return tabRes;
    }

    public static int[] SearchSubFunctionFrom(IBuilderTag startTag, String function) {
        int[] tabRes = new int[2];
        IBuilderTag currentTag = startTag.firstSon();
        IBuilderTag result = startTag;
        String currentFct = null;
        boolean found = false;
        while (!found && currentTag != null) {
            currentFct = currentTag.getName().substring(0, 3);
            if (currentFct.charAt(0) == 'F') {
                boolean bl = found = EBCDICCompare.stringCompare((String)currentFct, (String)function) >= 0;
                if (found) {
                    currentFct = result.getName();
                    break;
                }
            }
            result = currentTag;
            currentTag = currentTag.nextTag();
        }
        if (found) {
            tabRes[0] = currentTag.getBeginIndex();
            found = false;
            while (!found && currentTag != null) {
                currentFct = currentTag.getName().substring(0, 3);
                if (currentFct.charAt(0) == 'F') {
                    String lev;
                    boolean bl = found = EBCDICCompare.stringCompare((String)currentFct, (String)function) > 0;
                    if (!found && "05".compareTo(lev = currentTag.getProperty("level")) > 0) {
                        found = true;
                    }
                    if (found) {
                        currentFct = result.getName();
                        tabRes[1] = currentTag.getBeginIndex();
                        break;
                    }
                }
                result = currentTag;
                currentTag = currentTag.nextTag();
            }
        }
        return tabRes;
    }

    private StringBuilder addMarkIfNeeded(StringBuilder tmp, String markToAppend) {
        if (PacbaseNodeTreeConverter.markAtEndOfLine()) {
            while (tmp.length() < 72) {
                tmp.append(" ");
            }
            tmp.append(markToAppend);
        }
        return tmp;
    }

    public static PacGeneratedSkeletonLanguageValues SearchGeneratedSkeletonLanguageFor(RadicalEntity re) {
        PacGeneratedSkeletonLanguageValues lang = null;
        if (re instanceof PacScreen) {
            PacScreenWrapper p = new PacScreenWrapper((PacScreen)re);
            lang = p.getGenerationParameter().getSkeletonLanguage();
        } else if (re instanceof PacServer) {
            PacServerWrapper p = new PacServerWrapper((PacServer)re);
            lang = p.getGenerationParameter().getSkeletonLanguage();
        } else if (re instanceof PacProgram) {
            PacProgramWrapper p = new PacProgramWrapper((PacProgram)re);
            lang = p.getGenerationParameter().getSkeletonLanguage();
        }
        return lang;
    }

    public static void RemoveAllTagsFrom(IGenInfoBuilder gib, IBuilderTag tag) {
        while (tag.hasSon()) {
            PacbaseNodeTreeConverter.RemoveAllTagsFrom(gib, tag.firstSon());
            gib.removeTag(tag.firstSon());
        }
    }

    public static boolean markAtEndOfLine() {
        String result = System.getProperty("markAtEndOfLine");
        return result == null || "true".equals(result);
    }
}

