/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.merge;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.macro.common.merge.Node;
import com.ibm.pdp.macro.common.merge.NodeRootTag;
import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.common.merge.NodeText;
import com.ibm.pdp.macro.common.merge.NodeTree;
import com.ibm.pdp.macro.pacbase.extension.Ebcdic;
import com.ibm.pdp.macro.pacbase.merge.PacbaseCSClientComparator;
import com.ibm.pdp.macro.pacbase.merge.PacbaseCSServerComparator;
import com.ibm.pdp.macro.pacbase.merge.PacbaseComparator;
import com.ibm.pdp.macro.pacbase.merge.PacbaseDialogComparator;
import com.ibm.pdp.macro.pacbase.merge.PacbaseEBusinessComparator;
import com.ibm.pdp.macro.pacbase.merge.PacbaseNodeRootTag;
import com.ibm.pdp.macro.pacbase.merge.PacbaseNodeTag;
import com.ibm.pdp.macro.pacbase.merge.PacbaseSpecialNodeText;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacGeneratedLanguageValues;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.impl.PacMacroImpl;
import com.ibm.pdp.mdl.pacbase.util.PacDialogWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacProgramWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacScreenWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacServerWrapper;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class PacbaseNodeTree
extends NodeTree {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    String model = null;
    private static String declaratives = "DECLARATIVES.";
    private static String secDeclaratives = "SEC";
    private static String sectionDeclaratives = "SECTION.";
    private String variant = "X";
    private String variantLanguage = "X";
    private String alphanumericDelimiter = "'";
    private String indic = null;
    private PacGeneratedLanguageValues generatedLanguage = null;
    static final ArrayList<String> dialogFunctions = new ArrayList();
    private PacTreeMap<String, ArrayList<NodeTag>> treeTags;
    private PacTreeMap<String, NodeTag> newTreeTags;
    private HashMap<String, String> treeNodesForStar;
    private HashMap<String, ArrayList<String>> hashmapForStarAPB;
    private HashMap<String, ArrayList<String>> hashmapForStarR;
    private boolean isStarForF80BeforeF8095 = false;
    private HashMap<String, ArrayList<String>> treeSorts;
    private ArrayList<Node> nodeTextComments;
    private ArrayList<String> logicalViewForServer;
    private String inputOutputField;
    private ArrayList<String> segmentForServer;
    private TreeMap<String, PacbaseNodeTag> creationFunctionsAndSubFunction;
    private ArrayList<Node> treeNodesWithSUP = null;
    private ArrayList<String> functionsSUP = null;
    private ArrayList<String> functions80EX = null;
    private ArrayList<String> OverrideFunctions = null;
    private ArrayList<NodeTag> treeTagsForOutOfProcSubstitution = null;
    private ArrayList<NodeTag> treeTagsWithElse = null;
    private ArrayList<NodeTag> treeTagsWithIf = null;
    private ArrayList<NodeTag> treeTagsWithIfSpecialMspvirt = null;
    private ArrayList<NodeTag> treeTagsWithDCDIDV = null;
    private ArrayList<NodeTag> treeTagsWithDo = null;
    private ArrayList<NodeTag> treeTagsWithDw = null;
    private ArrayList<NodeTag> treeTagsWithDu = null;
    private HashMap<String, PacbaseNodeTag> treeTagsForIndicesI;
    private HashMap<String, PacbaseNodeTag> treeTagsForIndicesIJ;
    private ArrayList<NodeTag> userServices = null;
    private ArrayList<String> treeTagsForDeclaratives;
    private NodeTag TreeTagF80ServerForSUP = null;
    private NodeTag tagProcedure;
    private NodeTag tagLinkage;
    private NodeTag afterIndex;
    private HashMap<String, ArrayList<NodeTag>> TitlesForSuppressDouble = null;
    private ArrayList<String> doubleStarRServer = null;
    private boolean codeMvtPresentF35;
    private boolean specialF65;
    private HashMap<String, PacbaseNodeTag> treeTagsF80Folder;
    private ArrayList<PacbaseNodeTag> nodesLevel00;

    static {
        dialogFunctions.add("20");
        dialogFunctions.add("25");
        dialogFunctions.add("30");
        dialogFunctions.add("35");
        dialogFunctions.add("60");
        dialogFunctions.add("65");
        dialogFunctions.add("80");
    }

    public PacbaseNodeTree(IGeneratedInfo genMgr, boolean b) {
        super(genMgr);
        this.setMerge(b);
        String model = this.getRootTag().getProperty("model");
        if (model != null) {
            if (model.equals("dialog")) {
                this.setComparator(new PacbaseDialogComparator());
                String entityName = this.getRootTag().getFirstNodeTag().getName();
                ((PacbaseDialogComparator)this.getComparator()).setCodeMvtPresentF35(this.isCodeMvtPresentF35());
                ((PacbaseDialogComparator)this.getComparator()).setSpecialF65(this.isSpecialF65());
                if (entityName.startsWith("ENTITY_")) {
                    entityName = entityName.substring(7);
                }
                ((PacbaseDialogComparator)this.getComparator()).setHelpScreen(entityName.substring(2).equals("HELP"));
            } else if (model.equals("client") || model.equals("client_monit") || model.equals("server_monit") || model.equals("commun_monit")) {
                this.setComparator(new PacbaseCSClientComparator());
            } else if (model.equals("server")) {
                this.setComparator(new PacbaseCSServerComparator());
            } else if (model.equals("folder_monit") || model.equals("server_ITtyp") || model.equals("folder")) {
                this.setComparator(new PacbaseEBusinessComparator());
            } else {
                this.setComparator(new PacbaseComparator());
            }
        } else {
            this.setComparator(new PacbaseComparator());
        }
    }

    public PacbaseNodeTree() {
        this.getRootTag().setName("Root");
        this.genInfoProperties = new Properties();
        this.genInfoProperties.setProperty("freeFormatting", "true");
        this.genInfoProperties.setProperty("ignoreCase", "true");
        this.setComparator(new PacbaseComparator());
    }

    public void clean(boolean onlyNodeTextFromMacro) {
        ((PacbaseNodeRootTag)this.getRootTag()).lineFeedManagement(onlyNodeTextFromMacro);
        this.verifyIndices();
    }

    public void cleanWithoutSNT() {
        ((PacbaseNodeRootTag)this.getRootTag()).lineFeedManagementWithoutSNT();
        this.verifyIndices();
    }

    public HashMap<String, ArrayList<String>> getTreeSorts() {
        if (this.treeSorts == null) {
            this.treeSorts = new HashMap();
        }
        return this.treeSorts;
    }

    public HashMap<String, ArrayList<String>> getHashmapForStarAPB() {
        if (this.hashmapForStarAPB == null) {
            this.hashmapForStarAPB = new HashMap();
        }
        return this.hashmapForStarAPB;
    }

    public HashMap<String, ArrayList<String>> getHashmapForStarR() {
        if (this.hashmapForStarR == null) {
            this.hashmapForStarR = new HashMap();
        }
        return this.hashmapForStarR;
    }

    public HashMap<String, String> getTreeNodesForStar() {
        if (this.treeNodesForStar == null) {
            this.treeNodesForStar = new HashMap();
        }
        return this.treeNodesForStar;
    }

    public ArrayList<Node> getTreeNodesWithSUP() {
        if (this.treeNodesWithSUP == null) {
            this.treeNodesWithSUP = new ArrayList();
        }
        return this.treeNodesWithSUP;
    }

    public ArrayList<String> getOverrideFunctions() {
        if (this.OverrideFunctions == null) {
            this.OverrideFunctions = new ArrayList();
        }
        return this.OverrideFunctions;
    }

    public ArrayList<Node> getNodeTextComments() {
        if (this.nodeTextComments == null) {
            this.nodeTextComments = new ArrayList();
        }
        return this.nodeTextComments;
    }

    public String getInputOutputField() {
        return this.inputOutputField;
    }

    public String getIndic() {
        return this.indic;
    }

    public PacGeneratedLanguageValues getGeneratedLanguage() {
        return this.generatedLanguage;
    }

    public ArrayList<String> getLogicalViewForServer() {
        if (this.logicalViewForServer == null) {
            this.logicalViewForServer = new ArrayList();
        }
        return this.logicalViewForServer;
    }

    public ArrayList<String> getSegmentForServer() {
        if (this.segmentForServer == null) {
            this.segmentForServer = new ArrayList();
        }
        return this.segmentForServer;
    }

    public TreeMap<String, PacbaseNodeTag> getCreationFunctionsAndSubFunction() {
        if (this.creationFunctionsAndSubFunction == null) {
            this.creationFunctionsAndSubFunction = new TreeMap();
        }
        return this.creationFunctionsAndSubFunction;
    }

    public ArrayList<String> getTreeTagsForDeclaratives() {
        if (this.treeTagsForDeclaratives == null) {
            this.treeTagsForDeclaratives = new ArrayList();
        }
        return this.treeTagsForDeclaratives;
    }

    public ArrayList<NodeTag> getTreeTagsForOutOfProcSubstitution() {
        if (this.treeTagsForOutOfProcSubstitution == null) {
            this.treeTagsForOutOfProcSubstitution = new ArrayList();
        }
        return this.treeTagsForOutOfProcSubstitution;
    }

    public HashMap<String, ArrayList<NodeTag>> getTitlesForSuppressDouble() {
        if (this.TitlesForSuppressDouble == null) {
            this.TitlesForSuppressDouble = new HashMap();
        }
        return this.TitlesForSuppressDouble;
    }

    public ArrayList<String> getFunctions80EX() {
        if (this.functions80EX == null) {
            this.functions80EX = new ArrayList();
        }
        return this.functions80EX;
    }

    public ArrayList<String> getFunctionsSUP() {
        if (this.functionsSUP == null) {
            this.functionsSUP = new ArrayList();
        }
        return this.functionsSUP;
    }

    public ArrayList<NodeTag> getTreeTagsWithElse() {
        if (this.treeTagsWithElse == null) {
            this.treeTagsWithElse = new ArrayList();
        }
        return this.treeTagsWithElse;
    }

    public ArrayList<NodeTag> getTreeTagsWithIf() {
        if (this.treeTagsWithIf == null) {
            this.treeTagsWithIf = new ArrayList();
        }
        return this.treeTagsWithIf;
    }

    public ArrayList<NodeTag> getTreeTagsWithIfSpecialMspvirt() {
        if (this.treeTagsWithIfSpecialMspvirt == null) {
            this.treeTagsWithIfSpecialMspvirt = new ArrayList();
        }
        return this.treeTagsWithIfSpecialMspvirt;
    }

    public ArrayList<NodeTag> getTreeTagsWithDCDIDV() {
        if (this.treeTagsWithDCDIDV == null) {
            this.treeTagsWithDCDIDV = new ArrayList();
        }
        return this.treeTagsWithDCDIDV;
    }

    public ArrayList<NodeTag> getTreeTagsWithDo() {
        if (this.treeTagsWithDo == null) {
            this.treeTagsWithDo = new ArrayList();
        }
        return this.treeTagsWithDo;
    }

    public ArrayList<String> getDoubleStarRServer() {
        if (this.doubleStarRServer == null) {
            this.doubleStarRServer = new ArrayList();
        }
        return this.doubleStarRServer;
    }

    public ArrayList<NodeTag> getTreeTagsWithDw() {
        if (this.treeTagsWithDw == null) {
            this.treeTagsWithDw = new ArrayList();
        }
        return this.treeTagsWithDw;
    }

    public HashMap<String, PacbaseNodeTag> getTreeTagsF80Folder() {
        if (this.treeTagsF80Folder == null) {
            this.treeTagsF80Folder = new HashMap();
        }
        return this.treeTagsF80Folder;
    }

    public ArrayList<NodeTag> getTreeTagsWithDu() {
        if (this.treeTagsWithDu == null) {
            this.treeTagsWithDu = new ArrayList();
        }
        return this.treeTagsWithDu;
    }

    public ArrayList<PacbaseNodeTag> getNodesLevel00() {
        if (this.nodesLevel00 == null) {
            this.nodesLevel00 = new ArrayList();
        }
        return this.nodesLevel00;
    }

    public HashMap<String, PacbaseNodeTag> getTreeTagsForIndicesI() {
        if (this.treeTagsForIndicesI == null) {
            this.treeTagsForIndicesI = new HashMap();
        }
        return this.treeTagsForIndicesI;
    }

    public HashMap<String, PacbaseNodeTag> getTreeTagsForIndicesIJ() {
        if (this.treeTagsForIndicesIJ == null) {
            this.treeTagsForIndicesIJ = new HashMap();
        }
        return this.treeTagsForIndicesIJ;
    }

    public ArrayList<NodeTag> getUserServices() {
        if (this.userServices == null) {
            this.userServices = new ArrayList();
        }
        return this.userServices;
    }

    public NodeTag getTagProcedure() {
        return this.tagProcedure;
    }

    public NodeTag getTagLinkage() {
        return this.tagLinkage;
    }

    public NodeTag getAfterIndex() {
        return this.afterIndex;
    }

    public NodeTag getTreeTagF80ServerForSUP() {
        return this.TreeTagF80ServerForSUP;
    }

    public String getVariant() {
        return this.variant;
    }

    public String getVariantLanguage() {
        return this.variantLanguage;
    }

    public String getAlphanumericDelimiter() {
        return this.alphanumericDelimiter;
    }

    public void setGenerationParameters(RadicalEntity re) {
        switch (re.eClass().getClassifierID()) {
            case 37: {
                PacMacroImpl p = (PacMacroImpl)re;
                if (p.getGenerationParameter() == null) break;
                this.variant = p.getGenerationParameter().getCobolType().getLiteral().substring(1);
                this.alphanumericDelimiter = p.getGenerationParameter().getAlphanumericDelimiter();
                break;
            }
            case 39: {
                PacProgramWrapper p = new PacProgramWrapper((PacProgram)re);
                this.variantLanguage = p.getVariante().getLiteral();
                this.variant = p.getGenerationParameter().getCobolType().getLiteral().substring(1);
                for (Object obj : p.getGenerationParameter().getGOLines()) {
                    String optionsGO;
                    int index;
                    if (!(obj instanceof PacGLine) || (index = (optionsGO = ((PacGLine)obj).getDescription()).indexOf("INDIC=")) == -1) continue;
                    this.setIndic(optionsGO.substring(index + 6));
                }
                this.alphanumericDelimiter = p.getGenerationParameter().getAlphanumericDelimiter();
                this.generatedLanguage = p.getGenerationParameter().getGeneratedLanguage();
                break;
            }
            case 70: {
                PacScreenWrapper p = new PacScreenWrapper((PacScreen)re);
                this.variantLanguage = p.getCobolType().getLiteral();
                this.variant = p.getGenerationParameter().getCobolType().getLiteral().substring(1);
                this.alphanumericDelimiter = p.getGenerationParameter().getAlphanumericDelimiter();
                break;
            }
            case 72: {
                PacDialogWrapper p = new PacDialogWrapper((PacDialog)re);
                this.variantLanguage = p.getCobolType().getLiteral();
                this.variant = p.getGenerationParameter().getCobolType().getLiteral().substring(1);
                this.alphanumericDelimiter = p.getGenerationParameter().getAlphanumericDelimiter();
                break;
            }
            case 101: {
                PacServerWrapper p = new PacServerWrapper((PacServer)re);
                this.variantLanguage = p.getCobolType().getLiteral();
                this.variant = p.getGenerationParameter().getCobolType().getLiteral().substring(1);
                this.alphanumericDelimiter = p.getGenerationParameter().getAlphanumericDelimiter();
            }
        }
    }

    public void setTagProcedure(NodeTag nt) {
        this.tagProcedure = nt;
    }

    public void setNodesLevel00(ArrayList<PacbaseNodeTag> alPnt) {
        this.nodesLevel00 = alPnt;
    }

    public void setTagLinkage(NodeTag nt) {
        this.tagLinkage = nt;
    }

    public void setAfterIndex(NodeTag nt) {
        this.afterIndex = nt;
    }

    public void setTreeTagF80ServerForSUP(NodeTag nt) {
        this.TreeTagF80ServerForSUP = nt;
    }

    public void setInputOutputField(String s) {
        this.inputOutputField = s;
    }

    public void setIndic(String s) {
        this.indic = s;
    }

    public void setGeneratedLanguage(PacGeneratedLanguageValues p) {
        this.generatedLanguage = p;
    }

    public PacTreeMap<String, ArrayList<NodeTag>> getTreeTags() {
        if (this.treeTags == null) {
            this.treeTags = new PacTreeMap(new Ebcdic());
        }
        return this.treeTags;
    }

    public PacTreeMap<String, NodeTag> getNewTreeTags() {
        if (this.newTreeTags == null) {
            this.newTreeTags = new PacTreeMap(new Ebcdic());
        }
        return this.newTreeTags;
    }

    protected NodeRootTag instanciateNodeRootTag() {
        return new PacbaseNodeRootTag(this);
    }

    public NodeTag instanciateNodeTag() {
        return new PacbaseNodeTag();
    }

    protected NodeText instanciateCarriageReturn(String carriageReturn) {
        return new PacbaseSpecialNodeText();
    }

    public void initializeArrays() {
        super.initializeArrays();
    }

    protected boolean isGoodFather(String nodeSort, NodeTag parent) {
        if (parent instanceof NodeRootTag || parent == null) {
            return false;
        }
        String parentSort = parent.getProperty("sort");
        if ((nodeSort.equals("H") || nodeSort.equals("I  40   ") || nodeSort.equals("160     ")) && parentSort.equals("A")) {
            return true;
        }
        if (nodeSort.startsWith("I  ") && Integer.parseInt(nodeSort.substring(3, 5)) < 40 && parentSort.equals("H")) {
            return true;
        }
        if ((nodeSort.equals("100     ") || nodeSort.equals("101     ") || nodeSort.equals("1  40  0")) && parentSort.equals("I  40   ")) {
            return true;
        }
        if (nodeSort.startsWith("1  40") && nodeSort.trim().length() > 5 && parentSort.equals("1  40  0")) {
            return true;
        }
        if (nodeSort.startsWith("100") && nodeSort.trim().length() > 3 && parentSort.equals("100     ")) {
            return true;
        }
        if (nodeSort.startsWith("101") && nodeSort.trim().length() > 3 && parentSort.equals("101     ")) {
            return true;
        }
        if ((nodeSort.equals("19999   ") || nodeSort.equals("3") || nodeSort.equals("160    0")) && parentSort.equals("160     ")) {
            return true;
        }
        if (nodeSort.startsWith("160") && nodeSort.trim().length() > 3 && parentSort.equals("160    0")) {
            return true;
        }
        if ((nodeSort.startsWith("2") && nodeSort.trim().length() < 4 || nodeSort.equals("19999  0")) && parentSort.equals("19999   ")) {
            return true;
        }
        if (nodeSort.startsWith("19999") && nodeSort.trim().length() > 5 && parentSort.equals("19999  0")) {
            return true;
        }
        if (nodeSort.startsWith("2") && nodeSort.trim().length() < 7 && nodeSort.substring(0, 3).startsWith(parentSort.substring(0, 3))) {
            return true;
        }
        if ((nodeSort.equals("3  0") || nodeSort.equals("30")) && parentSort.equals("3")) {
            return true;
        }
        if ((nodeSort.equals("30A") || nodeSort.equals("300") || nodeSort.equals("300A")) && parentSort.equals("30")) {
            return true;
        }
        if ((nodeSort.equals("3 0A") || nodeSort.equals("3 00") || nodeSort.equals("3 00A")) && parentSort.equals("3 0")) {
            return true;
        }
        return nodeSort.startsWith("7") && parent.getName().equals("PROCEDURE-DIVISION");
    }

    public boolean isGroupingPossibleFor(NodeTag node) {
        String sort = node.getProperty("sort");
        return sort.startsWith("I") && sort.trim().length() > 5 || sort.startsWith("100") && sort.trim().length() > 5 || sort.startsWith("101") && sort.trim().length() > 5 || sort.startsWith("160") && sort.trim().length() > 3 || sort.startsWith("2") && sort.trim().length() > 3 || (sort.startsWith("3") || sort.startsWith("7")) && sort.length() > 5 && node.getProperty("type") == null || sort.startsWith("9") && sort.trim().length() > 8;
    }

    public void regroupTag(ArrayList<NodeTag> nts) {
        Iterator<NodeTag> itTag = nts.iterator();
        NodeTag ntResult = itTag.next();
        StringBuilder nText = new StringBuilder();
        while (itTag.hasNext()) {
            NodeTag nttmp = itTag.next();
            Iterator itText = nttmp.allSubNodeTexts();
            while (itText.hasNext()) {
                nText.append(((NodeText)itText.next()).getContent());
            }
        }
        itTag = nts.iterator();
        itTag.next();
        while (itTag.hasNext()) {
            NodeTag ntTag = itTag.next();
            ntTag.getParentNode().removeNodeTagAndHisChildren((Node)ntTag);
        }
        ntResult.getLastNodeText().append(nText.toString());
        this.clean(false);
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String m) {
        this.model = m;
    }

    private boolean isCodeMvtPresentF35() {
        if (this.codeMvtPresentF35) {
            return this.codeMvtPresentF35;
        }
        return false;
    }

    public boolean isStarForF80BeforeF8095() {
        return this.isStarForF80BeforeF8095;
    }

    private boolean isSpecialF65() {
        if (this.specialF65) {
            return this.specialF65;
        }
        return false;
    }

    private void setCodeMvtPresentF35(Boolean b) {
        this.codeMvtPresentF35 = b;
    }

    private void setSpecialF65(Boolean b) {
        this.specialF65 = b;
    }

    protected void terminateTag(NodeTag node) {
        super.terminateTag(node);
        if (node instanceof PacbaseNodeTag) {
            StringBuilder sb;
            String model;
            PacbaseNodeTag pnt = (PacbaseNodeTag)node;
            String nodeSort = pnt.getSort();
            String action = pnt.getAction();
            PacbaseNodeTag parentPnt = null;
            if (node.getParentNode() != null && !(node.getParentNode() instanceof NodeRootTag)) {
                parentPnt = (PacbaseNodeTag)node.getParentNode();
            }
            if (node.getName().equals("LINKAGE")) {
                this.setTagLinkage(node);
            }
            if (node.getName().equals("AFTER-INDEX")) {
                this.setAfterIndex(node);
            }
            if (nodeSort != null) {
                if (pnt.isIndiceTagI() || pnt.isIndiceTagJ()) {
                    String s = null;
                    s = nodeSort.charAt(0) == '4' ? nodeSort.substring(1) : nodeSort.substring(nodeSort.length() - 5, nodeSort.length());
                    if (pnt.isIndiceTagI()) {
                        this.getTreeTagsForIndicesI().put(s, pnt);
                    }
                    this.getTreeTagsForIndicesIJ().put(s, pnt);
                }
                if (pnt.isProcedureTag()) {
                    boolean isNumberLine$ = false;
                    if (node.getName().length() > 6 && node.getName().substring(5).contains("$")) {
                        isNumberLine$ = true;
                    }
                    if (pnt.isBodyTag() || pnt.is900Line() || pnt.isFNTag()) {
                        node.setFixedTag(true);
                    } else if (parentPnt != null && nodeSort.length() > 6 && (pnt.getMSPName() != null && nodeSort.length() <= 12 || pnt.getMSPName() == null && nodeSort.length() < 10 || nodeSort.contains("-")) && parentPnt.getSort().length() > 6 && nodeSort.substring(0, 6).equals(parentPnt.getSort().substring(0, 6)) && !isNumberLine$) {
                        node.setFixedTag(true);
                    }
                } else if (!nodeSort.startsWith("8") && this.isGoodFather(nodeSort, parentPnt)) {
                    node.setFixedTag(true);
                }
            }
            if (node.getName().indexOf(36) >= 0) {
                this.getTreeNodesWithParam().add(node);
            } else {
                String level = pnt.getLevel();
                if (nodeSort != null && nodeSort.indexOf(36) >= 0 || level != null && level.indexOf(36) >= 0 || pnt.getRef() != null && pnt.getRef().indexOf(36) >= 0) {
                    this.getTreeNodesWithParam().add(node);
                }
            }
            NodeText nt = node.getNodeText();
            if (nt != null && nt.getContent().indexOf(36) >= 0) {
                this.getTreeNodesWithParam().add(nt);
            }
            if (!(nodeSort == null || pnt.isBodyTag() || pnt.isFNTag() || pnt.is900Line())) {
                this.getNewTreeTags().put(nodeSort.trim(), node);
            }
            if ((model = node.getNodeTree().getRootTag().getProperty("model")) != null && (model.equals("folder") || model.equals("folder_monit"))) {
                this.terminateTagForFolder(node);
            }
            if (nodeSort != null) {
                if (pnt.isProcedureTag() && pnt.getLevel() == null && nodeSort.length() < 8 && !pnt.isProcedure() && !pnt.isProcedureDivision() && action == null) {
                    return;
                }
                if (nodeSort.length() > 13 && !nodeSort.endsWith("A ")) {
                    return;
                }
                if (pnt.isSpecialLineProcedure()) {
                    sb = new StringBuilder();
                    sb.append(nodeSort.substring(0, 6));
                    sb.append(nodeSort.substring(9));
                    ArrayList<Object> nodeTags = this.getTreeTags().get(sb.toString());
                    if (nodeTags != null && nodeTags.indexOf(node) == -1) {
                        nodeTags.add(node);
                    } else {
                        nodeTags = new ArrayList();
                        nodeTags.add(node);
                        this.getTreeTags().put(sb.toString(), nodeTags);
                    }
                } else if (nodeSort.charAt(0) != '4' || nodeSort.length() < 4 || pnt.getName().charAt(0) != 'I') {
                    ArrayList<NodeTag> nodeTags = new ArrayList<NodeTag>();
                    nodeTags.add(node);
                    this.getTreeTags().put(pnt.getSort().trim(), nodeTags);
                }
                ArrayList<String> sorts = new ArrayList<String>();
                sorts.add(nodeSort);
                if (this.getTreeSorts().containsKey(nodeSort)) {
                    sorts.addAll((Collection)this.getTreeSorts().get(nodeSort));
                }
                this.getTreeSorts().put(nodeSort, sorts);
                if (nodeSort.startsWith("90A")) {
                    String textForDeclaratives = node.getFirstNodeText().getContent();
                    if (textForDeclaratives.contains(declaratives) && textForDeclaratives.indexOf(declaratives) == 7) {
                        this.getTreeTagsForDeclaratives().add("90A0  A");
                    } else if (textForDeclaratives.contains(secDeclaratives) && textForDeclaratives.indexOf(secDeclaratives) == 7 && textForDeclaratives.contains(sectionDeclaratives)) {
                        String sort = nodeSort;
                        if (nodeSort.length() > 6) {
                            sort = sort.substring(0, 6);
                        }
                        this.getTreeTagsForDeclaratives().add(String.valueOf(sort) + "A");
                    }
                }
            }
            if (this.getModel() != null && (this.getModel().equals("dialog") || this.getModel().equals("client") || this.getModel().equals("client_monit") || this.getModel().equals("server_monit") || this.getModel().equals("commun_monit"))) {
                this.terminateTagForDialogOrCSClient(node);
            }
            if (model != null && (model.equals("dialog") || model.equals("client") || model.equals("client_monit") || model.equals("server_monit") || model.equals("commun_monit"))) {
                this.terminateTagForDialogOrCSClient(node);
            }
            if (this.getModel() != null && this.getModel().equals("server") || model != null && model.equals("server")) {
                this.terminateTagForCSServer(node);
            }
            if (this.getModel() != null && node.getNodeTree().getRootTag().getProperty("model") == null) {
                this.terminateTagForCreationSubFunction(node);
            }
            if (pnt.getMSPName() != null) {
                if (!pnt.isProcedureTag() && action != null && action.equals("*R") && pnt.getRef() != null) {
                    this.getTreeTagsForOutOfProcSubstitution().add(node);
                }
                if (pnt.isNxxOrNxxyyTag() && !pnt.getMSPName().equals("MSPVIRT")) {
                    String sort6c = pnt.getSort().substring(0, 6);
                    if (this.getTitlesForSuppressDouble().get(sort6c) != null) {
                        this.getTitlesForSuppressDouble().get(sort6c).add(node);
                    } else {
                        ArrayList<NodeTag> alnt = new ArrayList<NodeTag>();
                        alnt.add(node);
                        this.getTitlesForSuppressDouble().put(sort6c, alnt);
                    }
                }
                if (node.getNodeText() != null && node.getNodeText().getContent().indexOf("*!SUP") != -1) {
                    sb = new StringBuilder(9);
                    if (nodeSort.length() > 9) {
                        sb.append(nodeSort.substring(0, 6));
                        sb.append(nodeSort.substring(9, 12));
                    } else {
                        sb.append(nodeSort);
                    }
                    if (this.getFunctionsSUP().indexOf(sb.toString()) == -1) {
                        this.getFunctionsSUP().add(sb.toString());
                    }
                }
                if ("\u00a3\u00a380EX".equals(pnt.getMSPName())) {
                    String s = pnt.getSort().substring(0, 6);
                    if (this.getFunctions80EX().indexOf(s) == -1) {
                        this.getFunctions80EX().add(pnt.getSort().substring(0, 6));
                    }
                }
                if (node.getName().equals("PROCEDURE-DIVISION")) {
                    this.setTagProcedure(node);
                }
                if (this.getModel() != null && action != null && action.equals("R")) {
                    this.getTreeNodesWithSUP().add((Node)node);
                }
                if (this.getModel() != null && pnt.isForFunction() && (this.getModel().equals("batch") && this.isGeneratedBatchFunction(nodeSort.substring(1, 3)) || (this.getModel().equals("dialog") || this.getModel().equals("client") || this.getModel().equals("client_monit") || this.getModel().equals("server_monit") || this.getModel().equals("commun_monit")) && !pnt.isFunction05())) {
                    String function = nodeSort.substring(1, 3);
                    if (this.getOverrideFunctions().indexOf(function) == -1) {
                        this.getOverrideFunctions().add(function);
                    }
                }
                if ("00".equals(pnt.getLevel())) {
                    this.getNodesLevel00().add(pnt);
                }
            }
        }
    }

    protected boolean isGeneratedBatchFunction(String s) {
        return s.equals("01") || s.equals("05") || s.equals("10") || s.equals("20") || s.equals("22") || s.equals("24") || s.equals("26") || s.equals("30") || s.equals("33") || s.equals("36") || s.equals("39") || s.equals("42") || s.equals("45") || s.equals("51") || s.equals("70") || s.equals("73") || s.equals("76") || s.equals("8E") || s.equals("90") || s.equals("95");
    }

    protected void terminateTagForDialogOrCSClient(NodeTag node) {
        if (node instanceof PacbaseNodeTag) {
            String model;
            PacbaseNodeTag pnt = (PacbaseNodeTag)node;
            String nodeSort = pnt.getSort();
            String action = node.getProperty("action");
            if (nodeSort != null && pnt.isProcedureTag() && pnt.getCateg() != null && nodeSort.length() > 3 && (nodeSort.substring(4, 6).equals("A ") || nodeSort.substring(4, 6).equals("R ") || nodeSort.substring(4, 6).equals("Z "))) {
                node.setFixedTag(true);
            }
            if (nodeSort != null && pnt.isProcedureTag() && nodeSort.length() > 2 && pnt.getMSPName() != null && dialogFunctions.contains(nodeSort.substring(1, 3)) && (!nodeSort.substring(1, 3).equals("25") || !nodeSort.substring(4, 6).equals("99"))) {
                String nodeLevel = pnt.getLevel();
                NodeTag parentNode = node.getParentNode();
                if (!(action != null && !action.startsWith("*") || pnt.getRef() != null && node.getProperty("remove_properties") == null)) {
                    if (nodeLevel != null) {
                        PacbaseNodeTag previousNode = (PacbaseNodeTag)node.getPreviousSiblingWithoutSNT();
                        if (nodeSort.substring(4, 6).trim().length() != 0 && (this.getModel() != null && !this.getModel().equals("commun_monit") || node.getAllNodeTexts().toString().indexOf("*!SUP") == -1) && !nodeSort.substring(1, 6).equals("80095") && !nodeSort.substring(1, 6).equals("80098") && !nodeSort.substring(1, 6).equals("80099") && (previousNode == null || !previousNode.getSort().substring(1, 3).equals(nodeSort.substring(1, 3)) || previousNode.getRefPgm() != null && previousNode.getRefPgm().equals("ZZ") || nodeSort.substring(1, 3).equals("25") && previousNode.getSort().substring(1, 3).equals(nodeSort.substring(1, 3)) && previousNode.getLevel() != null && !(Float.valueOf(nodeLevel).floatValue() > Float.valueOf(previousNode.getLevel()).floatValue()))) {
                            node.getProperties().setProperty("refInPgm", "ZZ");
                        }
                        if (pnt.isFunction80() && node.getProperties().getProperty("level").equals("10")) {
                            node.getProperties().setProperty("level", "09.5");
                        }
                    } else if (parentNode instanceof PacbaseNodeRootTag) {
                        node.getProperties().setProperty("refInPgm", "ZZ");
                    }
                }
                pnt.getMSPName();
                if (action != null && action.equals("*R")) {
                    if (pnt.isFunction80() && pnt.getLevel().equals("10") && pnt.getRef() != null && pnt.getRef().trim().indexOf(" ") == -1) {
                        node.getProperties().setProperty("level", "09.5");
                    }
                    if (!this.isSUPFunction(pnt)) {
                        String ref;
                        ArrayList<Object> al;
                        if (this.getHashmapForStarR().containsKey(nodeSort.substring(1, 3))) {
                            al = this.getHashmapForStarR().get(nodeSort.substring(1, 3));
                            ref = pnt.getRef();
                            if (ref != null) {
                                if (pnt.isFunction20() && ref.trim().length() > 6) {
                                    ref = ref.substring(0, 6).trim();
                                }
                                if (ref.indexOf(" P1") != -1) {
                                    ref = ref.substring(0, ref.length() - 1);
                                }
                                al.add(ref.trim());
                            }
                        } else {
                            al = new ArrayList();
                            ref = pnt.getRef();
                            if (ref != null) {
                                if (pnt.isFunction20() && ref.trim().length() > 6) {
                                    ref = ref.substring(0, 6).trim();
                                }
                                if (ref.indexOf(" P1") != -1) {
                                    ref = ref.substring(0, ref.length() - 1);
                                }
                                al.add(ref.trim());
                            }
                            this.getHashmapForStarR().put(nodeSort.substring(1, 3), al);
                            if (pnt.isFunction80() && EBCDICCompare.stringCompare((String)nodeSort.substring(4, 6), (String)"95") < 0) {
                                this.isStarForF80BeforeF8095 = true;
                            }
                        }
                    }
                }
            }
            if ((model = this.getRootTag().getProperty("model")) != null && (model.equals("dialog") || model.equals("client") || model.equals("client_monit") || model.equals("server_monit") || model.equals("commun_monit")) && pnt.getMSPName() == null) {
                if (node.getName().equals("INPUT-SCREEN-FIELDS")) {
                    this.setInputOutputField(node.getNodeText().getContent());
                }
                if (pnt.isFunction35() && "06".equals(pnt.getLevel())) {
                    this.setCodeMvtPresentF35(true);
                }
                if (pnt.isFunction65() && "05.5".equals(pnt.getLevel()) && "A".equals(pnt.getCateg())) {
                    int i = 0;
                    while (i < pnt.getAllNodeTexts().size()) {
                        this.setSpecialF65(true);
                        NodeText nText = (NodeText)pnt.getAllNodeTexts().get(i);
                        if (nText.getContent().indexOf("F65A.") != -1) {
                            this.setSpecialF65(false);
                            break;
                        }
                        ++i;
                    }
                }
                if (pnt.getRef() != null && dialogFunctions.contains(nodeSort.substring(1, 3))) {
                    if (pnt.isFunction80()) {
                        this.terminateTagForDialogOrCSClientForF80(node, this.getRootTag().getProperty("model"));
                    } else if (!model.equals("client") && !model.equals("client_monit") || !pnt.isFunction60() || !pnt.getName().endsWith("-2")) {
                        this.getTreeNodesForStar().put(String.valueOf(nodeSort.substring(1, 3)) + pnt.getRef().trim(), nodeSort.substring(4, 6));
                    }
                }
            }
        }
    }

    private boolean isSUPFunction(PacbaseNodeTag pnt) {
        int i = 0;
        while (i < this.getFunctionsSUP().size()) {
            String sort = this.getFunctionsSUP().get(i);
            if (sort.substring(0, 6).equals(pnt.getSort().substring(0, 6))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void terminateTagForDialogOrCSClientForF80(NodeTag node, String model) {
        PacbaseNodeTag pnt = (PacbaseNodeTag)node;
        String nodeSort = pnt.getSort();
        String ref = pnt.getRef();
        if (model.equals("dialog")) {
            this.getTreeNodesForStar().put(String.valueOf(nodeSort.substring(1, 3)) + ref.trim(), nodeSort.substring(6, 9));
        } else {
            this.getTreeNodesForStar().put(String.valueOf(nodeSort.substring(1, 3)) + ref.trim(), nodeSort.substring(4, 9));
        }
    }

    protected void terminateTagForCreationSubFunction(NodeTag node) {
        PacbaseNodeTag pnt = (PacbaseNodeTag)node;
        String nodeSort = pnt.getSort();
        if (nodeSort.trim().length() > 6 && nodeSort.charAt(0) == '9') {
            String function = nodeSort.substring(1, 3);
            String subFunction = nodeSort.substring(4, 6);
            String endSort = null;
            if (nodeSort.length() > 6) {
                endSort = nodeSort.substring(6).trim();
            }
            if (!(function.trim().length() <= 0 || nodeSort.charAt(3) != '0' || endSort == null || endSort.equals("A") || endSort.startsWith("A*") || endSort.startsWith("$") || endSort.equals("B"))) {
                NodeTag parentNode = node.getParentNode();
                String parentNodeSort = parentNode.getProperty("sort");
                String parentFunction = null;
                String parentSubFunction = null;
                if (parentNodeSort != null && parentNodeSort.trim().length() > 6) {
                    parentFunction = parentNodeSort.substring(1, 3);
                    parentSubFunction = parentNodeSort.substring(4, 6);
                }
                if (!function.equals(parentFunction) || !subFunction.equals(parentSubFunction)) {
                    StringBuilder sb = new StringBuilder(9);
                    sb.append('9');
                    sb.append(function);
                    sb.append('0');
                    sb.append(subFunction);
                    sb.append('A');
                    String refInPgm = pnt.getRefPgm();
                    if (refInPgm != null) {
                        sb.append(refInPgm);
                    }
                    if (this.getCreationFunctionsAndSubFunction().get(sb.toString()) == null) {
                        this.getCreationFunctionsAndSubFunction().put(sb.toString(), (PacbaseNodeTag)node);
                    }
                }
            }
        }
    }

    protected void terminateTagForFolder(NodeTag node) {
        PacbaseNodeTag pnt = (PacbaseNodeTag)node;
        if (pnt.getSort().startsWith("980")) {
            this.getTreeTagsF80Folder().put(pnt.getSort(), pnt);
        }
    }

    protected void terminateTagForCSServer(NodeTag node) {
        ArrayList<Object> al;
        String function;
        PacbaseNodeTag pnt = (PacbaseNodeTag)node;
        String nodeSort = pnt.getSort();
        String action = pnt.getAction();
        String reference = pnt.getRef();
        if (pnt.getMSPName() == null && nodeSort != null) {
            if (nodeSort.startsWith("9K") || nodeSort.startsWith("9O")) {
                String view = nodeSort.substring(2, 6);
                if (!this.getLogicalViewForServer().contains(view.trim())) {
                    this.getLogicalViewForServer().add(view.trim());
                }
            }
            if (nodeSort.startsWith("9P") || nodeSort.startsWith("9Q") || nodeSort.startsWith("9S") || nodeSort.startsWith("9T")) {
                String segment = nodeSort.substring(2, 6);
                if (!this.getSegmentForServer().contains(segment.trim())) {
                    this.getSegmentForServer().add(segment.trim());
                }
            }
        }
        if (pnt.getMSPName() != null && nodeSort.substring(1, 3).equals("80") && nodeSort.substring(4, 6).equals("  ") && node.getAllNodeTexts().toString().indexOf("*!SUP") != -1) {
            this.setTreeTagF80ServerForSUP(node);
        }
        pnt.getMSPName();
        if (action != null && action.equals("*R") && !this.isSUPFunction(pnt)) {
            function = nodeSort.substring(1, 3);
            String subFunction = nodeSort.substring(4, 6);
            if (!function.equals("80") || subFunction.equals("99") || !reference.trim().equals("OKKO")) {
                if (function.equals("80") || function.equals("81")) {
                    ArrayList<Object> al2;
                    if (function.equals("80") && (reference == null || reference.trim().length() == 0)) {
                        reference = "99";
                    }
                    if (this.getHashmapForStarR().containsKey(nodeSort.substring(1, 3))) {
                        al2 = this.getHashmapForStarR().get(function);
                        al2.add(reference.trim());
                    } else {
                        al2 = new ArrayList();
                        if (reference != null) {
                            al2.add(reference.trim());
                        }
                        this.getHashmapForStarR().put(function, al2);
                    }
                } else {
                    String logicalViewOrSegment = ((PacbaseNodeTag)node).getLogicalViewOrSegmentForServer((PacbaseNodeTag)node).trim();
                    if (this.getHashmapForStarR().containsKey(logicalViewOrSegment)) {
                        al = this.getHashmapForStarR().get(logicalViewOrSegment);
                        if (al.size() > 0) {
                            if (al.indexOf(reference.trim()) == -1) {
                                al.add(reference.trim());
                            } else {
                                this.getDoubleStarRServer().add(reference.trim());
                            }
                        }
                    } else {
                        al = new ArrayList<String>();
                        al.add(reference.trim());
                        this.getHashmapForStarR().put(logicalViewOrSegment, al);
                    }
                }
            }
        }
        if (action != null && (action.equals("*A") || action.equals("*P") || action.equals("*B")) && reference.trim().indexOf(" ") != -1 && !this.isSUPFunction(pnt) && !(function = nodeSort.substring(1, 3)).equals("80") && !function.equals("81")) {
            String logicalViewOrSegment = ((PacbaseNodeTag)node).getLogicalViewOrSegmentForServer((PacbaseNodeTag)node).trim();
            StringBuilder sb = new StringBuilder();
            sb.append(action);
            sb.append(" ");
            sb.append(logicalViewOrSegment);
            sb.append(" ");
            sb.append(reference);
            if (this.getHashmapForStarAPB().containsKey(sb.toString().trim())) {
                al = this.getHashmapForStarAPB().get(sb.toString().trim());
                if (al.size() > 0) {
                    al.add(nodeSort);
                }
            } else {
                al = new ArrayList();
                al.add(nodeSort);
                this.getHashmapForStarAPB().put(sb.toString().trim(), al);
            }
        }
        if (action != null && action.equals("*C") && reference.trim().endsWith(" R")) {
            ArrayList al3;
            if (reference.startsWith("BS ")) {
                al3 = new ArrayList();
                this.getHashmapForStarR().put("BS", al3);
            } else if (reference.startsWith("ES ")) {
                al3 = new ArrayList();
                this.getHashmapForStarR().put("ES", al3);
            } else {
                al3 = new ArrayList();
                this.getHashmapForStarR().put(reference.substring(0, 4), al3);
            }
        }
        if (nodeSort != null && nodeSort.startsWith("9") && pnt.getMSPName() != null) {
            String nodeLevel = pnt.getLevel();
            if (action == null && nodeLevel != null && ((PacbaseNodeTag)node).getReference((PacbaseNodeTag)node).trim().length() > 0) {
                NodeTag previousNode = (NodeTag)node.getPreviousSiblingWithoutSNT();
                PacbaseNodeTag parentNode = (PacbaseNodeTag)node.getParentNode();
                String parentNodeAction = null;
                String parentNodeRef = null;
                if (parentNode != null) {
                    parentNodeAction = parentNode.getAction();
                    parentNodeRef = parentNode.getRef();
                }
                if (previousNode != null && (previousNode.getName().endsWith("-BODY") || !previousNode.isFixedTag()) && parentNodeAction != null && parentNodeAction.equals("*C") && parentNodeRef != null && parentNodeRef.trim().length() > 5 && parentNodeRef.trim().indexOf(" ") == 4 && parentNodeRef.trim().indexOf(" EX ") == -1 && parentNodeRef.trim().indexOf("USER ") == -1) {
                    node.setFixedTag(false);
                    Properties properties = node.getProperties();
                    properties.setProperty("ref", parentNodeRef);
                } else if (previousNode != null || parentNode != null) {
                    String previousLevel = previousNode.getProperty("level");
                    if (previousNode != null && !previousNode.isFixedTag() && (previousLevel == null || Float.valueOf(previousLevel).floatValue() >= Float.valueOf(nodeLevel).floatValue()) && Float.valueOf(nodeLevel).floatValue() > 10.0f) {
                        node.setFixedTag(false);
                    } else {
                        node.setFixedTag(true);
                    }
                }
            }
        }
    }

    public static class PacTreeMap<K, V> {
        TreeMap<K, V> treeMap = null;
        Set<K> keys = new HashSet<K>();

        public PacTreeMap(Comparator<? super K> comparator) {
            this.treeMap = new TreeMap(comparator);
            this.keys = new HashSet<K>();
        }

        public V put(K key, V value) {
            this.keys.add(key);
            return this.treeMap.put(key, value);
        }

        public V get(K key) {
            return this.treeMap.get(key);
        }

        public Set<K> keySet() {
            return this.treeMap.keySet();
        }

        public V remove(Object key) {
            this.keys.remove(key);
            return this.treeMap.remove(key);
        }

        public int size() {
            return this.treeMap.size();
        }

        public Map.Entry<K, V> floorEntry(K key) {
            return this.treeMap.floorEntry(key);
        }

        public boolean containsKey(K key) {
            return this.keys.contains(key);
        }
    }
}

