/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.merge;

import com.ibm.pdp.macro.common.merge.Node;
import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.pacbase.merge.PacbaseCSServerSort;
import com.ibm.pdp.macro.pacbase.merge.PacbaseComparator;
import com.ibm.pdp.macro.pacbase.merge.PacbaseSort;

public class PacbaseNodeTag
extends NodeTag {
    PacbaseSort pSort = null;
    PacbaseCSServerSort pCSSSort = null;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PacbaseNodeTag() {
    }

    public PacbaseNodeTag(String content) {
        super(content);
    }

    public Object clone() {
        PacbaseNodeTag clone = null;
        clone = (PacbaseNodeTag)((Object)super.clone());
        clone.pSort = null;
        return clone;
    }

    public boolean containsTag(String sort, String name) {
        if (name != null && name.equals("LINKAGE")) {
            for (Node node : this.getChildren()) {
                NodeTag nodetag;
                if (!(node instanceof NodeTag) || !name.equals((nodetag = (NodeTag)node).getName())) continue;
                return true;
            }
            Node currentNode = this.getFirstNode();
            if (currentNode != null && currentNode.containsTag(sort, name)) {
                return true;
            }
            currentNode = this.getNextSibling();
            return currentNode != null && currentNode.containsTag(sort, name);
        }
        return super.containsTag(sort, name);
    }

    public PacbaseSort getPacbaseSort(PacbaseComparator comp) {
        if (this.pSort == null || this.pSort.getComp() != comp) {
            this.pSort = new PacbaseSort(this, comp);
        }
        return this.pSort;
    }

    public PacbaseCSServerSort getPacbaseCSServerSort() {
        if (this.pCSSSort == null) {
            this.pCSSSort = new PacbaseCSServerSort(this);
        }
        return this.pCSSSort;
    }

    public String getLogicalViewOrSegmentForServer(PacbaseNodeTag pnt) {
        if (pnt.getParentNode() != null && pnt.getParentNode() instanceof PacbaseNodeTag) {
            if (pnt.getParentNode().getProperty("action") != null && (!pnt.getParentNode().getProperty("action").equals("*C") || pnt.getParentNode().getProperty("action").equals("*C") && pnt.getParentNode().getProperty("ref").indexOf("USER ") != -1) || pnt.getParentNode().getProperty("action") == null) {
                return this.getLogicalViewOrSegmentForServer((PacbaseNodeTag)pnt.getParentNode());
            }
            return pnt.getParentNode().getProperty("ref");
        }
        return " ";
    }

    public PacbaseNodeTag searchParentFloorNT(PacbaseNodeTag pntFloor) {
        if (pntFloor.getParentNode() != null && !pntFloor.getParentNode().getProperty("sort").trim().equals("9")) {
            return this.searchParentFloorNT((PacbaseNodeTag)pntFloor.getParentNode());
        }
        return pntFloor;
    }

    public String getForStar(PacbaseNodeTag pnt) {
        if (pnt.getParentNode() != null && pnt.getParentNode() instanceof PacbaseNodeTag) {
            if (pnt.getParentNode().getProperty("action") != null) {
                if (pnt.getParentNode().getProperty("action").equals("*A")) {
                    return "1";
                }
                if (pnt.getParentNode().getProperty("action").equals("*P")) {
                    return "3";
                }
                return " ";
            }
            this.getForStar((PacbaseNodeTag)pnt.getParentNode());
        }
        return " ";
    }

    public String getReference(PacbaseNodeTag pnt) {
        if (pnt.getParentNode() != null && pnt.getParentNode() instanceof PacbaseNodeTag) {
            if (pnt.getParentNode().getProperty("ref") != null) {
                return pnt.getParentNode().getProperty("ref");
            }
            return this.getReference((PacbaseNodeTag)pnt.getParentNode());
        }
        return "";
    }

    public String getReferenceInPgm(PacbaseNodeTag pnt) {
        if (pnt.getProperty("refInPgm") != null) {
            return pnt.getProperty("refInPgm");
        }
        if (pnt.getParentNode() != null && pnt.getParentNode() instanceof PacbaseNodeTag) {
            return this.getReferenceInPgm((PacbaseNodeTag)pnt.getParentNode());
        }
        return "";
    }

    public boolean isBodyTag() {
        return this.getName().indexOf("-BODY") != -1;
    }

    public boolean isFNTag() {
        String name = this.getName();
        return name.length() > 3 && name.substring(name.length() - 3, name.length()).equals("-FN");
    }

    public boolean is900Line() {
        return this.getName().indexOf("-900") != -1;
    }

    public String getSort() {
        return this.getProperty("sort");
    }

    public String getOrigine() {
        return this.getProperty("origine");
    }

    public String getAction() {
        return this.getProperty("action");
    }

    public String getLogicalView() {
        return this.getProperty("LogicalView");
    }

    public String getLevel() {
        return this.getProperty("level");
    }

    public String getCateg() {
        return this.getProperty("categ");
    }

    public String getRef() {
        return this.getProperty("ref");
    }

    public String getRefPgm() {
        return this.getProperty("refInPgm");
    }

    public boolean isIndiceTagJ() {
        return this.getName().charAt(0) == 'J' && (this.getSort().charAt(0) == '4' || this.getSort().length() > 8 && this.getSort().substring(0, 8).equals("3AA200DE"));
    }

    public boolean isIndiceTagI() {
        return this.getName().charAt(0) == 'I' && (this.getSort().charAt(0) == '4' || this.getSort().length() > 8 && this.getSort().substring(0, 8).equals("3AA200DE"));
    }

    public boolean isProcedureTag() {
        return this.getSort().charAt(0) == '9';
    }

    public boolean isProcedure() {
        return this.getSort().trim().equals("9");
    }

    public boolean isProcedureDivision() {
        return this.getSort().trim().equals("9  0");
    }

    public String getFunction() {
        return this.getSort().substring(1, 3);
    }

    public String getSubFunction() {
        return this.getSort().substring(4, 6);
    }

    public boolean isForFunction() {
        return this.isProcedureTag() && this.getSort().trim().length() > 6 && this.getSort().substring(4, 6).trim().length() == 0;
    }

    public boolean isForSubFunction() {
        return this.isProcedureTag() && this.getSort().trim().length() > 6 && this.getSort().substring(4, 6).trim().length() > 0;
    }

    public boolean isFxxOrFxxyyTag() {
        return this.isProcedureTag() && this.getSort().trim().length() == 7 && this.getSort().charAt(6) == 'A';
    }

    public boolean isNxxOrNxxyyTag() {
        return this.isProcedureTag() && this.getSort().trim().length() > 7 && this.getSort().substring(6, 8).equals("A*");
    }

    public boolean isLineProcedure() {
        return this.isProcedureTag() && this.getSort().trim().length() > 8 && this.getSort().charAt(7) != '*' && this.getSort().substring(1, 3).trim().length() > 0;
    }

    public boolean isAlphaLineProcedure() {
        return this.isLineProcedure() && (Character.isLetter(this.getSort().charAt(6)) || 10 == Character.getType(this.getSort().charAt(6)));
    }

    public boolean isSpecialLineProcedure() {
        return this.isProcedureTag() && !this.isNxxOrNxxyyTag() && (this.getSort().trim().length() == 11 || this.getSort().trim().length() == 12);
    }

    public boolean isServerSort() {
        return this.getSort().length() > 20;
    }

    public boolean isFunction25() {
        return this.isProcedureTag() && this.getSort().trim().length() > 3 && this.getSort().substring(1, 3).equals("25");
    }

    public boolean isFunction35() {
        return this.isProcedureTag() && this.getSort().trim().length() > 3 && this.getSort().substring(1, 3).equals("35");
    }

    public boolean isFunction05() {
        return this.isProcedureTag() && this.getSort().trim().length() > 3 && this.getSort().substring(1, 3).equals("05");
    }

    public boolean isFunction20() {
        return this.isProcedureTag() && this.getSort().trim().length() > 3 && this.getSort().substring(1, 3).equals("20");
    }

    public boolean isSpecialFunction2599() {
        return this.isProcedureTag() && this.getSort().trim().length() > 5 && this.getSort().substring(1, 3).equals("25") && this.getSort().substring(4, 6).equals("99");
    }

    public boolean isSpecialFunction9099() {
        return this.isProcedureTag() && this.getSort().trim().length() > 5 && this.getSort().substring(1, 3).equals("90") && this.getSort().substring(4, 6).equals("99");
    }

    public boolean isFunction30() {
        return this.isProcedureTag() && this.getSort().trim().length() > 3 && this.getSort().substring(1, 3).equals("30");
    }

    public boolean isFunction50() {
        return this.isProcedureTag() && this.getSort().trim().length() > 3 && this.getSort().substring(1, 3).equals("50");
    }

    public boolean isFunction60() {
        return this.isProcedureTag() && this.getSort().trim().length() > 3 && this.getSort().substring(1, 3).equals("60");
    }

    public boolean isFunction65() {
        return this.isProcedureTag() && this.getSort().trim().length() > 3 && this.getSort().substring(1, 3).equals("65");
    }

    public boolean isFunction80() {
        return this.isProcedureTag() && this.getSort().trim().length() > 3 && this.getSort().substring(1, 3).equals("80");
    }
}

