/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.merge;

import com.ibm.pdp.macro.common.merge.GenericComparator;
import com.ibm.pdp.macro.common.merge.Node;
import com.ibm.pdp.macro.common.merge.NodeRootTag;
import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.pacbase.extension.Ebcdic;
import com.ibm.pdp.macro.pacbase.merge.Merge;
import com.ibm.pdp.macro.pacbase.merge.PacbaseNodeTag;
import com.ibm.pdp.macro.pacbase.merge.PacbaseSort;
import java.util.ArrayList;

public class PacbaseComparator
implements GenericComparator {
    static final String[] idents = new String[]{"H", "I  40   ", "160     "};
    static final String[] dataIdents = new String[]{"160    0", "19999   ", "3"};
    String[] workingIdents = new String[]{"3", "30", "300A"};
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ArrayList<NodeTag> childsOfPrevious(NodeTag insert_node, NodeTag read_node, NodeTag savePrev) {
        ArrayList<NodeTag> aln = new ArrayList<NodeTag>();
        NodeTag parent_node = read_node.getParentNode();
        int i = parent_node.getChildren().indexOf(read_node);
        while (i < parent_node.getChildren().size()) {
            NodeTag nt;
            if (((Node)parent_node.getChildren().get(i)).isNodeTag() && !(nt = (NodeTag)parent_node.getChildren().get(i)).isFixedTag()) {
                String readSort = nt.getProperty("sort");
                String updateSort = insert_node.getProperty("sort");
                if (readSort.startsWith("9") && updateSort.startsWith("9") && readSort.length() > 3 && updateSort.length() > 3 && readSort.substring(1, 3).equals(updateSort.substring(1, 3))) {
                    String readLevel = nt.getProperty("level");
                    String updateLevel = insert_node.getProperty("level");
                    String previousLevel = savePrev.getProperty("level");
                    if (readLevel != null && previousLevel != null && Float.parseFloat(readLevel) <= Float.parseFloat(previousLevel)) {
                        return aln;
                    }
                    if (readLevel == null && readSort.length() > 8 && !readSort.substring(4, 6).equals(updateSort.substring(4, 6))) break;
                    if (readLevel != null && updateLevel != null && previousLevel != null && Float.parseFloat(readLevel) > Float.parseFloat(previousLevel) && Float.parseFloat(readLevel) <= Float.parseFloat(updateLevel)) {
                        aln.add(nt);
                    } else if (aln.size() > 0) break;
                }
            }
            ++i;
        }
        return aln;
    }

    public boolean isBrotherOfNode(NodeTag node, NodeTag brotherNode) {
        String nodeSort = node.getProperty("sort");
        String brotherNodeSort = brotherNode.getProperty("sort");
        if (nodeSort.startsWith("9") && brotherNodeSort.startsWith("9")) {
            String nodeLevel = node.getProperty("level");
            String brotherNodeLevel = brotherNode.getProperty("level");
            if (nodeLevel != null && nodeLevel.startsWith("$")) {
                nodeLevel = this.getDefaultLevel(((PacbaseNodeTag)node).getPacbaseSort(this));
            }
            if (brotherNodeLevel != null && brotherNodeLevel.startsWith("$")) {
                brotherNodeLevel = this.getDefaultLevel(((PacbaseNodeTag)brotherNode).getPacbaseSort(this));
            }
            if (nodeLevel == null || nodeLevel.length() == 0) {
                nodeLevel = "10";
            }
            if (brotherNodeLevel != null && (nodeLevel.equals(brotherNodeLevel) || brotherNode.getParentNode() != null && brotherNode.getParentNode().getProperty("level") == null)) {
                return true;
            }
            if (brotherNode.getParentNode() != null) {
                String parentLevel = brotherNode.getParentNode().getProperty("level");
                if (parentLevel != null && parentLevel.startsWith("$")) {
                    parentLevel = this.getDefaultLevel(((PacbaseNodeTag)brotherNode.getParentNode()).getPacbaseSort(this));
                }
                if (parentLevel == null || Float.parseFloat(parentLevel) < Float.parseFloat(nodeLevel)) {
                    return true;
                }
            }
        } else if (this.getIdentInList(nodeSort, idents).equals("160     ") && this.getIdentInList(brotherNodeSort, idents).equals("160     ") && (brotherNode.getParentNode() instanceof NodeRootTag || brotherNode.getParentNode().getProperty("sort").equals("160     "))) {
            return true;
        }
        return false;
    }

    private boolean isChildOfDataNode(NodeTag node, NodeTag childNode) {
        String refWkId;
        String nodeSort = node.getProperty("sort");
        String childNodeSort = childNode.getProperty("sort");
        if (childNodeSort.startsWith("9")) {
            return false;
        }
        String refDataId = this.getIdentInList(childNodeSort, dataIdents);
        if (refDataId.equals(nodeSort)) {
            return true;
        }
        if (node.getName().equals("LINKAGE") || node.getName().equals("PROCEDURE-DIVISION")) {
            return Ebcdic.stringCompare(childNodeSort, nodeSort) > 0;
        }
        return refDataId.equals("3") && this.isWellKnownIdent(this.workingIdents, nodeSort) && Ebcdic.stringCompare(nodeSort, refWkId = this.getIdentInList(childNodeSort, this.workingIdents)) <= 0;
    }

    private boolean isChildOfEnvironmentNode(String nodeSort, String childNodeSort) {
        if (!nodeSort.contains("$")) {
            if (nodeSort.equals("I  40  0")) {
                nodeSort = "I  40";
            }
            if (nodeSort.trim().length() == 3 && childNodeSort.substring(0, 3).equals(nodeSort.substring(0, 3))) {
                return true;
            }
            if (nodeSort.trim().length() == 5 && childNodeSort.substring(0, 5).equals(nodeSort.substring(0, 5))) {
                return true;
            }
        }
        return false;
    }

    private boolean isChildOfIdentificationNode(String nodeSort, String childNodeSort) {
        return childNodeSort.substring(0, 5).equals(nodeSort.substring(0, 5));
    }

    public boolean isChildOfNode(NodeTag node, NodeTag childNode) {
        String nodeSort = node.getProperty("sort");
        String childNodeSort = childNode.getProperty("sort");
        if (nodeSort.equals("A")) {
            return true;
        }
        if (nodeSort.startsWith("9") && childNodeSort.startsWith("9")) {
            return this.isChildOfProcedureNode((PacbaseNodeTag)node, (PacbaseNodeTag)childNode);
        }
        if (!nodeSort.startsWith("9") && !childNodeSort.startsWith("9")) {
            String refIdChildNode = this.getIdentInList(childNodeSort, idents);
            if (refIdChildNode.equals(nodeSort) && !childNode.getName().equals("LINKAGE")) {
                return true;
            }
            if (childNode.getName().equals("LINKAGE")) {
                return nodeSort.equals("160     ");
            }
            String refIdNode = this.getIdentInList(nodeSort, idents);
            if (refIdChildNode.equals(refIdNode)) {
                if (refIdChildNode.equals("H")) {
                    return this.isChildOfIdentificationNode(nodeSort, childNodeSort);
                }
                if (refIdChildNode.equals("I  40   ")) {
                    return this.isChildOfEnvironmentNode(nodeSort, childNodeSort);
                }
                if (refIdChildNode.equals("160     ")) {
                    return this.isChildOfDataNode(node, childNode);
                }
            }
        }
        return false;
    }

    protected boolean isChildOfProcedureNode(PacbaseNodeTag node, PacbaseNodeTag childNode) {
        String nodeLevel;
        PacbaseSort nodeSort = node.getPacbaseSort(this);
        PacbaseSort childNodeSort = childNode.getPacbaseSort(this);
        String childLevel = childNode.getProperty("level");
        if (nodeSort.getSort().trim().equals("9") && childNodeSort.getSort().trim().startsWith("9")) {
            return true;
        }
        if (nodeSort.getSort().trim().equals("9  0")) {
            return false;
        }
        if (nodeSort.getSort().trim().length() > 16) {
            return false;
        }
        if (nodeSort.getFunction().equals("25") && nodeSort.getFunction().equals(childNodeSort.getFunction())) {
            nodeLevel = node.getProperty("level");
            boolean isCategorie = false;
            PacbaseNodeTag previousPnt = null;
            if (childNode.getPreviousSibling() instanceof PacbaseNodeTag) {
                previousPnt = (PacbaseNodeTag)childNode.getPreviousSibling();
            }
            boolean bl = isCategorie = previousPnt != null && previousPnt.getLevel() != null && previousPnt.getLevel().equals("05.5");
            if (nodeLevel != null && childLevel != null && nodeLevel.length() > 0 && childLevel.length() > 0 && Float.parseFloat(childLevel) > Float.parseFloat(nodeLevel) && !isCategorie) {
                return true;
            }
        }
        if (!nodeSort.getFunction().equals("80") && !nodeSort.getSubFunction().substring(0, 2).equals(childNodeSort.getSubFunction().substring(0, 2))) {
            return false;
        }
        if (nodeSort.getSubFunction().trim().length() == 0) {
            if (childNodeSort.get4FirstCar().equals(nodeSort.get4FirstCar())) {
                return childLevel == null || !childLevel.equals("00");
            }
        } else {
            if (childNodeSort.getSort().trim().length() > 5 && childNodeSort.getFunctionSubFunction().equals(nodeSort.getFunctionSubFunction())) {
                return true;
            }
            nodeLevel = node.getProperty("level");
            if (nodeLevel != null && nodeLevel.startsWith("$")) {
                nodeLevel = this.getDefaultLevel(nodeSort);
            }
            if (childLevel != null && childLevel.startsWith("$")) {
                childLevel = this.getDefaultLevel(childNodeSort);
            }
            if (childNodeSort.get4FirstCar().equals(nodeSort.get4FirstCar()) && (childNodeSort.getSort().trim().length() > 16 ? nodeLevel != null && nodeLevel.length() > 0 && Float.parseFloat(nodeLevel) < 10.0f : nodeLevel != null && childLevel != null && nodeLevel.length() > 0 && childLevel.length() > 0 && Float.parseFloat(childLevel) > Float.parseFloat(nodeLevel))) {
                return true;
            }
        }
        return false;
    }

    public boolean isAReplacedNode(NodeTag node, NodeTag replacedNode) {
        return this.compareReadUpdate((PacbaseNodeTag)node, (PacbaseNodeTag)replacedNode) < 0;
    }

    private String getDefaultLevel(PacbaseSort pSort) {
        if (pSort.getSort().trim().length() > 3 && pSort.getSubFunction().trim().length() == 0) {
            return "05";
        }
        return "10";
    }

    public int compare(NodeTag previous_node, NodeTag read_node, NodeTag update_node) {
        String sort = update_node.getProperty("sort");
        if (sort.equals("A")) {
            return 5;
        }
        if (sort.startsWith("9")) {
            return this.compareProcedure(previous_node, read_node, update_node);
        }
        return this.compareExceptProcedure(previous_node, read_node, update_node);
    }

    public int compareProcedure(NodeTag previous_node, NodeTag read_node, NodeTag update_node) {
        int i = 0;
        if (read_node != null) {
            i = this.compareSort((PacbaseNodeTag)read_node, (PacbaseNodeTag)update_node);
            if (i > 0) {
                return i;
            }
            i = this.comparePreviousLevel((PacbaseNodeTag)previous_node, (PacbaseNodeTag)read_node, (PacbaseNodeTag)update_node);
            if (i > 0) {
                return i;
            }
            i = this.compareReadLevel((PacbaseNodeTag)read_node, (PacbaseNodeTag)update_node);
            return i;
        }
        i = this.comparePreviousLevel((PacbaseNodeTag)previous_node, null, (PacbaseNodeTag)update_node);
        if (i > 0) {
            return i;
        }
        return 4;
    }

    public int compareExceptProcedure(NodeTag previous_node, NodeTag read_node, NodeTag update_node) {
        String updateSort = update_node.getProperty("sort");
        if (read_node != null) {
            String readSort = read_node.getProperty("sort");
            if (readSort != null && Ebcdic.stringCompare(updateSort, readSort) > 0) {
                return 8;
            }
            if (this.isWellKnownIdent(idents, updateSort)) {
                String refIdRead;
                if (!readSort.startsWith("9") && updateSort.equals(refIdRead = this.getIdentInList(readSort, idents))) {
                    return 5;
                }
                return 3;
            }
        } else {
            if (previous_node.getProperty("sort").startsWith("A")) {
                return 7;
            }
            if (this.isWellKnownIdent(idents, updateSort)) {
                return 4;
            }
            if (previous_node.getProperty("sort").charAt(0) == '4' && updateSort.charAt(0) == '4') {
                return 4;
            }
        }
        if (updateSort.startsWith("H") || Ebcdic.stringCompare(updateSort.substring(0, updateSort.length()), "I  40   ") < 0) {
            return this.compareIdentificationDivision(previous_node, read_node, update_node);
        }
        if (updateSort.startsWith("I  40   ") || Ebcdic.stringCompare(updateSort.substring(0, updateSort.length()), "160     ") < 0) {
            return this.compareEnvironmentDivision(previous_node, read_node, update_node);
        }
        if (updateSort.startsWith("160     ") || Ebcdic.stringCompare(updateSort.substring(0, updateSort.length()), "9") < 0) {
            return this.compareDataDivision(previous_node, read_node, update_node);
        }
        return 0;
    }

    private int compareDataDivision(NodeTag previous_node, NodeTag read_node, NodeTag update_node) {
        String previousSort = null;
        if (previous_node != null && ((previousSort = previous_node.getProperty("sort")).equals("160     ") || previous_node.getName().equals("DATA"))) {
            return 7;
        }
        String updateSort = update_node.getProperty("sort");
        String dataIdUpdt = this.getIdentInList(updateSort, dataIdents);
        if (previousSort != null) {
            if (!dataIdUpdt.equals("3")) {
                String shortPrevSort = previousSort.substring(0, previousSort.length() - 1).trim();
                String shortUpdtSort = updateSort.substring(0, updateSort.length() - 1).trim();
                if (updateSort.trim().length() > 3 && shortPrevSort.length() < shortUpdtSort.length() && previousSort.startsWith(updateSort.substring(0, 3)) || previous_node.getName().equals("DATADIV") && updateSort.charAt(0) != '2' || previous_node.getName().equals("FILE")) {
                    return 7;
                }
            }
            if (previousSort.equals(dataIdUpdt) || previous_node.getName().equals("LINKAGE") || updateSort.startsWith("2") && updateSort.trim().length() < 7 && (previousSort.endsWith("  0") || previousSort.trim().length() == 3) && updateSort.substring(0, 3).startsWith(previousSort.substring(0, 3)) || updateSort.startsWith(previousSort) && !this.isWellKnownIdent(this.workingIdents, updateSort)) {
                return 7;
            }
        }
        if (dataIdUpdt.equals("3")) {
            String updtWkId = this.getIdentInList(updateSort, this.workingIdents);
            if (previous_node != null && this.getIdentInList(previousSort, idents).equals(this.getIdentInList(updateSort, idents))) {
                if (this.getIdentInList(previousSort, dataIdents).equals("3") && this.isWellKnownIdent(this.workingIdents, previousSort) && Ebcdic.stringCompare(this.getIdentInList(previousSort, this.workingIdents), updtWkId) <= 0) {
                    if (update_node.getName().equals("LINKAGE") && !previous_node.hasChildrenNodeTag()) {
                        return 6;
                    }
                    return 7;
                }
                if (!previousSort.trim().equals("4 a") && updtWkId.equals("300A") && Ebcdic.stringCompare(updateSort, "7") < 0 && updateSort.trim().length() > previousSort.trim().length() && previousSort.startsWith(updateSort.substring(0, 1))) {
                    return 7;
                }
            }
            if (read_node != null) {
                String readWkId = this.getIdentInList(read_node.getProperty("sort"), this.workingIdents);
                if (this.isWellKnownIdent(this.workingIdents, updateSort) && Ebcdic.stringCompare(updateSort, readWkId) > 0) {
                    return 5;
                }
            }
        }
        if (update_node.getName().equals("PROCEDURE-DIVISION") && read_node != null) {
            return 5;
        }
        if (previous_node != null && previous_node.getName().equals("PROCEDURE-DIVISION") && Ebcdic.stringCompare(updateSort, previousSort) > 0) {
            return 7;
        }
        if (update_node.getName().equals("LINKAGE")) {
            String parentSort;
            if (read_node != null) {
                parentSort = read_node.getParentNode().getProperty("sort");
                if (this.isWellKnownIdent(this.workingIdents, parentSort)) {
                    return 6;
                }
                if (parentSort == null) {
                    if (read_node.getProperty("sort").startsWith("9")) {
                        return 3;
                    }
                    return 5;
                }
            } else {
                parentSort = previous_node.getParentNode().getProperty("sort");
                if (this.isWellKnownIdent(this.workingIdents, parentSort)) {
                    return 6;
                }
            }
        }
        if (this.isWellKnownIdent(dataIdents, updateSort) && !update_node.getName().equals("LINKAGE")) {
            if (read_node != null && !read_node.getName().equals("LINKAGE")) {
                if (Ebcdic.stringCompare(updateSort, "19999   ") < 0) {
                    return 3;
                }
                return 5;
            }
            if (read_node == null && !update_node.getName().equals("LINKAGE")) {
                return 4;
            }
        }
        if (read_node == null) {
            return 4;
        }
        return 3;
    }

    private int compareEnvironmentDivision(NodeTag previous_node, NodeTag read_node, NodeTag update_node) {
        String readSort;
        String updateSort = update_node.getProperty("sort");
        if (read_node != null) {
            int i;
            String readSort2 = read_node.getProperty("sort");
            String wkSort = updateSort;
            if (updateSort.equals("I  40  0")) {
                wkSort = "I  40";
            }
            if (readSort2.startsWith(wkSort.trim()) && (i = Ebcdic.stringCompare(readSort2.substring(0, wkSort.trim().length()), wkSort.trim())) == 0) {
                return 5;
            }
        }
        if (read_node != null && previous_node == null) {
            return 3;
        }
        String previousSort = previous_node.getProperty("sort");
        if (previousSort.equals("I  40   ") || updateSort.startsWith(previousSort.trim()) || previousSort.equals("I  40  0") && updateSort.substring(0, 5).equals(previousSort.substring(0, 5))) {
            return 7;
        }
        if (read_node != null && Ebcdic.stringCompare(readSort = read_node.getProperty("sort"), "160     ") > 0) {
            return 3;
        }
        if (read_node == null) {
            return 4;
        }
        return 3;
    }

    private int compareIdentificationDivision(NodeTag previous_node, NodeTag read_node, NodeTag update_node) {
        int i;
        String readSort;
        String updateSort = update_node.getProperty("sort");
        if (updateSort.trim().length() == 5 && read_node != null && (readSort = read_node.getProperty("sort")).startsWith(updateSort.trim()) && (i = Ebcdic.stringCompare(readSort.substring(0, updateSort.trim().length()), updateSort.trim())) == 0) {
            return 5;
        }
        if (read_node != null && previous_node == null) {
            return 3;
        }
        String previousSort = previous_node.getProperty("sort");
        if (previousSort.equals("H") && Ebcdic.stringCompare(updateSort.substring(0, updateSort.length()), "I  30   ") <= 0 || updateSort.startsWith(previousSort.trim())) {
            return 7;
        }
        if (read_node == null) {
            return 4;
        }
        return 3;
    }

    public int compareReadUpdate(PacbaseNodeTag read_node, PacbaseNodeTag update_node) {
        String update_sort = update_node.getProperty("sort");
        String read_sort = read_node.getProperty("sort");
        int read_sort_length = read_sort.length();
        int update_sort_length = update_sort.length();
        if (read_sort_length < 8 && update_sort_length > 6 && update_sort.indexOf("$") > 5) {
            update_sort = update_sort.replace("$", "1");
        }
        if (update_sort_length < 8 && read_sort_length > 6 && read_sort.indexOf("$") > 5) {
            read_sort = read_sort.replace("$", "1");
        }
        if (update_sort_length > 6 && update_sort.substring(6, 7).equals("$")) {
            update_sort = String.valueOf(update_sort.substring(0, 6)) + update_sort.substring(6).replace("$", "1");
        }
        return Ebcdic.stringCompare(read_sort, update_sort);
    }

    public int compareSort(PacbaseNodeTag read_node, PacbaseNodeTag update_node) {
        int compareReadUpdate = this.compareReadUpdate(read_node, update_node);
        if (compareReadUpdate < 0) {
            return 8;
        }
        return 0;
    }

    private boolean isWellKnownIdent(String[] idents, String id) {
        if (id != null && id.trim().length() > 0) {
            String[] stringArray = idents;
            int n = idents.length;
            int n2 = 0;
            while (n2 < n) {
                String ident = stringArray[n2];
                if (ident.equals(id)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private String getIdentInList(String sort, String[] identsList) {
        String refId = "";
        int i = 0;
        i = 0;
        while (i < identsList.length) {
            String ident = identsList[i];
            if (refId.trim().length() == 0 && Ebcdic.stringCompare(sort, ident) < 0) {
                refId = identsList[i - 1];
                break;
            }
            ++i;
        }
        if (refId.trim().length() == 0) {
            refId = identsList[i - 1];
        }
        return refId;
    }

    public int comparePreviousLevel(PacbaseNodeTag previous_node, PacbaseNodeTag read_node, PacbaseNodeTag update_node) {
        if (previous_node != null) {
            PacbaseSort previousSort = previous_node.getPacbaseSort(this);
            PacbaseSort updateSort = update_node.getPacbaseSort(this);
            String previousSortString = previousSort.getSort().trim();
            String updateSortString = updateSort.getSort().trim();
            if (previousSortString.length() < 3) {
                return 7;
            }
            String previousLevel = previous_node.getProperty("level");
            if (previousLevel != null && previousLevel.startsWith("$")) {
                previousLevel = this.getDefaultLevel(previousSort);
            }
            if (updateSortString.equals("9") && !previousSortString.startsWith("9")) {
                if (read_node == null) {
                    return 4;
                }
                if (read_node.getPacbaseSort(this).getSort().startsWith("9")) {
                    return 5;
                }
            }
            if (previousSort.getFunction().equals(updateSort.getFunction())) {
                String updateLevel = update_node.getProperty("level");
                if (updateLevel != null && updateLevel.startsWith("$")) {
                    updateLevel = this.getDefaultLevel(updateSort);
                }
                if (previousLevel != null && previousLevel.length() > 0) {
                    if (previous_node.getProperty("sort").trim().equals("9900  A") && update_node.getProperty("sort").trim().equals("99099999")) {
                        if (read_node == null) {
                            return 4;
                        }
                        return 3;
                    }
                    if (!previous_node.hasChildrenNodeTag() && previousSortString.length() > 5) {
                        if (!(previousSort.getFunctionSubFunction().equals(updateSort.getFunctionSubFunction()) || previousSort.getSort().endsWith("*") && previousSort.getFunctionSubFunction().equals(updateSort.getFunctionSubFunction()) || read_node != null)) {
                            return 4;
                        }
                        return 3;
                    }
                    if (previous_node.hasChildrenNodeTag()) {
                        return 7;
                    }
                }
                if (!(previousLevel != null && previousLevel.length() != 0 || updateLevel != null && updateLevel.length() != 0)) {
                    if (!(previous_node.getParentNode() instanceof NodeRootTag) && previous_node.getParentNode().isFixedTag()) {
                        if (previousSortString.length() > 8 && updateSortString.length() > 8 && !previousSort.getFunctionSubFunction().equals(updateSort.getFunctionSubFunction())) {
                            return 6;
                        }
                    } else if (previous_node.getName().endsWith("BODY")) {
                        boolean childrenWithLevel = false;
                        if (previous_node.hasChildrenNodeTag()) {
                            int i = 0;
                            while (i < previous_node.getChildren().size()) {
                                PacbaseNodeTag pnt;
                                Node n = (Node)previous_node.getChildren().get(i);
                                if (n instanceof PacbaseNodeTag && (pnt = (PacbaseNodeTag)n).getProperty("level") != null) {
                                    childrenWithLevel = true;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (!(previous_node.hasChildrenNodeTag() && childrenWithLevel || previousSort.getFunctionSubFunction().trim().equals(updateSort.getFunctionSubFunction().trim()))) {
                            if (read_node != null && updateLevel == null && previousSort.getFunctionSubFunction().trim().length() > 4) {
                                if (read_node.getParentNode().getParentNode() != null) {
                                    return 2;
                                }
                                return 3;
                            }
                            if (previousSort.getSubFunction().trim().length() != 0) {
                                return 6;
                            }
                        } else {
                            return 7;
                        }
                    }
                }
            }
        }
        return 0;
    }

    public int compareReadLevel(PacbaseNodeTag read_node, PacbaseNodeTag update_node) {
        if (read_node != null) {
            PacbaseNodeTag parentNode;
            String readLevel = read_node.getProperty("level");
            String updateLevel = update_node.getProperty("level");
            if (readLevel != null && readLevel.startsWith("$")) {
                readLevel = this.getDefaultLevel(read_node.getPacbaseSort(this));
            }
            if (updateLevel != null && updateLevel.startsWith("$")) {
                updateLevel = this.getDefaultLevel(update_node.getPacbaseSort(this));
            }
            String parentLevel = null;
            if (!(read_node.getParentNode() instanceof NodeRootTag) && (parentLevel = (parentNode = (PacbaseNodeTag)read_node.getParentNode()).getProperty("level")) != null && parentLevel.startsWith("$")) {
                parentLevel = this.getDefaultLevel(parentNode.getPacbaseSort(this));
            }
            if (readLevel != null && readLevel.length() > 0) {
                if (updateLevel != null && updateLevel.length() > 0 && Float.parseFloat(readLevel) > Float.parseFloat(updateLevel) && read_node.getPacbaseSort(this).getFunction().equals(update_node.getPacbaseSort(this).getFunction())) {
                    if (parentLevel != null && !(Float.parseFloat(parentLevel) < Float.parseFloat(updateLevel))) {
                        return 6;
                    }
                    return 5;
                }
            } else if (updateLevel != null && updateLevel.length() > 0) {
                Node previousNode;
                if (parentLevel != null && Float.parseFloat(parentLevel) == Float.parseFloat(updateLevel)) {
                    return 6;
                }
                if (read_node.getPacbaseSort(this).getFunction().equals(update_node.getPacbaseSort(this).getFunction())) {
                    if (read_node.getPacbaseSort(this).getSubFunction().equals(update_node.getPacbaseSort(this).getSubFunction()) && (!update_node.isSpecialFunction9099() || Merge.isSUP(update_node, "batch"))) {
                        return 5;
                    }
                    if (update_node.getPacbaseSort(this).getSubFunction().trim().length() == 0) {
                        return 5;
                    }
                }
                if (parentLevel != null && Float.parseFloat(updateLevel) < Float.parseFloat(parentLevel)) {
                    return 6;
                }
                if (read_node.getPacbaseSort(this).getSort().trim().length() > 16 && (previousNode = read_node.getPreviousSiblingWithoutSNT()) instanceof NodeTag && ((NodeTag)previousNode).getProperty("level") == null && Float.parseFloat(updateLevel) < 10.0f) {
                    if (parentLevel == null || Float.parseFloat(parentLevel) < Float.parseFloat(updateLevel)) {
                        return 5;
                    }
                    return 6;
                }
            }
        }
        return 3;
    }
}

