/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.merge;

import com.ibm.pdp.macro.pacbase.extension.Ebcdic;
import com.ibm.pdp.macro.pacbase.merge.PacbaseCSServerComparator;
import com.ibm.pdp.macro.pacbase.merge.PacbaseNodeTag;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class PacbaseCSServerSort {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    boolean findSortForClean = false;
    PacbaseNodeTag pnTag;
    String sort;
    String msp;
    ArrayList<String> alReferences = new ArrayList();
    static final int G3 = 0;
    static final int G4 = 1;
    static final int G5 = 2;
    static final int G6 = 3;
    static final int G7 = 4;
    static final int G8 = 5;
    static final int G9 = 6;
    static final int G0 = 7;
    static final int GA = 8;
    static final int GB = 9;
    String forStar;
    String[] result = new String[10];
    String compareSort;
    private static final MessageFormat MESSAGE_FORMAT = new MessageFormat("");
    static final HashMap<String, String> INDEX_PATTERNS = new HashMap();
    static final HashMap<String, String> TABLE;

    static {
        INDEX_PATTERNS.put("SECTION", "{0},{1},{5}");
        INDEX_PATTERNS.put("FSERVER", "{0},{3},{5}");
        INDEX_PATTERNS.put("STRVIEW", "{4},{5}");
        INDEX_PATTERNS.put("BEG", "{4},{5},{6},{7},{8}");
        INDEX_PATTERNS.put("SQLW", "{0},{3},{5},{6}");
        INDEX_PATTERNS.put("SQLD", "{0},{3},{5},{6}");
        INDEX_PATTERNS.put("BEGV", "{0},{1},{2},{3},{4},{5}");
        INDEX_PATTERNS.put("CHUP", "{0},{1},{2},{3},{4}");
        INDEX_PATTERNS.put("LOCK", "{0},{1},{2},{3},{4}");
        INDEX_PATTERNS.put("UNLK", "{0},{1},{2},{3},{4}");
        INDEX_PATTERNS.put("USER", "{0},{1},{2},{3},{4}");
        INDEX_PATTERNS.put("ERRV", "{0},{1},{2},{3},{4},{5}");
        INDEX_PATTERNS.put("ENDV", "{0},{1},{2},{3},{4},{5}");
        INDEX_PATTERNS.put("END", "{0},{3},{5}");
        INDEX_PATTERNS.put("CCNX", "{0},{3},{4}");
        INDEX_PATTERNS.put("DCNX", "{0},{3},{4}");
        INDEX_PATTERNS.put("TRDT", "{0},{1},{2},{3},{4}");
        INDEX_PATTERNS.put("CHKD", "{0},{1},{2},{3},{4},{5}");
        INDEX_PATTERNS.put("OPEN", "{0},{1},{2},{3},{4}");
        INDEX_PATTERNS.put("CLOS", "{0},{1},{2},{3},{4}");
        INDEX_PATTERNS.put("SYNC", "{0},{1},{2},{3},{4}");
        INDEX_PATTERNS.put("TRER", "{0},{1},{2},{3},{4}");
        INDEX_PATTERNS.put("TRVW", "{0},{1},{2},{3},{4}");
        INDEX_PATTERNS.put("SLCT", "{0},{1},{2},{4}");
        INDEX_PATTERNS.put("USRS", "{0},{1},{2},{4}");
        INDEX_PATTERNS.put("CATA", "{5},{6}");
        INDEX_PATTERNS.put("CATR", "{5},{6}");
        INDEX_PATTERNS.put("CATT", "{5},{6}");
        INDEX_PATTERNS.put("CATZ", "{5},{6}");
        INDEX_PATTERNS.put("SRVE", "{6}");
        INDEX_PATTERNS.put("SRVL", "{6}");
        INDEX_PATTERNS.put("SRVM", "{6}");
        INDEX_PATTERNS.put("SRVT", "{6}");
        INDEX_PATTERNS.put("SRVX", "{6}");
        INDEX_PATTERNS.put("SRVA", "{6}");
        INDEX_PATTERNS.put("REPET", "{7},{8}");
        INDEX_PATTERNS.put("INIT", "{7},{8}");
        INDEX_PATTERNS.put("TRCS", "{7},{8}");
        INDEX_PATTERNS.put("TRAN", "{7},{8}");
        INDEX_PATTERNS.put("DONE", "{7},{8}");
        INDEX_PATTERNS.put("ALIM", "{6},{7},{8}");
        INDEX_PATTERNS.put("CALL", "{6},{7},{8}");
        INDEX_PATTERNS.put("ERRS", "{6},{7},{8}");
        TABLE = new HashMap();
        TABLE.put("SECTION", "H,0A,B");
        TABLE.put("FSERVER", "I,G,B");
        TABLE.put("STRVIEW", "C, ");
        TABLE.put("BEG", "C,9,999,9,9");
        TABLE.put("SQLW", "J,G,C,G");
        TABLE.put("SQLD", "J,G,D,G");
        TABLE.put("BEGV", "K,$1,$2,G,BB,G");
        TABLE.put("CHUP", "K,$1,$2,G,GG");
        TABLE.put("LOCK", "K,$1,$2,G,LG");
        TABLE.put("UNLK", "K,$1,$2,G,NG");
        TABLE.put("USER", "K,$1,$2,G,UG");
        TABLE.put("ERRV", "K,$1,$2,G,V,G");
        TABLE.put("ENDV", "K,$1,$2,G,W,G");
        TABLE.put("END", "M,G,B");
        TABLE.put("CCNX", "O,B,G");
        TABLE.put("DCNX", "O,C,G");
        TABLE.put("TRDT", "O,$1,$2,D,G");
        TABLE.put("CHKD", "O,$1,$2,H,$3,G");
        TABLE.put("OPEN", "O,$1,$2,O,G");
        TABLE.put("CLOS", "O,$1,$2,P,G");
        TABLE.put("SYNC", "O,$1,$2,S,G");
        TABLE.put("TRER", "O,$1,$2,T,G");
        TABLE.put("TRVW", "O,$1,$2,V,G");
        TABLE.put("SLCT", "S,$1,$2,G");
        TABLE.put("USRS", "T,$1,$2,G");
        TABLE.put("CATA", "A,G");
        TABLE.put("CATR", "R,G");
        TABLE.put("CATT", "T,G");
        TABLE.put("CATZ", "Z,G");
        TABLE.put("SRVE", "GEG");
        TABLE.put("SRVL", "GLG");
        TABLE.put("SRVM", "GMG");
        TABLE.put("SRVT", "GTG");
        TABLE.put("SRVX", "GXG");
        TABLE.put("SRVA", "GAG");
        TABLE.put("REPET", "I,G");
        TABLE.put("INIT", "I,G");
        TABLE.put("TRCS", "K,G");
        TABLE.put("TRAN", "R,G");
        TABLE.put("DONE", "X,G");
        TABLE.put("ALIM", "G,A,G");
        TABLE.put("CALL", "G,C,G");
        TABLE.put("ERRS", "G,E,G");
    }

    public PacbaseCSServerSort() {
        this.findSortForClean = true;
    }

    public PacbaseCSServerSort(PacbaseNodeTag node) {
        this.pnTag = node;
        String references = this.pnTag.getProperty("ref");
        if (references == null) {
            references = this.pnTag.getReference(this.pnTag);
        }
        this.sort = this.pnTag.getProperty("sort");
        this.setForStar(this.sort);
        this.msp = node.getProperty("msp");
        if (this.msp != null) {
            if (this.sort.startsWith("980")) {
                if (references.trim().length() > 3) {
                    this.getIndexForF80(references.trim(), this.sort);
                } else {
                    this.initResult();
                    this.result[0] = "U";
                    this.result[1] = "80";
                    this.result[2] = " " + this.sort.substring(4, 6);
                    this.result[3] = "A";
                    this.setCompareSort();
                }
            } else if (this.sort.startsWith("981")) {
                this.getIndexForF81(this.sort);
            } else if (this.sort.startsWith("9V")) {
                this.computeResultForServerSort(this.sort);
            } else if (references.trim().length() == 0 && this.pnTag.getProperty("LogicalView") != null) {
                this.computeResultForFalseLogivalView(this.pnTag.getProperty("LogicalView"));
            } else {
                String logicalView = this.pnTag.getReferenceInPgm(this.pnTag);
                if (logicalView.trim().length() <= 0 && this.pnTag.getProperty("LogicalView") != null) {
                    logicalView = this.pnTag.getProperty("LogicalView").trim();
                }
                if (logicalView.trim().length() <= 0 && this.pnTag.getParentNode() != null && this.pnTag.getParentNode().getProperty("LogicalView") != null) {
                    logicalView = this.pnTag.getParentNode().getProperty("LogicalView").trim();
                }
                String action = this.pnTag.getProperty("action");
                String level = this.pnTag.getProperty("level");
                this.getReferences(references, logicalView, action != null && level != null && level.equals("05") && action.equals("*C"));
            }
        } else {
            this.computeResultForServerSort(this.sort);
        }
    }

    private void computeResultForFalseLogivalView(String lv) {
        this.initResult();
        this.result[0] = "K";
        this.result[1] = lv.substring(0, 2);
        this.result[2] = lv.substring(2);
        this.setCompareSort();
    }

    private void computeResultForServerSort(String sort) {
        this.initResult();
        if (sort.length() > 1) {
            this.result[0] = sort.substring(1, 2);
            this.result[1] = sort.substring(2, 4);
            if (sort.length() > 4) {
                this.result[2] = sort.substring(4, 7);
                this.result[3] = sort.substring(7, 8);
                if (sort.length() > 8) {
                    this.result[4] = sort.substring(8, 10);
                }
                if (sort.length() > 10) {
                    this.result[5] = sort.substring(10, 11);
                }
                if (sort.length() > 11) {
                    this.result[6] = sort.substring(11, 14);
                }
                if (sort.length() > 14) {
                    this.result[7] = sort.substring(14, 15);
                }
                if (sort.length() > 15) {
                    this.result[8] = sort.substring(15, 16);
                }
                if (sort.length() > 16) {
                    this.result[9] = sort.substring(16, 19);
                }
            }
        }
        this.setCompareSort();
    }

    public String getG3() {
        return this.result[0];
    }

    public String getG4() {
        return this.result[1];
    }

    public String getG5() {
        return this.result[2];
    }

    public String getG6() {
        return this.result[3];
    }

    public String getG7() {
        return this.result[4];
    }

    public String getG8() {
        return this.result[5];
    }

    public String getG9() {
        return this.result[6];
    }

    public String getG0() {
        return this.result[7];
    }

    public String getGA() {
        return this.result[8];
    }

    public String getGB() {
        return this.result[9];
    }

    private void initResult() {
        int i = 0;
        while (i < this.result.length) {
            this.result[i] = "";
            ++i;
        }
    }

    public void getReferences(String references, String logicalViewOrSegment, boolean isLevel05) {
        this.initResult();
        String ref = "";
        int i = 0;
        while (i < references.trim().length()) {
            if (references.charAt(i) != ' ') {
                ref = String.valueOf(ref) + String.valueOf(references.charAt(i));
            } else {
                if (ref.length() > 0) {
                    this.alReferences.add(ref);
                }
                ref = "";
            }
            ++i;
        }
        if (ref.length() > 0) {
            this.alReferences.add(ref);
        }
        if (isLevel05 || this.alReferences.size() > 0 && (this.alReferences.get(0).equals("BS") || this.alReferences.get(0).equals("ES") || this.alReferences.get(0).equals("SQ"))) {
            this.getIndexForReferenceForLevel05();
        } else {
            this.getIndexForReferences(this.alReferences, logicalViewOrSegment);
        }
        this.setCompareSort();
    }

    public void getIndexForF80(String references, String sort) {
        this.initResult();
        this.result[0] = "U";
        this.result[1] = "80";
        if (references.equals("OKKO") && sort != null && sort.substring(4, 6).equals("99")) {
            this.result[2] = "99";
        } else {
            this.result[2] = references.substring(0, 2);
            this.result[4] = references.substring(2, 4);
        }
        boolean isActionServer = false;
        int i = 0;
        while (i < PacbaseCSServerComparator.action80Server.length) {
            if (references.indexOf(" EX ") != -1) break;
            if (references.indexOf(PacbaseCSServerComparator.action80Server[i]) != -1 || references.endsWith("CL")) {
                isActionServer = true;
                break;
            }
            ++i;
        }
        if (isActionServer) {
            this.result[5] = "I";
            if (references.endsWith("R1")) {
                this.result[6] = " CG";
                this.result[7] = "A";
            } else if (references.endsWith("R2")) {
                this.result[6] = " DG";
                this.result[7] = "C";
            } else if (references.endsWith("R3")) {
                this.result[6] = " EG";
                this.result[7] = "R";
            } else {
                this.result[6] = references.endsWith("RN-ALL") ? " WG" : (references.endsWith("P-ALL") ? " VG" : (references.endsWith("RA") ? " OG" : (references.endsWith("UN") ? " MG" : (references.endsWith("RW") ? " KG" : (references.endsWith("EB") ? " IG" : (references.endsWith("RN") ? " HG" : (references.endsWith("RU") ? " DG" : (references.endsWith("D") ? " LG" : (references.endsWith("W") ? " JG" : (references.endsWith("P") ? " EG" : (references.endsWith("CL") ? " NG" : " CG")))))))))));
            }
        } else {
            this.result[5] = "A";
            if (references.contains("DC")) {
                this.result[6] = "  D";
            } else if (references.contains("CL")) {
                this.result[6] = "CLN";
            } else if (references.contains("P")) {
                this.result[6] = "P E";
            } else if (references.contains("RN")) {
                this.result[6] = "RNH";
            }
        }
        this.setCompareSort();
    }

    public void getIndexForF81(String sort) {
        this.initResult();
        this.result[0] = "U";
        this.result[1] = "81";
        this.result[2] = "G" + sort.substring(4, 6);
        if (sort.substring(3, 4).equals("9")) {
            this.result[4] = "99";
            this.result[5] = "9";
            this.result[6] = "999";
            this.result[7] = "9";
            this.result[8] = "9";
            this.result[9] = "999";
        }
        this.result[3] = "G";
        this.setCompareSort();
    }

    private void getIndexForReferences(ArrayList<String> alReferences, String logicalViewOrSegment) {
        for (String ref : alReferences) {
            String pattern = INDEX_PATTERNS.get(ref);
            if (pattern != null) {
                MESSAGE_FORMAT.applyPattern(pattern);
                try {
                    Object[] parameters = MESSAGE_FORMAT.parse(TABLE.get(ref));
                    int i = 0;
                    while (i < parameters.length) {
                        if (parameters[i] != null) {
                            this.result[i] = this.specificParameters((String)parameters[i], logicalViewOrSegment, i);
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {}
                continue;
            }
            this.getIndexForSpecificReferences(ref, logicalViewOrSegment);
        }
    }

    private void getIndexForReferenceForLevel05() {
        String reference = this.alReferences.get(0);
        this.result[3] = "G";
        if (reference.equals("BS")) {
            this.result[0] = "I";
            this.result[5] = "B";
        } else if (reference.equals("ES")) {
            this.result[0] = "M";
            this.result[5] = "B";
        } else if (reference.equals("SQ")) {
            this.result[0] = "J";
            if (this.alReferences.get(1).equals("P")) {
                this.result[1] = "99";
                this.result[2] = "999";
                this.result[3] = "9";
            }
        } else {
            this.result[0] = "K";
            this.result[1] = reference.substring(0, 2);
            this.result[2] = reference.substring(2);
            if (this.alReferences.size() == 1 || Ebcdic.stringCompare(this.alReferences.get(1), "G") < 0) {
                this.result[3] = " ";
                this.result[5] = " ";
            } else if (this.alReferences.get(1).equals("R")) {
                this.result[5] = "B";
            } else {
                this.result[4] = "9";
            }
        }
    }

    private void getIndexForSpecificReferences(String ref, String logicalViewOrSegment) {
        if (ref.equals("SELC")) {
            if (this.result[0].equals("K")) {
                this.result[7] = "L";
                this.result[8] = "G";
            } else {
                this.result[0] = "K";
                if (logicalViewOrSegment != null && logicalViewOrSegment.length() > 0) {
                    this.result[1] = logicalViewOrSegment.substring(0, 2);
                    this.result[2] = logicalViewOrSegment.substring(2, 4);
                }
                this.result[3] = "G";
                this.result[4] = "SG";
            }
        } else if (ref.equals("PROC")) {
            if (this.result[3].equals("D")) {
                this.result[6] = "G";
                this.result[9] = "000";
            }
            if (this.result[3].equals("S")) {
                this.result[5] = "R";
                this.result[6] = "G";
            }
            if (this.result[3].equals("T")) {
                this.result[9] = "???";
            }
            if (this.result[3].equals("V")) {
                this.result[6] = "G";
                this.result[7] = "A";
            }
        } else if (ref.equals("CHCK")) {
            if (this.result[0].equals("K")) {
                this.result[7] = "L";
                this.result[8] = "G";
            } else {
                this.result[0] = "P";
                this.result[4] = "G";
            }
        } else if (ref.equals("UPDT")) {
            if (this.result[0].equals("K")) {
                this.result[7] = "U";
                this.result[8] = "G";
            } else {
                this.result[0] = "Q";
                this.result[4] = "G";
            }
        } else if (ref.length() == 4 && ref.substring(0, 3).equals("CAT")) {
            this.result[5] = String.valueOf(ref.charAt(3));
        } else if (this.result[0].equals("J")) {
            this.result[1] = ref.substring(0, 2);
            this.result[2] = ref.substring(2);
        } else if (this.result[3].equals("H")) {
            this.result[6] = ref.length() > 2 ? ref.substring(0, 3) : ref;
            if (ref.length() > 3) {
                this.result[7] = String.valueOf(ref.charAt(3));
            }
            if (ref.length() > 4) {
                this.result[8] = String.valueOf(ref.charAt(4));
            }
            if (ref.length() > 5) {
                this.result[9] = String.valueOf(ref.charAt(5));
            }
        } else if (this.result[3].equals("T")) {
            this.result[4] = "G" + String.valueOf(ref.charAt(0));
            this.result[5] = String.valueOf(ref.charAt(1));
            this.result[6] = String.valueOf(ref.substring(2, 4)) + "G";
        } else if (this.result[3].equals("V")) {
            this.result[6] = "G" + ref.substring(0, 2);
            this.result[7] = String.valueOf(ref.charAt(2));
            this.result[8] = String.valueOf(ref.charAt(3));
            this.result[9] = "B" + ref.substring(2, 4);
        } else if (!this.result[3].equals("G") || !this.result[4].equals("UG")) {
            if (ref.length() > 2) {
                if (this.result[0].trim().length() == 0 && logicalViewOrSegment.trim().length() > 0) {
                    this.result[0] = "K";
                }
                this.result[1] = ref.substring(0, 2);
                this.result[2] = ref.substring(2);
            }
            if ("P".equals(ref) || "R".equals(ref)) {
                this.result[0] = "K";
                this.result[3] = "G";
                this.result[4] = "9";
            }
        }
    }

    private String specificParameters(String parameters, String logicalViewOrSegment, int i) {
        if (parameters.equals("$1") && logicalViewOrSegment != null && logicalViewOrSegment.trim().length() > 0) {
            return logicalViewOrSegment.substring(0, 2);
        }
        if (parameters.equals("$2") && logicalViewOrSegment != null && logicalViewOrSegment.trim().length() > 0) {
            if (logicalViewOrSegment.trim().length() > 4) {
                return logicalViewOrSegment.substring(2, 4);
            }
            return logicalViewOrSegment.substring(2);
        }
        if (parameters.equals("$3")) {
            if (this.alReferences.contains("CATA")) {
                return "GA";
            }
            if (this.alReferences.contains("CATR")) {
                return "GR";
            }
            if (this.alReferences.contains("CATT")) {
                return "GT";
            }
            if (this.alReferences.contains("CATZ")) {
                return "GZ";
            }
            return "G ";
        }
        if (this.result[3].equals("H")) {
            if (i == 5) {
                if (this.alReferences.contains("CATA") || this.alReferences.contains("CATR") || this.alReferences.contains("CATT") || this.alReferences.contains("CATZ")) {
                    return "G";
                }
                return "";
            }
            if (i == 6) {
                return " ";
            }
        } else if (this.result[0].equals("H")) {
            if (i == 2) {
                return String.valueOf(this.alReferences.get(0).substring(3)) + "G";
            }
        } else if (this.result[6].trim().length() == 3 && i == 6) {
            return this.result[6];
        }
        return parameters;
    }

    public String getCompareSort() {
        return this.compareSort;
    }

    private void specificResultsForStarP() {
        if (this.forStar != null && this.forStar.equals("3") && this.isSpecificStarP()) {
            if (this.getG3().equals("K")) {
                if (this.getG8().trim().length() <= 0) {
                    this.result[5] = "9";
                } else if (this.getG9().trim().length() == 1) {
                    this.result[6] = String.valueOf(this.getG9()) + "99";
                } else if (this.getG0().trim().length() <= 0) {
                    this.result[7] = "9";
                }
            } else if (this.getG3().equals("O")) {
                if (this.getG8().trim().length() <= 0) {
                    this.result[4] = "9";
                    this.result[5] = "9";
                    this.result[6] = "9";
                    this.result[7] = "9";
                    this.result[8] = "9";
                } else if (this.getG9().trim().length() <= 0) {
                    this.result[6] = "9";
                } else if (this.getG0().trim().length() <= 0) {
                    this.result[7] = "9";
                    this.result[8] = "9";
                } else if (this.result[3].equals("H") && this.getGB().trim().length() > 0) {
                    this.result[9] = String.valueOf(this.result[9]) + "Z9";
                } else if (this.getGB().trim().length() <= 0) {
                    this.result[9] = " Z9";
                }
            } else if (this.getG8().trim().length() <= 0) {
                this.result[5] = "9";
                this.result[6] = "9";
                this.result[7] = "9";
                this.result[8] = "9";
            } else if (this.getG0().trim().length() <= 0) {
                this.result[7] = "9";
                this.result[8] = "9";
            }
        }
    }

    public void setCompareSort() {
        this.specificResultsForStarP();
        StringBuilder sb = new StringBuilder();
        if (this.msp == null && !this.findSortForClean) {
            if (this.pnTag.getName().indexOf("-FN") != -1 && this.pnTag.getSort().charAt(1) != 'U') {
                int i = sb.length();
                while (i < 19) {
                    sb.append("9");
                    ++i;
                }
            } else if (this.pnTag.getName().indexOf("-900") != -1 && this.pnTag.getSort().charAt(1) != 'U') {
                sb.append("9");
                int i = sb.length();
                while (i < 19) {
                    sb.append("8");
                    ++i;
                }
            } else {
                if (this.sort.trim().length() > 19) {
                    sb.append(this.sort.substring(0, 19));
                } else {
                    sb.append(this.sort);
                    int i = this.sort.length();
                    while (i < 19) {
                        sb.append(" ");
                        ++i;
                    }
                }
                sb.append(this.forStar);
                if (this.sort.trim().length() > 19) {
                    sb.append(this.sort.substring(19));
                }
            }
        } else {
            int i;
            if (this.pnTag != null && this.pnTag.getName().indexOf("-FN") != -1) {
                i = 0;
                while (i < 19) {
                    sb.append("9");
                    ++i;
                }
            } else if (this.pnTag != null && this.pnTag.getName().indexOf("-900") != -1) {
                sb.append("9");
                i = 1;
                while (i < 19) {
                    sb.append("8");
                    ++i;
                }
            } else {
                sb.append("9");
                sb.append(this.result[0]);
                i = sb.length();
                while (i < 2) {
                    sb.append(" ");
                    ++i;
                }
                sb.append(this.result[1]);
                i = sb.length();
                while (i < 4) {
                    sb.append(" ");
                    ++i;
                }
                sb.append(this.result[2]);
                i = sb.length();
                while (i < 7) {
                    sb.append(" ");
                    ++i;
                }
                sb.append(this.result[3]);
                i = sb.length();
                while (i < 8) {
                    sb.append(" ");
                    ++i;
                }
                sb.append(this.result[4]);
                i = sb.length();
                while (i < 10) {
                    sb.append(" ");
                    ++i;
                }
                sb.append(this.result[5]);
                i = sb.length();
                while (i < 11) {
                    sb.append(" ");
                    ++i;
                }
                sb.append(this.result[6]);
                i = sb.length();
                while (i < 14) {
                    sb.append(" ");
                    ++i;
                }
                sb.append(this.result[7]);
                i = sb.length();
                while (i < 15) {
                    sb.append(" ");
                    ++i;
                }
                sb.append(this.result[8]);
                i = sb.length();
                while (i < 16) {
                    sb.append(" ");
                    ++i;
                }
                sb.append(this.result[9]);
                i = sb.length();
                while (i < 19) {
                    sb.append(" ");
                    ++i;
                }
            }
            if (this.findSortForClean) {
                sb.append("A");
            } else if (this.forStar.trim().length() > 0) {
                sb.append(this.forStar);
            } else if (this.pnTag != null) {
                String s = sb.toString().substring(0, 19);
                sb = new StringBuilder();
                sb.append(s);
                PacbaseNodeTag parent = null;
                if (this.pnTag.getParentNode() instanceof PacbaseNodeTag) {
                    parent = (PacbaseNodeTag)this.pnTag.getParentNode();
                }
                if (parent != null && parent.getSort().length() > 1) {
                    sb.append(parent.getPacbaseCSServerSort().getCompareSort().substring(19, 20));
                } else {
                    sb.append("2");
                }
                if (this.pnTag.getName().endsWith("-BODY")) {
                    sb.append("B");
                }
            }
        }
        this.compareSort = this.getG4().equals("81") ? (this.getG7().equals("99") ? String.valueOf(sb.toString().substring(0, 4)) + "9" + sb.toString().substring(4) : String.valueOf(sb.toString().substring(0, 4)) + sb.toString().substring(4)) : (this.msp != null && this.sort != null && this.sort.trim().length() > 4 ? String.valueOf(sb.toString()) + this.sort.substring(1, 3) + this.sort.substring(4, 6) : sb.toString());
    }

    private boolean isSpecificStarP() {
        if (this.getG3().equals("K") && (this.getG7().equals("GG") || this.getG7().equals("SG"))) {
            return true;
        }
        if (this.getG3().equals("O") && (this.getG6().equals("D") || this.getG6().equals("H") || this.getG6().equals("S") || this.getG6().equals("T") || this.getG6().equals("V"))) {
            return true;
        }
        return this.getG3().equals("P") || this.getG3().equals("Q") || this.getG3().equals("S") || this.getG3().equals("T");
    }

    public void setForStar(String sort) {
        this.forStar = " ";
        String action = this.pnTag.getProperty("action");
        if (this.pnTag.getProperty("msp") == null) {
            this.forStar = "2";
        } else if (action != null && action.equals("*A")) {
            this.forStar = "1";
        } else if (action != null && action.equals("*B")) {
            String[] s;
            if ((this.pnTag.getRef().indexOf("ALIM") != -1 || this.pnTag.getRef().indexOf("CALL") != -1 || this.pnTag.getRef().indexOf("ERRS") != -1) && (s = this.pnTag.getRef().split(" ")).length == 4) {
                this.forStar = "1";
            }
        } else if (action != null && action.equals("*P")) {
            this.forStar = "3";
        } else if (action != null && action.equals("*C")) {
            String ref = this.pnTag.getProperty("ref").trim();
            if (ref != null) {
                int index = ref.trim().indexOf(" ");
                if (index != -1 && ref.trim().length() <= 6) {
                    String s = ref.trim().substring(index + 1);
                    if (Ebcdic.stringCompare(s, "G") < 0) {
                        this.forStar = "1";
                    } else if (ref.trim().length() == 4) {
                        this.forStar = "3";
                    }
                }
                if (ref.indexOf("USER") > -1) {
                    this.forStar = "3";
                }
            }
        } else {
            this.forStar = this.pnTag.getForStar(this.pnTag);
        }
    }
}

