/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.merge;

import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.pacbase.extension.Ebcdic;
import com.ibm.pdp.macro.pacbase.merge.PacbaseCSServerSort;
import com.ibm.pdp.macro.pacbase.merge.PacbaseComparator;
import com.ibm.pdp.macro.pacbase.merge.PacbaseNodeTag;
import com.ibm.pdp.macro.pacbase.merge.PacbaseNodeTree;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.pacbase.util.PositioningErroneousSuspicion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class PacbaseCSServerComparator
extends PacbaseComparator {
    private ArrayList<PositioningErroneousSuspicion> alPositioningErroneousSuspicions = new ArrayList();
    private HashMap<String, String> hmCorrespondanceSort = new HashMap();
    String[] csServerWorkingIdents = new String[]{"3", "3 0", "3 00A"};
    protected static final String[] action80Server = new String[]{" R", " RU", " P", " RN", " W", " RW", " D", " UN", " R1", " R2", " R3", " EB", " RA", " P-ALL", " RN-ALL"};
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PacbaseCSServerComparator() {
        this.workingIdents = this.csServerWorkingIdents;
    }

    @Override
    public ArrayList<NodeTag> childsOfPrevious(NodeTag insert_node, NodeTag read_node, NodeTag savePrev) {
        return null;
    }

    public ArrayList<PositioningErroneousSuspicion> getPositioningErroneousSuspicions() {
        return this.alPositioningErroneousSuspicions;
    }

    public HashMap<String, String> getHmCorrespondanceSort() {
        return this.hmCorrespondanceSort;
    }

    @Override
    public int compareReadUpdate(PacbaseNodeTag read_node, PacbaseNodeTag update_node) {
        String newSort = update_node.getPacbaseCSServerSort().getCompareSort();
        if (!update_node.getSort().equals(newSort)) {
            this.hmCorrespondanceSort.put(update_node.getSort(), newSort);
        }
        Properties properties = update_node.getProperties();
        properties.setProperty("sort", newSort);
        update_node.setProperties(properties);
        return Ebcdic.stringCompare(read_node.getPacbaseCSServerSort().getCompareSort(), newSort);
    }

    @Override
    public int comparePreviousLevel(PacbaseNodeTag previous_node, PacbaseNodeTag read_node, PacbaseNodeTag update_node) {
        String action = update_node.getAction();
        String updateLevel = update_node.getLevel();
        if (previous_node != null) {
            String parentLevel;
            String readLevel = null;
            String previousLevel = previous_node.getLevel();
            if (updateLevel.equals("05") && action != null && action.equals("*C")) {
                String updateRef = update_node.getRef().trim();
                if (updateRef != null && updateRef.length() == 4 && updateRef.indexOf(" P") != -1 && previousLevel != null && Float.valueOf(previousLevel).floatValue() >= Float.valueOf(updateLevel).floatValue() && (!previous_node.getPacbaseCSServerSort().getG3().equals(update_node.getPacbaseCSServerSort().getG3()) || previous_node.getMSPName() != null)) {
                    return 7;
                }
                return 0;
            }
            if (read_node != null) {
                readLevel = read_node.getLevel();
            }
            if (previous_node.getPacbaseCSServerSort().getCompareSort().trim().length() < 3) {
                return 7;
            }
            if (previous_node.getPacbaseCSServerSort().getG3().equals("I")) {
                PacbaseNodeTree pnt = (PacbaseNodeTree)previous_node.getNodeTree();
                NodeTag nTag = null;
                if (pnt != null) {
                    nTag = pnt.getTreeTags().get("9").get(0);
                }
                if (nTag != null && (nTag.getProperty("attach") == null || nTag.getProperty("attach").indexOf("BS P") == -1)) {
                    return 7;
                }
                if (!previous_node.isFixedTag() && (update_node.getPacbaseCSServerSort().getG3().equals("I") || update_node.getPacbaseCSServerSort().getG3().equals("K") && (update_node.getRefPgm() == null || update_node.getRefPgm().trim().length() == 0))) {
                    return 7;
                }
                return 0;
            }
            if (previous_node.getPacbaseCSServerSort().getG3().equals("O") && previousLevel != null && previousLevel.equals("05")) {
                return 0;
            }
            if (previous_node.getPacbaseCSServerSort().getG3().equals("U") && previous_node.getPacbaseCSServerSort().getG4().equals(update_node.getPacbaseCSServerSort().getG4())) {
                if (previous_node.getPacbaseCSServerSort().getG4().equals("80") && previous_node.getPacbaseCSServerSort().getG6().equals("G")) {
                    return 7;
                }
                if (previous_node.getPacbaseCSServerSort().getG4().equals("81") && previousLevel != null && previousLevel.length() > 0 && previous_node.hasChildrenNodeTag()) {
                    return 7;
                }
                if (previous_node.getPacbaseCSServerSort().compareSort.substring(0, 11).equals(update_node.getSort().substring(0, 11)) && (update_node.getPacbaseCSServerSort().getG9().trim().equals("CG") || update_node.getPacbaseCSServerSort().getG9().trim().equals("DG") || update_node.getPacbaseCSServerSort().getG9().trim().equals("EG")) && update_node.getPacbaseCSServerSort().getG0().trim().length() > 0 && previous_node.getPacbaseCSServerSort().getG0().trim().length() == 0) {
                    return 7;
                }
                if (previous_node.getPacbaseCSServerSort().compareSort.length() > 22 && update_node.getPacbaseCSServerSort().compareSort.length() > 22 && previousLevel != null && updateLevel != null && Float.valueOf(updateLevel).floatValue() > Float.valueOf(previousLevel).floatValue()) {
                    return 7;
                }
                return 0;
            }
            String reference = update_node.getProperty("ref");
            if (reference != null && reference.length() > 4 && " P".equals(reference.trim().substring(4))) {
                String previousReference = previous_node.getProperty("ref");
                previous_node.getProperty("sort");
                if (previousReference != null && previousReference.equals(reference) && Float.valueOf(updateLevel).floatValue() > Float.valueOf(previousLevel).floatValue()) {
                    return 7;
                }
            }
            if (action != null && action.equals("*P") && updateLevel != null) {
                if (!(previousLevel == null || !previous_node.hasChildrenNodeTag() || previous_node.getName().indexOf("-PROC") != -1 && update_node.getPacbaseCSServerSort().getG0().equals("9") && update_node.getPacbaseCSServerSort().getGA().equals("9") || EBCDICCompare.stringCompare((String)update_node.getPacbaseCSServerSort().getG3(), (String)"K") >= 0 && !update_node.getSort().substring(0, 6).equals(previous_node.getSort().substring(0, 6)) && !(Float.valueOf(updateLevel).floatValue() >= Float.valueOf(previousLevel).floatValue()))) {
                    return 7;
                }
                parentLevel = previous_node.getParentNode().getProperty("level");
                if (parentLevel != null && Float.valueOf(updateLevel).floatValue() > Float.valueOf(parentLevel).floatValue()) {
                    if (read_node == null) {
                        return 4;
                    }
                    return 5;
                }
                if (parentLevel == null && Float.valueOf(previousLevel).floatValue() >= Float.valueOf(updateLevel).floatValue()) {
                    return 5;
                }
                return 6;
            }
            if (action != null && action.equals("*C") && updateLevel != null && previousLevel != null && Float.parseFloat(updateLevel) > Float.parseFloat(previousLevel)) {
                return 7;
            }
            if (action != null && updateLevel != null && (action.equals("*A") || action.equals("*R"))) {
                if (!(previousLevel == null || !previous_node.hasChildrenNodeTag() || update_node.getPacbaseCSServerSort().getG3().equals("U") && previous_node.getPacbaseCSServerSort().getG4().equals(update_node.getPacbaseCSServerSort().getG4()) && previous_node.getPacbaseCSServerSort().getG5().equals(update_node.getPacbaseCSServerSort().getG5()))) {
                    return 7;
                }
                parentLevel = previous_node.getParentNode().getProperty("level");
                if (parentLevel != null && Float.parseFloat(parentLevel) < Float.parseFloat(updateLevel) && !(Float.parseFloat(updateLevel) < 10.0f)) {
                    if (readLevel != null && Float.parseFloat(updateLevel) < Float.parseFloat(readLevel)) {
                        return 5;
                    }
                    return 3;
                }
                if (parentLevel == null) {
                    return 0;
                }
                return 6;
            }
            if (action != null && action.equals("*B") && updateLevel != null) {
                if (!(previousLevel == null || !previous_node.hasChildrenNodeTag() || previous_node.getName().indexOf("-PROC") != -1 || update_node.getPacbaseCSServerSort().getG3().equals("U") && previous_node.getPacbaseCSServerSort().getG4().equals(update_node.getPacbaseCSServerSort().getG4()) && previous_node.getPacbaseCSServerSort().getG5().equals(update_node.getPacbaseCSServerSort().getG5()))) {
                    if (previous_node.getAction() == null || !previous_node.getAction().equals("*B") || Float.parseFloat(updateLevel) > Float.parseFloat(previousLevel)) {
                        return 7;
                    }
                    return 3;
                }
                parentLevel = previous_node.getParentNode().getProperty("level");
                if (parentLevel != null && Float.parseFloat(parentLevel) < Float.parseFloat(updateLevel) && !(Float.parseFloat(updateLevel) < 10.0f)) {
                    if (readLevel != null && Float.parseFloat(updateLevel) < Float.parseFloat(readLevel)) {
                        return 5;
                    }
                    return 3;
                }
                if (parentLevel == null) {
                    return 4;
                }
                return 6;
            }
            if (action == null && previousLevel != null && reference != null && (reference.trim().length() == 6 && reference.trim().charAt(5) == 'P' && updateLevel != null && Float.parseFloat(previousLevel) < Float.parseFloat(updateLevel) || reference.indexOf("USER") != -1)) {
                return 7;
            }
            if (read_node != null && updateLevel != null && previousLevel != null && Float.parseFloat(updateLevel) > Float.parseFloat(previousLevel) && update_node.getLogicalView() != null) {
                if (update_node.getLogicalView() != null) {
                    PositioningErroneousSuspicion pes = new PositioningErroneousSuspicion();
                    pes.setFunction(update_node.getName().substring(1, 3));
                    if (update_node.getName().length() > 3) {
                        pes.setSubFunction(update_node.getName().substring(3));
                    } else {
                        pes.setSubFunction("  ");
                    }
                    this.alPositioningErroneousSuspicions.add(pes);
                }
                return 7;
            }
            if (read_node == null) {
                if ("W".equals(previous_node.getPacbaseCSServerSort().getG7().trim()) && reference.length() == 6 && " P".equals(reference.substring(4))) {
                    return 0;
                }
                return 7;
            }
        }
        return 0;
    }

    @Override
    public int compareReadLevel(PacbaseNodeTag read_node, PacbaseNodeTag update_node) {
        String action = update_node.getAction();
        String readLevel = read_node.getLevel();
        String updateLevel = update_node.getLevel();
        String parentLevel = read_node.getParentNode().getProperty("level");
        if (update_node.getMSPName() != null && read_node.getMSPName() == null && !read_node.getSort().substring(1, 2).equals(update_node.getPacbaseCSServerSort().getG3())) {
            return 3;
        }
        if ((action == null || action.equals("*C")) && updateLevel != null && parentLevel != null && !(Float.parseFloat(updateLevel) > Float.parseFloat(parentLevel))) {
            return 6;
        }
        if (readLevel == null && updateLevel != null) {
            if (parentLevel != null && Float.parseFloat(parentLevel) == Float.parseFloat(updateLevel)) {
                return 6;
            }
            if (parentLevel != null && Float.parseFloat(updateLevel) < Float.parseFloat(parentLevel)) {
                return 6;
            }
        }
        if (updateLevel != null && readLevel != null && Float.parseFloat(updateLevel) < Float.parseFloat(readLevel) && (update_node.getLogicalView() != null && read_node.getLogicalView() != null && update_node.getLogicalView().equals(read_node.getLogicalView()) || update_node.getLogicalView() == null)) {
            if (update_node.getSort().startsWith("9U80") && read_node.getSort().startsWith("9U81")) {
                return 3;
            }
            if (parentLevel != null && Float.parseFloat(parentLevel) == Float.parseFloat(updateLevel)) {
                return 6;
            }
            return 5;
        }
        return 3;
    }

    @Override
    protected boolean isChildOfProcedureNode(PacbaseNodeTag node, PacbaseNodeTag childNode) {
        PacbaseCSServerSort nodeSort = node.getPacbaseCSServerSort();
        PacbaseCSServerSort childNodeSort = childNode.getPacbaseCSServerSort();
        if (!nodeSort.getG3().equals("U") || nodeSort.getG3().equals(childNodeSort.getG3())) {
            if (node.getLevel().equals("00")) {
                return false;
            }
            String nodeLevel = node.getProperty("level");
            String childLevel = childNode.getProperty("level");
            if (nodeLevel != null && childLevel != null && Float.parseFloat(childLevel) > Float.parseFloat(nodeLevel)) {
                return true;
            }
        }
        return false;
    }
}

