/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.macro.pacbase.merge;

import com.ibm.pdp.macro.common.merge.NodeTag;
import com.ibm.pdp.macro.common.merge.NodeText;
import com.ibm.pdp.macro.pacbase.merge.NodeTagInfoForMerge;
import com.ibm.pdp.macro.pacbase.merge.PacbaseNodeRootTag;
import com.ibm.pdp.macro.pacbase.merge.PacbaseNodeTag;
import com.ibm.pdp.macro.pacbase.merge.PacbaseNodeTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class ManageNodeTagInfoForMerge {
    public HashMap<String, NodeTagInfoForMerge> hmNtim;
    public HashMap<String, ArrayList<PacbaseNodeTag>> memoDetail000 = new HashMap();
    ArrayList<String> functionSUPByMSPVIRTWhisCOA = new ArrayList();
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void ManageNodeTagForMerge() {
    }

    public void createNtiForChildren(PacbaseNodeTag pnt) {
        NodeTagInfoForMerge ntim = new NodeTagInfoForMerge();
        ntim.setTagName(pnt.getName());
        ntim.setFxxOrFxxyyTag(pnt.isFxxOrFxxyyTag());
        ntim.setNti(true);
        ntim.setDetailpresent(false);
        ntim.setGeneratedCodepresent(false);
        if (pnt.getNodeText() != null) {
            ntim.setText(pnt.getNodeText().getContent());
        } else {
            ntim.setText("");
        }
        ntim.setNodeTagEnclosing(pnt.getParentNode().getParentNode().getName());
        if (pnt.getPreviousSiblingWithoutSNT() != null) {
            PacbaseNodeTag pntBefore = (PacbaseNodeTag)pnt.getPreviousSiblingWithoutSNT();
            if (pntBefore != null) {
                ntim.setNodeTagBefore(pntBefore.getName());
            } else {
                ntim.setNodeTextBefore(null);
            }
        }
        if (pnt.getNextSiblingWithoutSNT() != null) {
            PacbaseNodeTag pntNext = (PacbaseNodeTag)pnt.getNextSiblingWithoutSNT();
            if (pntNext != null) {
                ntim.setNodeTagAfter(pntNext.getName());
            } else {
                ntim.setNodeTextAfter(null);
            }
        }
        ntim.addProperty("msp", pnt.getMSPName());
        this.getHmNtim().put(pnt.getSort(), ntim);
    }

    public void createSpecialGeneratedFunction(PacbaseNodeTag pnt) {
        NodeTagInfoForMerge ntim;
        if (pnt.isNxxOrNxxyyTag()) {
            PacbaseNodeTag pntNext;
            NodeTagInfoForMerge ntim2 = new NodeTagInfoForMerge();
            if (pnt.isForFunction()) {
                ntim2.setTagName(pnt.getName());
            } else {
                StringBuilder sb = new StringBuilder(8);
                sb.append(pnt.getName());
                sb.append("000");
                ntim2.setTagName(sb.toString());
            }
            ntim2.setFxxOrFxxyyTag(pnt.isFxxOrFxxyyTag());
            ntim2.setNti(true);
            ntim2.setDetailpresent(false);
            ntim2.setGeneratedCodepresent(false);
            if (pnt.getNodeText() != null) {
                ntim2.setText(pnt.getNodeText().getContent());
            } else {
                ntim2.setText("");
            }
            ntim2.addProperty("msp", "SPECIALGENFUNC");
            if (pnt.getLevel() != null) {
                ntim2.addProperty("level", pnt.getLevel());
            }
            ntim2.setNodeTagEnclosing(pnt.getParentNode().getName());
            if (pnt.getNextSiblingWithoutSNT() != null && (pntNext = (PacbaseNodeTag)pnt.getNextSiblingWithoutSNT()).isBodyTag()) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < pntNext.getAllNodeTexts().size()) {
                    sb.append(pntNext.getAllNodeTexts().get(i));
                    ++i;
                }
                ntim2.setNodeTextAfter(sb.toString());
            }
            this.getHmNtim().put(pnt.getSort(), ntim2);
        } else if (pnt.isBodyTag()) {
            PacbaseNodeTag next;
            NodeTagInfoForMerge ntim3 = new NodeTagInfoForMerge();
            ntim3.setNti(false);
            ntim3.setFxxOrFxxyyTag(pnt.isFxxOrFxxyyTag());
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < pnt.getAllNodeTexts().size()) {
                sb.append(pnt.getAllNodeTexts().get(i));
                ++i;
            }
            ntim3.setText(sb.toString());
            if (pnt.getPreviousSiblingWithoutSNT() != null) {
                PacbaseNodeTag previous = (PacbaseNodeTag)pnt.getPreviousSiblingWithoutSNT();
                if (previous.isNxxOrNxxyyTag() && previous.isForSubFunction()) {
                    sb = new StringBuilder(8);
                    sb.append(previous.getName());
                    sb.append("000");
                    ntim3.setNodeTagBefore(sb.toString());
                } else {
                    ntim3.setNodeTagBefore(previous.getName());
                }
            }
            if (pnt.getNextSiblingWithoutSNT() != null && (next = (PacbaseNodeTag)pnt.getNextSiblingWithoutSNT()).isFxxOrFxxyyTag()) {
                ntim3.setNodeTagAfter(next.getName());
            }
            ntim3.setNodeTagEnclosing(pnt.getParentNode().getName());
            this.getHmNtim().put(pnt.getSort(), ntim3);
        } else if (pnt.isFxxOrFxxyyTag() && (ntim = this.getHmNtim().get(pnt.getSort())) != null && "MSPVIRT".equals(ntim.getProperty("msp"))) {
            this.modifySpecialGeneratedFunction(ntim, pnt);
        }
    }

    public void modifySpecialGeneratedFunction(NodeTagInfoForMerge ntim, PacbaseNodeTag pnt) {
        PacbaseNodeTag next;
        ntim.setNode(pnt);
        ntim.addProperty("msp", "SPECIALGENFUNC");
        if (pnt.getLevel() != null) {
            ntim.addProperty("level", pnt.getLevel());
        }
        ntim.setText(((NodeText)pnt.getAllNodeTexts().get(0)).getContent());
        String nodeTagEnclosing = null;
        if (pnt.getParentNode() != null) {
            nodeTagEnclosing = pnt.getParentNode().getName();
        }
        ntim.setNodeTagEnclosing(nodeTagEnclosing);
        String nodeTagBefore = null;
        if (pnt.getPreviousSibling() != null) {
            PacbaseNodeTag previous = (PacbaseNodeTag)pnt.getPreviousSibling();
            if (previous.isBodyTag()) {
                if (previous.getPreviousSibling() != null) {
                    PacbaseNodeTag previousPrevious = (PacbaseNodeTag)previous.getPreviousSibling();
                    nodeTagBefore = previousPrevious.getName();
                }
            } else {
                nodeTagBefore = previous.getName();
            }
        }
        ntim.setNodeTagBefore(nodeTagBefore);
        String nodeTagAfter = null;
        if (pnt.getNextSibling() != null && !(next = (PacbaseNodeTag)pnt.getNextSibling()).isFNTag()) {
            nodeTagAfter = next.getName();
        }
        ntim.setNodeTagAfter(nodeTagAfter);
    }

    public void create900ForElse(PacbaseNodeTag pnt, PacbaseNodeTag previous, String msp) {
        NodeTagInfoForMerge ntim = new NodeTagInfoForMerge();
        StringBuilder sb = new StringBuilder(9);
        sb.append("F");
        sb.append(previous.getSort().substring(1, 3));
        sb.append(previous.getSort().substring(4, 6));
        sb.append("-900");
        ntim.setTagName(sb.toString());
        ntim.setNode(null);
        ntim.setFxxOrFxxyyTag(pnt.isFxxOrFxxyyTag());
        ntim.setNti(true);
        ntim.setDetailpresent(false);
        ntim.setGeneratedCodepresent(false);
        StringBuilder sb1 = new StringBuilder(33);
        sb1.append("       ");
        sb1.append(sb.toString());
        sb1.append(". GO TO F");
        sb1.append(pnt.getSort().substring(1, 3));
        sb1.append(pnt.getSort().substring(4, 6));
        sb1.append("-FN.");
        sb1.append("\r\n");
        ntim.setText(sb1.toString());
        ntim.addProperty("msp", msp);
        this.getHmNtim().put(sb.toString(), ntim);
    }

    public void create900ForDoDu(PacbaseNodeTag pnt, String msp) {
        NodeTagInfoForMerge ntim = new NodeTagInfoForMerge();
        StringBuilder sb = new StringBuilder(9);
        sb.append("F");
        sb.append(pnt.getSort().substring(1, 3));
        sb.append(pnt.getSort().substring(4, 6));
        sb.append("-900");
        ntim.setTagName(sb.toString());
        ntim.setNode(null);
        ntim.setFxxOrFxxyyTag(pnt.isFxxOrFxxyyTag());
        ntim.setNti(true);
        ntim.setDetailpresent(false);
        ntim.setGeneratedCodepresent(false);
        StringBuilder sb1 = new StringBuilder(32);
        sb1.append("       ");
        sb1.append(sb.toString());
        sb1.append(". GO TO F");
        sb1.append(pnt.getSort().substring(1, 3));
        sb1.append(pnt.getSort().substring(4, 6));
        sb1.append("-A.");
        sb1.append("\r\n");
        ntim.setText(sb1.toString());
        ntim.addProperty("msp", msp);
        this.getHmNtim().put(sb.toString(), ntim);
    }

    public void createIndiceForDo(PacbaseNodeTag pnt, String msp) {
        NodeTagInfoForMerge ntim = new NodeTagInfoForMerge();
        StringBuilder sb = new StringBuilder(9);
        sb.append("J");
        sb.append(pnt.getSort().substring(1, 3));
        sb.append(pnt.getSort().substring(4, 6));
        sb.append("R");
        ntim.setTagName(sb.toString());
        ntim.setNode(null);
        ntim.setFxxOrFxxyyTag(pnt.isFxxOrFxxyyTag());
        ntim.setNti(true);
        ntim.setDetailpresent(false);
        ntim.setGeneratedCodepresent(false);
        StringBuilder sb1 = new StringBuilder(32);
        sb1.append(pnt.getSort().substring(4, 6));
        sb1.append("R         05           J");
        sb1.append(pnt.getSort().substring(1, 3));
        sb1.append(pnt.getSort().substring(4, 6));
        sb1.append("R PICTURE S9(4) VALUE  ZERO.");
        sb1.append("\r\n");
        ntim.setText(sb1.toString());
        ntim.addProperty("msp", msp);
        this.getHmNtim().put(sb.toString(), ntim);
    }

    public void specialWhenMspvirtSUPByMsp(PacbaseNodeTree firstPNT, PacbaseNodeTree currentPNT, String sort) {
        if (firstPNT.getMSPName().equals("MSPVIRT")) {
            StringBuilder sb = new StringBuilder();
            sb.append(sort.substring(0, 6));
            sb.append("000");
            if (currentPNT.getFunctionsSUP().indexOf(sb.toString()) != -1) {
                this.getHmNtim().remove(sort);
            }
        }
    }

    public void alimAttributsWhenSUPInVirt(PacbaseNodeTree firstPNT, PacbaseNodeTag nTag, String sort) {
        PacbaseNodeTag pnt = (PacbaseNodeTag)firstPNT.getTreeTags().get(sort).get(0);
        if (pnt.getMSPName().equals("MSPVIRT") && pnt.getAction() == null && nTag.getAction() != null && nTag.getAction().charAt(0) == '*') {
            boolean doTreatement = false;
            for (String s : firstPNT.getFunctionsSUP()) {
                if (s.indexOf(sort.substring(0, 6)) == -1) continue;
                PacbaseNodeTag nextPnt = (PacbaseNodeTag)pnt.getNextSibling();
                if (nextPnt != null && nextPnt.getRef() == null) break;
                doTreatement = true;
                break;
            }
            if (doTreatement) {
                Properties properties = pnt.getProperties();
                properties.setProperty("action", nTag.getAction());
                if (nTag.getRef() != null) {
                    properties.setProperty("ref", nTag.getRef());
                }
            }
        }
    }

    public void createNtiFor900(PacbaseNodeTag nTag, PacbaseNodeTree currentPNT, PacbaseNodeTree firstPNT) {
        boolean createOK;
        for (PacbaseNodeTag pacbaseNodeTag : currentPNT.getTreeTagsWithDo()) {
            if (!pacbaseNodeTag.getSort().equals(nTag.getSort())) continue;
            createOK = true;
            for (PacbaseNodeTag pacbaseNodeTag2 : firstPNT.getTreeTagsWithDo()) {
                if (!pacbaseNodeTag2.getSort().equals(nTag.getSort())) continue;
                createOK = false;
            }
            if (!createOK) continue;
            this.create900ForDoDu(nTag, currentPNT.getMSPName());
            this.createIndiceForDo(nTag, currentPNT.getMSPName());
        }
        for (PacbaseNodeTag pacbaseNodeTag : currentPNT.getTreeTagsWithDu()) {
            if (!pacbaseNodeTag.getSort().equals(nTag.getSort())) continue;
            createOK = true;
            for (PacbaseNodeTag pacbaseNodeTag3 : firstPNT.getTreeTagsWithDu()) {
                if (!pacbaseNodeTag3.getSort().equals(nTag.getSort())) continue;
                createOK = false;
            }
            if (!createOK) continue;
            this.create900ForDoDu(nTag, currentPNT.getMSPName());
        }
    }

    public void create(ArrayList<NodeTag> alnt) {
        int i = 0;
        while (i < alnt.size()) {
            NodeTagInfoForMerge ntim = new NodeTagInfoForMerge();
            NodeTag nt = alnt.get(i);
            if (nt instanceof PacbaseNodeTag) {
                PacbaseNodeTag pnt = (PacbaseNodeTag)nt;
                ntim.setTagName(pnt.getName());
                ntim.setFxxOrFxxyyTag(pnt.isFxxOrFxxyyTag());
                ntim.setNode(pnt);
                ntim.setNti(true);
                ntim.setDetailpresent(false);
                ntim.setGeneratedCodepresent(false);
                if (pnt.getNodeText() != null) {
                    ntim.setText(pnt.getNodeText().getContent());
                } else {
                    ntim.setText("");
                }
                ntim.addProperty("msp", pnt.getMSPName());
                if (pnt.getLevel() != null) {
                    ntim.addProperty("level", pnt.getLevel());
                }
                this.getHmNtim().put(pnt.getSort(), ntim);
            }
            ++i;
        }
    }

    public void modifyDoubleOnTitleWithLevel00(PacbaseNodeTag pnt, String sort) {
        NodeTagInfoForMerge ntim = this.getHmNtim().get(sort);
        if (ntim != null && !ntim.getProperty("msp").equals("artificialCreate")) {
            if (pnt.isFxxOrFxxyyTag()) {
                ntim.addProperty("msp", "artificialCreate");
                ntim.addProperty("level", "10");
                ntim.setLevel00(true);
                ntim.setNode(pnt);
                ntim.setNti(true);
                ntim.setFxxOrFxxyyTag(pnt.isFxxOrFxxyyTag());
                ntim.setText("");
                this.getHmNtim().put(sort, ntim);
            }
            if (pnt.isLineProcedure()) {
                ntim.setNti(false);
                StringBuilder sb = new StringBuilder();
                sb.append("       F");
                sb.append(pnt.getFunction());
                if (pnt.getSubFunction().trim().length() > 0) {
                    sb.append(pnt.getSubFunction());
                }
                sb.append(".");
                sb.append("\r\n");
                ntim.setText(sb.toString());
                this.getHmNtim().put(sort, ntim);
            }
        }
    }

    public void modifyDoubleOnTitle(String sort, ArrayList<String> functionsSUPByMspvirt) {
        StringBuilder sb = new StringBuilder(7);
        sb.append(sort);
        sb.append("A");
        NodeTagInfoForMerge ntim = this.getHmNtim().get(sb.toString());
        if (ntim != null && !ntim.getProperty("msp").equals("artificialCreate")) {
            ntim.addProperty("msp", "artificialCreate");
            if (sort.trim().length() == 4) {
                ntim.addProperty("level", "05");
            } else {
                ntim.addProperty("level", "10");
            }
            sb = new StringBuilder(9);
            sb.append(sort);
            sb.append("000");
            if (functionsSUPByMspvirt.indexOf(sb.toString()) == -1) {
                NodeTagInfoForMerge ntimForDetail = new NodeTagInfoForMerge();
                ntim.setFxxOrFxxyyTag(false);
                ntimForDetail.setNti(false);
                sb = new StringBuilder(5);
                sb.append("F");
                sb.append(sort.substring(1, 3));
                if (sort.trim().length() > 4) {
                    sb.append(sort.substring(4));
                }
                ntimForDetail.setNodeTagEnclosing(sb.toString());
                StringBuilder sb1 = new StringBuilder(15);
                sb1.append("       F");
                sb1.append(sort.substring(1, 3));
                if (sort.trim().length() > 4) {
                    sb1.append(sort.substring(4));
                }
                sb1.append(".");
                sb1.append("\r\n");
                ntimForDetail.setText(sb1.toString());
                this.getHmNtim().put(sb.toString(), ntimForDetail);
            }
        }
    }

    public void modify(NodeTag nt, PacbaseNodeTree pntMspVirt, ArrayList<String> tagSUP) {
        PacbaseNodeTag pnt;
        if (nt instanceof PacbaseNodeTag && ((pnt = (PacbaseNodeTag)nt).getNodeText() == null || pnt.getNodeText().getContent().indexOf("*!N") == -1)) {
            String smallSort = null;
            if (pnt.getSort().length() > 11) {
                StringBuilder sb = new StringBuilder(9);
                sb.append(pnt.getSort().substring(0, 6));
                sb.append(pnt.getSort().substring(9));
                smallSort = sb.toString();
            } else {
                smallSort = pnt.getSort();
            }
            NodeTagInfoForMerge ntim = this.getHmNtim().get(smallSort);
            if (ntim != null) {
                if (!(pnt.isFxxOrFxxyyTag() || pnt.isNxxOrNxxyyTag() || ntim.getProperty("msp").equals("MSPVIRT"))) {
                    if (smallSort.equals(pnt.getSort())) {
                        this.getHmNtim().remove(smallSort);
                    }
                } else if (!pnt.isFxxOrFxxyyTag() && !pnt.isNxxOrNxxyyTag() && pnt.getParentNode() instanceof PacbaseNodeRootTag) {
                    if (smallSort.endsWith("000")) {
                        ArrayList<PacbaseNodeTag> al = this.memoDetail000.get(smallSort);
                        if (al != null) {
                            al.add(pnt);
                        } else {
                            al = new ArrayList();
                            al.add(pnt);
                            this.memoDetail000.put(smallSort, al);
                        }
                    }
                    StringBuilder sb = new StringBuilder(7);
                    sb.append(pnt.getSort().substring(0, 6));
                    sb.append("A");
                    ntim = this.getHmNtim().get(sb.toString());
                    if (ntim != null) {
                        ntim.setDetailpresent(true);
                    }
                } else {
                    String sortFunction = null;
                    if (pnt.isForSubFunction()) {
                        StringBuilder sb = new StringBuilder(smallSort.length());
                        sb.append(smallSort.substring(0, 4));
                        sb.append("  ");
                        sb.append(smallSort.substring(6));
                        sortFunction = sb.toString();
                    }
                    if (tagSUP.indexOf(smallSort) == -1 && tagSUP.indexOf(sortFunction) == -1) {
                        if (ntim.getTagName().charAt(0) == 'F' && pnt.getNodeText() != null && pnt.getNodeText().getContent().length() > 13 && pnt.getNodeText().getContent().substring(13).trim().startsWith("IF ") && pntMspVirt.getFunctionsSUP().indexOf(pnt.getSort()) == -1 && (ntim.getText().length() < 13 || !ntim.getText().substring(13).trim().startsWith("IF "))) {
                            pntMspVirt.getTreeTagsWithIfSpecialMspvirt().add(ntim.getNode().getParentNode().getParentNode());
                        }
                        ntim.setTagName(pnt.getName());
                        ntim.setNode(pnt);
                        if (pnt.getNodeText() != null) {
                            ntim.setText(pnt.getNodeText().getContent());
                        } else {
                            ntim.setText("");
                        }
                        ntim.addProperty("msp", pnt.getMSPName());
                        if (pnt.getLevel() != null) {
                            ntim.addProperty("level", pnt.getLevel());
                        }
                        if (pnt.getAction() != null) {
                            ntim.addProperty("action", pnt.getAction());
                        }
                        if (pnt.getRef() != null) {
                            ntim.addProperty("ref", pnt.getRef());
                        }
                    }
                }
            } else if (pnt.isLineProcedure()) {
                StringBuilder sb = new StringBuilder(7);
                sb.append(pnt.getSort().substring(0, 6));
                sb.append("A");
                ntim = this.getHmNtim().get(sb.toString());
                if (ntim != null) {
                    ntim.setDetailpresent(true);
                }
            }
        }
    }

    public ArrayList<String> getFunctionSUPByMSPVIRTWhisCOA() {
        return this.functionSUPByMSPVIRTWhisCOA;
    }

    public HashMap<String, ArrayList<PacbaseNodeTag>> getMemoDetail000() {
        return this.memoDetail000;
    }

    public HashMap<String, NodeTagInfoForMerge> getHmNtim() {
        if (this.hmNtim == null) {
            this.hmNtim = new HashMap();
        }
        return this.hmNtim;
    }
}

